Option Base 1
Option Explicit

Type TPerson
  phone As integer
  surname As string Length 8
  name As string Length 7
  padding As string Length 2 'alignment to uint32_t seems OK, L=6 for uint64_t
End Type

Dim people(2) As TPerson = (1234,"Marther","Peter","", 5678,"Graham","Geoff","")

Dim pt As TPerson

Dim p1 As TPerson
p1 = people(1)

Print "Struct Print p1:"
Struct Print p1 ' Works !

Print "At start:"
Print "TPerson.Print(people(1)):"
TPerson.Print(people(1))

' The "standard way"
people(1) = p1
TPerson.S9999(people(1))
Print "After TPerson.S9999(people(1))"
Print "TPerson.Print(people(1)):"
TPerson.Print(people(1))

' Same function but with "ByRef" and behaves like TPerson.S9999() as expected..
people(1) = p1
TPerson.ByRef(people(1))
Print "After TPerson.ByRef(people(1))"
Print "TPerson.Print(people(1)):"
TPerson.Print(people(1))

' Value of people(1) should be "restored" - OK!
people(1) = p1
Print "After people(1) = p1"
Print "TPerson.Print(people(1)):"
TPerson.Print(people(1))
Print "TPerson.Print(people(2)):"
TPerson.Print(people(2))

' Pass e single struct var to TPerson.S9999(pt) - OK!
pt = people(1)
TPerson.S9999(pt)
'Print "After TPerson.S9999(pt)"
'Print "TPerson.Print(pt):"

'Bug! Throws error: "Error : Array dimensions" (inside Sub!)
'TPerson.Print(pt)

End

Sub TPerson.Print(me As TPerson)
  Print : Print "In Sub TPerson.Print(me As TPerson), Print me.name:"
  Print me.name

  'Bug! Throws error: "Error : Array dimensions"
  'Struct Print me

  'Bug! Prints whole array people(), while 'me' is no array !!!
  'Struct Print me()

  Local p As TPerson

  'Bug! Throws error: "Error : Array dimensions"
  'p = me

  'Struct Print p ' Should work, but irrelevant cos bug before..

  ' Works, but "weird", as 'me' is no array !!!
  Print : Print "In Sub TPerson.Print(me As TPerson), Struct Print me(1):"
  Struct Print me(1)  ' Prints the array-element passed by arg!
End Sub

Sub TPerson.S9999(me As TPerson)
  me.phone = 9999
End Sub

Sub TPerson.ByRef(ByRef me As TPerson)
  me.phone = 9999
End Sub
