' with font-unpack and rain
'led-order
' original       swapped
' 8  15 24...    8  9  24...
' |\ |\ |\    or |--|  |-
' | \| \|        |  |__|
' 1  9  16       1 15  16

'inspirated by the project
'https://github.com/gquiring/MorphingClockQ

Option EXPLICIT
Option DEFAULT NONE
'const-----------------------------------------------------
Const MaCo = 64 'MaxColumn
'vars -----------------------------------------------------
Dim Integer FSize, FRows
Dim integer CTab(9)     'ColorTable see InitLedChars
Dim integer FTab(5)     'ColorTable green
Dim integer cmp1(256)   'for colorpattern
Dim integer cmp2(256)   'for colorpattern

Dim integer matx(1024)  'all 4 tiles with 16x16 pix 4x256 work
Dim integer back(1024)  'back layer  background layer
Dim integer mask(1024)  'for mapping
Dim integer pack(512)   'for Pio-packing
Dim integer tmp(255)    'for swapp

Dim integer mptr = Peek(VarAddr matx())
Dim integer bptr = Peek(VarAddr back()) '------------------------------
Dim integer tptr = Peek(VarAddr tmp())

'Dim Integer zId,fId,bId                'index for textchar and color
Dim Integer i, j, MyCo 'MyColor global for print
Dim Float   tim1,tim2,tim3

'-application consts/vars -----------------------------------------------------|
Dim integer animSpeed = 50
Const black     = 0  'select from colortable!!

Const sA = 0
Const sB = 1
Const sC = 2
Const sD = 3
Const sE = 4
Const sF = 5
Const sG = 6

Dim integer digitBits(9)
 digitBits(0) = &B01111110 ' 0 -ABCDEF-
 digitBits(1) = &B00110000 ' 1 --BC----
 digitBits(2) = &B01101101 ' 2 -AB-DE-G
 digitBits(3) = &B01111001 ' 3 -ABCD--G
 digitBits(4) = &B00110011 ' 4 --BC--FG
 digitBits(5) = &B01011011 ' 5 -A-CD-FG
 digitBits(6) = &B01011111 ' 6 -A-CDEFG
 digitBits(7) = &B01110000 ' 7 -ABC----
 digitBits(8) = &B01111111 ' 8 -ABCDEFG
 digitBits(9) = &B01111011 ' 9 -ABCD_FG

' temporary set by InitDigits() with the segment values
Dim integer _value
Dim integer segHeight
Dim integer segWidth
Dim integer xOffset
Dim integer yOffset
Dim integer _color

Dim integer Clock(7,5)
 ' 0     1    2   3   4   5   6 7
 'actV,xofs,yofs,col,oldV,max H W
Data 2,   2,   1,  5, 0  ,2  ,6,6'0h
Data 3,  11,   1,  6, 0  ,9  ,6,6'1h
Data 5,  23,   1,  7, 0  ,5  ,6,6'2m
Data 9,  32,   1,  8, 0  ,9  ,6,6'3m
Data 5,  44,   1,  6, 0  ,5  ,6,6'4s
Data 8,  53,   1,  2, 0  ,9  ,6,6'5s
Read Clock()

Dim integer Nd, ClMk
'sys inits ------------------------------------------------
SetPin gp0,pio1
InitWs2812Pio()  'program PIO
'SetTick 1000,WsUpdate,1

'my inits -------------------------------------------------
MyInit()     'read and set MyFont and colortable

Print "End with Ctrl+C"

' application start -----------------------------------------------------------|

SetTick   50,DupD  ,1 'makes a display-flush every 50ms
SetTick 1000,Cnt() ,3 'inc clock ones a second

'Print "GetVal"
ClockGetVal() 'fill the "Clock"array with the values from system-timer
'Print "Init digs"
InitDigits()  'show the values of the digits without morphing
Pause 1000

Do 'main loop
  'Inc ClMk  will be done in tick "count"
  'this part is only for the "time"-part, the data have to be implemented!!!!!"
  Do While ClMk > 0 'if anim. takes too long,steps are lost some times:save them
    Inc clock(0,5)  'lower second
    For Nd = 5 To 0 Step -1 'compare all in upward order because of carry
      If clock(0,Nd) <> clock(4,Nd) Then  ' act val diffs from old val

        If Nd > 1 Then 'mm,ss both 59
          If clock(0,Nd) > clock(5,Nd) Then ' act val > max of this digit
            clock(0,Nd) = 0
            Inc clock(0,Nd-1)
          End If
        Else
          If Nd=1 Then 'lower hour  00-19
            If (clock(0,0) < 2)And(clock(0,1) > 9) Then
              clock(0,1) = 0
              Inc clock(0,0)
            Else If (clock(0,0) = 2)And(clock(0,1) > 3) Then '20-23

              SetTick 0,DupD ,1
               clock(0,0) = 0
               clock(0,1) = 0
               clrScr()
               ClockGetVal() ' mit sys-timer abgleichen
               InitDigits()
              SetTick 40,DupD(),1

              Exit Do ' no morph this time
            End If
            'If Nd>0 Then Inc clock(0,Nd-1) 'no more carry! :-> ClockGetVal??????
          End If
        End If

        UpdateVar(Nd) 'set globals for this digit:old val,x/yoffsets,color...
        Morph(clock(0,Nd))  'make the animation
        clock(4,Nd) = _value'new val -> old val
      End If 'act<>old
    Next Nd 'digit
    Inc ClMk,-1 'step processed! -> one less
  Loop          'other steps?
  Pause 200
Loop 'end main loop

'Math Window matx(),1,0,mask()    'create mask from front layer
'Math C_Mult mask(),back(),mask() 'clear pixel with mask
'Math C_Add  mask(),matx(),matx() 'set bufferdata to blanked pixel

'- tics -------------------------------------------------------
Sub cnt()
  Inc ClMk 'one more second left -> new step/morph
End Sub

Sub DupD() 'Display update, then we need it not in every sub/function
 SwapRows(mptr, 16, MaCo)'from first adr; "64" for all 3 tiles hin und
   StartWs2812Pio()'new Output PIO with DMA
 SwapRows(mptr, 16, MaCo)'from first adr; "64" for all 3 tiles zurueck
End Sub

'- subs -------------------------------------------------------
Sub ClrScr()
  Math set 0, matx()
End Sub

Sub ClockGetVal()' I am not happy with this, but it works for the moment
 Local string tmpStr
 'DATETIME$(n) n: Epoch number or "now" for systemtime
 'DAY$(now) 'Monday', 'Tuesday' etc. DayOfWeek
 TmpStr = Time$
 Clock(0,0) = Asc(Mid$(TmpStr, 1,1))-48'h
 Clock(0,1) = Asc(Mid$(TmpStr, 2,1))-48'h
 Clock(0,2) = Asc(Mid$(TmpStr, 4,1))-48'm
 Clock(0,3) = Asc(Mid$(TmpStr, 5,1))-48'm
 Clock(0,4) = Asc(Mid$(TmpStr, 7,1))-48's
 Clock(0,5) = Asc(Mid$(TmpStr, 8,1))-48's
End Sub

Sub InitDigits() 'init digits by first view or when ext. update
Local integer i
  For i = 0 To 5
    UpdateVar(i)       'old val,offsets,color reset save to global???!!!
    DrawNum(clock(0,i))
    clock(4,i) = _value
    If (i=2)Or(i=4)  Then DrawColon() ' : :
  Next i
End Sub

Sub UpdateVar(Id%)
'not very nice to make them global, but I am lazy at the moment(from C++object)
 _value   = Clock(4,Id%) 'act num to get diff
 xOffset  = Clock(1,Id%) 'xo
 yOffset  = Clock(2,Id%) 'yo
 _color   = Clock(3,Id%) 'color
 segHeight= Clock(6,Id%) '
 segWidth = Clock(7,Id%) '
End Sub

'7 segment --------------------------------------------------------------------|
Sub drawSeg( seg As integer)
  Select Case (seg)
    Case sA: drawLine(1         ,segHeight*2+2,segWidth  ,segHeight*2+2,_color)
    Case sB: drawLine(segWidth+1,segHeight*2+1,segWidth+1,segHeight+2  ,_color)
    Case sC: drawLine(segWidth+1,      1      ,segWidth+1,segHeight    ,_color)
    Case sD: drawLine(1         ,      0      ,segWidth  ,     0       ,_color)
    Case sE: drawLine(0         ,      1      ,   0      , segHeight   ,_color)
    Case sF: drawLine(0         ,segHeight*2+1,   0      , segHeight+2 ,_color)
    Case sG: drawLine(1         ,segHeight+1  ,segWidth  , segHeight+1 ,_color)
  End Select
End Sub

Sub DrawColon() 'Colon is drawn to the left of this digit
  drawFillRect(-3, segHeight-3  , 2, 2)
  drawFillRect(-3, segHeight+1+3, 2, 2)
End Sub

Sub DrawDot() 'Dot is drawn to the left of this digit
  'drawFillRect(-3, segHeight-4, 2, 2)
End Sub

Sub DrawNum(newvalue As integer)
Local integer pattern
  pattern = digitBits(newvalue)
  If pattern And 64 Then drawSeg(sA)
  If pattern And 32 Then drawSeg(sB)
  If pattern And 16 Then drawSeg(sC)
  If pattern And  8 Then drawSeg(sD)
  If pattern And  4 Then drawSeg(sE)
  If pattern And  2 Then drawSeg(sF)
  If pattern And  1 Then drawSeg(sG)
  _value = newvalue
End Sub

'momentary the moves are only for rising numbers without them to '0' by carry
Sub Morph(newValue As integer)
  Select Case newValue
    Case 0: Morph0()
    Case 1: Morph1()
    Case 2: Morph2()
    Case 3: Morph3()
    Case 4: Morph4()
    Case 5: Morph5()
    Case 6: Morph6()
    Case 7: Morph7()
    Case 8: Morph8()
    Case 9: Morph9()
  End Select
  _value = newValue
End Sub

Sub Morph1() 'Zero or two to One
Local integer i
  For  i = 0 To (segWidth+1)
    ' Move E left to right
    drawLine(0+i-1, 1, 0+i-1, segHeight, black)
    drawLine(0+i  , 1, 0+i  , segHeight, _color)
    ' Move F left to right
    drawLine(0+i-1, segHeight*2+1, 0+i-1, segHeight+2, black)
    drawLine(0+i  , segHeight*2+1, 0+i  , segHeight+2, _color)
    ' Gradually Erase A, G, D
    drawPixel(1+i, segHeight*2+2, black) 'A
    drawPixel(1+i,       0      , black) 'D
    drawPixel(1+i, segHeight+1  , black) 'G
    Pause animSpeed
  Next i
End Sub

Sub Morph2() 'TWO
Local integer i
  For i = 0 To segWidth
    If (i<segWidth) Then
      drawPixel(segWidth-i, segHeight*2+2,_color)
      drawPixel(segWidth-i, segHeight+1  ,_color)
      drawPixel(segWidth-i,      0       ,_color)
    End If
    drawLine(segWidth+1-i, 1, segWidth+1-i, segHeight, black)
    drawLine(segWidth-i  , 1, segWidth-i  , segHeight,_color)
    Pause animSpeed
  Next i
End Sub

Sub Morph3() 'THREE
Local integer i
  For i = 0 To segWidth
    drawLine(0+i, 1, 0+i, segHeight, black)
    drawLine(1+i, 1, 1+i, segHeight,_color)
    Pause animSpeed
  Next i
End Sub

Sub Morph4() 'FOUR
Local integer i
  For i = 0 To (segWidth-1)
    drawPixel(segWidth-i, segHeight*2+2  , black) ' Erase A
    drawPixel(   0      , segHeight*2+1-i,_color) ' Draw as F
    drawPixel(   1+i    ,    0           , black) ' Erase D
    Pause animSpeed
  Next i
End Sub

Sub Morph5() 'FIVE
Local integer i
  For i = 0 To (segWidth-1)
    drawPixel(segWidth+1, segHeight+2+i, black)  ' Erase B
    drawPixel(segWidth-i, segHeight*2+2, _color) ' Draw as A
    drawPixel(segWidth-i,        0     , _color) ' Draw D
    Pause animSpeed
  Next i
End Sub

Sub Morph6() 'SIX
Local integer i
  For i = 0 To segWidth
    ' Move C right to left
    drawLine(segWidth-i, 1, segWidth-i, segHeight, _color)
    If (i>0) Then
    drawLine(segWidth-i+1, 1, segWidth-i+1, segHeight, black)
  End If
    Pause animSpeed
  Next i
End Sub

Sub Morph7() 'SEVEN
Local integer i
  For i = 0 To (segWidth+1)
    ' Move E left to right
    drawLine(0+i-1, 1, 0+i-1, segHeight, black)
    drawLine(0+i  , 1, 0+i  , segHeight, _color)
    ' Move F left to right
    drawLine(0+i-1, segHeight*2+1, 0+i-1, segHeight+2, black)
    drawLine(0+i  , segHeight*2+1, 0+i  , segHeight+2,_color)
    ' Erase D and G gradually
    drawPixel(1+i,    0       , black) ' D
    drawPixel(1+i, segHeight+1, black) ' G
    Pause animSpeed
  Next i
End Sub

Sub Morph8() 'EIGHT
Local integer i
  For i = 0 To segWidth
    ' Move B right to left
    drawLine(segWidth-i, segHeight*2+1, segWidth-i, segHeight+2,_color)
    If (i > 0) Then
    drawLine(segWidth-i+1, segHeight*2+1, segWidth-i+1, segHeight+2, black)
    End If
    ' Move C right to left
    drawLine(segWidth-i, 1, segWidth-i, segHeight,_color)
    If (i>0) Then
    drawLine(segWidth-i+1, 1, segWidth-i+1, segHeight, black)
    End If
    ' Gradually draw D and G
    If (i<segWidth) Then
      drawPixel(segWidth-i,           0,_color) ' D
      drawPixel(segWidth-i, segHeight+1,_color) ' G
    End If
    Pause animSpeed
  Next i
End Sub

Sub Morph9() 'NINE
Local integer i
  For i = 0  To (segWidth+1)
    ' Move E left to right
    drawLine(0+i-1, 1, 0+i-1, segHeight, black)
    drawLine(0+i  , 1, 0+i  , segHeight,_color)
    Pause animSpeed
  Next i
End Sub

Sub Morph0() 'ZERO
Local integer i
  For i = 0 To segWidth
    If (_value=1) Then ' If 1 to 0, slide B to F and E to C
      ' slide B to F
      drawLine(segWidth-i, segHeight*2+1, segWidth-i, segHeight+2,_color)
      If (i>0) Then
        drawLine(segWidth-i+1,segHeight*2+1,segWidth-i+1, segHeight+2, black)
      End If
      ' slide E to C
      drawLine(segWidth-i, 1, segWidth-i, segHeight,_color)
      If (i>0) Then
        drawLine(segWidth-i+1, 1, segWidth-i+1, segHeight, black)
      End If
      If (i<segWidth) Then
        drawPixel(segWidth-i, segHeight*2+2 ,_color) ' Draw A
      End If
      If (i<segWidth) Then
        drawPixel(segWidth - i, 0,_color) ' Draw D
      End If
    End If
    If (_value=2) Then ' If 2 to 0, slide B to F and Flow G to C
      ' slide B to F
      drawLine(segWidth-i, segHeight*2+1 , segWidth-i, segHeight+2,_color)
      If (i>0) Then
        drawLine(segWidth-i+1, segHeight*2+1, segWidth-i+1, segHeight+2,black)
      End If
        drawPixel(1+i, segHeight+1, black) ' Erase G left to right
      If (i<segWidth) Then
        drawPixel(segWidth+1, segHeight+1-i,_color) ' Draw C
      End If
    End If
    If (_value=3) Then ' B to F, C to E
      ' slide B to F
      drawLine(segWidth-i, segHeight*2+1, segWidth-i, segHeight+2,_color)
      If (i>0) Then
        drawLine(segWidth-i+1, segHeight*2+1, segWidth-i+1, segHeight+2,black)
      End If
      ' Move C to E
      drawLine(segWidth-i, 1, segWidth-i, segHeight,_color)
      If (i>0) Then
        drawLine(segWidth-i+1, 1, segWidth-i+1, segHeight, black)
      End If
      ' Erase G from right to left
      drawPixel(segWidth-i,segHeight+1, black) ' G
    End If
    If (_value=5) Then 'If 5 to 0, we also need to slide F to B
      If (i<segWidth) Then
        If (i>0) Then
          drawLine(1+i, segHeight*2+1, 1+i, segHeight+2, black)
        End If
        drawLine(2+i, segHeight*2+1, 2+i, segHeight+2,_color)
       End If
    End If
    If (_value=5)Or(_value=9) Then 'If 9 or 5 to 0, Flow G into E
      If (i<segWidth) Then
        drawPixel(segWidth-i, segHeight+1, black)
      End If
      If (i<segWidth) Then
        drawPixel(0, segHeight-i, _color)
      End If
    End If
    Pause animSpeed
  Next i
End Sub

'helper ----------------------------------------------------------------------

Sub drawPixel(x%,y%,c%)
  'matx( x%+x%offset+((y%+yoffset)*64)) ) = CTab(MyCo)
  matx((x%+xoffset)*16+(y%+yoffset)) = CTab(c%)
  'in preparation to switch to byte-oriented displayarea
  'Memory Set Integer WAdr+((((y%+yoffset)<<6)+x%+xoffset)<<3),CrTb(c%),1
End Sub

'-----------------------------------------------------------------
' draws a line with bresenham from the coordinates x0,y0 to x1,y1
' from the net: ported from C
'-----------------------------------------------------------------
Sub DrawLine(x0%,y0%,x1%,y1%,c%)
 Local integer dx= Abs(x1%-x0%),sx=Choice(x0%<x1%,1,-1)
 Local integer dy=-Abs(y1%-y0%),sy=Choice(y0%<y1%,1,-1)
 Local integer er=dx+dy,e2
 Do
  drawPixel(x0%,y0%,c%)
  If (x0%=x1%)And(y0%=y1%) Then Exit Do
  e2=er<<1
  If (e2>=dy)Then Inc er,dy: Inc x0%,sx
  If (e2<=dx)Then Inc er,dx: Inc y0%,sy
 Loop
End Sub

Sub drawFillRect(x% ,y%, w%, h%)
Local integer i,j
 For  i = 0 To h%-1
   For j = 0 To w%-1
     drawPixel(x%+j, y%+i, _color)
   Next j
   'Memory Set Integer WAdr+((((y%+i)<<6)+x%)<<3),CrTb(c%),w%
 Next i
End Sub

'-sys-subs------------------------------------------------------
Sub InitWs2812Pio()
 Dim integer Busy = 1 'must be global
  '       ____                 ________
  '(0) __|    |______   (1) __|        |__
  '  .2us .4us .6us       .2us  .8us   .2us
  PIO CLEAR 1
  PIO ASSEMBLE 1, ".program leds"
  PIO ASSEMBLE 1, ".line 0"
  PIO ASSEMBLE 1, "SET PINDIRS, 1"
  PIO ASSEMBLE 1, ".wrap target"   'steps |delay
  PIO ASSEMBLE 1, "OUT x, 1 "      '1 lo   0.2us
  PIO ASSEMBLE 1, "SET PINS, 1 [1]"'2 hi   0.4us
  PIO ASSEMBLE 1, "MOV PINS, x [1]"'2 data 0.4us
  PIO ASSEMBLE 1, "SET PINS, 0 "   '1 lo   0.2us
  PIO ASSEMBLE 1, ".wrap"          '6 sum  1.2us = 833kHz
  PIO ASSEMBLE 1, ".end program list"

  Dim integer ExeC = Pio(execctrl GP0,Pio(.wrap target),Pio(.wrap))
  Dim integer PinC = Pio(pinctrl 0,1,1,,,gp0,gp0)
  Dim integer ShiC = Pio(shiftctrl 0,24,0,1) 'Set Auto Pull at 24bits
  Dim integer Freq = 5000000 '5MHz -> 1 step -> 0.2us
  PIO init machine 1,0,Freq,PinC,ExeC,ShiC,0
 Busy = 0
End Sub

Sub StartWs2812Pio()
  Do While Busy: Loop               'wait for ready
  Memory pack matx(),pack(),1024,32 'copy and pack
  Busy = 1                          'set busy-flag
  PIO DMA TX 1,0,1024,pack()
  SetTick 30,TicI,2 '~29us/24bit x 1024 =>29ms max 5x256 to be save with 25Hz
End Sub

Sub TicI 'stop the PIO and re-init for next run
  SetTick 0,0,2 'stop timer 1
  PIO stop 1,0
  PIO init machine 1,0,Freq,PinC,ExeC,ShiC,0
  Busy = 0 'ready for restart
End Sub

Sub SwapRows(adr As integer,H As integer, W As integer)
'save every second column to mirrored position, all columns same time
Local integer i,x,y,z,b,d
 x = H<<1  'distance of column in integer-count
 y = H/2-1 'raws: only hight/2 because they are swapped
 z = W/2   'count: only width/2 because only every second
 For i = 0 To y
  d=i<<3 'diff bytes! for adr= 8,16,24,..
  b=(H<<3)-d-8
  Memory Copy Integer adr+d,tptr ,z,x,1
  Memory Copy Integer adr+b,adr+d,z,x,x
  Memory Copy Integer tptr ,adr+b,z,1,x
 Next i
End Sub

'-----------------------
Sub MyInit()
 Local Integer actP 'act. position must be counted because variable width
 Local Integer FCnt, RCnt, CCnt
 Local Integer i,j,k,bit,dat,x,y
 CTab(0)=RGB(0,0,0)<<8
 CTab(1)=RGB(0,16,0)<<8
 CTab(2)=RGB(16,0,0)<<8
 CTab(3)=RGB(0,0,16)<<8
 CTab(4)=RGB(0,8,8)<<8
 CTab(5)=RGB(8,8,0)<<8
 CTab(6)=RGB(8,0,8)<<8
 CTab(7)=RGB(6,16,0)<<8
 CTab(8)=RGB(1,9,6)<<8
 CTab(9)=RGB(6,4,6)<<8
 'generate color gradient
 For x = 0 To 15 'cmp1
  For y = 0 To 7
    cmp1((x*16)+y) = RGB(7-(x>>1),y+1,7-y)<<8
    cmp2((y*16)+x) = RGB(7-(x>>1),y+1,7-y)<<8
  Next y
  For y = 0 To 7
    cmp1( (x*16)+8+y) = RGB(7-(x>>1)+y,8-y,(y>>2))<<8
    cmp2(((y+7)*16)+x)= RGB(7-(x>>1)+y,8-y,(y>>2))<<8
  Next y
 Next x
End Sub