'HUB75 driver 6bit color(rgb222)
'this version is for Hub75-displays with max.5 Adr-lines(1/8, 1/16 or 1/32 scan)
' the wide has to be a power of 2 -> 32,64,128,256,...(using ringbuffer)       |
' tested with 32x64/128/256; 64x64/128/256
'
' Connection PICO          Connection HUB75
'
' gp0  RED0  -+
' gp1  GREEN0 |
' gp2  BLUE0  SM0 out          +----+
' gp3  RED1   |           RED0 |1 16| GREEN0
' gp4  GREEN1 |          BLUE0 |2 15| GND
' gp5  BLUE1 -+           RED1 |3 14| GREEN1
' gp6  A     -+          BLUE1  4 13| E
' gp7  B      |              A  5 12| B
' gp8  C      SM1 out        C |6 11| D
' gp9  D      |            CLK |7 10| LATCH
' gp10 E     -+            /OE |8  9| GND
' gp11 CLK   -SM0 sset         +----+
' gp12 LATCH -SM1 sset
' gp13 /OE   -SM2 sset
' gp25 PIN   -SM0/SM1/SM2/SM3(nc)
'
' examples of connecting more then one panel
'   stacked    con.          attached         attached & stacked        con.
'  +--------+pico       +--------+--------+   +--------+--------+        _
'32|        | [+]1>[] 32|      HS=1       | 32|        |        |pico   / \
'  | HS=2   |    __/    |     32x128      |   |       HS=2      | [+]1>[] []2>[]
'  +-64x64--+   /       +--------+--------+   +------64x128-----+    _________/
'32|        |  []2>[]       64       64     32|        |        |   /
'  |        |           pico   con.           |        |        |  []3>[] []4>[]
'  +--------+            [+]1>[] []2>[]       +--------+--------+       \_/
'      64                      \_/                64       64
'
' some displays exchanged colorchanels or for other routings on board
' look for "InitCt("rgb")"
'
'OPTION SDCARD  CS_pin, CLK_pin, MOSI_pin, MISO_pin
'OPTION SDCARD  gp14, gp26, gp15, gp27
'------------------------------------------------------------------------------|
Option EXPLICIT
Option DEFAULT INTEGER

Const MSB     = 128
'consts for hub-display
'if you use stacked displays they must be equal.e.g. 32x128 stack 2 -> 64x64
'Const HubLayer= 2
Const HubStack= 1   '1: no stack; 2: stacked: first botton to second top
Const HubH    = 32'*Hub  'MM.VRES(virtual);val:16,32,64
Const HubW    = 128 'real  wide  / stacks => MM.HRES(virtual);val:32,64,128,256
Const HubScan = HubH/2-1    'there should be others but they are not supported
Const HubPixs = HubH*HubW   '
Const HubInts = HubH*HubW/8 '8 bytes = 1 int

'ringbuffer for PIO DMA TX finally contains the twisted display-data
Dim Pack '
PIO make ring buffer Pack,HubPixs 'in byte HubH*HubW/2

' vars for display: buffers and PIO-calculation

Dim Work(HubInts-1)    'contains display-data 1pixel = 1byte

'pointer: used for memory functions
Dim WAdr = Peek(VarAddr Work(0))           'upper half of org
Dim VAdr = Peek(VarAddr Work(HubInts/2))   'lower half of org
Dim pAA  = Peek(VarAddr Pack())            'ptr to ringbuffer

'check if display are stacked -> declare memory for rearranging pixels
If (HubStack<0)Or(HubStack>2) Then Print "error: number of stacks!!!":End
If HubStack = 2 Then
 Dim Stacker(HubInts-1) 'contains stacked display-data(mem for rearrange)
 Dim pSt0 = Peek(VarAddr Stacker(0))        'ptr to stacker
 Dim pSt1 = Peek(VarAddr Stacker(HubInts/2))'ptr to stacker
EndIf

'display start ----------------------------------------------------------------|
Dim DimTab(18)=(0,1,2,3,5,7,10,15,22,31,44,63,90,127,175,240,330,490,640)
Dim C6Tb(63) 'precalculated colors for rgb222
Dim rC,Bcol,Fcol,lFco=-1,lBco=-1,lCol=-1

Dim float tic1,tic2' for manual profiling with timer

InitCt("rgb") 'switch color-channels here

'init sys-display config
On error skip
Option lcdpanel user, HubW/HubStack, HubH*HubStack' inform system about display config

If (MM.HRES<>HubW/HubStack)Or(MM.VRES<>HubH*HubStack) Then
  Print "error: display config wrong!!! first: option lcdpanel disable"
  End
EndIf

'init PIO
'there is a problem with "DMA TX off",I can not stop/restart after Ctrl+C
If MM.Info(PIO TX DMA) Then
  Print "PIO TX DMA still running !!!!"
  PIO DMA TX OFF
  Pause 100
  PIO stop 1,0
  Pause 100
  If MM.Info(PIO TX DMA) Then Print "resetting Pico": CPU RESTART
End If

InitHub75Pio() 'create the POIs and starts SM1, SM2 and SM3
StartHub75Pio()'start SM0 with DMA TX "ringbuffer"

'-application consts/vars -----------------------------------------------------|
Dim i,j,a,R,G,B,s,c,x,y,RP
Dim float ScDy

'polygons:
Dim px5(4)=(3,26,0,23,13),py5(4)=(0,16,16,0,26) 'created by pencil
Dim pxt5(4),pyt5(4)                             'for displace
Dim px10(9),py10(9),pxt10(9),pyt10(9)           'for generate and displace

' application start -----------------------------------------------------------|
'init polygon10 "star"
For i=0 To 9
  px10(i)=-(Sin((i*Pi/5))*(4+(i And 1)*7))+11
  py10(i)= (Cos((i*Pi/5))*(4+(i And 1)*7))+11
Next i

'welcome
 CLS 0
 Text MM.HRES/2, 0 ,"Driver in"  ,CT,7,1,RGB(255,255,0)
 Text MM.HRES/2, 9 ,"BASIC with" ,CT,7,1,RGB(0,255,0)
 Text MM.HRES/2,18 ,"brightness" ,CT,8,1,RGB(255,255,255)
 Text MM.HRES/2,25 ,"control"    ,CT,8,1,RGB(0,255,255)
 DupD()
 Pause 2000

 For i = 70 To 0 Step -5: HubDim(i):Pause 200: Next

'test place
 CLS 0
 Box  MM.HRES/2   , 1,10,10,0,0,RGB( 64,0,0)
 Box  MM.HRES/2+10, 1,10,10,0,0,RGB(128,0,0)
 Box  MM.HRES/2+20, 1,10,10,0,0,RGB(196,0,0)

 Box  MM.HRES/2   ,11,10,10,0,0,RGB(0, 64,0)
 Box  MM.HRES/2+10,11,10,10,0,0,RGB(0,128,0)
 Box  MM.HRES/2+20,11,10,10,0,0,RGB(0,196,0)

 Box  MM.HRES/2   ,21,10,10,0,0,RGB(0,0, 64)
 Box  MM.HRES/2+10,21,10,10,0,0,RGB(0,0,128)
 Box  MM.HRES/2+20,21,10,10,0,0,RGB(0,0,196)

For i = 0 To 100 Step 5
 Text 3,MM.VRES/2,Str$(i,3)+"%",LM,7,1,RGB(yellow):DupD()
 HubDim(i) 'vari brightness
 Pause 300
Next i
Pause 1000
HubDim(75) 'brightness in %(0-100)

'colortest
CLS RGB(grey)
Text MM.HRES/2,MM.VRES/2,"colortest",CM,7,1,0,1:DupD()
Pause 2000
CLS RGB(red):DupD()
Pause 1000
CLS RGB(green):DupD()
Pause 1000
CLS RGB(blue):DupD()
Pause 1000
CLS RGB(yellow):DupD()
Pause 1000
CLS RGB(cyan):DupD()
Pause 1000
CLS RGB(magenta):DupD()
Pause 1000

'scrolltext demo for static content
Tic1=Timer
 Text  MM.HRES, MM.VRES/2,"@", RM,1,1,RGB(R,G,B)
Tic2=Timer
ScDy=Tic2-Tic1'calc sample output delay
CLS 0
 Dim string tStr,sTxt(1)
 STxt(0)="MMBasic is amazing !!! "
 STxt(1)="The quick brown fox jumps over the lazy dog "
 'STxt(2)="Franz jagt im komplett verwahrlosten Taxi quer durch Bayern"

 For y= 0 To 1
  For j = 1 To Len(STxt(y))
   R=((Rnd*2))+1<<6
   G=(Rnd*3)<<6
   B=(Rnd*3)<<6
   tStr = Mid$(STxt(y),j,1)
   For i = 0 To 7 'font-wide
     Timer =0
     StripeMoveLeft(MM.VRES/2-8,MM.VRES/2+8)
     Text  MM.HRES+7-i, MM.VRES/2, tStr, RM,1,1,RGB(R,G,B)
     Do While Timer < ScDy:Pause 1:Loop 'to reduce the bumpiness
     DupD()
   Next i
  Next j
 Next y
 For i = 0 To MM.HRES
   StripeMoveLeft(MM.VRES/2-8,MM.VRES/2+8):DupD()
   Pause ScDy
 Next i

'Bitmaps
CLS 0:DupD()
For y = 0 To MM.VRES Step 32
  For x = 0 To MM.HRES Step 32          'chessboard
    Box x   ,y   ,16,16,0,0,RGB(64,64,0)
    Box x+16,y   ,16,16,0,0,RGB(0,0,64)
    Box x   ,y+16,16,16,0,0,RGB(0,0,64)
    Box x+16,y+16,16,16,0,0,RGB(64,64,0):DupD()
  Next x
Next y
GUI Bitmap MM.HRES/2-12,20,&hff8155aa55aa81ff,8,8,1,RGB(green),1
GUI Bitmap MM.HRES/2   , 0,&haa55aa55aa55aa55,8,8,4,RGB(cyan),1
GUI Bitmap MM.HRES/2-32,16,&hff8155aa55aa81ff,8,8,2,RGB(red),0
GUI Bitmap MM.HRES/2+20,20,&haa55aa55aa55aa55,8,8,1,RGB(magenta),0
Text MM.HRES/2,2,"Bitmaps",CT,7,1,RGB(255,255,255)
DupD()
Pause 2000

'lines and
CLS 0
For i = 0 To MM.HRES/2
  Line i,        0, MM.HRES-i-1,MM.VRES/2,1,RGB((i/8 Mod 4)<<6,0,0)
  Line i,MM.VRES/2, MM.HRES-i-1,MM.VRES-1,1,RGB(0,(i/8 Mod 4)<<6,0)
  DupD()
Next i
For i = MM.HRES/2 To MM.HRES-1
  Line i,        0, MM.HRES-i-1,MM.VRES/2,1,RGB(0,0,(i/8 Mod 4)<<6)
  Line i,MM.VRES/2, MM.HRES-i-1,MM.VRES-1,1,RGB((i/8 Mod 4)<<6,(i/8 Mod 4)<<6,0)
  DupD()
Next i

'pixel
For i = 0 To MM.HRES
  a = Sin(i/10)*15+MM.VRES/2
  b = Cos(i/12)*13+MM.VRES/2
  c = Sin((i+15)/15)*10+MM.VRES/2
  Pixel i, a, RGB(0,255,0)
  Pixel i, b, RGB(255,0,255)
  Pixel i, c, RGB(0,255,255): DupD()
Next i
Text MM.HRES/2,1 ,"Lines",CT,7,1,RGB(255,255,255),1:DupD()
Pause 200

'polygon
CLS 0
Text MM.HRES/2,2,"Poly fill",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 30
 R=(Rnd*3)<<6
 G=(Rnd*3)<<6
 B=(Rnd*3)<<6
 x = Rnd*(MM.HRES-27)+1
 y = Rnd*(MM.VRES-27)+1
 Math add px5(), x, pxt5()
 Math add py5(), y, pyt5()
 Polygon 5, pxt5(), pyt5(), RGB(r,g,b), RGB(r,g,b): DupD()
Next i

CLS 0
Text MM.HRES/2,2 ,"Polygon",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 60
 R=(Rnd*3)<<6
 G=(Rnd*3)<<6
 B=(Rnd*3)<<6
 x = Rnd*(MM.HRES-22)
 y = Rnd*(MM.VRES-22)
 Math add px10(), x, pxt10()
 Math add py10(), y, pyt10()
 Polygon 10, pxt10(), pyt10(), RGB(r,g,b): DupD()
Next i

CLS 0
 Arc MM.HRES/2,  MM.VRES/2 ,10, 16,  45, 225,RGB(255,0,64)
 Arc MM.HRES/2,  MM.VRES/2 ,10, 16, 225, 360,RGB(64,0,255)
 Arc MM.HRES/2,  MM.VRES/2 , 6, 10,  90, 180,RGB(64,64,128)
 Arc MM.HRES/2,  MM.VRES/2 , 6, 10, 180,  20,RGB(0,64,64)
 Text 0,0,"Arcs",LT,7,1,RGB(0,255,64),1:DupD()
Pause 1000

CLS 0
Text MM.HRES/2,2,"Circle",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 100
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*5+5
  X=S+Rnd*(MM.HRES-S*2-1)
  Y=S+Rnd*(MM.VRES-S*2-1)
  Circle X,Y,S,1,1,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"Circle fill",CT,8,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 150
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*5+5
  X=S+Rnd*(MM.HRES-S*2-1)
  Y=S+Rnd*(MM.VRES-S*2-1)
  Circle X,Y,S,0,1,0,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"RBox r=3",CT,7,1,RGB(0,255,64):DupD()
Pause 700
For i = 0 To 100
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*9+7
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  RBox X,Y,S,S, 3,RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"RBox fl",CT,7,1,RGB(0,255,64):DupD()
Pause 600
For i = 0 To 70
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*9+7
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  RBox X,Y,S,S, 3,RGB(R,G,B),RGB(R,G,B): DupD()
Next i

CLS 0
Text MM.HRES/2,2,"Box",CT,7,1,RGB(0,255,64):DupD()
Pause 700
For i = 0 To 250
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*10+5
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  Box X,Y,S,S,1,RGB(R,G,B): DupD()
Next i

CLS 0:DupD()
Text MM.HRES/2,2,"Box filled",CT,7,1,RGB(0,255,64):DupD()
Pause 700
For i = 0 To 650
  R=(Rnd*3)<<6
  G=(Rnd*3)<<6
  B=(Rnd*3)<<6
  S=Rnd*10+5
  X=Rnd*(MM.HRES-S-1)
  Y=Rnd*(MM.VRES-S-1)
  Box X,Y,S,S,0,0,RGB(R,G,B): DupD()
Next i

'Fonts
CLS 0:DupD()
Text MM.HRES/2,  1 ,"font8",CT,8,1,RGB(magenta)
Text MM.HRES/2,  7 ,"font7",CT,7,1,RGB(red)
Text MM.HRES/2, 15 ,"font1",CT,1,1,RGB(green):DupD()
Pause 1000

CLS 0
Text MM.HRES/2,1  ,"can we run" ,CT,7,1,RGB(255,255,0)
Text MM.HRES/2,12 ,"Font 9"     ,CT,7,1,RGB(255,255,64)
Text MM.HRES/2,23 ,"VGA-Demo"   ,CT,7,1,RGB(255,255,128):DupD
Pause 1000
 For i=0 To MM.VRES/16-1
  For j=0 To MM.HRES/16-1
   Text j*16,i*16,Chr$(Rnd*7+32),LT,9,1,RGB(0,0,192)
  Next j
  DupD()
 Next
Pause 1000

'Text orientation
CLS 0:DupD()
Text MM.HRES/2   ,8         ,"text"        ,CT,8,1,RGB(255,255,255)
Text MM.HRES/2+3 ,0         ,"orientation" ,CT,8,1,RGB(255,255,255)
Text MM.HRES/2-24,2         ,"vertical"    ,LTV,8,1,RGB(255,255,0)
Text MM.HRES/2   ,MM.VRES-7 ,"invert"      ,CBI,8,1,RGB(128,64,255)
Text 0           ,2         ,"counter"     ,LBU,8,1,RGB(0,255,64)
Text MM.HRES-7   ,2         ,"clock"       ,RTD,8,1,RGB(255,64,64):DupD()
Pause 2000

'Text align
CLS 0:DupD()
Text MM.HRES/2,1,"Text align",CT,8,1,RGB(0,255,64),0:DupD()
Text 0        ,0        ,"LT",LT,8,1,RGB(64,64,255),RGB(64, 0, 0)
Text MM.HRES  ,0        ,"RT",RT,8,1,RGB(64,64,255),RGB(64,64, 0)
Text 0        ,MM.VRES  ,"LB",LB,8,1,RGB(64,64,255),RGB(0 ,64,64)
Text MM.HRES  ,MM.VRES  ,"RB",RB,8,1,RGB(64,64,255),RGB(64, 0,64):DupD()
Text MM.HRES/2,MM.VRES/2,"CM",CM,8,1,RGB(64,64,255),RGB(64, 0,64):DupD()
Pause 2000

'Drive "b:"
'Load image "tut256.bmp",0,0:DupD()
'Pause 2000

'scrolltext demo for static content
Tic1=Timer
 Text  MM.HRES, MM.VRES/2,"@", RM,7,1,RGB(R,G,B)
Tic2=Timer
ScDy=(Tic2-Tic1)*2 'calc max output delay
Print ScDy
CLS 0 ' did not show the test
 Text MM.HRES/2,MM.VRES/2,"geoffg.net",CM,7,1,RGB(128,0,0) :DupD()
 Dim string tSt0,ScollText0=" that's PicoMite "
 Dim string tSt1,ScollText1="MMBasic & RP2040 "

 For j = 1 To Len(ScollText0)+1'both the same len
   tSt0 = Mid$(ScollText0,j,1)
   tSt1 = Mid$(ScollText1,j,1)
   For i = 0 To 7 'font-wide
     StripeMoveLeft( MM.VRES/2+6, MM.VRES/2+15)
     StripeMoveLeft( MM.VRES/2-6, MM.VRES/2-15)
     Timer =0
     Text  MM.HRES+7-i, MM.VRES-2, tSt0, RB,7,1,RGB(128,0,128)
     Text  MM.HRES+7-i,         2, tSt1, RT,7,1,RGB(0,192,0)
     Do While Timer < ScDy:Pause 0.1:Loop 'to reduce the bumpiness
     DupD()
   Next i
 Next j
 For i = 0 To MM.HRES
   StripeMoveLeft( MM.VRES/2+6, MM.VRES/2+15)
   StripeMoveLeft( MM.VRES/2-6, MM.VRES/2-15)
   Pause ScDy
   DupD()
 Next i

CLS 0:DupD()
Text MM.HRES/2,MM.VRES/2,"FIN",CM,1,2,RGB(64,192,64),0:DupD()
Pause 1000
End

'- subs application -----------------------------------------------------------|
Sub HubScrBmp( Fn As string) 'scroll (24bit)bmp direct from file to screen
'to make it easier, the bmp have to be rotated 90 degree right and mirrored
Local integer lGap, lWid, lHei, lBas, lEnd, lPos, lRow, x
 Open Fn For input As #1
  '- read parts of bmp-header       IDs: Adr =0, S=1, W=2, H=3
  Seek #1,19      ' skip headersize
  lWid = HubRDW() ' wide
  lHei = HubRDW() ' height
  lBas = WAdr+MM.HRES-1        ' adr of column to insert (TopRight)
  lEnd = WAdr+MM.HRES*MM.VRES-1' adr of column to insert (BottomRight)
  'now read bmp-data: bmp-lines to display-columns
  Seek #1,55                     'skip planes, bitcount, compress, ...
  For lRow = 0 To lHei 'height
   'todo:check if lWid <> MM.VRES
   For lPos = lBas To lEnd Step MM.HRES 'over the wide: topleft -> last column
     Memory set lPos, HubRP(),1
   Next ' lPos
   'todo: handle if lWid <> MM.VRES
   lGap = 3-Loc(#1)And 3        'check for 4-byte boundary/line
   If lGap>0 Then x=Asc(Input$(lGap,#1)) 'skip dummy-data
   'todo: delay ?
   DupD()
   StripeMoveLeft(0,63)
   'Pause 7
  Next ' lRow
 Close #1
End Sub

'Read 3 bytes for RGB from a file which is a 24bit BMP.
'Mask the top 2 bits, then shift into place to create an
'index 0 to 63 into a colour look up array
Function HubRP()'read pixel
 RP=Asc(Input$(1,1))>>6 Or(Asc(Input$(1,1))>>6)<<2 Or(Asc(Input$(1,1))>>6)<<4
 HubRP = C6Tb(RP)
End Function

Function HubRDW()'read dword
'reads four bytes from file
Local integer lsb,msb,msb1,msb2
 lsb =Asc(Input$(1,#1))
 msb =Asc(Input$(1,#1))
 msb1=Asc(Input$(1,#1))
 msb2=Asc(Input$(1,#1))
 HubRDW = (msb2<<24)+(msb1<<16)+(msb<<8)+lsb
End Function

Sub StripeMoveLeft(slY0,slY1)'area
Local slT,sWid=MM.HRES,sDec=sWid-1
If slY0>slY1 Then slT=slY1:slY1=slY0:slY0=slT
Local sSrc=WAdr+slY0*sWid,sEnd=WAdr+slY1*sWid
 For slT=sSrc To sEnd Step sWid:Memory copy slT+1,slT,sDec
 Next 'slT
End Sub

Sub StripeMoveRight(srY0,srY1)'area
Local srT,sWid=MM.HRES,sDec=sWid-1
If srY0>srY1 Then srT=srY1:srY1=srY0:srY0=srT
Local sSrc=WAdr+srY0*sWid,sEnd=WAdr+srY1*sWid
 For srT=sSrc To sEnd Step sWid:Memory copy srT,srT+1,sDec
 Next 'srT
End Sub

Sub StripeMoveUp(suX0,suX1)'Start & End of strip width
Local suT
If suX0>suX1 Then suT=suX1:suX1=suX0:suX0=suT
Local sEnd=WAdr+suX0,sSrc=sEnd+MM.HRES*MM.VRES-MM.HRES,sWid=suX1-suX0
 For suT=sSrc To sEnd Step -MM.HRES:Memory copy suT,suT+MM.HRES,sWid
 Next 'suT
End Sub

Sub StripeMoveDn(suX0,suX1)'Start & End of strip width
Local sdT
If suX0>suX1 Then sdT=suX1:suX1=suX0:suX0=sdT
Local sSrc=WAdr+suX0,sEnd=sSrc-MM.HRES+MM.VRES*MM.HRES,sWid=suX1-suX0
 For sdT=sSrc To sEnd Step MM.HRES:Memory copy sdT,sdT-MM.HRES,sWid
 Next 'sdT
End Sub

'- subs user display ----------------------------------------------------------|
Sub mm.user_rectangle(x1,y1,x2,y2,col)
'looks not very nice because of speed-optimization. Sorry!!!!!!!!
col=col And &hC0C0C0' no background: no use of transparency
If (lcol<>col)Then
 rC=rgbTo222(col):lcol=col
EndIf
If (x1=x2)And(y1=y2)Then'Short cut for single pixel;Looks like MMBasic trim here
 Memory set WAdr+x1+(MM.VRES-y1-1)*MM.HRES,rC,1:Exit Sub
EndIf
Local rT,rI,rWid=MM.HRES
If (x1>x2)Then rT=x2:x2=x1:x1=rT' swap vars: because the calling
If (y1>y2)Then rT=y2:y2=y1:y1=rT'-function did not sort !!!
'more tests decrease speed, coords outside screen will skip the hole rec
If (x1<0)Or(y1<0)Or(x2>MM.HRES-1)Or(y2>MM.VRES-1)Then Exit Sub
Local rW=x2-x1+1,rH=y2-y1,rBas=WAdr+(MM.VRES-y2-1)*rWid+x1,rTes=rBas+rH*rWid
For rI=rBas To rTes Step rWid:Memory Set rI,rC,rW
Next
End Sub

'------------------------------------------------------------------------------------
Sub mm.user_bitmap(x0,y0,bW,bH,bS,Fc,Bc,bitmap)
'looks not very nice because of speed-optimization. Sorry!!!!!!
Local bK,bM,bMas,bO,bDat,Acol,bX
Local bWid=MM.HRES,bBas=WAdr+x0,bI=bW*bH,bYba=MM.VRES-y0-1
 Fc=Fc And &hC0C0C1
 If (lFco<>Fc)Then Fcol=rgb2222(Fc):lFco=Fc
 Bc=Bc And &hC0C0C1
 If (lBco<>Bc)Then Bcol=rgb2222(Bc):lBco=Bc
If bS=1 Then'no scale: move the query outside the loop
 If Fcol*Bcol Then'if product>0 => no transparenz; move query outside the loop
  For bX=1To bI
   If Not bMas Then
    bDat=Peek(BP bitmap):bMas=MSB'next byte; reset mask msb
   EndIf
   If (x0+bK)<bWid Then
     Memory Set bBas+(bYba-bM)*bWid+bK,Choice(bDat And bMas,Fcol,Bcol),1
   EndIf
   Inc bK'                      column-counter
   If bK=bW Then Inc bM:bK=0'   cr lf(line-conter)
   If bM>bYba Then Exit For '   max Y-pos reached(trouble with vertical text)
   bMas=bMas>>1'                move mask
  Next
 Else
  For bX=1To bI
   If Not bMas Then
    bDat=Peek(BP bitmap):bMas=MSB'next byte; reset mask msb
   EndIf
   Acol=Choice(bDat And bMas,Fcol,Bcol)
   If Acol And (x0+bK)<bWid Then
    Memory Set bBas+(bYba-bM)*bWid+bK,Acol,1
   EndIf
   Inc bK'                      column-counter
   If bK=bW Then Inc bM:bK=0'   cr lf(line-conter)
   If bM>bYba Then Exit For '   max Y-pos reached
   bMas=bMas>>1'                move mask
  Next
 EndIf
Else ' scale > 1
 For bX=1To bI
  If Not bMas Then'              byte scan fin -> next
   bDat=Peek(BP bitmap):bMas=MSB'reset mask msb first
  EndIf '                        mask = 0
  Acol=Choice(bDat And bMas,Fcol,Bcol)
  If Acol Then'not 0(transparent)
   For bO = 0 To bS-1
    If (x0+bK+bS)<bWid Then
     Memory Set bBas+(bYba-bM*bS+bO)*bWid+bK*bS,Acol,bS
    EndIf
   Next
  EndIf ' transparent
  Inc bK'                      column-counter
  If bK=bW Then Inc bM:bK=0'   cr lf(line-conter)
  If ((bM+1)*bS)>bYba Then Exit For 'max Y-pos reached
  bMas=bMas>>1'                move mask
 Next
EndIf
End Sub

Sub DupD() 'DisplayUpDate
 If HubStack >1 Then 'stacked->rearrange by copying to an other array
  Local dInc=MM.HRES,src0,src1=Wadr+MM.VRES/2*dInc,des0=pSt0,stop=src1-dInc
  For src0=WAdr To stop Step dInc
   Memory copy src1,des0,dInc
   Inc src1,dInc:Inc des0,dInc
   Memory copy src0,des0,dInc
   Inc des0,dInc
  Next
  Memory copy pSt0,pAA+0,HubPixs>>1,1,2 'to even adr of ringbuffer
  Memory copy pSt1,pAA+1,HubPixs>>1,1,2 'to odd adr of ringbuffer
 Else
  Memory copy WAdr,pAA+0,HubPixs>>1,1,2 'to even adr of ringbuffer
  Memory copy VAdr,pAA+1,HubPixs>>1,1,2 'to odd adr of ringbuffer
 EndIf
End Sub

'-PIO-------------------------------------------------------------------------|
Sub StartHub75Pio()
  PIO dma tx 1,0,0,Pack(),,,HubInts*2 '32bit count = 2*64bit count))
End Sub

Sub InitHub75Pio()
Local ExeC,PinC,ShiC,Freq,pnl'PioNextLine
  SetPin gp0,pio1 ' out RED  -----+
  SetPin gp1,pio1 ' out GREEN     |
  SetPin gp2,pio1 ' out BLUE      |
  SetPin gp3,pio1 ' out red       SM0 out
  SetPin gp4,pio1 ' out green     |
  SetPin gp5,pio1 ' out blue -----+
  '----------------------------------------------
  SetPin gp6,pio1 ' out A    -----+
  SetPin gp7,pio1 ' out B         |
  SetPin gp8,pio1 ' out C         SM1 out
  SetPin gp9,pio1 ' out D         |
  SetPin gp10,pio1' out E     ----+
  '----------------------------------------------
  SetPin gp11,pio1' sideset CLK --SM0
  SetPin gp12,pio1' sideset LATCH-SM1
  SetPin gp13,pio1' sideset /OE --SM2
  '----------------------------------------------
  SetPin gp25,pio1' Bit0/1-Pin  --SM0,SM1,SM2,SM3
 'BGR for upper half and bgr for lower half
  PIO CLEAR 1
 'SM0: RGB-Data
  pnl = Pio(next line 1)
  PIO assemble 1
  .program RgbData
   .side set 1
   .line next
   .wrap target
    Jmp Pin, one   side 0 'if pin set jump
     Out Null, 2   side 0 'begin Bit0, skip first 2 bits
     In  Osr,  3   side 0 'collect Bit0-data top
     Out Null, 8   side 0 'skip whole byte
     In  Osr,  3   side 0 'collect Bit0-data down
     Out Null, 6   side 0 'skip whole byte
     Jmp ende      side 0 'fin
    .label one
     Out Null, 5   side 0 'begin Bit1, skip Bit0-data
     In  Osr,  3   side 0 'collect  Bit1-data top
     Out Null, 8   side 0 'Skip 3rest + 5Bits
     In Osr,   3   side 0 'collect Bit1-data down
     Out Null, 3   side 0 'skip whole byte
    .label ende
    Mov pins,isr   side 0 'out collected BGR-data up-down
    IRQ SET 0      side 1 'Clk+bgrBGR-ready for SM2
    Wait 1 irq 1   side 0 'wait for SM1(ctrl)
   .wrap
  .end program 'list
  ExeC = Pio(execctrl GP25,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,0,6,,gp11,,gp0) 'sideset:gp11(CLK), out:gp0,1,2,3,4,5
  ShiC = Pio(shiftctrl 0,0,0,1,0,1)'InShDir(l),OutShDir(r)
  Freq = 20700000
  PIO init machine 1,0,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
 'SM1: X = pixelcount(rowlen);Y = address of line
  pnl = Pio(next line 1)
  PIO assemble 1
  .program Ctrl
   .side set 1
   .line next
   .wrap target
    Wait 1 irq 0   side 0 'wait for "BGR-data present" from SM0
    Jmp x--,nPix   side 0 'no EndOfLine
     Mov x,isr     side 0 '(tic10) reset pixel-count to rowlen
     Mov pins,y    side 1 'Latch+out new address(ABCDE)
     IRQ SET 2     side 0 'EOL inform SM2 /EOn
     Jmp y--,nPix  side 0 'not EndOfFrame
      Mov y,osr    side 0 'reset line-adr; scan: 1/16(15),1/32(31)
      IRQ SET 3    side 0 'inform SM3 to toggle pin (saves a command)
    .label nPix
    IRQ SET 1      side 0 '->ready for next pixel-data
   .wrap
  .end program 'list
  ExeC = Pio(execctrl GP25,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,1,5,,gp12,gp25,gp6)'sset:Clk/Latch,set:gp25,out:gp6..
  ShiC = Pio(shiftctrl 0,0,0,0,0,0)'autopull off
  PIO init machine 1,1,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
  PIO   start 1,1   'first wait for irq from SM0-data: time to execute extras
  PIO   write 1,1,2,HubW-1,HubH/2-1'values for row-adr and line-len
  PIO execute 1,1,&h80A0  'Pull block   side 0 'get rowlen
  PIO execute 1,1,&hA0C7  'Mov isr,osr  side 0 'save rowlen in isr
  PIO execute 1,1,&hA026  'Mov x,isr    side 0 'reset pixel-count
  PIO execute 1,1,&h80A0  'Pull block   side 0 'get linescan,
  PIO execute 1,1,&hA047  'Mov y,osr    side 0 'reset line-adr
 'SM2 for brightness: triggered by SM1 ctrl
  pnl = Pio(next line 1)
  PIO assemble 1
  .program delay
   .side set 1
   .line next
   .wrap target
    .label start
    Wait 1 irq 2    side 1 'leds off, wait for signal from SM1-ctrl
    Mov x,osr       side 1 'allways reload with Bit1-delay: saves a jump
    Jmp !x,start    side 1 'needed in case of 0(off)
    Jmp Pin, delay  side 1 'jump if this is the right one else -
     Mov x,isr      side 1 'overwrite with Bit0-delay
    .label delay
    Jmp x--,delay   side 0 'sideset leds on
   .wrap
  .end program 'list
  ExeC = Pio(execctrl GP25,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 1,,,,gp13,,) 'sideset:gp12(/OE)
  ShiC = Pio(shiftctrl 0,0,0,0,0,0)'autopull off
  PIO init machine 1,2,Freq,PinC,ExeC,ShiC,pnl,1,1,1'side_set-,set-,outDir=out
  PIO   start 1,2 '"delay" starts first and wait immediately for irq from "crtl"
  HubDim(75)'init with startvalue(40%) possible from saved var
 'SM3 toggle Pin: there was one SM leftand we can save a command with this
  pnl = Pio(next line 1)
  PIO assemble 1
   .program toggle
    .line next
    .wrap target
     Wait 1 irq 3   'wait for SM1: EndOfFrame
     Mov Pins,!Pins 'toggle pin
    .wrap
   .end program 'list
  ExeC = Pio(execctrl gp25,Pio(.wrap target),Pio(.wrap))
  PinC = Pio(pinctrl 0,0,1,gp25,,,gp25) 'out,in,gp25
  ShiC = Pio(shiftctrl 0,0,0,0,0,0)
  PIO init machine 1,3,Freq,PinC,ExeC,ShiC,pnl,1,1,1
  PIO   start 1,3 '
End Sub 'InitHub75Pio()

Sub HubDim(iBr)'1..100  possible in combination with a LDR
If (iBr<0)Or(iBr>100) Then Exit Sub
Local B1=DimTab(Int(iBr/5.5))*HubW/64,B0=B1/2'with DimTable
'Local B1=(iBr*HubW)/10,B0=B1/2'(tic10) per column = max val
  PIO   write 1,2,2,B0,B1 'init value Bit0/1-delays
  PIO execute 1,2,&h80A0  'Pull block    side 0 'get delay Bit0
  PIO execute 1,2,&hA0C7  'Mov isr,osr   side 0 'save delay in isr
  PIO execute 1,2,&h80A0  'Pull block    side 0 'get delay Bit1 in osr
End Sub

Sub InitCt(Mix$)
Local iI,iRd,iGr,iBl
 'create colortable  format bgrBGR00
 Mix$=UCase$(Mix$)
 For iRd = 0 To 3
  For iGr = 0 To 3
    For iBl = 0 To 3
     iI =  1 Or(iBl And 1)<<2 Or(iBl And 2)<<4
     iI = iI Or(iGr And 1)<<3 Or(iGr And 2)<<5
     iI = iI Or(iRd And 1)<<4 Or(iRd And 2)<<6
     iI = iI And &hff
     Select Case Mix$ 'channel-config(3!)
      Case "RGB"
        C6Tb(iBl*16+iGr*4+iRd)=iI
      Case "RBG"
        C6Tb(iGr*16+iBl*4+iRd)=iI
      Case "GRB"
        C6Tb(iBl*16+iRd*4+iGr)=iI
      Case "GBR"
        C6Tb(iRd*16+iBl*4+iGr)=iI
      Case "BRG"
        C6Tb(iGr*16+iRd*4+iBl)=iI
      Case "BGR"
        C6Tb(iRd*16+iGr*4+iBl)=iI
     End Select
 Next iBl,iGr,iRd
End Sub

'helper ----------------------------------------------------------------------
Function Rgb2222(col)'for bitmaps
 If col=1 Then rgb2222=0:Exit Function
 Rgb2222=C6Tb((col And &hc00000)>>18 Or(col And &hc000)>>12 Or(col And &hc0)>>6)
End Function

Function RgbTo222(col)'for recs/pixel: no transparency: no query
RgbTo222=C6Tb((col And &hc00000)>>18 Or(col And &hc000)>>12 Or(col And &hc0)>>6)
End Function
'---------------------------------------------------------------------------------
Sub mm.end
  PIO DMA TX OFF
  PIO stop 1,3
  PIO stop 1,2
  PIO stop 1,1
  PIO stop 1,0
  SetPin gp13,dout:Pin(gp13)=1 'set /OE (sometimes it stay on)
End Sub

DefineFont #9
08201010
C003C003 C003C003 C003C003 DFFBDFFB DFFBDFFB C003C003 C003C003 C003C003
C003C003 0000E001 FC03F001 FFF0FFC7 E3FF0FFF 800FC03F 80070000 C003C003
C003C003 C003C003 0000C003 FFFFFFFF FFFFFFFF C0030000 C003C003 C003C003
C003C003 80078007 402F000F 77EF63EF F7C6F7EE F000F402 E001E001 C003C003
C003C003 8007C007 003F800F 1FFC07FE 7FE03FF8 F001FC00 E003E001 C003C003
C003C003 E003E003 FC01F001 7FF8FFE0 0FFE3FFC 800F003F C0078007 C003C003
C003C003 8007C007 003F800F 1FFC07FE 7FE03FF8 F001FC00 E003E001 C003C003
C003C003 E001E003 FC00F001 3FF87FE0 07FE1FFC 800F003F C0078007 C003C003
End DefineFont
                                                                                        