'CAN-FILTER.BAS Version 0.1
'Proof of concept picomite data transfer via CAN-BUS with MCP2515
'CAN-BUS timing acc. to "KVASER bit timing calculator for MCP2510"
'parameters adapted for moduloscillator 8MHz,BUS-speed 125 Kbits/s
'used transmit/receive buffer "0" only,message receive by interrupt,
'standard identifiers only,acceptance filtering example,limited failure
'evaluation,transfer of 1 byte per frame only,tested with 3 CAN-
'modules (picos) connected to the CAN-bus.

Dim ID_S,ID_R,ID_F,CAN_Data_S,CAN_Data_R,RC,BN,ER As integer
Dim A,H,L,j As integer
Print "Activate filter (y/n) ?"
Do
Select Case Inkey$
Case "y" :Input "Filter ID (0-2047): "; ID_F:Exit
Case "n" :ID_F=-1:Exit
End Select
Loop

'SPI setup
SetPin GP1,dout:Pin(GP1)=1  'define CS-pin of SPI interface (Pin 2)
SetPin GP4,INTL,CAN_RECEIVE 'define interrupt pin/routine for receive frame
SetPin GP0,GP3,GP2,SPI      'define SPI-pins RX,TX,CLK
SPI open 100000,0,8        'Open SPI speed,mode,bits

CAN_INIT 'Init. CAN-adapter
RC=0 'Start condition no ID received

'Set filter ID if selected (positive ID)
If ID_F>=0 Then
CAN_FILTER ID_F
EndIf

Do

' "CAN_TRANSMIT ID_S,CAN_Data_S" -> Subroutine to send ID and Data

' "CAN_RECEIVE" -> Subroutine to receive ID_R and CAN_Data_R via interrupt

' Send simulated CAN-frame every second
If Timer>1000 Then
CAN_TRANSMIT ID_S,CAN_Data_S
ID_S=ID_S+1:If ID_S=2047 Then ID_S=0 'Send test ID
CAN_Data_S=CAN_Data_S+1:If CAN_Data_S=255 Then CAN_Data_S=0 'Send test Data
Timer =0
EndIf

'Print new received CAN-Frame if available
If RC=1 Then
RC=0
Print "ID_R: ",ID_R, " Data Received: ",CAN_Data_R
EndIf


'Switch filter on/off if filtering previously selected
If Inkey$="f" Then CAN_FILTER_ON
If Inkey$="n" Then CAN_FILTER_OFF

Loop

SPI close

Sub CAN_INIT
'Reset adapter
Pin(2)=0:j=SPI(&B11000000):Pin(2)=1
'Set CAN-bus timing MCP2515 to 125 KBits/s
Pin(2)=0:j=SPI(&H02):j=SPI(&H2A):j=SPI(&H01):Pin(2)=1'Register CNF1
Pin(2)=0:j=SPI(&H02):j=SPI(&H29):j=SPI(&H9A):Pin(2)=1'Register CNF2
Pin(2)=0:j=SPI(&H02):j=SPI(&H28):j=SPI(&H07):Pin(2)=1'Register CNF3
'Set CAN-interupt enable register CANINTE receive buffer 0 full enable
Pin(2)=0:J=SPI(&H02):j=SPI(&H2b):j=SPI(&B00000001):Pin(2)=1
'Set CAN-control register CANCTRL to normal mode
Pin(2)=0:j=SPI(&H02):j=SPI(&H0F):j=SPI(&B00000000):Pin(2)=1
End Sub

Sub CAN_TRANSMIT ID_S,CAN_Data_S
'Clear error message
ERR$=""
'Set bits transmit buffer standard ident register high (bits 10 to 3 =0 )
A=ID_S:H=A>>3 And &B0000000011111111
Pin(2)=0:j=SPI(&H02):j=SPI(&H31):j=SPI(H):Pin(2)=1
'Set bits transmit buffer standard ident register low (bits 5 to 7)
A=ID_S:L=A<<5 And &B0000000011111111
Pin(2)=0:j=SPI(&H02):j=SPI(&H32):j=SPI(L):Pin(2)=1
'Set Transmit buffer 0 data lengh code register TXB0DLC (possible 1-8 bytes)
Pin(2)=0:j=SPI(&H02):j=SPI(&H35):j=SPI(&B00000001):Pin(2)=1
'Load data to be transmitted into transmit buffer TXB0DO(1 byte, see above)
Pin(2)=0:j=SPI(&H02):j=SPI(&H36):j=SPI(CAN_Data_S):Pin(2)=1
'Send transmition request to transmit data control register (TXB0CTRL)
BN=&B00001000
Pin(2)=0:j=SPI(&H02):j=SPI(&H30):j=SPI(BN):Pin(2)=1
'Loop until transmittion has been performed or leave loop on error
Do While BN<>0
Pin(2)=0:j=SPI(&H03):j=SPI(&H30):BN=SPI(0):Pin(2)=1
'Read error flag register EFLG
Pin(2)=0:j=SPI(&H03):j=SPI(&H2D):ER=SPI(0):Pin(2)=1
'Evaluate errors
If ER And &B0010000 Then
ERR$="BUS-off":Exit Do
EndIf
If ER And &B00000001 Then
ERR$="ERROR-warning":Exit Do
EndIf
'Reset CAN interrupt flag register CANINTF To clear lost interrupts
Pin(2)=0:j=SPI(&H02):j=SPI(&H2C):j=SPI(0):Pin(2)=1
Loop
'Present transmition result
Print "ID_S: ";ID_S, " Data Transmitted: ";CAN_Data_S,ERR$
End Sub

Sub CAN_RECEIVE
'Read receive buffer 0 standard identification register high RXB0SIDH
Pin(2)=0:j=SPI(&H03):j=SPI(&H61):H=SPI(0):Pin(2)=1
'Read receive buffer 0 standard identification register low RXB0SIDL
Pin(2)=0:j=SPI(&H03):j=SPI(&H62):L=SPI(0):Pin(2)=1
'Calculate received ID
L=L>>5:ID_R=H*8+L
'Read receive buffer control register RXB0RTRL (special fast SPI command)
Pin(2)=0:j=SPI(&B10010010):CAN_Data_R=SPI(0):Pin(2)=1
RC=1
End Sub

Sub CAN_FILTER ID_F
'set receive buffer 0 control register RXB0CRTL to filters for standard identf.
Pin(2)=0:j=SPI(&H02):j=SPI(&H60):j=SPI(&B00100000):Pin(2)=1
'Set CAN-control register CANCTRL to configuration mode
Pin(2)=0:j=SPI(&H02):j=SPI(&H0F):j=SPI(&B10000000):Pin(2)=1
'Set bits filter 0 standard ident register high RXF0SIDH (bits 10 to 3 =0 )
A=ID_F:H=A>>3 And &B0000000011111111
Pin(2)=0:j=SPI(&H02):j=SPI(&H00):j=SPI(H):Pin(2)=1
'Set bits filter 0 standard ident register low RXF0SIDL (bits 5 to 7)
A=ID_F:L=A<<5 And &B0000000011111111
Pin(2)=0:j=SPI(&H02):j=SPI(&H01):j=SPI(L):Pin(2)=1
'Set mask 0 standard ident register high RXM0SIDH
Pin(2)=0:j=SPI(&H02):j=SPI(&H20):j=SPI(&B11111111):Pin(2)=1
'Sep mask 0 standard ident register low RXM0SIDL (bits 5 to 7)
Pin(2)=0:j=SPI(&H02):j=SPI(&H21):j=SPI(&B11100000):Pin(2)=1
'Set CAN-control register CANCTRL to normal mode
Pin(2)=0:j=SPI(&H02):j=SPI(&H0F):j=SPI(&B00000000):Pin(2)=1
End Sub

Sub CAN_FILTER_OFF
'Set receive buffer 0 control register RXB0CTRL filters off
Pin(2)=0:j=SPI(&H02):j=SPI(&H60):j=SPI(&B01100000):Pin(2)=1
End Sub

Sub CAN_FILTER_ON
'Set receive buffer 0 control register RXB0CTRL filters on
Pin(2)=0:j=SPI(&H02):j=SPI(&H60):j=SPI(&B00100000):Pin(2)=1
End Sub
