  '                         CHESS-2-PICO
  ' terminal program for external chess engine running on 2nd pico running TSCP
  ' TSCP uses COM1 port GP0,GP1 , terminal uses COM2 port GP4,GP5
  '
  ' Versions
  ' 0.1         colorchess_b27 auto mode only running on V050707b27
  ' 0.2         tiles back to 8x12 to potentially colour text
  ' 0.3         UI for player=white
  ' 0.4         focus on string handling and validation
  ' 0.5         parse all commands
  ' 0.6         plays a good match to the end
  ' 0.7         lists moves
  ' 0.8         Color list
  ' 0.9         Fixes Peters bugs
  
  
  debug=0       ' development help
  reply=0       ' 0=single player. 1=auto mode
  hlt=0         ' halt is the end of the game
  wtime=100     ' waiting time toget response from chess engine
  
  
  ' open COM port to second pico
  SetPin gp5,gp4,COM2
  Open "COM2:115200,2048" As #1   '115200 baud = 0.1ms per character
  if debug then open "a:/log.txt" for output as #3
  
  ' defines
  Dim respons$(12)  'response from TSCP, max size is board response is 13 lines
  MODE 1:CLS        'screen definition
  score_template
  
  
  
  'a clean game
  pause 1000
  restart_chess     'does not work when game has ended ?
  board
  pause 1000
  
  'interactive terminal function
  Do
    
    ' bypass player when reply is automatic
    if reply=0 then
      
      'make sure computer does not play
      print #1,"off"
      if debug then print "off":print #3,"off"
      Pause wtime
      n=get_response%()
      
      'read the next payer move
      print @(260,440);
      input "player move ";a$
      print
      
    else
      
      a$="on"   'make computer move for player as well
      
    end if
    
    'check validity - to be implemented
    valide = vali%(a$)
    
    if valide=4 then  'it is a valid move
      
      print #1,a$
      if debug then print a$:print #3,a$
      Pause wtime
      n=get_response%()
      inc hlt,game_end(n)
      game_flow(n)
      
      'show the board
      board
      
      'force the computer to play
      Print #1,"on"
      if debug then print "on":print #3,"on"
      Pause wtime
      n=get_response%()
      inc hlt,game_end(n)
      game_flow(n)
      
      'print respons$(0) 'the computer move
      if debug then
        for i=0 to n
          print respons$(i)
        next
      end if
      
    else 'this may be a command
      
      a$=cmd$(a$) 'convert to valid commands
      
      if len(a$) then
        Print #1,a$
        if debug then print a$:print #3,a$
        Pause wtime
        n=get_response%()
        inc hlt,game_end(n)
        game_flow(n)
      end if
      
    end if
    
    'show the board
    board
    
  Loop Until a$=Chr$(27) or hlt>0
end
  
  
  
sub game_flow(n)
  if n>0 then
    if instr(respons$(n-1),"Computer") then
      print @(xlist,ylist);right$(respons$(n-1),4);
      if xlist<120 then xlist = 100 - xlist else xlist = 324-xlist
      inc ylist,mm.fontheight*((xlist=30)+(xlist=142))
      if ylist > ymaxlist then xlist=142:ylist=28
    end if
  endif
end sub
  
sub score_template
  
  box 1,1,221,478
  print @(16,12);"WHITE BLACK   WHITE BLACK"
  for i=1 to 37
    print @(4,16+i*mm.fontheight);str$(i,2);"            ";str$(i+37,2);
  next
  
  'tiles
  tile 0,0,RGB(black),rgb(white),28,40
  tile 3,2,rgb(blue),rgb(white),10,38
  tile 17,2,rgb(blue),rgb(white),10,38
  TILE 8,1,RGB(WHITE),RGB(BLACK),5,1
  TILE 22,1,RGB(WHITE),RGB(BLACK),5,1
  
  'game list related
  xlist=30:  ylist=28:  ymaxlist = 460
  
end sub
  
  'detect computer says end of game
function game_end(n)
  local i,a$
  
  game_end=0
  for i=0 to 12
    a$ = respons$(i)
    inc game_end,instr(a$,"legal")    'no legal moves
    inc game_end,instr(a$,"1/2-1/2")  '50 moves
    inc game_end,instr(a$,"mates}")   'check mate
  next
  
end function
  
  
sub board
  
  'print the board as ascii
  Print #1,"d"
  if debug then print "d":print #3,"d"
  Pause wtime
  n=get_response%()
  
  'and display the board in graphics
  if not debug then show_board
  
end sub
  
function vali%(aaa$) as integer
  
  vali%=0 'this is not a valid chess move
  local a,b,c,d, aa$
  
  aa$=ucase$(aaa$)
  if len(aa$)=4 then
    a=asc(left$(aa$,1))
    b=asc(mid$(aa$,2,1))
    c=asc(mid$(aa$,3,1))
    d=asc(right$(aa$,1))
    if a>64 and a<73 then inc vali% 'a...h
    if c>64 and c<73 then inc vali% 'a...h
    if b>48 and b<57 then inc vali% '1...8
    if d>48 and d<57 then inc vali% '1...8
  end if
  
end function
  
function cmd$(a$)
  local b$=lcase$(a$),tm
  
  cmd$=""
  if instr(b$,"auto") then cmd$="on":reply=1:exit function
  if instr(b$,"xboard") then cmd$="xboard":exit function
  if instr(b$,"new") then cmd$="new":exit function
  if instr(b$,"bye") then cmd$=chr$(27):exit function
  if instr(b$,"on") then cmd$="on":exit function
  if instr(b$,"help") then cmd$="help":exit function
  if instr(b$,"undo") then cmd$="undo":exit function
  if instr(b$,"on") then cmd$="on":exit function
  if instr(b$,"?") then cmd$="help":exit function
  if instr(b$,"st ") then
    tm=val(right$(b$,len(b$)-instr(b$,"st ")-3))
    cmd$="st "+str$(tm)
    exit function
  end if
  if instr(b$,"sd ") then
    tm=val(right$(b$,len(b$)-instr(b$,"sd ")-3))
    cmd$="sd "+str$(tm)
    exit function
  end if
end function
  
  
Sub show_board
  if not debug then
    Local i%,j%,px%,py%,tx%,ty%,pc%,tc%,dx%,dy%
    Local fi$="Tiles\\b", ex$="w.bin", tl$, p$
    For i%=1 To 8  'first string is " ", then follows the board on strings 1-8
      'print respons$(i%)
      py%=(i%-1)*48+12: ty%=i%-1
      For j%=4 To 18 Step 2
        px%=240+(j%-4)*24:tx%=(j%-4)/2
        
        'get piece
        p$=Mid$(respons$(i%),j%,1)
        
        'decide piece color (capitals are black pieces, lowercase white)
        If Asc(p$) < Asc("a") Then
          pc%=RGB(white)
        Else
          pc%=RGB(red)'(black)
        EndIf
        
        'decide tile color
        If (i%+j%/2)Mod 2 Then
          tc%=RGB(green)  'dark tiles
        Else
          tc%=RGB(myrtle) 'light tiles
        EndIf
        
        'get icon from SD card
        p$=fi$+lcase$(p$+ex$)           'for A: drive
        Open p$ For input As #2: tl$=Input$(200,#2):Close #2
        
        'draw icon on enlarged tile
        Box px%,py%,48,48,1,RGB(white),RGB(white) 'make the tiles virtually bigger
        GUI bitmap 4+px%,4+py%,tl$,40,40          'print the 40x40 tile in centre
        
        For dx%=0 To 5
          For dy%=0 To 3
            TILE 30+dx%+6*tx%, 1+dy%+4*ty%,tc%,pc%
          Next
        Next
        
      Next j%
    Next i%
    
    'board legend
    For k%=1 To 8
      text 230,48*k%-16,Str$(9-k%)',"LT",,,rgb(white),rgb(black)
      text 630,48*k%-16,Str$(9-k%)',"LT",,,rgb(white),rgb(black)
      text 210+48*k%,0,Chr$(k%+64)',"LT",,,rgb(white),rgb(black)
      text 210+48*k%,400,Chr$(k%+64)',"LT",,,rgb(white),rgb(black)
    Next k%
  end if
End Sub
  
  
  ' read response from chess module in maximum 13 strings
Function get_response%()
  Local n%=0, i%
  local a$="",b$=""
  
  'debug clean buffer
  for i%=0 to 12
    respons$(i%)=""
  next
  'debug
  
  timer=0
  Do
    a$=Input$(1,1)
    If a$=Chr$(13) Then
      respons$(n%)=b$
      b$=""
      Inc n%
    ElseIf a$=Chr$(10) Then
      'do nothing
    Else
      b$=b$+a$
    EndIf
    if timer>10000 then b$=b$+"tscp>"    'sometimes TSCP does not respons
  Loop Until Instr(b$,"tscp>")
  respons$(n%)=b$                        'this is the tscp> prompt
  get_response%=n%
  
  if debug then
    for i%=0 to n%
      print respons$(i%)
    next
  end if
  
End Function
  
  'restart chess module with a clean game
Sub restart_chess
  
  'flush UART buffer
  do
    a$=input$(1,#1)
  loop while loc(1)
  
  'send initial command that will fail becuase no pullup on RXD
  Print #1,"new"
  if debug then print "new":print #3,"new"
  pause wtime
  n=get_response%() 'read until prompt
  
  'send "new" to make the chess module perform a watchdog reset
  Print #1,"new"
  if debug then print "new":print #3,"new"
  pause wtime
  n=get_response%() 'read until prompt
  
End Sub
