  '                         CHESS-2-PICO
  ' terminal program for external chess engine running on 2nd pico running TSCP
  ' TSCP uses COM1 port GP0,GP1 , terminal uses COM2 port GP4,GP5


Dim Integer debug=0       ' development help
Dim Integer reply=0       ' 0=single player. 1=auto mode
Dim Integer hlt=0         ' halt is the end of the game, exit program
Dim Integer wtime=50      ' waiting time toget response from chess engine
Dim Integer move=0        ' count of total number of moves so far
Dim Integer finished=0    ' game has been completed.
Dim Integer stop_play=0   ' turn off computer plays against you.


' open COM port to second pico
SetPin gp1,gp0,COM1
'SetPin gp5,gp4,COM1
Open "COM1:115200,1024" As #1   '115200 baud = 0.1ms per character
If debug Then Open "a:/log.txt" For output As #3

' defines
Dim respons$,board$(14)
' Dim respons$(30)  'max response from TSCP, look ahead so far plus board
MODE 1:CLS        'screen definitio
Font 7
moves_template
' a clean game
restart_chess     'does not work when game has ended ?
board_update
Print #1,"off"
n=get_response%()

' interactive terminal function
Do

' bypass player when reply is automatic
  If reply=0 Then

' make sure computer does not play
    Print #1,"off"
    n=get_response%()
' read the next payer move
    Print @(40,464);:Input ;a$

  Else
    a$="on"   'make computer move for player as well
  End If

' check validity of possible move
  valide = vali%(a$)
  If Instr(a$,"undo") Then
    If move > 0 Then Inc move,-1
    Print #1,"undo"
    wait_tscp
    a$="    ":respons$="    "
    print_moves(n):Inc move,-1' because print_moves increments move
  ElseIf valide=4 Or valide=5 Then 'players move
    Print #1,a$
    n=get_response%()
    If Not Instr(respons$,"tscp") Then prompt
    If Not Instr(respons$,"Illegal") Then
      If Instr(respons$,"ply") Then
        wait_tscp
      Else
        respons$=a$
        print_moves(n)
      EndIf
      board_update
      If stop_play<1 Then
        Print #1,"on"
        wait_tscp
      Else
        respons$="tscp> "
        prompt
      EndIf
    Else ' Illegal move
      wait_tscp
    EndIf
  ElseIf Instr(a$,"help") Then
    respons$="auto - computer plays itself"
    prompt
' call display help routine
    Print #1,"help"
    help
    wait_tscp
  ElseIf Instr(a$,"bench") Then
' call benchmark routine
    Print #1,"bench"
    wait_tscp
'    respons$="Not implimented"
'    prompt
'    respons$="tscp> "
'    prompt
  ElseIf Instr(a$,"versi") Then
    Print #1,"version"
    wait_tscp
  ElseIf Instr(a$,"board") Then
    respons$="Not implimented"
    prompt
    respons$="tscp> "
    prompt
  ElseIf Instr(a$,"off") Then
    stop_play=1
    respons$="tscp> "
    prompt
  ElseIf Instr(a$,"on") Then
    Print #1,"on"
    n=get_response%()
    If Instr(respons$,"Computer") Then print_moves
    prompt
    wait_tscp
    stop_play=0
  ElseIf Instr(a$,"new") Then
    move=0:stop_play=0:finished=0
    restart_chess
    moves_template
  ElseIf Instr(a$,"st") Or Instr(a$,"sd") Then
    Print #1,a$
    wait_tscp
  ElseIf Instr(a$,"auto") Then
    reply=1
' Is there a completed game?
    If finished Then
      finished=0:move=0:stop_play=0
      restart_chess
      moves_template
    EndIf
  ElseIf Instr(a$,"d") Then
    respons$="tscp> "
    prompt
  ElseIf Instr(a$,"bye") Then
    hlt=1
    Print #1,"bye"
    End
  Else
    respons$="Unknown command?"
    prompt
    respons$="tscp> "
    prompt
'    Print #1,a$
'    wait_tscp
  EndIf
' show the board
    board_update

  Loop Until a$=Chr$(27) Or hlt>0
End



Sub print_moves(n)
Local integer xposm(3)=(34,72,144,184)
Local integer xposc(1)=(7,110)
  'game list related

  xmoves=move \ 2 +1
  ymoves=move \ 4
  If move>131 Then
   If (move Mod 4)=0 Then
' move whole list up one line, blanking last line
    Blit 3,20,3,12,212,262
    If move<198 Then
      Print @(xposc(0),13+(32*MM.Info(FONTHEIGHT)));Str$(xmoves,2);"                ";Str$(xmoves+1,2);"               "
    Else
      Print @(xposc(0),13+(32*MM.Info(FONTHEIGHT)));Str$(xmoves,3);"               ";Str$(xmoves+1,3);"              "
    EndIf
   EndIf
   Print @(xposm(move Mod 4),13+(32*MM.Info(Fontheight)));Right$(respons$,4);
  Else
    If (move Mod 4)=0 Then
      Print @(xposc(0),13+(ymoves*MM.Info(FONTHEIGHT)));Str$(xmoves,2);"                ";Str$(xmoves+1,2);"                "
    EndIf
    Print @(xposm(move Mod 4),13+(ymoves*MM.Info(Fontheight)));Right$(respons$,4);

  EndIf

  Inc move
End Sub

Sub moves_template
' Clear the moves
  Box 0,1,227,282,,,RGB(black)
' draw the outline
  Box 0,1,227,282
  'tiles
  TILE 0,0,RGB(cyan),RGB(black),29,24
  TILE 3,1,RGB(white),RGB(black),5,22
  TILE 8,1,RGB(red),RGB(black),5,22
  TILE 17,1,RGB(white),RGB(black),5,22
  TILE 23,1,RGB(red),RGB(black),5,22
End Sub

' detect computer says end of game
Function game_end(n)
  game_end=0
    Inc game_end,Instr(respons$,"legal")    'no legal moves
    Inc game_end,Instr(respons$,"1/2-1/2")  '50 moves
    Inc game_end,Instr(respons$,"mates}")   'check mate
End Function


Sub board_update
Local integer x,found=0

' request print the board as ascii
  Print #1,"d"
' loop until we see the first line of the board
  Do
   n=get_response%()
  Loop Until Instr(respons$,"8  ")
' save in first element of board display array
  board$(0)=respons$
' get the rest of the board
  For x=1 To 8
   n=get_response%()
   board$(x)=respons$
  Next
' output the board as graghics
  show_board
'print the prompt
  discard_tscp

End Sub

Function vali%(aaa$) As integer

  vali%=0 'this is not a valid chess move
  Local a,b,c,d,e$, aa$

  aa$=UCase$(aaa$)
  If Len(aa$)=4 Or Len(aa$)=5 Then
    a=Asc(Left$(aa$,1))
    b=Asc(Mid$(aa$,2,1))
    c=Asc(Mid$(aa$,3,1))
    d=Asc(Mid$(aa$,4,1))
    If a>64 And a<73 Then Inc vali% 'a...h
    If c>64 And c<73 Then Inc vali% 'a...h
    If b>48 And b<57 Then Inc vali% '1...8
    If d>48 And d<57 Then Inc vali% '1...8
    If Len(aa$)=5 Then
     e$=Mid$(aa$,5,1)
' promotion to a queen,knight,bishop,castle
     If Instr("qQkKbBcC",e$) Then Inc vali%
    EndIf

  End If

End Function


Sub show_board
'  If Instr(board$(0), "8  ") Then
  Local Integer i,j,k,px,py,tx,ty,pc,tc,dx,dy,q,t
  Local fi$="Tiles\\b", ex$="w.bin", tl$, p$
  For i=0 To 7
    py=i*48+12: ty=i
    For j=4 To 18 Step 2
      px=240+(j-4)*24:tx=(j-4)/2
' get piece
      p$=Mid$(board$(i),j,1)
' decide piece color (capitals are black pieces, lowercase white)
      If Asc(p$) < Asc("a") Then
        pc=RGB(white)'(white)
      Else
        pc=RGB(red)  '(black)
      EndIf

'decide tile color
      If (i+j/2)Mod 2 Then
        tc=RGB(green)  'dark tiles
      Else
        tc=RGB(myrtle) 'light tiles
      EndIf

' get icon from file on sd/flash
      p$=fi$+LCase$(p$)+ex$
      Open p$ For input As #2: tl$=Input$(200,#2):Close #2
' draw icon on enlarged tile
' make the tiles virtually bigger
      Box px,py,48,48,1,RGB(white),RGB(white)
' print the 40x40 tile in centre
      GUI bitmap 4+px,4+py,tl$,40,40
' display the chess board squares
      t=tx*6+30:q=4*ty+1
      For dx=t To t+5
       TILE dx, q,tc,pc:Inc q
       TILE dx, q,tc,pc:Inc q
       TILE dx, q,tc,pc:Inc q
       TILE dx, q,tc,pc:Inc q,-3
      Next

    Next ' j
  Next ' i

' board legend increase font size temporarily
  Font 1
  For k=1 To 8
'    Text 230,48*k%-16,Str$(9-k%)',"LT",,,rgb(white),rgb(black)
    Text 630,48*k-16,Str$(9-k)',"LT",,,rgb(white),rgb(black)
    Text 210+48*k,0,Chr$(k+64)',"LT",,,rgb(white),rgb(black)
'    Text 210+48*k%,400,Chr$(k%+64)',"LT",,,rgb(white),rgb(black)
  Next ' k
  Font 7
End Sub


' read response from chess module
Function get_response%()
  Local n%=0, i%
  Local a$="",b$=""

  wait_reply
  Do
    a$=Input$(1,#1)
' end of response line
    If a$=Chr$(13) Then
' if empty line, discard it
      If Len(b$)<2 Then b$="":a$=""
' check for leading spaces or start line character and remove them
    ElseIf Len(b$)=0 And (a$=" " Or a$=Chr$(10)) Then
       b$="" 'nothing
' build up response string
    Else
       b$=b$+a$
    EndIf
  Loop Until Instr(b$,"tscp>") Or a$=Chr$(13)
  respons$=b$

  get_response%=1

End Function

' restart chess module with a clean game
Sub restart_chess

  empty_buff

' send initial command that will fail becuase no pullup on RXD
  Print #1,"new"
  n=get_response%() 'read until prompt

' send "new" to make the chess module perform a watchdog reset
  Print #1,"new"
  n=get_response%() 'read until prompt
  prompt
End Sub

Sub prompt

' scroll right part of the screen
  Blit 240,408,240,400,400,72
' scroll left part of the screen
  Blit 1,296,1,288,239,176
' blank out old line
  Print @(1,464)"                                                                          "
' display new line
  Print @(1,464);respons$
  If game_end()>0 Then reply=0:finished=1:stop_play=0

End Sub

' display the help menu
Sub help
Local integer x

  For x=0 To 11
    n=get_response%()
    prompt
  Next
End Sub

' wait untill tscp> prompt displayed
Sub wait_tscp
  Do
    n=get_response%()
    prompt
    If Instr(respons$,"Computer") Then
     print_moves(n)
'     Inc move
    ElseIf Instr(respons$,"ply") Then
     respons$=""
    EndIf
   EndIf
  Loop Until Instr(respons$,"tscp>")
End Sub

Sub discard_tscp
  Do
    n=get_response%()
  Loop Until Instr(respons$,"tscp>")
End Sub

'wait for tscp to respond
Sub wait_reply
  Do
    Pause wtime+wtime
  Loop Until Loc(#1)
  Pause wtime
End Sub

Sub empty_buff
Local a$
' flush UART buffer
  Do
   a$=Input$(1,#1)
  Loop While Loc(#1)
End Sub
