/*
 * Copyright (c) 2020, Anton Staaf.  All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#include "libs/color/color.h"
#include "libs/math/matrix.h"
#include "libs/math/range.h"
#include "libs/math/vector.h"
#include "libs/random/random.h"

#include <cstdint>

struct Transform
{
    Math::Matrix22d matrix;
    Math::Vector2d  translate;
    Color::Color3d  color;
    double          probability;
    double          lerp_factor;
};

struct State
{
    Math::Vector2d          position;
    Color::Color3d          color;
    Random::XorShift128Plus random;
};

struct DisplayTransform
{
    double         scale_x;
    double         scale_y;
    Math::Vector2d offset;
};

extern "C" void csub(std::int64_t * framebuffer,
                     std::int64_t * resolution,
                     std::int64_t * first_,
                     std::int64_t * last_,
                     State * state,
                     DisplayTransform * display,
                     std::int64_t * iterations,
                     double * blend);
