'
' Copyright (c) 2020, Anton Staaf.  All rights reserved.
' Use of this source code is governed by a BSD-style license that can be
' found in the LICENSE file.
'

sub range.reset range() as float
    range(0) = 0
    range(1) = 0
    range(2) = -1
    range(3) = -1
end sub

function range.empty(range() as float) as integer
    range.empty = (range(0) > range(2)) or (range(1) > range(3))
end function

sub range.expand range() as float, x as float, y as float
    if range.empty(range()) then
        range(0) = x
        range(1) = y
        range(2) = x
        range(3) = y
    else
        range(0) = min(range(0), x)
        range(1) = min(range(1), y)
        range(2) = max(range(2), x)
        range(3) = max(range(3), y)
    end if
end sub

sub range.scale range() as float, s as float
    local float x = (range(0) + range(2)) / 2
    local float y = (range(1) + range(3)) / 2

    range(0) = (range(0) - x) * s + x
    range(1) = (range(1) - y) * s + y
    range(2) = (range(2) - x) * s + x
    range(3) = (range(3) - y) * s + y
end sub

sub range.translate range() as float, x as float, y as float
    range(0) = range(0) + x
    range(1) = range(1) + y
    range(2) = range(2) + x
    range(3) = range(3) + y
end sub

function range.width(range() as float) as float
    range.width = range(2) - range(0)
end function

function range.height(range() as float) as float
    range.height = range(3) - range(1)
end function

function range.center_x(range() as float) as float
    range.center_x = (range(2) + range(0)) / 2
end function

function range.center_y(range() as float) as float
    range.center_y = (range(3) + range(1)) / 2
end function

