 ' 'WiFi File transfer (MXWifi)
  
  '******* the following code is self contained and should be stored as a library file ******
  '********************* Library Code **************************
  '**************** sub routines *********************
  'http://www.codenquilts.com.au
  'Michael Ogden July 2016
  'WiFi File transfer
  'ver 0.8 additions for use on other platforms running MMBasic ver 5.2
  'add uMite plus platform detection.
  '0.086 add Sub Other, add individual resets
  'UserProcess routine   ' process network data and commands.
  'ver 1.1 add handshake in listfiles routines
  'ver 1.5 change to extCmd (external commands)
  'ver 1.6 add error check for long lines on debug prints Raw and From
  'Power up system check
  'test for Normal or Restart
  'v1.9 optimise for UserprocessFlag
  'v 2.3 add Read and write on MX170 for System file access eg, INI/dat files
  'v2.4 add mins to SDT function, DST fixes
  'v2.4 compatible with uMite commander 1.1.48 and above, ESP8266-Mcu5.7 and above
  'v2.5 add Close files (for uMite Plus)
  'v2.6 add Read and Write array functions, Err routine changes
  'v2.8 replace previous array functions with direct save for config.dat file to cfgdata() array
  'v2.9 cleaned up exits from Do-Loops
  'v3.0 remove PUSC sub declare
  'v3.1 Err skip fix
  'BM Ver 1.2
  'removed unused functions and SD support
  '***********Core functions for MXWifi - DO NOT REMOVE **********

  dim ver$="1.1"
  '** MX170 only
  dim integer sdFileopen=1
  dim integer sdReadfile=2
  dim integer sdWritefile=3
  dim integer sdOpendir=4
  dim integer sdReaddir=5
  '** MX170 only
  dim Q$=chr$(34)
  dim integer maxWait=2000  'ESP handshake minimum wait
  dim integer CTRL_Z = 26 'Used in example as EOF marker
  dim integer CS_PIN=4 'Chip select pin conected to the SD card
  Dim res As Integer
  Dim cr$=chr$(13) + chr$(10)
  dim integer sdfilepos,err,minWait
  Dim Integer cfgNum=10		'set size of config array
  Dim String cfgdata(cfgnum) length 80		'general configuration array  80 char
  Dim lastline$,newline$,temp$,from$,cfg$,cmd$,strin$
  dim Integer userprocessflag,ReadyFlag,stopflag,sdOpenFlag,starttime,debug
  Dim Integer md(12) = (0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334) 'used by dst cal
  if isPlus()=1 then
    minWait=85
  else
    minWait=85
  end if
  if mm.watchdog=1 then
    print "BM_MXWifi "; ver$   ; " System restarted from Error condition"
  else
    print "BM_MXWiFi "; ver$ ; " System restarted - OK"
  end if

  
Sub UserProcess
  local temp$
  if instr(newline$,"debug:")>0 then
    print newline$  'debug
  end if
  'Parse fields
  'print
  'Print "New Run"
  if debug=1 Then print "Raw:" + newline$ 'debug prints any complete lines from ESP8266
  from$=parse$(newline$,2,"|")
  cmd$=parse$(newline$,3,"|")
  cfg$=parse$(newline$,4,"|")
  strin$=parse$(newline$,5,"|")
  print "From:";from$;" Cmd:";cmd$;" Config:";cfg$;" Data:";strin$
  if instr(newline$,"udp.rec:")>0 then
    select case cmd$
      case "close"
        if isplus()=1 then
          on error skip
          close #1
          If ChkErr()>0 then exit Sub
          xbsend "udp.send:|"+from$+"|File-Closed"
          WaitforReady
        end if
      case "date"
        xbsend "udp.send:|"+from$+"|Date-read|"+date$
        WaitforReady
      case "time"
        if cfg$="set" then
          time$=parse$(strin$,1,"-")+":"+parse$(strin$,2,"-")+":"+parse$(strin$,3,"-")
        elseif cfg$="read" then
          xbsend "udp.send:|"+from$+"|Time-read|"+time$
          WaitforReady
        end if
      case "reload"
        if isplus()=1 then
          load cfg$,R
        else
          bootload cfg$
        end if
      case "resetall"
        xbsend "reboot:"   'restart ESP8266
        watchdog 100    'set the uMite to time out
        pause 200       'pause to wait for time out
      case "resetesp"
        xbsend "reboot:"   'restart ESP8266
      case "resetmite"
        watchdog 100    'set the uMite to time out
        pause 200       'pause to wait for time out
      
        xbsend "udp.send:|"+from$+"|Dir-deleted|"+cfg$
      
        
        'other commands
      case else
        on error skip
        extCmd
        res=ChkErr()
    end select
  elseif instr(newline$,"ESP:")>0 then    'feedback from ESP module
    print "Ext command from ESP only"
    on error skip
    extCmd
    res=ChkErr()
  endif
End Sub
  
function isPlus() as integer
  isplus=0
  if mm.device$="Micromite Plus" then isplus=1
end function
  

  
  'write to config array variable
sub writecfg(d$,sys)
  Local p As Integer
  p=Val(Parse$(d$,1))
  If  p=0 Then Exit Sub
  If p>sys Then Exit sub
  on error skip
  Print "Save Config array :";Mid$(d$,InStr(d$,",")+1)
  cfgdata(p)=Mid$(d$,InStr(d$,",")+1)
  res=ChkErr()
End Sub
  
  
  'Check Error routine call is placed after the line that is being Skipped
  'The routine will report the errors out to console and via UDP
Function ChkErr() As Integer
  ChkErr=0
  if mm.errno<>0 then
    print "Error# ";mm.errno; " "; mm.errmsg$
    xbsend "udp.send:|"+from$+"|Error#|"+ str$(mm.errno) + " " + mm.errmsg$ +"|"
    WaitforReady           'reset flag
    ChkErr=1
  end if
end function
  

  
sub WaitforReady
  local timeout, period
  timeout = Timer
  do while ReadyFlag=0
    if Timer-timeout>MaxWait then exit do  'wait max 1000 mSec
  loop   'wait for ready from ESP8266
  period=Timer-timeout
  if period<=1 then pause MinWait 'make sure there is a min period
  'print "Wait:";period
  ReadyFlag=0                 'reset flag
end sub
  
Function Parse$(s$,FieldNumber,d$)
  Local String stringArg$
  Local Integer intOldY,intY,intX
  'print s$;" ";fieldnumber;" ";d$
  if d$="" then
    d$=","
  endif
  StringArg$ = S$ + d$
  intOldY = 1:intX=0:intY=0
  Parse$ = ""
  do While intY < Len(StringArg$) And intX < FieldNumber
    intY = Instr(intOldY, StringArg$, d$)
    intX = intX + 1
    If intX = FieldNumber Then
      parse$ = Mid$(StringArg$, intOldY, intY - intOldY)
    Endif
    intOldY = intY + 1
  loop
  'print s$; intx; inty; intoldy
  'print fieldnumber;" ";parse$
End Function
  
Function Ltrim(sString As String)As String
  ltrim=Str$(Val(sString))
End Function
  
  
  'replaceString$(string$, replaceWhat$, replaceWith$)
FUNCTION replace$(R$, a$, b$)
  local integer i,j,c,d
  d=1
  replace$=R$
  i = LEN(a$) : j = LEN(b$)
  do while INSTR(d,replace$, a$) > 0
    c = INSTR(d,replace$, a$)
    replace$ = LEFT$(replace$, c-1) + b$ + MID$(replace$, c+i)
    d = c+j
  loop
END FUNCTION
  
  
  
  
  'Comms for ESP8266
  'initialise routines
  
Sub iniTWiFifile (c as integer)
  Open "com" + str$(c) + ":38400,1024,Xbreceive" As #5 'initialise commS
End Sub
  
Sub xbreceive
  'reads bytes from comms buffer , data terminated bt CR will output a NewLine$ and set the UserFlag
  'also checks for block data transmissions , start with SOH (Dec 1)
  local a$
  local bl as integer
  'print "Buffer:";loc(5)
  a$=Input$(1,#5)  'user supplied processing routine
  If debug=1 Then  Print a$; 'debug prints any CHR from ESP8266
  if a$=chr$(4) then
    ReadyFlag=1:exit sub
  end if
  if a$=chr$(26) then stopflag=1
  if a$=chr$(10) then exit sub  'ignore Line feed
  'print "Line length:";len(lastline$)
  if len(lastline$)=>254 then
    lastline$=lastline$ + a$
    a$=chr$(13)    'terminate line to force processing
  else
    lastline$=lastline$ + a$    'add to data packet
  endif
packet:
  if a$=chr$(13)and len(lastline$)>1 or a$=chr$(02) or a$=chr$(26) then
    if a$=chr$(13) then a$="" 'don't want CR added
    if a$=chr$(02) then 'get rest of Block
      print "Block";191;len(lastline$)
      print "Buffer";loc(5)
      print "Lastlins$:";lastline$
      on error skip
      a$=Input$(loc(5),#5)
      res=ChkErr()
    end if
    Newline$=Lastline$ + a$
    lastline$=""
    if instr(newline$,"udp.send:")>0 then   'filter out sent strings being returned
      exit sub
    else
      UserProcessFlag=1  'set process data flag
    end if
  endif
End Sub
  
  
Sub xbsend (msgframe$)
  Print #5,msgframe$
End Sub
  
  'End of ESP8266 Comms
  'End of Library code
  '*********** End of Core functions for MXWifi - DO NOT REMOVE  above code**********
  
  
  
 
  
  '  ***************  General Subs/Functions  **********
  '  ***************  Time & Date functions
Sub IncTime
  Local iHr As Integer
  'Print Time$
  ihr=Val(parse$(Time$,1,":"))
  iHr=ihr+1
  If ihr=24 Then ihr=0
  Time$=Str$(ihr,2,0,"0")+":"+parse$(Time$,2,":")+":"+parse$(Time$,3,":")
  'Print Time$
End Sub
  
  
  'convert month to number
function moy(mon$)As Integer
  For moy=1 To 12
    if UCase$(mon$)=parse$(numofmonth$,moy) Then Exit For
  Next
end function
  
  
  
  'write a file to current folder 'mx170
  
  'open requested file and return data for MX170
  
Function IsDST() As Integer
  Local S$,E$
  Local integer mon,startYr,sun1,sun2,d0,day
  'get the serial of the date to test
  d0=sdt(date$,"","d") 'of the date only
  'get the current month and the current year for DST ie Oct to Apr
  mon=Val(parse$(date$,2,"-"))
  startyr=Val(parse$(date$,3,"-"))
  If mon=>1 And mon=<4 Then startyr=startyr-1
  s$=("1-10-"+str$(startyr))
  e$=("1-4-"+str$(startyr+1))
else
  s$=("1-10-"+str$(startyr))
  e$=("1-4-"+str$(startyr+1))
end If
'print d0
'print s$;" ";e$
'find start sunday and end sunday
day=GetDOW(SDT(s$))
sun1=sdt(s$,"","d")
sun2=sdt(e$,"","d")
if day>0 then
  sun1=((7-day)*86400)+sun1
end if
day=GetDOW(SDT(e$))
if day>0 then
  sun2=((7-day)*86400)+sun2
end if
'print "sun1&2:";sun1;" ";sun2
If  d0 >=sun1 And d0 <sun2  Then IsDST=1
End Function

' convert seconds to the day of the week (Sunday = 0)
Function GetDOW(seconds As Integer) As integer
GetDOW = ((seconds \ (24 * 3600)) + 3) Mod 7
End Function

'Serial date Time, convert Date or time to Number
Function SDT(d$,t$,p$)as integer
local integer y,m,da,h,mn,sc
if d$="" then d$=date$
If t$="" Then t$=Time$
if p$="" then p$="DT"
da=val(parse$(d$,1,"-"))
m=val(parse$(d$,2,"-"))
y=val(parse$(d$,3,"-"))
h=val(parse$(t$,1,":"))
mn=val(parse$(t$,2,":"))
sc=val(parse$(t$,3,":"))
'print "input:";d$;" ";t$;" ";p$
'print "recovered:";da;m;y;h;mn;sc
Select Case ucase$(p$)
  Case "D"
    SDT=getsec(y,m,da,0,0,0)
  Case "T"
    SDT=getsec(0,0,0,h,mn,sc)
  Case	"DT"
    SDT=getsec(y,m,da,h,mn,sc)
  Case	"M"
    SDT=getsec(0,0,0,h,mn,0)
  case else
    SDT=0
End Select
'print "result:";SDT
end function

' calculate the seconds since midnight 1st Jan 2014
Function GetSec(yr As Integer, mth As Integer, day As Integer, hr As Integer, min As Integer, sec As Integer) As Integer
if yr>2000 Then yr=yr-2000
if yr>0 then
  GetSec = (yr - 14) * (365 * 24 * 60)
  GetSec = GetSec + ((yr - 13) \ 4) * (24 * 60)
  GetSec = GetSec + (md(mth) * (24 * 60))
  GetSec = GetSec + ((day - 1) * (24 * 60))
end if
GetSec = GetSec + (hr * 60)
GetSec = ((GetSec + min) * 60) + sec
if yr>0 then
  If (yr - 16) Mod 4 = 0 And mth > 2 Then GetSec = GetSec + (24 * 3600)
end if
End Function
