/*
 * Sample sketch which makes the Arduino emulate a Classic Controller.
 *
 * converts a PS2 mouse to a HobbyTronics port and serial port
 r
 */

#include "Wire.h" 
#include "PS2Mouse.h"

// PS2 mouse pins
#define DATA_PIN 2
#define CLOCK_PIN 3

#define I2C_PORT 41
#define SERIAL_BAUD 19200
#define HT_MODE 1

int dx,dy,dw,stat,statold;  // used in PS/2 routines
long X,Y,LB,RB,SB,XS,YS, WS;
long Hmax = 800, Vmax = 600, ms = 10;
long Hstart = 400, Vstart = 300;
byte addr = 0;
byte ht_registers[0x40];
long HTS = HT_MODE;
unsigned long readStart = 0; // the time the read started

PS2Mouse mouse(CLOCK_PIN, DATA_PIN);

void setup() {
 Serial.begin(SERIAL_BAUD);
	ht_init();
  mouse.initialize();
}

void loop() {
 // delay(3000);
}

// called whenever the CMM2 changes display mode 
// and has to reconfigure X and Y limits
 void ht_configure() {
  Hmax = ht_registers[20]*256 + ht_registers[21] -1;
  Vmax = ht_registers[22]*256 + ht_registers[23] -1;
  Hstart = ht_registers[24]*256 + ht_registers[25];
  Vstart = ht_registers[26]*256 + ht_registers[27];
  ms = ht_registers[28]; 
  X = Hstart;
  Y = Vstart;
  WS = 0;
  mouse.initialize();
  // printout for debug only
  /*
     Serial.print(Hmax);
    Serial.print(',');
    Serial.print(Vmax);
    Serial.print(',');
    Serial.print(Hstart);
    Serial.print(',');
    Serial.print(Vstart);
    Serial.print(',');
    Serial.println(ms);
    */
 }

 // getmouse 'should' get called AFTER the last data set has been sent.
 // the timing is what I have had trouble achieving
void getMouse() {
  
   readStart = millis();
   MouseData data = mouse.readData();
   stat = data.status;
   dx = data.position.x;
   dy = data.position.y;
   dw = data.wheel;
  // convert data to suit HT
   XS = dx*8/ms;
   X = X + XS;
   X = constrain(X,0,(Hmax));

   YS = -dy*8/ms;
   Y = Y + YS;
   Y = constrain(Y,0,(Vmax));
  
   LB = stat & 1;          // left mouse button
   RB = (stat>>1) & 1;     // right mouse button
   SB = (stat>>2) & 1;     // middle mouse button

   WS = constrain(dw,-1,1);
   ht_registers[0] = X >> 8;
   ht_registers[1] = X % 256;
   ht_registers[2] = Y >> 8;
   ht_registers[3] = Y % 256;
   ht_registers[4] = LB;
   ht_registers[5] = RB;
   ht_registers[6] = SB;
   ht_registers[7] = XS;
   ht_registers[8] = YS;
   ht_registers[9] = WS;

}

void doSerial() {
  // send data out serial port only if something has changed
  // there are two modes HTS which sends in the HobbyTronics format
  // and Compressed which send 4 bytes
  // normally called after the getmouse but that would give even more delay so currently not sent.
    if(dx != 0 || dy != 0 || dw != 0 || statold != stat){
      statold = stat;
      if(HTS = 1){
        // send serial data in HobbyTronics format
    Serial.print(X);
    Serial.print(',');
    Serial.print(Y);
    Serial.print(',');
    Serial.print(LB);
    Serial.print(',');
    Serial.print(RB);
    Serial.print(',');
    Serial.print(SB);
    Serial.print(',');
    Serial.print(XS);
    Serial.print(',');
    Serial.print(YS);
    Serial.print(',');
    Serial.println(WS);
    }else{
      // send serial data in compressed form
    Serial.write(stat);
    Serial.write(dx);
    Serial.write(dy);
    Serial.write(dw); 
        }
    }
}
void ht_set_byte(int index, byte value) {
  ht_registers[index] = value;
}

// called whenever data is ready in the I2C stream
 void receive_bytes(int count) {
  if (count == 1) {
    addr = Wire.read();
  //  Serial.print(addr);
  //  Serial.print(',');
  } else if (count > 1) {
    addr = Wire.read();
  //  Serial.print(addr);
  //  Serial.print(',');
    byte curr = addr;
    for (int i = 1; i < count; i++) {
      byte d = Wire.read();
      ht_registers[curr++] = d;
  //    Serial.print(d);
  //  Serial.print(',');
      }
  //    Serial.println("done");
      if(curr > 28){
      ht_configure();
    }
    }
}

void send_data(uint8_t* data, uint8_t size) {
    Wire.write(data, size);
}

// called whenever a request for data has been received
void handle_request() {
  send_data(ht_registers + addr, 12);
  //  update the mouse movement ready for next call
   getMouse();
  }

  // init is called once on first startup
void ht_init() {
  X = Hstart;
  Y = Vstart;
    ht_registers[0] = X >> 8;
    ht_registers[1] = X % 256;
    ht_registers[2] = Y >> 8;
    ht_registers[3] = Y % 256;
    ht_registers[4] = LB;
    ht_registers[5] = RB;
    ht_registers[6] = SB;
    ht_registers[7] = XS;
    ht_registers[8] = YS;
    ht_registers[9] = WS;
 
  // Join I2C bus
  Wire.begin(41);
  // Serial.println("INIT");
  Wire.onReceive(receive_bytes);
  Wire.onRequest(handle_request);
}
