  ' RD-03D radar module
  ' TassyJim
  Option Explicit
  Option Default Integer
  Option Base 0
  
  Dim record$, rec$, k$
  Dim debug = 0
  Dim cmdDelay = 50
  Dim cro ' used for timing with CRO
  Dim Float Yscale = 4000/Mm.vres ' 400 = max reading = 4M
  Dim Float Xscale = -Yscale '-8000/mm.hres  'keep x and y the same
  Dim Xmid = Mm.hres/2
  Dim multi = 0 ' single or mitiple targets
  Dim samplerate = 5 ' plot every nn signals
  Dim tailsize = 20 ' length of tail
  Dim tX1(tailsize), tY1(tailsize),tX2(tailsize)
  Dim tY2(tailsize),tx3(tailsize),tY3(tailsize)
  Dim x1,x2,x3,y1,y2,y3,v1,v2,v3,prec1,prec2,prec3
  Dim dataAvailable
  Dim hdr$= hex2str$("AAFF0300")
  Dim foot$ = Hex2Str$("55CC")
  Dim cmdHdr$ = hex2str$("FDFCFBFA")
  Dim cmdFoot$ = hex2str$("04030201")
  Dim enableConf$ = hex2str$("FDFCFBFA0400FF00010004030201")
  Dim endConf$ = hex2str$("FDFCFBFA0200FE0004030201")
  Dim ackEnableConf$ = hex2str$("FDFCFBFA0800FF0100000100400004030201")
  Dim ackEndConf$ = hex2str$("FDFCFBFA0400FE01000004030201")
  Dim singleTarget$ = hex2str$("FDFCFBFA0200800004030201")
  Dim ackSingleTarget$ = hex2str$("FDFCFBFA04008001000004030201")
  Dim multiTarget$ = hex2str$("FDFCFBFA0200900004030201")
  Dim ackMultiTarget$ = hex2str$("FDFCFBFA04009001000004030201")
  
  If cro Then
    Setpin Gp3, Dout
    Setpin Gp2, Dout
  Endif
  'change com port to suit
  Setpin Gp5, Gp4, Com2
  Open "com2: 256000" As #3
  Cls
  If multi Then setmulti Else setsingle
  If debug Then
    Pause 4000
  Endif
  Close #3
  drawroom
  ' change com port to suit
  Setpin Gp5, Gp4, Com2
  Open "com2: 256000, 1024,radar,30" As #3
  Do
    rec$ = Input$(255,#3)
  Loop Until Len(rec$) = 0
  
  Do
    If dataAvailable Then processIt
    'pause 10
    k$ = Inkey$
    If k$<>"" Then
      If k$="t" Then printTail
      If k$="d" Then debug = 1 - debug
    Endif
  Loop
  
Sub radar
  Local st,fin, lenr
  If cro Then Pin(Gp3) = 1
  lenr = Len(rec$)
  rec$ = rec$+Input$(255-lenr,#3)
  st = Instr(rec$,hdr$)
  If st Then
    rec$= Mid$(rec$,st)
    fin = Instr(rec$, foot$)
    If fin Then
      If Len(rec$) = 30 Then
        record$=rec$
        rec$ = ""
      Else
        record$ = Left$(rec$,fin+1)
        rec$ = Mid$(rec$,fin+2)
      Endif
      dataAvailable = 1
    Endif
  Endif
  If cro Then Pin(Gp3) = 0
End Sub
  
Sub processIt
  Static n
  If cro Then Pin(Gp2) = 1
  dataAvailable = 0
  x1 = Signed16(Str2bin(Uint16,Mid$(record$,5,2)))
  y1 = Signed16(Str2bin(Uint16,Mid$(record$,7,2)))
  v1 = Signed16(Str2bin(Uint16,Mid$(record$,9,2)))
  prec1 = Str2bin(Uint16,Mid$(record$,11,2))
  ' if multi then
  x2 = Signed16(Str2bin(Uint16,Mid$(record$,13,2)))
  y2 = Signed16(Str2bin(Uint16,Mid$(record$,15,2)))
  v2 = Signed16(Str2bin(Uint16,Mid$(record$,17,2)))
  prec2 = Str2bin(Uint16,Mid$(record$,19,2))
  
  x3 = Signed16(Str2bin(Uint16,Mid$(record$,21,2)))
  y3 = Signed16(Str2bin(Uint16,Mid$(record$,23,2)))
  v3 = Signed16(Str2bin(Uint16,Mid$(record$,25,2)))
  prec3 = Str2bin(Uint16,Mid$(record$,27,2))
  ' endif
  Inc n
  If prec1 > 0 And(n Mod samplerate) = 0 Then
    If debug Then
      Print Chr$(27)+"[36;2H";x1,y1,v1,prec1,x2,y2,v2,x3,y3,v3;
      ' for n = 1 to len(record$)
      '   print hex$(asc(mid$(record$,n,1)),2);
      ' next n
    Endif
    plotit x1,y1,x2,y2,x3,y3
  Endif
  If cro Then Pin(Gp2) = 0
End Sub
  
Function Signed16(u As Integer) As Integer
  If u And &h8000 Then Signed16 = u And &h7FFF Else Signed16 = -u
End Function
  
Function Hex2Str$(txt$)
  Local h
  For h = 1 To Len(txt$) Step 2
    Hex2Str$=Hex2Str$+Chr$(Val("&h"+Mid$(txt$,h,2)))
  Next h
End Function
  
Sub plotit ax1, ay1, ax2,ay2,ax3,ay3
  Local bx1,by1,bx2,by2,bx3,by3
  Local arrStart
  Static cx1,cy1,cx2,cy2,cx3,cy3
  Framebuffer Copy f,n
  Framebuffer Write n
  If prec1 >0 Then 'ax1<> 0 and ay1<> 0 then
    bx1 = ax1/Xscale +Xmid
    by1 = Mm.vres-ay1/Yscale
    'tx1(0)=bx1
    'ty1(0)=by1
    arrStart = Peek(Varaddr tX1())
    Memory Copy Integer arrStart,arrStart+8,8*tailsize
    arrStart = Peek(Varaddr tY1())
    Memory Copy Integer arrStart,arrStart+8,8*tailsize
    tX1(0)=bx1
    tY1(0)=by1
    Line Graph tX1(),tY1(),Rgb(Yellow)
    Circle bx1,by1,3,1,1,Rgb(Yellow),Rgb(Yellow)
  Endif
  
  If ax2 <> 0 And ay2 <> 0 Then
    bx2 = ax2/Xscale +Xmid
    by2 = Mm.hres-ay2/Yscale
    arrStart = Peek(Varaddr tX2())
    Memory Copy Integer arrStart,arrStart+8,8*tailsize
    arrStart = Peek(Varaddr tY2())
    Memory Copy Integer arrStart,arrStart+8,8*tailsize
    tX2(0)=bx2
    tY2(0)=by2
    Line Graph tX2(),tY2(),Rgb(Cyan)
    Circle bx2,by2,3,1,1,Rgb(Cyan),Rgb(Cyan)
  Endif
  
  If ax3 <> 0 And ay3 <> 0 Then
    bx3 = ax3/Xscale +Xmid
    by3 = Mm.hres-ay3/Yscale
    arrStart = Peek(Varaddr tX3())
    Memory Copy Integer arrStart,arrStart+8,8*tailsize
    arrStart = Peek(Varaddr tY3())
    Memory Copy Integer arrStart,arrStart+8,8*tailsize
    tX3(0)=bx3
    tY3(0)=by3
    Line Graph tX3(),tY3(),Rgb(Green)
    Circle bx3,by3,3,1,1,Rgb(Green),Rgb(Green)
    
  Endif
End Sub
  
Sub setsingle
  Local n
  Local junk$
  junk$ = Input$(255,#3)
  Print #3, enableconf$;
  Pause cmdDelay
  junk$ = Input$(255,#3)
  If debug Then
    If junk$ = ackEnableConf$ Then
      Print "ACK conf OK"
    Else
      For n = 1 To Len(junk$)
        Print Hex$(Asc(Mid$(junk$,n,1)),2);
      Next n
    Endif
    Print
  Endif
  Print #3, singleTarget$;
  Pause cmdDelay
  junk$ = Input$(255,#3)
  If debug Then
    If junk$ = ackSingleTarget$ Then
      Print "ACK single OK"
    Else
      For n = 1 To Len(junk$)
        Print Hex$(Asc(Mid$(junk$,n,1)),2);
      Next n
    Endif
    Print
  Endif
  Print #3, endconf$;
  Pause cmdDelay
  junk$ = Input$(255,#3)
  If debug Then
    If junk$ = ackEndConf$ Then
      Print "ACK endconf OK"
    Else
      For n = 1 To Len(junk$)
        Print Hex$(Asc(Mid$(junk$,n,1)),2);
      Next n
    Endif
    Print
  Endif
End Sub
  
Sub setmulti
  Local junk$, n
  junk$ = Input$(255,#3)
  Print #3, enableconf$;
  Pause cmdDelay
  junk$ = Input$(255,#3)
  Print #3, multiTarget$;
  Pause cmdDelay
  junk$ = Input$(255,#3)
  If debug Then
    If junk$ = ackMultiTarget$ Then
      Print "ACK multi OK"
    Else
      For n = 1 To Len(junk$)
        Print Hex$(Asc(Mid$(junk$,n,1)),2);
      Next n
      Print
    Endif
  Endif
  Print #3, endconf$;
  Pause cmdDelay
  junk$ = Input$(255,#3)
End Sub
  
Sub drawroom
  Framebuffer Create
  Framebuffer Write F
  Arc 160,240,60,,285,75,Rgb(Green)
  Arc 160,240,120,,285,75,Rgb(Green)
  Arc 160,240,180,,298,62,Rgb(Green)
  Arc 160,240,240,,318,42,Rgb(Green)
  Line 0,0,160,240,,Rgb(Green)
  Line 160,0,160,240,,Rgb(Green)
  Line 320,0,160,240,,Rgb(Green)
  Line 0,150,160,240,,Rgb(Green)
  Line 320,150,160,240,,Rgb(Green)
  'font 7:text 0,220,vers 'shows version in left bottom corner
  
  Framebuffer Copy f,n
  
End Sub
  
Sub printTail
  Local n
  For n = 0 To tailsize
    Print n,tX1(n),tY1(n)
  Next n
  Memory
End Sub
  
