  'Peters code for a 2 channel oscilloscope
  
  'todo : check if wiping traces by re-drawing black is faster than CLS
  
  vga=0 'not VGA then LCD
  
  CLS
  FRAMEBUFFER create
  FRAMEBUFFER write f
  framebuffer layer
  
  'memory allocation and fill default X axis locations
  if VGA then
    Dim float a(1279),b(1279),aa(639),bb(639),c(639),d(639),e(639)
    For i=0 To 639:e(i)=i:Next
    framebuffer write L
    box 0,0,640,480,1,rgb(yellow)
    line 0,240,640,240,1,rgb(yellow)
    framebuffer write F
  else
    Dim float a(639),b(639),aa(319),bb(319),c(319),d(319),e(319)
    For i=0 To 319:e(i)=i:Next
    framebuffer write L
    box 0,0,320,240,1,rgb(yellow)
    line 0,120,320,120,1,rgb(yellow)
    framebuffer write F
  end if
  
  'test signal
  play tone 1000,1000
  
  'open ADC for maximum clock speed (378MHz CPU)
  'ADC open 1968750,2,done
  ADC open 200000,2,done '@harm tesat when CPU not running flat out
  
  'main loop
  Do
    'start sampler
    ADC start a(),b()
    
    'wait for ready
    Do
    Loop Until f%=1
    f%=0
    
    'this assumes a trigger in the first half of a()
    p%=Math(crossing a(),1.5,1) 'a trigger 1.5V rising edge on a()
    if p%<0 then p%=0 '@harm -> when no trigger
    
    'copy 640 points from a() to aa(), similar b()
    if VGA then
      Memory copy float Peek(varaddr a(p%)),Peek(varaddr aa(0)),640
      Memory copy float Peek(varaddr b(p%)),Peek(varaddr bb(0)),640
      
      'scale to 3.3 x 50 = 165 pix vertical
      Math scale aa(),50,aa()
      Math scale bb(),50,bb()
      
      'add vertical location on screen
      Math add aa(),50,aa()
      Math add bb(),250,bb()
      
    else
      Memory copy float Peek(varaddr a(p%)),Peek(varaddr aa(0)),320
      Memory copy float Peek(varaddr b(p%)),Peek(varaddr bb(0)),320
      
      'scale to 3.3 x 30 = 100 pix vertical
      Math scale aa(),-120/3.3,aa()
      Math scale bb(),-120/3.3,bb()
      
      'add vertical location on screen
      Math add aa(),120,aa()
      Math add bb(),240,bb()
      
      'math window aa(),0,240,aa()
      'math window bb(),0,120,bb()
      
    endif
    
    'wipe old traces
    Line graph e(),c(),0
    Line graph e(),d(),0
    'cls
    
    'draw new traces
    Line graph e(),aa(),RGB(green)
    Line graph e(),bb(),RGB(cyan)
    
    'show on screen
    if VGA then
      FRAMEBUFFER copy f,n
    else
      framebuffer merge 0,b
    end if
    
    'copy current, for wiping later
    Math scale aa(),1,c()
    Math scale bb(),1,d()
    
  Loop
  
Sub done
  f%=1
End Sub
