  'game loop for a lemmings game
  
  option default integer
  
  const SPRADDR = Peek(cfunaddr LemWalk)
  const SPRSIZE = 136
  const WALKSPD = 100
  const NUM_LEM = 30
  
  if instr(mm.device$,"VGA") then MODE 2
  framebuffer layer
  
  
  'game parameters
  h_beat=100 'ms
  
  'memory allocation
  dim lx(NUM_LEM),ly(NUM_LEM),dx(NUM_LEM),dy(NUM_LEM),visi(NUM_LEM),typ(NUM_LEM)
  fill_default
  
  'mouse initialization
  'could be done in the program, but the mouse is already enabled in OPTION MOUSE
  'mouse open 2,gp27,gp28
  
  'load background
  'load image "Station.bmp"
  
  
  'main player input loop -----------------------------------------
  Do
  
    'debug loop timer information
    framebuffer write n : text 290,0,"     "
    Text 290,0,Str$(timer,3,0," ")
    
    ' constant timing in the game loop
    Do : Loop Until Timer>h_beat
    Timer=0
   
    
    'graphics processing ----------------------------------------------
    
    '  world map

    'tbd
    
    
    '  lemmings
    framebuffer write l
    cls
    for i = 0 to NUM_LEM
      if visi(i)=1 then
        blit memory SPRADDR+typ(i)*SPRSIZE , lx(i) , ly(i)   ' draw sprite
      end if
    next
    
    '  mouse
    box mx,my,14,20,,choice(ml=1,rgb(red),rgb(green))
    
    '  animations
    
    'tbd
      
    
    
    
    
    'gameplay processing ------------------------------------------------
    
    '  demo mouse click effect
    if ml=1 then
      l=find_lem()    'find lemming under the mouse
      dx(l)=-dx(l)    'change walk direction
      ml=0            'ackn using mouse click
      framebuffer write n
      text 0,0,str$(l,3,0,"0")
    end if
    
    '  move lemmings
    for i = 0 to NUM_LEM
      if visi(i)=1 then
        inc lx(i),dx(i)*2
        if lx(i)>300 then dx(i)=-1
        if lx(i)<6 then dx(i)=1
        typ(i)=(dx(i)<0)*8 + ((typ(i)+1) and 7)
      end if
    next
    
    
    'mouse controls -------------------------------------------------------
    
    mx=device(mouse 2,X)
    my=device(MOUSE 2,Y)
    
    'flipflop in software for L mouse button
    mm=m : m=device(mouse 2,L)
    if mm=0 and m=1 then ml=1
    
  loop

  
  
sub fill_default
  local i
  for i=0 to NUM_LEM
    lx(i)=20*int(15*rnd):ly(i)=20*int(11*rnd) 'random position
    typ(i)=int(rnd*8)
  next
  math set 0,dy()   'none move down
  math set 1,dx()   'all walk right step 2
  math set 1,visi() 'all visible
  'math set 1,typ()  'all type 1 (walking right)
  'mouse set 2,160,120 'set mouse in centre screen, does not work
end sub

  
  
function find_lem()
  local i
  for i=0 to NUM_LEM
    if visi(i)=1 then
      if abs(lx(i)-mx) < 5 then
        if abs(ly(i)-my) < 8 then
          find_lem=i : exit function
        endif
      endif
    endif
  next
end function
  
  
  '------------------------------- graphics --------------------------------
  
CSub LemWalk
  00000000
  0014000D
  00000000 00000000 00066660 46660000
  00004646 44446460 66600006 0000DD44
  D4464600 000000FD FFDDDD44 D4000000
  000FFFFD 333D0000 00000000 000333D0
  DD000000 00000353 353DF000 00000000
  003555DF 5FD00000 00000355 33555500
  5D000000 00033355 3355DF00 D0000033
  0033333D DD000000 000000DD DDFFF000
  00000000
  ' length: 136
  0014000D
  00460000 00000046 04460446 66460000
  00000046 04444446 66600000 0000DD44
  D4444000 000000DD FFFDDD40 D0000000
  000FFFDF 353D0000 00000000 000353DF
  3DD00000 00000035 33553DF0 DF000000
  FF035553 555DF000 000DF033 33335500
  550000DF 0DD33333 03335500 50000DDF
  0DD00333 DDDF0000 00000000 00DDFFF0
  00000000
  ' length: 136
  0014000D
  00000000 00000000 00000000 00660000
  00000046 04440640 46000000 00004466
  44664000 00000006 00DD4466 64000000
  0000FDD4 FDDD0000 000000FF 0FFDFDD0
  5DF00000 00000035 0355DF00 DF000000
  00033555 555DF000 F0000035 335355DD
  55DD0000 00035533 53355500 50000333
  33333335 00DDFF00 F0DDDDD0 F000DDFD
  0000DDDF
  ' length: 136
  0014000D
  00000000 00000000 00000000 46000000
  00000006 44464600 66000000 00464D44
  D4464000 0000044D FDFDDD46 D4600000
  000FFFDF 33F50000 00000000 00033DF0
  DF000000 00000035 335DDF00 DF000000
  0003553D 553DF000 00000335 33555300
  55000000 00033353 335355FF 3DF00033
  03333533 3000DF00 F000DDD3 DFF000DF
  000000FD
  ' length: 136
  0014000D
  00000000 00000000 00000000 66600000
  00006464 64444460 64000044 0000DD44
  D4446000 000000DD FFFDDD46 D4600000
  000FFDFD 35FD4000 00000000 0005DDF0
  F5000000 0000033D 35DF5000 00000000
  00335DFF 5DFF0000 00000335 33555500
  5F000000 00033355 3355DF00 F0000033
  0033333D DF000000 000000DD DDDFF000
  00000000
  ' length: 136
  0014000D
  00460000 00000046 04640446 46460000
  00000046 06444460 66000000 0000DD44
  D4446000 000000FD FDFDDD40 D0000000
  000FFFDF 35DF0000 00000000 0003DFF0
  F5000000 0000003D 3DF55000 00000000
  FF03DF55 F5550000 000DF33D 33333550
  555000DD 0DDF3333 03335500 50000DDF
  0DF00333 DDDFF000 00000000 00DDDFF0
  00000000
  ' length: 136
  0014000D
  00000000 00000000 00000000 00600000
  00000046 04460460 44000000 00004446
  46646000 00000004 00DD4460 44000000
  0000FDD4 FDDD0000 000000FF 0FDFDFD0
  F5000000 0000003D 03DF5000 00000000
  0003DF35 F55F0000 0000003D DDF355DF
  55000000 000FF535 33355500 50F00033
  33333333 00DDFF00 FDFDDD00 FF00DFDD
  00000DDD
  '00000000 00000000 00000000 00600000
  '00000046 04460460 44000000 00004446
  '46646000 00000004 00DD4460 44000000
  '0000FDD4 FDDD0000 000000FF 0FDFDFD0
  'F5000000 0000003D 03DF5000 00000000
  '0003DF35 F5500000 0000003D DDF35500
  '50000000 000FF535 33355500 50F00033
  '33333333 00DDFF00 FDFDDD00 FF00DFDD
  '00000DDD
  ' length: 136
  0014000D
  00000000 00000000 00000000 46000000
  00000066 64446400 66000000 0044DD44
  D4446000 000006DD FFDDDD44 F4600000
  000FFFDD 335F4000 00000000 00035DF0
  DF000000 00000355 35DDF000 00000000
  0003DDF5 F5500000 0000033D 33555500
  30000000 00033355 335555F0 5DF00033
  03333335 F000DF00 F000DDDF DFF000DF
  000000DF
  ' length: 136
  0014000D
  00000000 00000000 00666600 46400000
  00066646 64444600 00000064 66644DD0
  DDF00000 00064644 4DDDDFF0 FF000004
  0004DDFF 33300000 0000000D 00D33300
  53000000 00000DD3 FD353000 30000000
  000FD555 55530000 000000DF 05555330
  33000000 000D5553 53333000 00000FD5
  DD333330 D0000000 00000DDD FFFDD000
  00000000
  ' length: 136
  0014000D
  40064000 00000006 06440644 40000000
  00064666 44440000 00000644 66644DD0
  DDD00000 00004444 4DDDFFF0 FF000000
  0000DFDF 35300000 0000000D 0FD35300
  30000000 0000DD35 35533000 0FF000FD
  0FD35553 5330FD00 D000FD55 0553333F
  33DD0000 00055333 330FDD00 00000553
  533300DD 00000000 000FDDD0 FDD00000
  000000FF
  ' length: 136
  0014000D
  00000000 00000000 00000000 40000000
  00066006 04440000 00000046 06466440
  46000000 00004664 644DD000 F0000006
  000464DD DDFFF000 0000000D 00DDFDFF
  30000000 0000FD55 D5530000 0000000F
  0FD55533 55300000 0000FD55 D5535330
  530000FD 0DD55335 33533300 30000555
  55333333 DDDDD000 DFFDD000 D000FFDD
  0000FDFD
  ' length: 136
  0014000D
  00000000 00000000 00000000 00000000
  00000646 46444000 40000006 06644D46
  DD440000 00004644 4DDDFDF0 FF000006
  0064DFDF F3300000 00000005 00FD3300
  30000000 00000FD5 DD533000 0000000F
  0FDD3553 55330000 0000FD35 03555330
  33000000 00055353 53333000 000FF553
  33353333 DDD000FD 0FD00033 00FFDDF0
  0000FFD0
  ' length: 136
  0014000D
  00000000 00000000 00000000 64600000
  00006664 44446440 00000064 04644DD0
  DDD00000 00006444 4DDDFFF0 FF000006
  0064DDFD F5300000 0000004D 00FDD500
  33000000 000005FD 5FD53000 30000000
  000FFD53 55330000 00000FFD 05555330
  33000000 000F5553 53333000 00000FD5
  FD333330 D0000000 00000FDD FFDDD000
  00000000
  ' length: 136
  0014000D
  40064000 00000006 06440464 40000000
  00064646 44460000 00000064 06644DD0
  DDF00000 00006444 4DDDFDF0 FF000000
  0000DFDF D5300000 0000000F 00FFD300
  30000000 000005FD 55FD3000 0FF00000
  00055FD3 FD33FD00 D0000555 5533333D
  3FDD0000 00555333 330FDD00 00000553
  533300FD 00000000 00FFDDD0 DDD00000
  000000FF
  ' length: 136
  0014000D
  00000000 00000000 00000000 40000000
  00006006 06440000 00000064 04464440
  44000000 00006466 644DD000 F0000000
  000444DD DDFFF000 0000000D 00DFDFDF
  30000000 000005FD 5FD30000 00000000
  00053FD3 FD300000 00000F55 D553FDD0
  FF00000F 00055535 33333000 30000555
  53333333 0DDDFDF0 0FFDD000 D00FFDDD
  0000FDDF
  '00000000 00000000 00000000 40000000
  '00006006 06440000 00000064 04464440
  '44000000 00006466 644DD000 F0000000
  '000444DD DDFFF000 0000000D 00DFDFDF
  '30000000 000005FD 5FD30000 00000000
  '00053FD3 FD300000 00000055 0553FDD0
  'FF000000 00005535 33333000 30000555
  '53333333 0DDDFDF0 0FFDD000 D00FFDDD
  '0000FDDF
  ' length: 136
  0014000D
  00000000 00000000 00000000 60000000
  00000646 64446000 40000004 06644DD4
  DDD60000 00006444 4DDDDFF0 FF000004
  0064FDDF 53300000 0000004F 00FD5300
  53000000 00000FD5 FDD53000 00000000
  0005FDD3 FD330000 00000055 05555330
  33000000 00003553 53333000 0000F555
  55333333 DDD000FD 0FD000FF 00FFDFD0
  0000FFD0
  ' length: 136
end csub
  ' end
