  ' Game of Life by John CONWAY.
  ' Unfortunately, Covid19 took John's life on April 11, 2020. His
  ' legacy lives on in the countless people inspired by his invention
  ' of the cellular automaton called the Game of Life and his other works.
  '
  ' Written by vegipete,       Apr  2020 for GFXTerm
  ' Modified by Steve Johnson, July 2023 for RP2040-LCD-0.96 in Landscape LCD
  ' Modified by Steve Johnson, Feb  2024 for any display & orientation
  
  Option DEFAULT INTEGER
  
  Const x      = MM.HRes/2     ' Horizontal Center of LCD
  Const y      = MM.VRes/2     ' Vertical Center of LCD
  Const top    = 0
  Const bot    = MM.VRes-1
  Const left   = 0
  Const right  = MM.HRes-1
  Const ltop   = top          ' Top edge of Universe display on LCD
  Const lleft  = left         ' Left edge of Universe display on LCD
  Const lspac  = 5            ' Cell spacing on Universe display on LCD
  Const width  = lspac-1      ' Width And Height of Cells on LCD
  Const height = lspac-1
  Const live   = RGB(Green) 
  Const dead   = RGB(myrtle) 
  Const empty  = RGB(Black)
  Const HMax   = Int(MM.HRes/lspac)
  Const VMax   = Int(MM.VRes/lspac)
  
  Dim INTEGER i, j, count, w(HMax+1,VMax+1), Changed
  Backlight 75
  
  Do
    CLS RGB(Yellow)
    Text x, y-36, "Conway's", "CM", 3, 1, RGB(Black), RGB(Yellow)
    Text x, y-12, "  GAME  ", "CM", 3, 1, RGB(Red),   RGB(Yellow)
    Text x, y+12, "   of   ", "CM", 3, 1, RGB(Red),   RGB(Yellow)
    Text x, y+36, "  LIFE  ", "CM", 3, 1, RGB(Red),   RGB(Yellow)
    Math SET 0, w()       ' clear the world to start
    
    Pause 4000 : CLS : Randomize Timer
    
    RandLife : Penta 3, 6
    
    LCDLife                ' Display the Universe
    
    Changed = 1
    Generation = 1
    
    Do
      Inc Generation,1
      Inc i : Changed = 0
      CONWAYLife           ' Calculate the next generation
      LCDLife              ' Display the Universe
      Text 0,0,Str$(generation)
    Loop while Changed
  Loop
  
End
  
Sub Heavy ' Seed life with a Heavyweight Spaceship
  w(16, 9)=1 :              w(16,11)=1
  w(17, 8)=1
  w(18, 8)=1 :                                        w(18,12)=1
  w(19, 8)=1 :                                        w(19,12)=1
  w(20, 8)=1
  w(21, 8)=1 :                           w(21,11)=1
  w(22, 8)=1 : w(22, 9)=1 : w(22,10)=1
End Sub
  
Sub Penta h, v ' Seed life with a Pentadecathlon (period 15)
  w(h   ,v)=1 : w(h   ,v+1)=1 : w(h   ,v+2)=1
  w(h+ 1,v+1)=1
  w(h+ 2,v+1)=1
  w(h+ 3,v)=1 : w(h+ 3,v+1)=1 : w(h+ 3,v+2)=1
  
  w(h+ 5,v)=1 : w(h+ 5,v+1)=1 : w(h+ 5,v+2)=1
  w(h+ 6,v)=1 : w(h+ 6,v+1)=1 : w(h+ 6,v+2)=1
  
  w(h+ 8,v)=1 : w(h+ 8,v+1)=1 : w(h+ 8,v+2)=1
  w(h+ 9,v+1)=1
  w(h+10,v+1)=1
  w(h+11,v)=1 : w(h+11,v+1)=1 : w(h+11,v+2)=1
End Sub
  
Sub SeedLife ' Seed the world with a simple pattern
  w( 9,10) = 1 : w(10,10) = 1 : w(11,10) = 1
  w( 9,11) = 1 : w(11,11) = 1
  w( 9,12) = 1 : w(11,12) = 1
  w(10,13) = 1
  w( 7,14) = 1 : w( 9,14) = 1 : w(10,14) = 3: w(11,14) = 1
  w( 8,15) = 1 : w(10,15) = 1 : w(12,15) = 1
  w(10,16) = 1 : w(13,16) = 1
  w( 9,17) = 1 : w(11,17) = 1
  w( 9,18) = 1 : w(11,18) = 1
End Sub
  
Sub RandLife  ' Seed Life with a random pattern
  Local i
  For i = 1 To HMax*VMax/7    
    w((1+Rnd*HMax),(1+Rnd*VMax)) = 1
  Next i
End Sub
  
Sub CONWAYLife ' Calculate a new generation of life
  Local integer i, j, count
  'Math SCALE w(), 2, w() ' shift left & clear new generation 5.08.00
  Math Shift w(), 1, w() ,U' shift left & clear new generation 6.01.00

  
  '   Wrap corners & edges To simplify neighbor count evaluation
  w(0,0)=w(HMax,VMax) : w(HMax+1,VMax+1)=w(1, 1)
  w(0,VMax+1)=w(HMax,1) : w(HMax+1, 0)=w(1,VMax)
  
  For i = 1 To VMax  ' wrap the edges
    w(0,i)=w(HMax,i) : w(HMax+1,i)=w(1,i)
  Next i
  
  For j = 1 To HMax
    w(j,0)=w(j,VMax) : w(j,VMax+1)=w(j,1)
  Next j
  
  ' calculate new generation
  For i = 1 To HMax
    For j = 1 To VMax
      count = Neighbors(i,j)
      If count=3 Then Inc w(i,j)
      If count=2 Then
        If (w(i,j) And 2) = 2 Then Inc w(i,j)
      EndIf
    Next j
  Next i
End Sub
  
Function Neighbors(x,y) ' return number of neighbors around given point
  Local count = 0       ' good candidate for C subroutine.
  count = (w(x-1,y-1) And 2) + (w(x+0,y-1) And 2) + (w(x+1,y-1) And 2)
  count = count + (w(x-1,y+0) And 2) + (w(x+1,y+0) And 2) + (w(x-1,y+1) And 2)
  count = count + (w(x+0,y+1) And 2) + (w(x+1,y+1) And 2)
  Neighbors = count>>1 ' Previous lines are bitwise ANDs, not Logical :-(
End Function
  
Sub LCDLife ' display the current world on LCD. Indicate if changes occurring
  Local integer i,j, xcoord, ycoord
  xcoord = lleft       ' Left side of Universe display on LCD screen
  For i = 1 To HMax
    ycoord = ltop      ' top edge of Universe display on LCD screen
    For j = 1 To VMax
      Select Case (w(i,j) And 3) '  faster than IF..THEN..ELSE..ENDIF
          Case 1: Box xcoord, ycoord, width, height, 1, live, live  : Changed = 1
          '       Case 2: Box xcoord, ycoord, width, height, 1, dead, empty : Changed = 1
          Case 2: Box xcoord, ycoord, width, height, 1, empty, dead : Changed = 1
      End Select
      Inc ycoord, lspac
    Next j
    Inc xcoord, lspac
  Next i
End Sub
