'MMB4W Modes etc. Loads a source PNG and translatet it to 121 RGB BMP
'---------------------------------
'Source Filename,width and height here 
FN$="A11"

'thresholds (Should be customized to the source)
LR=40    'Lower threshold Red
UR=128   'Upper threshold

LG=16
  'Lower threshold Green
MG=40 'Mid threshold
UG=96 'Upper threshold

LB=18 'Lower threshold Blue
UB=64  'Upper threshold
'---------------------------------
dim w, h

open FN$ + ".png" for input as #1
s$ = INPUT$(24, #1) ' Erste 24 Bytes holen (bis Ende IHDR-Header)

' Breite aus Byte 17-20 (Index 16–19 in MMBasic, da 0-basiert)
w = ASC(MID$(s$,17,1))*16777216 + ASC(MID$(s$,18,1))*65536 + ASC(MID$(s$,19,1))*256 + ASC(MID$(s$,20,1))

' Höhe aus Byte 21–24 (Index 20–23)
h = ASC(MID$(s$,21,1))*16777216 + ASC(MID$(s$,22,1))*65536 + ASC(MID$(s$,23,1))*256 + ASC(MID$(s$,24,1))

close #1
mode 1:cls
load png FN$+".png"
for y=0 to h
    for x=0 to w 
        cl%=0
        n=Pixel(x,y)AND &HFFFFFF
        '-->get Red
        r=n AND &HFF
        'Check red thresholds if value is in then dither
        if r>LR and r<UR then
         if (y mod 2)then 
         R=255*not (x mod 2)
         else
         R=255*(x mod 2)
         endif 
        end if
        inc cl%,255*(r>127):n=int(n/256)
        '-->get Green
        g=n AND &HFF
        'Check green thresholds, no dithering
        select case g
        case >UG
        inc cl%,&HFF00
        case >MG
        inc cl%,&H8000
        case >LG
        inc cl%,&H4000
        end select
        '-->get Blue
        n=int(n/256)
        b=n AND &HFF
        'Check Blue thresholds, if value is in then dither
        if B>64 and b<162 then
         if (y mod 2)then 
         B=255*(x mod 2)
         else
         B=255*not (x mod 2)
         endif 
        end if
        inc cl%,&Hff0000*(b>64)
        pixel x,y,cl%
    next
next
save image FN$+".bmp",0,0,w,h
print "Breite:"; w; " Höhe:"; h
