' Transpiled on 07-01-2024 18:07:39
' Copyright (c) 2022-2023 Martin Herhaus
Const VERSION = 101301
' ../../mmbasic-third-party/3d-maze/../splib/system.inc ++++
' Copyright (c) 2020-2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
' Preprocessor value GAMEMITE defined
Const sys.VERSION = 102201
Const sys.NO_DATA$ = Chr$(&h7F)
Const sys.CRLF$ = Chr$(13) + Chr$(10)
Const sys.FIRMWARE = Int(1000000 * Mm.Info(Version))
Const sys.SUCCESS = 0
Const sys.FAILURE = -1
Dim sys.break_flag%
Dim sys.err$

Function sys.format_version$(v%)
 Const v_% = Choice(v%, v%, sys.VERSION), a% = v_%\10^5, b% = (v_%-a%*10^5)\10^3
 Local c% = v_%-a%*10^5-b%*10^3, s$ = Str$(a%) + "." + Str$(b%)
 Select Case c%
  Case < 100 : Cat s$, " alpha "
  Case < 200 : Cat s$, " beta " : Inc c%, -100
  Case < 300 : Cat s$, " RC " : Inc c%, -200
  Case Else  : Cat s$, "." : Inc c%, -300
 End Select
 sys.format_version$ = s$ + Str$(c%)
End Function

Sub sys.override_break(callback$)
 sys.break_flag% = 0
 Option Break 4
 If Len(callback$) Then
  Execute "On Key 3, " + callback$ + "()"
 Else
  On Key 3, sys.break_handler()
 EndIf
End Sub

Sub sys.break_handler()
 Inc sys.break_flag%
 If sys.break_flag% > 1 Then
  sys.restore_break()
  End
 EndIf
End Sub

Sub sys.restore_break()
 sys.break_flag% = 0
 On Key 3, 0
 Option Break 3
End Sub

' ---- ../../mmbasic-third-party/3d-maze/../splib/system.inc
' ../../mmbasic-third-party/3d-maze/../splib/ctrl.inc ++++
' Copyright (c) 2022-2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Const ctrl.R      = &h01
Const ctrl.START  = &h02
Const ctrl.HOME   = &h04
Const ctrl.SELECT = &h08
Const ctrl.L      = &h10
Const ctrl.DOWN   = &h20
Const ctrl.RIGHT  = &h40
Const ctrl.UP     = &h80
Const ctrl.LEFT   = &h100
Const ctrl.ZR     = &h200
Const ctrl.X      = &h400
Const ctrl.A      = &h800
Const ctrl.Y      = &h1000
Const ctrl.B      = &h2000
Const ctrl.ZL     = &h4000
Const ctrl.OPEN  = -1
Const ctrl.CLOSE = -2
Const ctrl.SOFT_CLOSE = -3
Const ctrl.PULSE = 0.001
Const ctrl.UI_DELAY = 200
Dim ctrl.open_drivers$
Dim ctrl.key_type%
Dim ctrl.key_map%(31 + Mm.Info(Option Base))

Sub ctrl.init_keys(use_inkey%, period%, nbr%)
 ctrl.term_keys()
 ctrl.key_type% = 0
 On Key ctrl.on_key()
End Sub

Sub ctrl.on_key()
 Poke Var ctrl.key_map%(), Asc(LCase$(Inkey$)), 1
End Sub

Sub ctrl.term()
 ctrl.term_keys()
 On Error Ignore
 Do While Len(ctrl.open_drivers$)
  Call Field$(ctrl.open_drivers$, 1), ctrl.CLOSE
 Loop
 On Error Abort
End Sub

Sub ctrl.term_keys()
 On Key 0
 Memory Set Peek(VarAddr ctrl.key_map%()), 0, 256
 Do While Inkey$ <> "" : Loop
End Sub

Function ctrl.keydown%(i%)
 ctrl.keydown% = Peek(Var ctrl.key_map%(), i%)
 If ctrl.key_type% = 0 Then Poke Var ctrl.key_map%(), i%, 0
End Function

Function ctrl.poll_multiple$(drivers$(), mask%, duration%, key%)
 Local expires% = Choice(duration%, Timer + duration%, &h7FFFFFFFFFFFFFFF), i%
 Do
  For i% = Bound(drivers$(), 0) To Bound(drivers$(), 1)
   key% = ctrl.poll_single%(drivers$(i%), mask%)
   If key% Then ctrl.poll_multiple$ = drivers$(i%) : Exit Do
  Next
 Loop While Timer < expires%
 If duration% Then duration% = Max(0, expires% - Timer)
End Function

Function ctrl.poll_single%(driver$, mask%)
 On Error Ignore
 Call driver$, ctrl.OPEN
 If Mm.ErrNo = 0 Then
  Local key%, t% = Timer + 5
  Do
   Call driver$, key%
   ctrl.poll_single% = key% And mask%
   If ctrl.poll_single% Then
    Do While key% : Pause 5 : Call driver$, key% : Loop
    Exit Do
   EndIf
  Loop While Timer < t%
  Call driver$, ctrl.SOFT_CLOSE
 EndIf
 On Error Abort
End Function

Sub ctrl.wait_until_idle(d1$, d2$, d3$, d4$, d5$)
 Local k%
 Do
  Call d1$, k%
  If Not k% Then If Len(d2$) Then Call d2$, k%
  If Not k% Then If Len(d3$) Then Call d3$, k%
  If Not k% Then If Len(d4$) Then Call d4$, k%
  If Not k% Then If Len(d5$) Then Call d5$, k%
  If Not k% Then Exit Do
  Pause 5
 Loop
End Sub

Sub keys_cursor(x%)
 If x% < 0 Then Exit Sub
 x% =    ctrl.keydown%(32)  * ctrl.A
 Inc x%, ctrl.keydown%(128) * ctrl.UP
 Inc x%, ctrl.keydown%(129) * ctrl.DOWN
 Inc x%, ctrl.keydown%(130) * ctrl.LEFT
 Inc x%, ctrl.keydown%(131) * ctrl.RIGHT
End Sub

Sub ctrl.open_driver(d$)
 Cat ctrl.open_drivers$, d$ + ","
End Sub

Sub ctrl.close_driver(d$)
 Local idx% = InStr(ctrl.open_drivers$, d$)
 Select Case idx%
  Case 0
  Case 1
   ctrl.open_drivers$ = Mid$(ctrl.open_drivers$, Len(d$) + 2)
  Case Else
   ctrl.open_drivers$ = Mid$(ctrl.open_drivers$, 1, idx% - 1) + Mid$(ctrl.open_drivers$, idx% + Len(d$) + 1)
 End Select
End Sub

Sub ctrl.gamemite(x%)
 Select Case x%
  Case >= 0
   x% = Port(GP12,2,GP11,2,GP8,1,GP8,1,GP11,1,GP10,1,GP9,1,GP13,3,GP13,3)
   x% = (x% Xor &h7FFF) And &h29EA
   Exit Sub
  Case ctrl.OPEN
   Local i%
   For i% = 8 To 15 : SetPin Mm.Info(PinNo "GP" + Str$(i%)), Din, PullUp : Next
   ctrl.open_driver("ctrl.gamemite")
  Case ctrl.CLOSE, ctrl.SOFT_CLOSE
   Local i%
   For i% = 8 To 15 : SetPin Mm.Info(PinNo "GP" + Str$(i%)), Off : Next
   ctrl.close_driver("ctrl.gamemite")
 End Select
End Sub

Function str.wwrap$(s$, p%, len%)
 Const slen% = Len(s$)
 Local ch%, q%, word$
 For q% = p% To slen% + 1
  ch% = Choice(q% > slen%, 0, Peek(Var s$, q%))
  Select Case ch%
   Case 0, &h0A, &h0D, &h20
    If Len(str.wwrap$) + Len(word$) > len% Then
     If Len(word$) > len% Then
      word$ = Left$(word$, len% - Len(str.wwrap$))
      Cat str.wwrap$, word$
      Inc p%, Len(word$)
     EndIf
     Exit For
    EndIf
    Cat str.wwrap$, word$
    p% = q% + 1
    Select Case ch%
     Case &h0D
      If Choice(p% > slen%, 0, Peek(Var s$, p%)) = &h0A Then Inc p%
      Exit For
     Case &h20
      If Len(str.wwrap$) = len% Then Exit For
      Cat str.wwrap$, " "
      word$ = ""
     Case Else
      Exit For
    End Select
   Case Else
    Cat word$, Chr$(ch%)
  End Select
 Next
 p% = Min(p%, slen% + 1)
End Function

' ---- ../../mmbasic-third-party/3d-maze/../splib/string.inc
' ../../mmbasic-third-party/3d-maze/../splib/msgbox.inc ++++
' Copyright (c) 2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Const msgbox.NO_PAGES = &h01

Function msgbox.show%(x%, y%, w%, h%, msg$, buttons$(), default%, ctrl$, fg%, bg%, frame%, flags%)
 Const base% = Mm.Info(Option Base), num% = Bound(buttons$(), 1) - base% + 1
 Local i%, btn_x%(num%), p% = 1
 btn_x%(base%) = x% + 2
 For i% = base% + 1 To base% + num% - 1
  btn_x%(i%) = btn_x%(i% - 1) + Len(buttons$(i% - 1)) + 5
 Next
 msgbox.box(x%, y%, w%, h%, 1, Choice(frame% = -1, fg%, frame%), bg%)
 i% = y% + 2
 Do While p% <= Len(msg$)
  msgbox.print_at(x% + 2, i%, str.wwrap$(msg$, p%, w% - 4), fg%, bg%)
  Inc i%
 Loop
 Local key%, released%, valid% = 1
 msgbox.show% = default%
 Do
  If sys.break_flag% Then msgbox.show% = default% : Exit Function
  If valid% Then
   For i% = base% To base% + num% - 1
    msgbox.button(btn_x%(i%), y% + h% - 4, buttons$(i%), i% = msgbox.show%, fg%, bg%)
   Next
   If Not flags% And msgbox.NO_PAGES Then FrameBuffer Copy F , N
   valid% = 0
  EndIf
  Call ctrl$, key%
  If Not key% Then keys_cursor(key%)
  If Not key% Then released% = 1 : Continue Do
  If Not released% Then key% = 0 : Continue Do
  valid% = 0
  Select Case key%
   Case ctrl.A, ctrl.SELECT
    key% = ctrl.SELECT
    valid% = 1
   Case ctrl.LEFT
    If msgbox.show% > 0 Then Inc msgbox.show%, -1 : valid% =1
   Case ctrl.RIGHT
    If msgbox.show% < num% - 1 Then Inc msgbox.show% : valid% =1
  End Select
  msgbox.beep(valid%)
  Pause ctrl.UI_DELAY - 100
 Loop Until key% = ctrl.SELECT
 ctrl.wait_until_idle(ctrl$, "keys_cursor")
End Function

Sub msgbox.button(x%, y%, txt$, selected%, fg%, bg%)
 msgbox.box(x%, y%, Len(txt$) + 4, 3, 0, fg%, bg%)
 Const fg_% = Choice(selected%, bg%, fg%)
 Const bg_% = Choice(selected%, fg%, bg%)
 msgbox.print_at(x% + 2, y% + 1, txt$, fg_%, bg_%)
End Sub

Sub msgbox.box(x%, y%, w%, h%, dbl%, fg%, bg%)
 Const fh% = Mm.Info(FontHeight), fw% = Mm.Info(FontWidth)
 Local d% = fw% \ 2
 Box x% * fw%, y% * fh%, w% * fw%, h% * fh%, , bg%, bg%
 Box x% * fw% + d%, y% * fh% + d%, w% * fw% - 2 * d%, h% * fh% - 2 * d%, 1, fg%
 Inc d%, d%
 If dbl% Then Box x% * fw% + d%, y% * fh% + d%, w% * fw% - 2 * d%, h% * fh% - 2 * d%, 1, fg%
End Sub

Sub msgbox.print_at(x%, y%, s$, fg%, bg%)
 Text x% * Mm.Info(FontWidth), y% * Mm.Info(FontHeight), s$, , , , fg%, bg%
End Sub

Sub msgbox.beep(valid%)
 If valid% Then
  Local notes!(3) = (987.77, 1567.98, 1975.53, 30.87)
 Else
  Local notes!(4) = (1046.50, 987.77, 739.99, 698.46, 30.87)
 EndIf
 Play Stop
 Local i%
 For i% = Bound(notes!(), 0) To Bound(notes!(), 1)
  If notes!(i%) > 16.0 Then Play Sound 4, B, S, notes!(i%), 25
  Pause 40
 Next
 Play Stop
End Sub

' ---- ../../mmbasic-third-party/3d-maze/../splib/msgbox.inc
' ../../mmbasic-third-party/3d-maze/../splib/gamemite.inc ++++
' Copyright (c) 2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Function gamemite.file$(f$)
 If InStr("A:/B:/", UCase$(Left$(f$, 3))) Then
  gamemite.file$ = f$
 Else
  Local f_$ = "A:/GameMite" + Choice(f$ = "", "", "/" + f$), x%
  x% = Mm.Info(Exists File f_$)
  If Not x% Then
   f_$ = "B" + Mid$(f_$, 2)
   On Error Skip
   x% = Mm.Info(Exists File f_$)
  EndIf
  If Not x% Then f_$ = "A" + Mid$(f_$, 2)
  gamemite.file$ = f_$
 EndIf
End Function

Sub gamemite.end(break%)
 FrameBuffer Write N
 Colour Rgb(White), Rgb(Black)
 Cls
 sys.restore_break()
 On Error Skip : sound.term()
 On Error Skip : ctrl.term()
 On Error Skip
 twm.enable_cursor(1)
 If break% Then
  Const f$ = "", msg$ = "Exited due to Ctrl-C"
 Else
  Const f$ = gamemite.file$("menu.bas")
  Const x% = Mm.Info(Exists File f$)
  Const msg$ = Choice(x%, "Loading menu ...", "Menu program not found!")
 EndIf
 Text 160, 110, msg$, CM
 If Len(f$) Then Run f$ Else End
End Sub

' ---- ../../mmbasic-third-party/3d-maze/../splib/gamemite.inc
sys.override_break("break_cb")
Const VERSION_STRING$ = "Game*Mite Version " + sys.format_version$(VERSION)
Dim CONTROLLERS$(1) = ("keys_wasd", "ctrl.gamemite")
Const STATE_SHOW_TITLE% = 0
Const STATE_PLAY_GAME% = 1
Const STATE_WIN_GAME% = 2
Const MAP_Y% = 37
Dim pd%
Dim redraw%
Dim tmp_int%
Dim state%
FrameBuffer Create
Font 1
FrameBuffer Write F
ctrl.init_keys()
Dim ctrl$ = show_title$()
WallC1%=0:WallC2%=RGB(RED)
Dim Wall%(6,4,2)
For N%=0 To 5
 For C%=0 To 3
  For F%=0 To 1
   Read Wall%(N%,C%,F%)
  Next
 Next
Next
MazeW%=24:MazeH%=24
Dim Maze$(MazeW%,MazeH%) length 1
restart_game:
For x% = 0 To MazeW%
 For y% = 0 To MazeH%
  Maze$(x%, y%) = "#"
 Next
Next
generator
MovDir$=Chr$(146)+Chr$(148)+Chr$(147)+Chr$(149)
show_map%=0
Cls Rgb(White)
PlrX% = MazeW% - 1
PlrY% = MazeH% - 1
For pd% = 0 To 3
 If Not blocked%(pd%) Then Exit For
Next
If pd% = 4 Then Error "Invalid state"
Ex_X%=2:Ex_Y%=0:If Maze$(Ex_X%,1)="#" Then Inc Ex_X%
Maze$(Ex_X%,Ex_Y%)="E"
If show_map% Then Box 243+Ex_X%*3,MAP_Y%+Ex_Y%*3,3,3,,WallC2%,WallC2%
Colour 0, Rgb(White)
Text 280, 10, "D  X  Y", CT
Select Case ctrl$
 Case "ctrl.gamemite"
  Text 280, 164, "GAMEPAD", CT
 Case "nes_a"
  Text 280, 164, "NES PAD", CT
 Case "atari_a"
  Text 280, 164, "ATARI JOY", CT
 Case "keys_wasd"
  Text 280, 120, "KEYS:    ", CT
  Text 280, 131, "W:FORWARD", CT
  Text 280, 142, "S:BACKWRD", CT
  Text 280, 153, "A:TURN L.", CT
  Text 280, 164, "D:TURN R.", CT
End Select
Text 280, 175, Choice(ctrl$ = "keys_wasd", "M", "B") + ":MAP ON ", CT
state% = STATE_PLAY_GAME
redraw% = 1
Do
 If redraw% Then
  Text 280,20," " + Mid$(MovDir$,PD%+1,1)+" "+Str$(PlrX%,2)+" "+Str$(PlrY%,2)+" ",CT
  Draw_3D
  Select Case PD%
   Case 0:XS%=0 :YS%=-1
   Case 1:XS%=1 :YS%=0
   Case 2:XS%=0 :YS%=1
   Case 3:XS%=-1:YS%=0
  End Select
  redraw% = 0
  FrameBuffer Copy F , N
 EndIf
 Key% = 0
 Do While Key% = 0
  Call ctrl$, Key%
  If Key% = OldKey% Then Key% = 0 Else OldKey% = Key%
  If show_map% Then
   FrameBuffer Write N
   tmp_int% = Choice((Timer Mod 1000) < 500, Rgb(Red), Rgb(White))
   Box 243 + PlrX% * 3, MAP_Y% + PlrY% * 3, 3, 3, , tmp_int%, tmp_int%
   FrameBuffer Write F
  EndIf
 Loop
 Select Case Key%
  Case ctrl.LEFT
   pd% = Choice(pd% = 0, 3, pd% - 1)
   redraw% = 1
  Case ctrl.RIGHT
   pd% = Choice(pd% = 3, 0, pd% + 1)
   redraw% = 1
  Case ctrl.UP, ctrl.DOWN
   OX%=PlrX%:OY%=PlrY%
   Inc PlrX%, Choice(Key% = ctrl.UP, 1, -1) * XS%
   Inc PlrY%, Choice(Key% = ctrl.UP, 1, -1) * YS%
   If Maze$(PlrX%,PlrY%)="#" Then
    PlrX%=OX%:PlrY%=OY%
    msgbox.beep(0)
   EndIf
   If show_map% Then Box 243 + ox% * 3, MAP_Y% + oy% * 3, 3, 3, ,Rgb(White), Rgb(White)
   redraw% = 1
  Case ctrl.B
   show_map% = Not show_map%
   If show_map% Then
    Box 243, MAP_Y%, 76, 76, , Rgb(White), Rgb(White)
    Show_Maze
    Box 243+Ex_X%*3,MAP_Y%+Ex_Y%*3,3,3,,255.255
    Text 280, 175, Choice(ctrl$ = "keys_wasd", "M", "B") + ":MAP OFF", CT
   Else
    Box 243, MAP_Y%, 76, 76, , Rgb(White), Rgb(White)
    Text 280, 175, Choice(ctrl$ = "keys_wasd", "M", "B") + ":MAP ON ", CT
   EndIf
   redraw% = 1
  Case ctrl.SELECT, ctrl.START
   on_quit()
   redraw% = 1
  Case ctrl.A Or ctrl.B
   PlrX% = Ex_X% : PlrY% = Ex_Y% + 1 : pd% = 0
   redraw% = 1
 End Select
 If PlrX%=Ex_X% And PlrY%=Ex_Y% Then Exit Do
Loop
win_game()
GoTo restart_game

Function blocked%(direction%)
 Local x% = PlrX%, y% = PlrY%
 Select Case direction%
  Case 0 : Inc y%, -1
  Case 1 : Inc x%, 1
  Case 2 : Inc y%, 1
  Case 3 : Inc x%, -1
 End Select
 blocked% = Maze$(x%, y%) = "#"
End Function

Sub on_quit()
 msgbox.beep(1)
 Local buttons$(1) Length 3 = ("Yes", "No")
 Const msg$ = "Quit game?"
 Select Case state%
  Case STATE_SHOW_TITLE
   Const x% = 9, y% = 5, fg% = Rgb(White), bg% = Rgb(Black), frame% = Rgb(Green)
  Case Else
   Const x% = 4, y% = 5, fg% = Rgb(Black), bg% = Rgb(White), frame% = -1
 End Select
 Local buf%(4799), pbuf% = Peek(VarAddr buf%())
 Memory Copy Mm.Info(WriteBuff), pbuf%, 38400
 Const answer% = msgbox.show%(x%, y%, 22, 9, msg$, buttons$(), 1, ctrl$, fg%, bg%, frame%)
 If buttons$(answer%) = "Yes" Then end_program()
 Memory Copy pbuf%, Mm.Info(WriteBuff), 38400
 FrameBuffer Copy F , N
End Sub

Sub draw_3d
 Box 0, 0, 241, 240, , Rgb(White), Rgb(White)
 Select Case PD%
  Case 0
   For f%=0 To 5
    If PlrY%-f%<0 Then Exit For
    If Maze$(PlrX%-1,PlrY%-f%)="#" Then Draw_Element f%,0,0 Else Draw_Element f%,0,1
    If Maze$(PlrX%+1,PlrY%-f%)="#" Then Draw_Element f%,1,0 Else Draw_Element f%,1,1
    If Maze$(PlrX%,PlrY%-f%)="#" Then Draw_Element f%,1,2:Exit For
   Next f%
  Case 1
   For f%=0 To 5
    If PlrX%+f%>MazeW% Then Exit For
    If Maze$(PlrX%+f%,PlrY%-1)="#" Then Draw_Element f%,0,0 Else Draw_Element f%,0,1
    If Maze$(PlrX%+f%,PlrY%+1)="#" Then Draw_Element f%,1,0 Else Draw_Element f%,1,1
    If Maze$(PlrX%+f%,PlrY%)="#" Then Draw_Element f%,1,2:Exit For
   Next f%
  Case 2
   For f%=0 To 5
    If PlrY%+f%>MazeH% Then Exit For
    If Maze$(PlrX%+1,PlrY%+f%)="#" Then Draw_Element f%,0,0 Else Draw_Element f%,0,1
    If Maze$(PlrX%-1,PlrY%+f%)="#" Then Draw_Element f%,1,0 Else Draw_Element f%,1,1
    If Maze$(PlrX%,PlrY%+f%)="#" Then Draw_Element f%,1,2:Exit For
   Next f%
  Case 3
   For f%=0 To 5
    If PlrX%-f%<0 Then Exit For
    If Maze$(PlrX%-f%,PlrY%+1)="#" Then Draw_Element f%,0,0 Else Draw_Element f%,0,1
    If Maze$(PlrX%-f%,PlrY%-1)="#" Then Draw_Element f%,1,0 Else Draw_Element f%,1,1
    If Maze$(PlrX%-f%,PlrY%)="#" Then Draw_Element f%,1,2:Exit For
   Next f%
 End Select
End Sub

Sub Draw_Element nr%,mir%,Gap%
 Local x1%,y1%,x2%,y2%,x3%,y3%,x4%,y4%
 x1%=Wall%(nr%,0,0):y1%=Wall%(nr%,0,1)
 x2%=Wall%(nr%,1,0):y2%=Wall%(nr%,1,1)
 x3%=Wall%(nr%,2,0):y3%=Wall%(nr%,2,1)
 x4%=Wall%(nr%,3,0):y4%=Wall%(nr%,3,1)
 If mir% Then x1%=240-x1%:x2%=240-x2%:x3%=240-x3%:x4%=240-x4%
 WallC1%=RGB(0,64,0):WallC2%=RGB(0,128,0)
 If Not Gap% Then
  Triangle x1%,y1%,x2%,y2%,x4%,y4%,WallC1%,WallC1%
  Triangle x1%,y1%,x3%,y3%,x4%,y4%,WallC1%,WallC1%
 ElseIf Gap%=1 Then
  Triangle x1%,y3%,x3%,y3%,x4%,y4%,WallC2%,WallC2%
  Triangle x1%,y4%,x1%,y3%,x4%,y4%,WallC2%,WallC2%
 Else
  Triangle x1%,y1%,240-x1%,y1%,240-x1%,y2%,WallC2%,WallC2%
  Triangle x1%,y1%,240-x1%,y2%,x1%,y2%,WallC2%,WallC2%
 EndIf
End Sub

Sub show_maze()
 For y% = 0 To MazeH%
  For x% = 0 To MazeW%
   If Maze$(x%,y%)="#" Then Box 243+x%*3,MAP_Y%+y%*3,3,3,,0,0
  Next
 Next
End Sub

Sub generator
 Local done%,i%,CurX%,CurY%,OldX%,OldY%,x%,y%
 CurX%=Int(Rnd * (MazeW% - 1))
 CurY%=Int(Rnd * (MazeH% - 1))
 If CurX% Mod 2=0 Then Inc CurX%
 If CurY% Mod 2=0 Then Inc CurY%
 Maze$(CurX%, CurY%) = " "
 done%=0
 Do While done%=0
  For i% = 0 To 99
   OldX%=CurX%
   OldY%=CurY%
   Select Case Int(Rnd*4)
    Case 0
     If CurX%+2<MazeW% Then Inc CurX%,2
    Case 1
     If CurY%+2<MazeH% Then Inc CurY%,2
    Case 2
     If CurX%-2>0 Then Inc CurX%,-2
    Case 3
     If CurY%-2>0 Then Inc CurY%,-2
   End Select
   If Maze$(CurX%,CurY%)="#" Then
    Maze$(CurX%,CurY%)=" "
    Maze$(Int((CurX%+OldX%)/2),((CurY%+OldY%)/2))=" "
   EndIf
  Next i%
  done%=1
  For x%=1 To MazeW%-1 Step 2
   For y%=1 To MazeH%-1 Step 2
    If Maze$(x%,y%)="#" Then done%=0
   Next y%
  Next x%
 Loop
End Sub

Sub break_cb()
 end_program(1)
End Sub

Sub end_program(break%)
 gamemite.end(break%)
End Sub

Function show_title$()
 Const txt$ = "Press START to play"
 Const X_OFFSET% = MM.HRes \ 2
 Const Y_OFFSET% = MM.VRes \ 2
 Cls
 Text X_OFFSET%, Y_OFFSET% - 27, "3D MAZE", "CM", 1, 2, RGB(White)
 Text X_OFFSET%, Y_OFFSET% - 2, VERSION_STRING$, "CM", 7, 1, Rgb(Green)
 Text X_OFFSET%, Y_OFFSET% + 10, "(c) 2022-2023 Martin Herhaus", "CM", 7, 1, RGB(Green)
 Text X_OFFSET%, Y_OFFSET% + 30, txt$, "CM", 1, 1, RGB(White)
 FrameBuffer Copy F , N
 Local key%
 Do
  ctrl$ = ctrl.poll_multiple$(CONTROLLERS$(), ctrl.A Or ctrl.START Or ctrl.SELECT, 100, key%)
  If key% And ctrl.SELECT Then
   Call ctrl$, ctrl.OPEN
   on_quit()
   Call ctrl$, ctrl.CLOSE
   key% = 0
  EndIf
 Loop While Not key%
 Call ctrl$, ctrl.OPEN
 msgbox.beep(1)
 show_title$ = ctrl$
End Function

Sub keys_wasd(x%)
 If x% < 0 Then Exit Sub
 x% =    ctrl.keydown%(32) * ctrl.A
 Inc x%, (ctrl.keydown%(Asc("w")) Or ctrl.keydown%(128)) * ctrl.UP
 Inc x%, (ctrl.keydown%(Asc("s")) Or ctrl.keydown%(129)) * ctrl.DOWN
 Inc x%, (ctrl.keydown%(Asc("a")) Or ctrl.keydown%(130)) * ctrl.LEFT
 Inc x%, (ctrl.keydown%(Asc("d")) Or ctrl.keydown%(131)) * ctrl.RIGHT
 Inc x%, ctrl.keydown%(Asc("m")) * ctrl.B
 Inc x%, ctrl.keydown%(Asc("q")) * ctrl.SELECT
End Sub

Sub win_game()
 Text 64, 70, Chr$(&h97) + " WELL DONE! " + Chr$(&h97)
 Text 120, 105, "Press " + Choice(ctrl$ = "keys_wasd", "'Q'", "SELECT") , CM
 Text 120, 120, "to quit,", CM
 Text 120, 135, "or " + Choice(ctrl$ = "keys_wasd", "SPACE", "START") + " to try", CM
 Text 120, 150, "another maze", CM
 FrameBuffer Copy F , N
 Local key% = 1
 Do While key% : Pause 5 : Call ctrl$, key% : Loop
 Do
  Call ctrl$, key%
  If key% = ctrl.SELECT Then end_program()
  If key% = ctrl.A Then key% = ctrl.START
 Loop Until key% = ctrl.START
End Sub

Data 0,0,0,239,10,10,10,229
Data 11,11,11,228,50,50,50,189
Data 51,51,51,188,80,80,80,159
Data 81,81,81,158,100,100,100,139
Data 101,101,101,138,110,110,110,129
Data 111,111,111,128,120,120,120,120
                                                           