' Transpiled on 07-01-2024 18:05:50
' Copyright (c) 2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Option Base 0
Option Default None
Option Explicit 1
' src/splib/system.inc ++++
' Copyright (c) 2020-2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
' Preprocessor value GAMEMITE defined
Const sys.VERSION = 200101 '102201
Const sys.NO_DATA$ = Chr$(&h7F)
Const sys.CRLF$ = Chr$(13) + Chr$(10)
Const sys.FIRMWARE = Int(1000000 * Mm.Info(Version))
Const sys.SUCCESS = 0
Const sys.FAILURE = -1
Dim sys.break_flag%
Dim sys.err$

Function sys.get_config$(key$, default$, file$)
 sys.get_config$ = default$
 If file$ = "" Then
  Const file_$ = Choice(Mm.Info(Exists File "A:/.spconfig"), "A:/.spconfig", "A:/.config")
 Else
  Const file_$ = file$
 EndIf
 If Not Mm.Info(Exists File file_$) Then Exit Function
 Local key_$ = LCase$(key$), s$, v$
 Open file_$ For Input As #1
 Do While Not Eof(#1)
  Line Input #1, s$
  If LCase$(Field$(Field$(s$, 1, "=", Chr$(34)),1, "#;", Chr$(34))) = key_$ Then
   v$ = Field$(Field$(s$, 2, "=", Chr$(34)), 1, "#;", Chr$(34))
   If Left$(v$, 1) = Chr$(34) Then v$ = Mid$(v$, 2)
   If Right$(v$, 1) = Chr$(34) Then v$ = Mid$(v$, 1, Len(v$) - 1)
   sys.get_config$ = v$
   Exit Do
  EndIf
 Loop
 Close #1
End Function

Function sys.format_version$(v%)
 Const v_% = Choice(v%, v%, sys.VERSION), a% = v_%\10^5, b% = (v_%-a%*10^5)\10^3
 Local c% = v_%-a%*10^5-b%*10^3, s$ = Str$(a%) + "." + Str$(b%)
 Select Case c%
  Case < 100 : Cat s$, " alpha "
  Case < 200 : Cat s$, " beta " : Inc c%, -100
  Case < 300 : Cat s$, " RC " : Inc c%, -200
  Case Else  : Cat s$, "." : Inc c%, -300
 End Select
 sys.format_version$ = s$ + Str$(c%)
End Function

' ---- src/splib/system.inc
main()
End

Sub main()
 Const version% = get_version%()
 Const drive$ = Mm.Info(Drive)
 Const dst_dir$ = "A:/GameMite"
 ?
 ? "Installing Game*Mite " sys.format_version$(version%) " to A:/"
 ?
 If Not Mm.Info(Exists Dir dst_dir$) Then
  If drive$ <> "A:" Then Drive "A:"
  MkDir dst_dir$
  Drive drive$
 EndIf
 Local dst$, src$, dst2$
 src$ = Dir$(Mm.Info(Path) + "*", File)
 'copy all the files from B: to A:/GameMite except install-a.bas and startup.bas
 'copy menu.bas in A:/ and A:/GameMite for backward compatibility
 Do While Len(src$)
  If src$ = "install-a.bas" Then src$ = Dir$() : Continue Do
  If src$ = "startup.bas" Then src$ = Dir$() : Continue Do
  dst$ = dst_dir$ + "/" + src$
  dst2$ = "A:/" + src$
  src$ = Mm.Info(Path) + src$
  ? "Copying " src$ " => " dst$
  Copy src$ To dst$
  if dst2$ = "A:/menu.bas" then copy src$ to dst2$
  src$ = Dir$()
 Loop
 ?
 ? "To configure autorun of Game*Mite type:"
 ?
 ? "  FLASH ERASE 1 ' fails harmlessly if flash slot 1 is empty"
 ? "  LOAD " + Chr$(34) + "/startup.bas" + Chr$(34)
 ? "  FLASH SAVE 1"
 ? "  OPTION AUTORUN 1,NORESET"
' ? "  OPTION PLATFORM " + Chr$(34) + "Game*Mite" + Chr$(34)
 ?
End Sub

Function get_version%()
 get_version% = Val(sys.get_config$("version", "1", Mm.Info(Path) + ".startup"))
End Function
