' Transpiled on 07-01-2024 18:07:52
Option Base 0
Option Default None
Option Explicit
Const VERSION = 101301
' ../../mmbasic-kingdom/src/splib/system.inc ++++
' Copyright (c) 2020-2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
' Preprocessor value GAMEMITE defined
Const sys.VERSION = 102201
Const sys.NO_DATA$ = Chr$(&h7F)
Const sys.CRLF$ = Chr$(13) + Chr$(10)
Const sys.FIRMWARE = Int(1000000 * Mm.Info(Version))
Const sys.SUCCESS = 0
Const sys.FAILURE = -1
Dim sys.break_flag%
Dim sys.err$

Function sys.format_version$(v%)
 Const v_% = Choice(v%, v%, sys.VERSION), a% = v_%\10^5, b% = (v_%-a%*10^5)\10^3
 Local c% = v_%-a%*10^5-b%*10^3, s$ = Str$(a%) + "." + Str$(b%)
 Select Case c%
  Case < 100 : Cat s$, " alpha "
  Case < 200 : Cat s$, " beta " : Inc c%, -100
  Case < 300 : Cat s$, " RC " : Inc c%, -200
  Case Else  : Cat s$, "." : Inc c%, -300
 End Select
 sys.format_version$ = s$ + Str$(c%)
End Function

Sub sys.override_break(callback$)
 sys.break_flag% = 0
 Option Break 4
 If Len(callback$) Then
  Execute "On Key 3, " + callback$ + "()"
 Else
  On Key 3, sys.break_handler()
 EndIf
End Sub

Sub sys.break_handler()
 Inc sys.break_flag%
 If sys.break_flag% > 1 Then
  sys.restore_break()
  End
 EndIf
End Sub

Sub sys.restore_break()
 sys.break_flag% = 0
 On Key 3, 0
 Option Break 3
End Sub

' ---- ../../mmbasic-kingdom/src/splib/system.inc
' ../../mmbasic-kingdom/src/splib/string.inc ++++
' Copyright (c) 2020-2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Function str.centre$(s$, x%)
 If Len(s$) < x% Then
  str.centre$ = s$ + Space$((x% - Len(s$)) \ 2)
  str.centre$ = Space$(x% - Len(str.centre$)) + str.centre$
 Else
  str.centre$ = s$
 EndIf
End Function

Function str.decode$(s$)
 Local ad%, ch%, prev%, state%, t$
 For ad% = Peek(VarAddr s$) + 1 TO Peek(VarAddr s$) + Len(s$)
  ch% = Peek(Byte ad%)
  Select Case ch%
   Case &h5C
    state% = 1
   Case Else
    Select Case state%
     Case 0
      Cat t$, Chr$(ch%)
     Case 1
      Select Case ch%
       Case &h22 : ch% = &h22
       Case &h27 : ch% = &h27
       Case &h30 : ch% = &h00
       Case &h3F : ch% = &h3F
       Case &h5C : ch% = &h5C
       Case &h61 : ch% = &h07
       Case &h62 : ch% = &h08
       Case &h65 : ch% = &h1B
       Case &h66 : ch% = &h0C
       Case &h6E : ch% = &h0A
       Case &h71 : ch% = &h22
       Case &h72 : ch% = &h0D
       Case &h74 : ch% = &h09
       Case &h76 : ch% = &h0B
       Case &h78 : state% = 2
       Case Else : Cat t$, "\"
      End Select
      If state% = 1 Then
       Cat t$, Chr$(ch%)
       state% = 0
      EndIf
     Case 2
      Select Case ch%
       Case &h30 To &h39, &h41 To &h46, &h61 To &h66
        prev% = ch%
        state% = 3
       Case Else
        Cat t$, "\x" + Chr$(ch%)
        state% = 0
      End Select
     Case 3
      Select Case ch%
       Case &h30 To &h39, &h41 To &h46, &h61 To &h66
        Cat t$, Chr$(Val("&h" + Chr$(prev%) + Chr$(ch%)))
       Case Else
        Cat t$, "\x" + Chr$(prev%) + Chr$(ch%)
      End Select
      state% = 0
    End Select
  End Select
 Next
 Select Case state%
  Case 1 : Cat t$, "\"
  Case 2 : Cat t$, "\x"
  Case 3 : Cat t$, "\x" + Chr$(prev%)
 End Select
 str.decode$ = t$
End Function

' ---- ../../mmbasic-kingdom/src/splib/string.inc
' ../../mmbasic-kingdom/src/splib/txtwm.inc ++++
' Copyright (c) 2021-2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
If Mm.Info(Option Base) <> 0 Then Error "expects OPTION BASE 0"
Const twm.BLACK%   = 0
Const twm.RED%     = 1
Const twm.GREEN%   = 2
Const twm.YELLOW%  = 3
Const twm.BLUE%    = 4
Const twm.MAGENTA% = 5
Const twm.CYAN%    = 6
Const twm.WHITE%   = 7
Dim twm.max_num%
Dim twm.num%
Dim twm.fw%
Dim twm.fh%
Dim twm.last_at%
Dim twm.cursor_enabled%
Dim twm.cursor_locked%
Dim twm.id%
Dim twm.a%
Dim twm.b%
Dim twm.w%
Dim twm.h%
Dim twm.x%
Dim twm.y%
Dim twm.at%
Dim twm.pc%
Dim twm.pa%

Sub twm.init(max_num%, mem_sz%)
 If twm.max_num% > 0 Then Error "'txtwm' already initialised"
 If max_num% < 1 Or max_num% > 10 Then Error "Invalid 'max_num'; must be between 1 and 10: " + Str$(max_num%)
 If mem_sz% < 100 Then Error "Invalid 'mem_sz'; must be >= 100: " + Str$(mem_sz%)
 twm.max_num% = max_num%
 twm.id%      = -1
 twm.last_at% = -1
 twm.fw%      = Mm.Info(FontWidth)
 twm.fh%      = Mm.Info(FontHeight)
 Dim twm.data%((mem_sz% \ 8) + 1)
 Dim twm.ptr%(Choice(max_num% = 1, 1, max_num% - 1))
 twm.init_serial_attrs()
 twm.init_screen_attrs()
 twm.init_box_chars()
 twm.enable_cursor(0)
End Sub

Sub twm.init_serial_attrs()
 Local i%, vt$
 Dim twm.vt$(255) Length 20
 For i% = 0 To 255
  vt$ = Chr$(27) + "[0m"
  Cat vt$, Chr$(27) + "[" + Choice(i% And &b01000000, "1;3", "3") + Str$(i% And &b00000111) + "m"
  Cat vt$, Chr$(27) + "[4" + Str$((i% And &b00111000) >> 3) + "m"
  If i% And &b10000000 Then Cat vt$, Chr$(27) + "[7m"
  twm.vt$(i%) = vt$
 Next
End Sub

Sub twm.init_screen_attrs()
 Local bg%, fg%, i%
 Dim twm.fg%(255)
 Dim twm.bg%(255)
 For i% = 0 To 255
  Select Case i% And &b00000111
   Case twm.BLACK%   : fg% = RGB(Black)
   Case twm.RED%     : fg% = RGB(Red)
   Case twm.GREEN%   : fg% = RGB(Green)
   Case twm.YELLOW%  : fg% = RGB(Yellow)
   Case twm.BLUE%    : fg% = RGB(Blue)
   Case twm.MAGENTA% : fg% = RGB(Magenta)
   Case twm.CYAN%    : fg% = RGB(Cyan)
   Case twm.WHITE%   : fg% = RGB(White)
   Case Else Error
  End Select
  If i% And &b01000000 Then
   If fg% <> 0 Then fg% = fg% Or &h404040
  EndIf
  Select Case (i% And &b00111000) >> 3
   Case twm.BLACK%   : bg% = RGB(Black)
   Case twm.RED%     : bg% = RGB(Red)
   Case twm.GREEN%   : bg% = RGB(Green)
   Case twm.YELLOW%  : bg% = RGB(Yellow)
   Case twm.BLUE%    : bg% = RGB(Blue)
   Case twm.MAGENTA% : bg% = RGB(Magenta)
   Case twm.CYAN%    : bg% = RGB(Cyan)
   Case twm.WHITE%   : bg% = RGB(White)
   Case Else Error
  End Select
  If i% And &b10000000 Then
   twm.bg%(i%) = fg%
   twm.fg%(i%) = bg%
  Else
   twm.bg%(i%) = bg%
   twm.fg%(i%) = fg%
  EndIf
 Next
End Sub

Sub twm.init_box_chars()
 Dim twm.c2b%(255)
 twm.c2b%(&hB9) = &b1101
 twm.c2b%(&hBA) = &b0101
 twm.c2b%(&hBB) = &b1100
 twm.c2b%(&hBC) = &b1001
 twm.c2b%(&hC8) = &b0011
 twm.c2b%(&hC9) = &b0110
 twm.c2b%(&hCA) = &b1011
 twm.c2b%(&hCB) = &b1110
 twm.c2b%(&hCC) = &b0111
 twm.c2b%(&hCD) = &b1010
 twm.c2b%(&hCE) = &b1111
 Dim twm.b2c%(15)
 twm.b2c%(&b1101) = &hB9
 twm.b2c%(&b0101) = &hBA
 twm.b2c%(&b1100) = &hBB
 twm.b2c%(&b1001) = &hBC
 twm.b2c%(&b0011) = &hC8
 twm.b2c%(&b0110) = &hC9
 twm.b2c%(&b1011) = &hCA
 twm.b2c%(&b1110) = &hCB
 twm.b2c%(&b0111) = &hCC
 twm.b2c%(&b1010) = &hCD
 twm.b2c%(&b1111) = &hCE
End Sub

Function twm.new_win%(x%, y%, w%, h%)
 If twm.num% > Bound(twm.ptr%(), 1) Then Error "maximum number of windows reached: " + Str$(twm.num%)
 Local ptr%
 If twm.num% = 0 Then
  ptr% = Peek(VarAddr twm.data%())
 Else
  ptr% = twm.ptr%(twm.num% - 1)
  Inc ptr%, 7 + Peek(Byte ptr% + 2) * Peek(Byte ptr% + 3) * 2
 EndIf
 twm.ptr%(twm.num%) = ptr%
 Const reqd% = ptr% + 7 + w% * h% * 2 - twm.ptr%(0)
 Const alloc% = (Bound(twm.data%(), 1) - Bound(twm.data%(), 0)) * 8
 If reqd% > alloc% Then
  Error "out of txtwm memory: " + Str$(alloc%) + " bytes allocated, " + Str$(reqd%) + " required"
 EndIf
 Poke Byte ptr% + 0, x% + 1
 Poke Byte ptr% + 1, y% + 1
 Poke Byte ptr% + 2, w%
 Poke Byte ptr% + 3, h%
 Poke Byte ptr% + 4, 0
 Poke Byte ptr% + 5, 0
 Poke Byte ptr% + 6, twm.WHITE%
 Memory Set ptr% + 7, 32, w% * h%
 Memory Set ptr% + 7 + w% * h%, twm.WHITE%, w% * h%
 twm.new_win% = twm.num%
 Inc twm.num%
End Function

Sub twm.switch(id%)
 twm.last_at% = -1
 If twm.id% = id% Then Exit Sub
 twm.lock_vga_cursor(1)
 Local ptr%
 If twm.id% > -1 Then
  ptr% = twm.ptr%(twm.id%)
  Poke Byte ptr% + 4, twm.x%
  Poke Byte ptr% + 5, twm.y%
  Poke Byte ptr% + 6, twm.at%
 EndIf
 twm.id% = id%
 ptr%    = twm.ptr%(twm.id%)
 twm.a%  = Peek(Byte ptr% + 0)
 twm.b%  = Peek(Byte ptr% + 1)
 twm.w%  = Peek(Byte ptr% + 2)
 twm.h%  = Peek(Byte ptr% + 3)
 twm.x%  = Peek(Byte ptr% + 4)
 twm.y%  = Peek(Byte ptr% + 5)
 twm.at% = Peek(Byte ptr% + 6)
 twm.pc% = ptr% + 7
 twm.pa% = twm.pc% + twm.w% * twm.h%
 twm.lock_vga_cursor(0)
End Sub

Sub twm.foreground(col%)
 twm.at% = (twm.at% And &b11111000) Or col%
End Sub

Sub twm.bold(z%)
 twm.at% = (twm.at% And &b10111111) Or (z% << 6)
End Sub

Sub twm.inverse(z%)
 twm.at% = (twm.at% And &b01111111) Or (z% << 7)
End Sub

Sub twm.print_at(x%, y%, s$)
 twm.lock_vga_cursor(1)
 twm.x% = x%
 twm.y% = y%
 twm.print(s$)
 twm.lock_vga_cursor(0)
End Sub

Sub twm.putc(ch%)
 Local at% = twm.at%
 Local s$ = Chr$(ch%)
 Local of% = twm.y% * twm.w% + twm.x%
 Local ax% = twm.a% + twm.x%
 Local by% = twm.b% + twm.y%
 Poke Byte twm.pc% + of%, ch%
 Poke Byte twm.pa% + of%, at%
 If twm.last_at% <> at% Then Print vt$; : twm.last_at% = at%
 Print Chr$(27) "[" Str$(by%) ";" Str$(ax%) "H" s$;
 Text (ax%-1)*twm.fw%,(by%-1)*twm.fh%,s$,,,,twm.fg%(at%),twm.bg%(at%)
 If at% And &b01000000 Then Text (ax%-1)*twm.fw%+1,(by%-1)*twm.fh%,s$,,,,twm.fg%(at%),-1
End Sub

Sub twm.print(s$)
 Local is% = 1
 Local ls% = Len(s$)
 Local ps% = Peek(VarAddr s$)
 Local nc% = Min(twm.w% - twm.x%, ls%)
 Local of%
 Local at% = twm.at%
 Local fg% = twm.fg%(at%)
 Local bg% = twm.bg%(at%)
 Local ax%
 Local by%
 Local seg$
 Local vt$ = twm.vt$(at%)
 If nc% = 0 Then Exit Sub
 If twm.last_at% <> at% Then Print vt$; : twm.last_at% = at%
 twm.lock_vga_cursor(1)
 Do
  If twm.y% = twm.h% Then
   twm.scroll_up(1)
   Inc twm.y%, -1
   If twm.last_at% <> at% Then Print vt$ : twm.last_at% = at%
  EndIf
  of% = twm.y% * twm.w% + twm.x%
  Memory Copy ps% + is%, twm.pc% + of%, nc%
  Memory Set twm.pa% + of%, at%, nc%
  seg$ = Mid$(s$, is%, nc%)
  ax% = twm.a% + twm.x%
  by% = twm.b% + twm.y%
  Print Chr$(27) "[" Str$(by%) ";" Str$(ax%) "H" seg$;
  Text (ax% - 1) * twm.fw%, (by% - 1) * twm.fh%, seg$,,,, fg%, bg%
  If at% And &b01000000 Then Text (ax% - 1) * twm.fw% + 1, (by% - 1) * twm.fh%, seg$,,,, fg%, -1
  Inc is%, nc%
  Inc twm.x%, nc%
  If twm.x% = twm.w% Then
   twm.x% = 0
   Inc twm.y%
   nc% = Min(twm.w% - twm.x%, ls% - is% + 1)
  EndIf
 Loop While is% <= ls%
 twm.lock_vga_cursor(0)
End Sub

Sub twm.scroll_up(redraw%)
 twm.lock_vga_cursor(1)
 Local pa% = twm.pa%
 Local pc% = twm.pc%
 Local y%
 For y% = 1 To twm.h% - 1
  Memory Copy pa% + twm.w%, pa%, twm.w%
  Memory Copy pc% + twm.w%, pc%, twm.w%
  Inc pa%, twm.w%
  Inc pc%, twm.w%
 Next
 Memory Set pa%, twm.at%, twm.w%
 Memory Set pc%, 32, twm.w%
 If redraw% Then twm.redraw()
 twm.lock_vga_cursor(0)
End Sub

Sub twm.redraw()
 Local at%, ch$, x%, y%
 Local pa% = twm.pa%
 Local pc% = twm.pc%
 Local vx%, vy%
 vy% = (twm.b% - 1) * twm.fh%
 For y% = 0 To twm.h% - 1
  Print Chr$(27) "[" Str$(twm.b% + y%) ";" Str$(twm.a%) "H";
  vx% = (twm.a% - 1) * twm.fw%
  For x% = 0 To twm.w% - 1
   at% = Peek(Byte pa% + x%)
   ch$ = Chr$(Peek(Byte pc% + x%))
   If twm.last_at% <> at% Then Print twm.vt$(at%); : twm.last_at% = at%
   Print ch$;
   Text vx%, vy%, ch$,,,, twm.fg%(at%), twm.bg%(at%)
   If at% And &b01000000 Then Text vx%+1, vy%, ch$,,,, twm.fg%(at%), -1
   Inc vx%, twm.fw%
  Next
  Inc pa%, twm.w%
  Inc pc%, twm.w%
  Inc vy%, twm.fh%
 Next
End Sub

Sub twm.cls(x%, y%, w%, h%)
 twm.lock_vga_cursor(1)
 Local s$ = Space$(Choice(w%, w%, twm.w%)), yy%
 For yy% = y% To y% + Choice(h%, h%, twm.h%) - 1
  twm.x% = x% : twm.y% = yy%
  twm.print(s$)
 Next
 twm.lock_vga_cursor(0)
End Sub

Sub twm.box(x%, y%, w%, h%)
 Local ad%, i%, pc% = twm.pc%, s$
 twm.lock_vga_cursor(1)
 Poke Var s$, 0, w%
 ad% = pc% + twm.w% * y% + x%
 Poke Var s$, 1, twm.box_or%(&hC9, Peek(Byte ad%))
 For i% = 2 To w% - 1
  Poke Var s$, i%, twm.box_or%(&hCD, Peek(Byte ad% + i% - 1))
 Next
 Poke Var s$, w%, twm.box_or%(&hBB, Peek(Byte ad% + w% - 1))
 twm.print_at(x%, y%, s$)
 For twm.y% = y% + 1 To y% + h% - 2
  Inc ad%, twm.w%
  twm.x% = x%
  twm.putc(twm.box_or%(&hBA, Peek(Byte ad%)))
  twm.x% = x% +  w% - 1
  twm.putc(twm.box_or%(&hBA, Peek(Byte ad% + w% - 1)))
 Next
 Inc ad%, twm.w%
 Poke Var s$, 1, twm.box_or%(&hC8, Peek(Byte ad%))
 For i% = 2 To w% - 1
  Poke Var s$, i%, twm.box_or%(&hCD, Peek(Byte ad% + i% - 1))
 Next
 Poke Var s$, w%, twm.box_or%(&hBC, Peek(Byte ad% + w% - 1))
 twm.print_at(x%, y% + h% - 1, s$)
 twm.lock_vga_cursor(0)
End Sub

Function twm.box_or%(ch%, ex%)
 Local tmp% = twm.c2b%(ch%)
 twm.box_or% = Choice(tmp% = 0, ch%, twm.b2c%(tmp% Or twm.c2b%(ex%)))
End Function

Sub twm.enable_cursor(z%)
 Print Chr$(27) Choice(z%, "[?25h", "[?25l");
 If z% = twm.cursor_enabled% Then Exit Sub
 twm.cursor_enabled% = z%
 If z% Then
  SetTick 500, twm.update_vga_cursor, 4
 Else
  SetTick 0, twm.update_vga_cursor, 4
 EndIf
End Sub

Sub twm.update_vga_cursor()
 Static lit% = 0
 If twm.cursor_locked% Then Exit Sub
 If twm.x% >= twm.w% Or twm.y% >= twm.h% Then Exit Sub
 lit% = Not lit%
 Local of% = twm.y% * twm.w% + twm.x%
 Local ax% = twm.a% + twm.x%
 Local by% = twm.b% + twm.y%
 Local fg% = Choice(lit%, RGB(Black), RGB(White))
 Text (ax%-1)*twm.fw%,(by%-1)*twm.fh%,"_",,,,fg%,-1
 Text (ax%-1)*twm.fw%,(by%-1)*twm.fh% + 1,"_",,,,fg%,-1
End Sub

Sub twm.lock_vga_cursor(lock%)
 Inc twm.cursor_locked%, Choice(lock%, 1, -1))
 If twm.id% = -1 Then Exit Sub
 If twm.cursor_locked% < 0 Then Error "Unbalanced cursor lock/unlock."
 If Not lock% Then Exit Sub
 If twm.cursor_locked% > 1 Then Exit Sub
 If twm.x% >= twm.w% Or twm.y% >= twm.h% Then Exit Sub
 Local ax% = twm.a% + twm.x%
 Local by% = twm.b% + twm.y%
 Local of% = twm.y% * twm.w% + twm.x%
 Local ch% = Peek(Byte twm.pc% + of%)
 Local at% = Peek(Byte twm.pa% + of%)
 Local fg% = twm.fg%(at%)
 Text (ax%-1)*twm.fw%,(by%-1)*twm.fh%,Chr$(ch%),,,,fg%,twm.bg%(at%)
 If at% And &b01000000 Then Text (ax%-1)*twm.fw%+1,(by%-1)*twm.fh%,Chr$(ch%),,,,fg%,-1
End Sub

' ---- ../../mmbasic-kingdom/src/splib/txtwm.inc
' ../../mmbasic-kingdom/src/splib/ctrl.inc ++++
' Copyright (c) 2022-2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Const ctrl.R      = &h01
Const ctrl.START  = &h02
Const ctrl.HOME   = &h04
Const ctrl.SELECT = &h08
Const ctrl.L      = &h10
Const ctrl.DOWN   = &h20
Const ctrl.RIGHT  = &h40
Const ctrl.UP     = &h80
Const ctrl.LEFT   = &h100
Const ctrl.ZR     = &h200
Const ctrl.X      = &h400
Const ctrl.A      = &h800
Const ctrl.Y      = &h1000
Const ctrl.B      = &h2000
Const ctrl.ZL     = &h4000
Const ctrl.OPEN  = -1
Const ctrl.CLOSE = -2
Const ctrl.SOFT_CLOSE = -3
Const ctrl.PULSE = 0.001
Const ctrl.UI_DELAY = 200
Dim ctrl.open_drivers$
Dim ctrl.key_type%
Dim ctrl.key_map%(31 + Mm.Info(Option Base))

Sub ctrl.init_keys(use_inkey%, period%, nbr%)
 ctrl.term_keys()
 ctrl.key_type% = 0
 On Key ctrl.on_key()
End Sub

Sub ctrl.on_key()
 Poke Var ctrl.key_map%(), Asc(LCase$(Inkey$)), 1
End Sub

Sub ctrl.term()
 ctrl.term_keys()
 On Error Ignore
 Do While Len(ctrl.open_drivers$)
  Call Field$(ctrl.open_drivers$, 1), ctrl.CLOSE
 Loop
 On Error Abort
End Sub

Sub ctrl.term_keys()
 On Key 0
 Memory Set Peek(VarAddr ctrl.key_map%()), 0, 256
 Do While Inkey$ <> "" : Loop
End Sub

Function ctrl.keydown%(i%)
 ctrl.keydown% = Peek(Var ctrl.key_map%(), i%)
 If ctrl.key_type% = 0 Then Poke Var ctrl.key_map%(), i%, 0
End Function

Sub keys_cursor_ext(x%)
 If x% < 0 Then Exit Sub
 x% =    ctrl.keydown%(32)  * ctrl.A
 Inc x%, ctrl.keydown%(98)  * ctrl.B
 Inc x%, (ctrl.keydown%(101) Or ctrl.keydown%(113)) * ctrl.SELECT
 Inc x%, ctrl.keydown%(115) * ctrl.START
 Inc x%, ctrl.keydown%(128) * ctrl.UP
 Inc x%, ctrl.keydown%(129) * ctrl.DOWN
 Inc x%, ctrl.keydown%(130) * ctrl.LEFT
 Inc x%, ctrl.keydown%(131) * ctrl.RIGHT
End Sub

Sub ctrl.open_driver(d$)
 Cat ctrl.open_drivers$, d$ + ","
End Sub

Sub ctrl.close_driver(d$)
 Local idx% = InStr(ctrl.open_drivers$, d$)
 Select Case idx%
  Case 0
  Case 1
   ctrl.open_drivers$ = Mid$(ctrl.open_drivers$, Len(d$) + 2)
  Case Else
   ctrl.open_drivers$ = Mid$(ctrl.open_drivers$, 1, idx% - 1) + Mid$(ctrl.open_drivers$, idx% + Len(d$) + 1)
 End Select
End Sub

Sub ctrl.gamemite(x%)
 Select Case x%
  Case >= 0
   x% = Port(GP12,2,GP11,2,GP8,1,GP8,1,GP11,1,GP10,1,GP9,1,GP13,3,GP13,3)
   x% = (x% Xor &h7FFF) And &h29EA
   Exit Sub
  Case ctrl.OPEN
   Local i%
   For i% = 8 To 15 : SetPin Mm.Info(PinNo "GP" + Str$(i%)), Din, PullUp : Next
   ctrl.open_driver("ctrl.gamemite")
  Case ctrl.CLOSE, ctrl.SOFT_CLOSE
   Local i%
   For i% = 8 To 15 : SetPin Mm.Info(PinNo "GP" + Str$(i%)), Off : Next
   ctrl.close_driver("ctrl.gamemite")
 End Select
End Sub

' ---- ../../mmbasic-kingdom/src/splib/ctrl.inc
' ../../mmbasic-kingdom/src/splib/sound.inc ++++
' Copyright (c) 2022-2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Const sound.FX_FLAG% = &b01
Const sound.MUSIC_FLAG% = &b10
Dim sound.F!(127)
Dim sound.FX_BLART%(2)
Dim sound.FX_SELECT%(2)
Dim sound.FX_DIE%(4)
Dim sound.FX_WIPE%(4)
Dim sound.FX_READY_STEADY_GO%(13)
Dim sound.enabled%
Dim sound.fx_int$
Dim sound.fx_ptr%
Dim sound.fx_start_ptr%
Dim sound.music_done_cb$
Dim sound.music_int$
Dim sound.music_ptr%
Dim sound.music_start_ptr%
Dim sound.music_tick% = 200
Dim sound.music_volume% = 15

Sub sound.init(fx_int$, music_int$)
 sound.fx_int$ = Choice(Len(fx_int$), fx_int$, "sound.fx_default_int")
 sound.music_int$ = Choice(Len(music_int$), music_int$, "sound.music_default_int")
 Const offset% = Choice("Game*Mite" = "Game*Mite", 12, 0)
 Local i%
 For i% = 0 To 127
  sound.F!(i%) = Max(440 * 2^((i% - 58 + offset%) / 12.0), 16.35)
 Next
 sound.load_data("sound.blart_data", sound.FX_BLART%())
 sound.load_data("sound.select_data", sound.FX_SELECT%())
 sound.load_data("sound.die_data", sound.FX_DIE%())
 sound.load_data("sound.wipe_data", sound.FX_WIPE%())
 sound.load_data("sound.ready_steady_go_data", sound.FX_READY_STEADY_GO%())
 sound.enable(sound.FX_FLAG% Or sound.MUSIC_FLAG%)
End Sub

Sub sound.enable(flags%)
 Local raw%
 If flags% And sound.MUSIC_FLAG% Then
  If Not (sound.enabled% And sound.MUSIC_FLAG%) Then
   Execute "SetTick " + Str$(sound.music_tick%) + ", " + sound.music_int$ + ", 1"
   sound.enabled% = sound.enabled% Or sound.MUSIC_FLAG%
  EndIf
 Else
  If sound.enabled% And sound.MUSIC_FLAG% Then
   sound.enabled% = sound.enabled% Xor sound.MUSIC_FLAG%
   SetTick 0, 0, 1
   If raw% Then
    Pwm 2, sound.F!(0), 0
   Else
    Play Sound 1, B, O
    Play Sound 2, B, O
    Play Sound 3, B, O
   EndIf
   sound.music_ptr% = 0
  EndIf
 EndIf
 If flags% And sound.FX_FLAG% Then
  If Not (sound.enabled% And sound.FX_FLAG%) Then
   Execute "SetTick 40, " + sound.fx_int$ + ", 2"
   sound.enabled% = sound.enabled% Or sound.FX_FLAG%
  EndIf
 Else
  If sound.enabled% And sound.FX_FLAG% Then
   sound.enabled% = sound.enabled% Xor sound.FX_FLAG%
   SetTick 0, 0, 2
   If raw% Then
    Pwm 3, sound.F!(0), 0
   Else
    Play Sound 4, B, O
   EndIf
   sound.fx_ptr% = 0
  EndIf
 EndIf
End Sub

Function sound.is_playing%(flags%)
 Select Case flags%
  Case 0
   sound.is_playing% = (sound.music_ptr% > 0) Or (sound.fx_ptr% > 0)
  Case sound.FX_FLAG%
   sound.is_playing% = sound.fx_ptr% > 0
  Case sound.MUSIC_FLAG%
   sound.is_playing% = sound.music_ptr% > 0
 End Select
End Function

Sub sound.term()
 sound.enable(&h00)
 Play Stop
End Sub

Function sound.data_size%(data_label$)
 Local num_bytes%
 Read Save
 Restore data_label$
 Read num_bytes%
 Read Restore
 sound.data_size% = num_bytes% \ 8
 If sound.data_size% Mod 8 Then Inc sound.data_size%
 If Mm.Info(Option Base) Then Inc sound.data_size%
End Function

Sub sound.load_data(data_label$, notes%())
 Local i%, num_notes%, num_channels%
 Read Save
 Restore data_label$
 Read num_notes%, num_channels%
 Const max_notes% = 8 * (Bound(notes%(), 1) - Bound(notes%(), 0))
 If num_notes% > max_notes% Then
  Local err$ = "Too much DATA; "
  Error err$ + "expected " + Str$(max_notes%) + " bytes but found " + Str$(num_notes%)
 EndIf
 notes%(0) = num_channels% + 256 * num_notes%
 For i% = 1 To num_notes% \ 8 : Read notes%(i%) : Next
 Read Restore
End Sub

Sub sound.play_music(music%(), done_cb$)
 If Not (sound.enabled% And sound.MUSIC_FLAG%) Then Exit Sub
 sound.music_start_ptr% = Peek(VarAddr music%())
 sound.music_ptr% = sound.music_start_ptr% + 8
 sound.music_done_cb$ = done_cb$
End Sub

Sub sound.music_default_int()
 If Not sound.music_ptr% Then Exit Sub
 Local n% = Peek(Byte sound.music_ptr%)
 If n% < 255 Then
  Play Sound 1, B, S, sound.F!(n%), (n% > 0) * sound.music_volume%
  n% = Peek(Byte sound.music_ptr% + 1)
  Play Sound 2, B, S, sound.F!(n%), (n% > 0) * sound.music_volume%
  n% = Peek(Byte sound.music_ptr% + 2)
  Play Sound 3, B, S, sound.F!(n%), (n% > 0) * sound.music_volume%
  Inc sound.music_ptr%, 3
  Exit Sub
 EndIf
 sound.music_ptr% = 0
 If Len(sound.music_done_cb$) Then Call sound.music_done_cb$
End Sub

Sub sound.play_fx(fx%(), block%)
 If Not (sound.enabled% And sound.FX_FLAG%) Then Exit Sub
 sound.fx_start_ptr% = Peek(VarAddr fx%())
 sound.fx_ptr% = sound.fx_start_ptr% + 8
 If block% Then Do While sound.fx_ptr% > 0 : Loop
End Sub

Sub sound.fx_default_int()
 If Not sound.fx_ptr% Then Exit Sub
 Local n% = Peek(Byte sound.fx_ptr%)
 If n% < 255 Then
  Play Sound 4, B, S, sound.F!(n%), (n% > 0) * 25
  Inc sound.fx_ptr%
 Else
  sound.fx_ptr% = 0
 EndIf
End Sub

sound.blart_data:
Data 16
Data 1
Data &hFFFFFF0036373C3D, &hFFFFFFFFFFFFFFFF
sound.select_data:
Data 16
Data 1
Data &hFFFFFFFF0048443C, &hFFFFFFFFFFFFFFFF
sound.die_data:
Data 32
Data 1
Data &h4748494A4B4C4D4E, &h3F40414243444546, &h0038393A3B3C3D3E, &hFFFFFFFFFFFFFFFF
sound.wipe_data:
Data 32
Data 1
Data &h3F3E3D3C3B3A3938, &h4746454443424140, &h004E4D4C4B4A4948, &hFFFFFFFFFFFFFFFF
sound.ready_steady_go_data:
Data 104
Data 1
Data &h3C3C3C3C3C3C3C3C, &h3C3C3C3C3C3C3C3C, &h0000000000000000, &h0000000000000000
Data &h3C3C3C3C3C3C3C3C, &h3C3C3C3C3C3C3C3C, &h0000000000000000, &h0000000000000000
Data &h4848484848484848, &h4848484848484848, &h4848484848484848, &h0000000048484848
Data &hFFFFFFFFFFFFFFFF
' ---- ../../mmbasic-kingdom/src/splib/sound.inc
' ../../mmbasic-kingdom/src/splib/gamemite.inc ++++
' Copyright (c) 2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Function gamemite.file$(f$)
 If InStr("A:/B:/", UCase$(Left$(f$, 3))) Then
  gamemite.file$ = f$
 Else
  Local f_$ = "A:/GameMite" + Choice(f$ = "", "", "/" + f$), x%
  x% = Mm.Info(Exists File f_$)
  If Not x% Then
   f_$ = "B" + Mid$(f_$, 2)
   On Error Skip
   x% = Mm.Info(Exists File f_$)
  EndIf
  If Not x% Then f_$ = "A" + Mid$(f_$, 2)
  gamemite.file$ = f_$
 EndIf
End Function

Sub gamemite.end(break%)
 FrameBuffer Write N
 Colour Rgb(White), Rgb(Black)
 Cls
 sys.restore_break()
 On Error Skip : sound.term()
 On Error Skip : ctrl.term()
 On Error Skip
 twm.enable_cursor(1)
 If break% Then
  Const f$ = "", msg$ = "Exited due to Ctrl-C"
 Else
  Const f$ = gamemite.file$("menu.bas")
  Const x% = Mm.Info(Exists File f$)
  Const msg$ = Choice(x%, "Loading menu ...", "Menu program not found!")
 EndIf
 Text 160, 110, msg$, CM
 If Len(f$) Then Run f$ Else End
End Sub

' ---- ../../mmbasic-kingdom/src/splib/gamemite.inc
sys.override_break("break_cb")
Const CTRL$ = "ctrl.gamemite"
Const THIEF$ = Chr$(&h98)
Const VERSION_STRING$ = "Game*Mite Version " + sys.format_version$(VERSION)
Randomize Timer
If CTRL$ = "keys_cursor_ext" Then
 Const START_MSG$ = "Press the SPACE BAR to play"
 Const CONTINUE_MSG$ = "Press the SPACE BAR to continue"
Else
 Const START_MSG$ = "Press START to play"
 Const CONTINUE_MSG$ = "Press A to continue"
EndIf
ctrl.init_keys()
Call CTRL$, ctrl.OPEN
Cls
twm.init(3, 4328)
Const HEIGHT = 20
Const WIDTH = 40
Const win1% = twm.new_win%(0, 0, WIDTH, HEIGHT)
Const win2% = twm.new_win%(3, 0, WIDTH - 4, HEIGHT)
Const win_menu% = twm.new_win%(7, 4, 26, 11)
Dim season_name$(3) = ("", "Winter", "Growing", "Harvest")
Dim vx%(3) = (0, 13, 21, 22)
If HEIGHT = 20 Then
 Dim vy%(3) = (0, HEIGHT - 16, HEIGHT - 12, HEIGHT - 6)
Else
 Dim vy%(3) = (0, HEIGHT - 17, HEIGHT - 13, HEIGHT - 7)
EndIf
Dim food%
Dim people%
Dim turn%
Dim season%
Dim year%
Dim workers%
Dim farmers%
Dim soldiers%
Dim planted!
Dim flooded%(3)
Dim flood_deaths%
Dim flood_losses%
Dim thief_deaths%
Dim thief_losses%
Dim starvation_deaths%
Dim num_flooded%
Dim was_attacked%
Dim was_flooded%
Dim use_keyboard% = (CTRL$ = "keys_cursor_ext")
Dim FX_ATTACK%(sound.data_size%("attack_fx_data"))
Dim FX_FLOOD%(sound.data_size%("flood_fx_data"))
Dim MUSIC_AUTUMN_FESTIVAL%(sound.data_size%("autumn_festival_music_data"))
Dim MUSIC_MO_LI_HUA%(sound.data_size%("mo_li_hua_music_data"))
Dim music_track%
sound.load_data("attack_fx_data", FX_ATTACK%())
sound.load_data("flood_fx_data", FX_FLOOD%())
sound.load_data("autumn_festival_music_data", MUSIC_AUTUMN_FESTIVAL%())
sound.load_data("mo_li_hua_music_data", MUSIC_MO_LI_HUA%())
sound.music_tick% = 150
sound.init()
music_track% = 0
music_done_cb()
procTITLEPAGE()
procINSTRUCTIONS()
Do
 procREINIT()
 procGAMELOOP()
 procMENU(1)
Loop
procEND()

Sub procTITLEPAGE()
 procMAP()
 Pause 1000
 Const y% = Choice(HEIGHT = 20, 7, 11)
 twm.foreground(twm.YELLOW%)
 twm.bold(1)
 twm.print_at(0, y%, Space$(twm.w%))
 twm.print_at(0, y% + 1, str.centre$("YELLOW RIVER", twm.w%))
 twm.print_at(0, y% + 2, str.centre$(" KINGDOM", twm.w%))
 twm.bold(0)
 twm.print_at(0, y% + 3, str.centre$(VERSION_STRING$, twm.w%))
 twm.print_at(0, y% + 4, Space$(twm.w%))
 If HEIGHT <> 20 Then twm.print_at(0, twm.h% - 2, Space$(twm.w%))
 twm.print_at(0, twm.h% - 1, str.centre$(START_MSG$, twm.w%))
 procKCL()
 Local key%
 Do
  Call CTRL$, key%
  Select Case key%
   Case 0
   Case ctrl.A, ctrl.START
    If key% = ctrl.START Then use_keyboard% = 0
    procOK()
    Exit Do
   Case Else
    procINVALID()
  End Select
 Loop
 twm.print_at(0, twm.h% - 1, Space$(twm.w%))
 procMENU(1)
End Sub

Sub procMENU(new_game%)
 Const old_win% = twm.id%
 twm.switch(win_menu%)
 twm.cls()
 twm.foreground(twm.YELLOW%)
 twm.box(0, 0, twm.w%, twm.h%)
 twm.bold(1)
 twm.print_at(1, 2, str.centre$("YELLOW RIVER KINGDOM", twm.w% - 2))
 twm.bold(0)
 Const x% = 5
 Local key%, sel% = 0, update% = 1
 Do
  If update% Then
   twm.inverse(sel% = 0)
   twm.print_at(x% + 3, 4, Choice(new_game%, " New Game ", " Continue "))
   twm.inverse(sel% = 1)
   twm.print_at(x% + 3, 5, "   Quit   ")
   twm.inverse(0) : twm.print_at(x%, 7, str.decode$("Music    \x95 "))
   twm.inverse(sel% = 2)
   twm.print(Choice(sound.enabled% And sound.MUSIC_FLAG%, "ON ", "OFF"))
   twm.inverse(0)
   twm.print(str.decode$(" \x94")))
   twm.inverse(0)
   twm.print_at(x%, 8, str.decode$("Sound FX \x95 "))
   twm.inverse(sel% = 3)
   twm.print(Choice(sound.enabled% And sound.FX_FLAG%, "ON ", "OFF"))
   twm.inverse(0)
   twm.print(str.decode$(" \x94")))
   update% = 0
  EndIf
  Call CTRL$, key%
  Select Case key%
   Case ctrl.START
    procOK()
    Exit Do
   Case ctrl.A, ctrl.SELECT
    Select Case sel%
     Case 0 : procOK() : Exit Do
     Case 1 : procOK() : procEND()
    End Select
   Case ctrl.UP
    Inc sel%, -1
    If sel% = -1 Then sel% = 0 Else update% = 1
   Case ctrl.DOWN
    Inc sel%, 1
    If sel% = 4 Then sel% = 3 Else update% = 1
   Case ctrl.LEFT, ctrl.RIGHT
    Select Case sel%
     Case 2
      If sound.enabled% And sound.MUSIC_FLAG% Then
       sound.enable(sound.enabled% Xor sound.MUSIC_FLAG%)
      Else
       sound.enable(sound.enabled% Or sound.MUSIC_FLAG%)
       music_done_cb()
      EndIf
      update% = 1
     Case 3
      If sound.enabled% And sound.FX_FLAG% Then
       sound.enable(sound.enabled% Xor sound.FX_FLAG%)
      Else
       sound.enable(sound.enabled% Or sound.FX_FLAG%)
      EndIf
      update% = 1
    End Select
  End Select
  If update% Then procOK() Else If key% Then procINVALID()
Loop
procKCL()
If Not new_game% Then
 twm.switch(old_win%)
 twm.redraw()
EndIf
End Sub

Sub procMAP()
 Local y%
 twm.switch(win1%)
 twm.cls()
 twm.foreground(twm.YELLOW%)
 For y% = Choice(HEIGHT = 20, 1, 3) To HEIGHT - 2
  twm.print_at(1, y%, Chr$(219))
 Next
 twm.foreground(twm.CYAN%)
 For y% = Choice(HEIGHT = 20, 1, 3) To HEIGHT - 2
  twm.print_at(3, y%, Chr$(221) + Chr$(221))
 Next
 twm.foreground(twm.RED%)
 For y% = Choice(HEIGHT = 20, 1, 3) To HEIGHT - 4 Step 2
  twm.print_at(29, y%, Chr$(222))
  twm.print_at(28, y% + 1, Chr$(220) + Chr$(219) + Chr$(219) + Chr$(220) + "  " + Chr$(222))
  twm.print_at(33, y% + 2, Chr$(220) + Chr$(219) + Chr$(219) + Chr$(220))
 Next
 Local y_top% = Choice(HEIGHT = 20, HEIGHT - 12, HEIGHT - 13)
 For y% = y_top% + 1 To y_top% + 3 : twm.print_at(30, y%, "  ") : Next
 twm.print_at(32, y_top%, THIEF$)
 twm.print_at(31, y_top% + 1, THIEF$ + THIEF$)
 twm.print_at(30, y_top% + 2, "THIEVES")
 twm.print_at(31, y_top% + 3, THIEF$)
 twm.print_at(32, y_top% + 4, THIEF$)
 twm.print_at(32, y_top% + 5, THIEF$)
 For y% = 1 To 3 : procVDRAW(y%) : Next
 twm.foreground(twm.white%)
 y% = Choice(HEIGHT = 20, 19, HEIGHT - 2)
 twm.print_at(0, y%, "   DYKE        VILLAGES      MOUNTAINS")
End Sub

Sub procVDRAW(i%)
 twm.foreground(twm.GREEN%)
 twm.print_at(vx%(i%) - 1, vy%(i%), Chr$(138) + Chr$(165))
 twm.print_at(vx%(i%) - 1, vy%(i%) + 1, Chr$(165) + Chr$(138))
End Sub

Sub procINSTRUCTIONS()
 procYELLOW()
 Const y% = Choice(HEIGHT = 20, 1, 4)
 twm.print_at(0, y%, "The kingdom is three villages. It")
 twm.print_at(0, y% + 1, "is between the Yellow River and")
 twm.print_at(0, y% + 2, "the mountains.")
 twm.print_at(0, y% + 4, "You have been chosen to take")
 twm.print_at(0, y% + 5, "all the important decisions. Your")
 twm.print_at(0, y% + 6, "poor predecessor was executed by")
 twm.print_at(0, y% + 7, "thieves who live in the nearby")
 twm.print_at(0, y% + 8, "mountains.")
 twm.print_at(0, y% + 10, "These thieves live off the ")
 twm.print_at(0, y% + 11, "villagers and often attack. The")
 twm.print_at(0, y% + 12, "rice stored in the villages must")
 twm.print_at(0, y% + 13, "be protected at all times.")
 procSPACE()
 twm.cls()
 twm.print_at(0, y% - 1, "The year consists of three long ")
 twm.print_at(0, y%,     "seasons, Winter, Growing and")
 twm.print_at(0, y% + 1, "Harvest. Rice is planted every")
 twm.print_at(0, y% + 2, "Growing Season. You must decide")
 twm.print_at(0, y% + 3, "how much is planted.")
 twm.print_at(0, y% + 5, "The river is likely to flood the")
 twm.print_at(0, y% + 6, "fields and the villages. The high")
 twm.print_at(0, y% + 7, "dyke between the river and the")
 twm.print_at(0, y% + 8, "fields must be kept up to prevent")
 twm.print_at(0, y% + 9, "a serious flood.")
 twm.print_at(0, y% + 11, "The people live off the rice that")
 twm.print_at(0, y% + 12, "they have grown. It is a very poor")
 twm.print_at(0, y% + 13, "living. You must decide what the")
 twm.print_at(0, y% + 14, "people will work at each season")
 twm.print_at(0, y% + 15, "so that they prosper under your")
 twm.print_at(0, y% + 16, "leadership.")
 procSPACE()
End Sub

Sub procSPACE()
 Const y% = Choice(HEIGHT = 20, 19, 22)
 twm.print_at(0, y%, str.centre$(CONTINUE_MSG$, twm.w% - 2))
 procKCL()
 Local key%
 Do
  Call CTRL$, key%
  Select Case key%
   Case 0
   Case ctrl.A
    procOK()
    Exit Do
   Case ctrl.START
    procOK()
    procMENU()
   Case Else
    procINVALID()
  End Select
 Loop
 procKCL()
 twm.print_at(0, y%, Space$(twm.w% - 2))
End Sub

Sub procREINIT()
 food% = 5000 + fnRND%(2000)
 people% = 300 + fnRND%(100)
 turn% = 0
End Sub

Sub procGAMELOOP()
 Do
  procNEWTURN()
  procBEGINSEASON()
  procMAP()
  procHEADER()
  If fnRND%(2) = 1 Then
   procATTACK()
   procFLOOD()
  Else
   procFLOOD()
   procATTACK()
  EndIf
  procCALCULATE()
  procENDSEASON()
  If people% <= 0 Or food% <= 0 Then Exit Do
  If turn% Mod 12 = 0 Then
   If Not fnRITUAL%() Then Exit Do
  EndIf
  If people% < 200 And fnRND%(3) = 1 Then procADDTHIEVES()
  people% = Int(people% * 1.045)
 Loop
End Sub

Sub procNEWTURN()
 Inc turn%
 season% = (turn% - 1) Mod 3 + 1
 year% = (turn% - 1) \ 3 + 1
 Local i%
 For i% = 1 To 3 : flooded%(i%) = 0 : Next
 flood_deaths% = 0
 flood_losses% = 0
 thief_deaths% = 0
 thief_losses% = 0
 num_flooded% = 0
 was_flooded% = 0
 was_attacked% = 0
End Sub

Sub procBEGINSEASON()
 procYELLOW()
 twm.print_at(8, 1, "Census Results")
 If turn% = 1 Then
  twm.print_at(0,  3, "You have inherited this situation")
  twm.print_at(0,  4, "from your unlucky predecessor. It")
  twm.print_at(0,  5, "is the start of the Winter Season.")
 Else
  twm.print_at(0, 3, "At the start of the " + season_name$(season%) + " Season")
  twm.print_at(0, 4, "of year "+ Str$(year%) + " of your reign this is")
  twm.print_at(0, 5, "the situation.")
 EndIf
 twm.print_at(0,  7, "Allowing for births and deaths,")
 twm.print_at(0,  8, "the population is " + Str$(people%) + ".")
 twm.print_at(0, 10, "There are " + Str$(food%) + " baskets of rice")
 twm.print_at(0, 11, "in the village stores.")
 twm.print_at(0, 13, "How many people should:")
 twm.print_at(0, 14, " A) Defend the dyke......")
 twm.print_at(0, 15, " B) Work in the fields...")
 twm.print_at(0, 16, " C) Protect the villages.")
 If use_keyboard% Then
  Do
   workers% = fnNUMKEYS%(26, 14, 6)
   If workers% > people% Then procIMPOS() Else Exit Do
  Loop
  If workers% = people% Then
   farmers% = 0
   twm.print_at(26, 15, "0")
  Else
   Do
    farmers% = fnNUMKEYS%(26, 15, 6)
    If workers% + farmers% > people% Then procIMPOS() Else Exit Do
   Loop
  EndIf
  soldiers% = people% - workers% - farmers%
  twm.print_at(26, 16, Str$(soldiers%))
  If season% = 2 Then
   twm.print_at(0, 18, "How many baskets of rice will be")
   twm.print_at(0, 19, "planted in the fields.....")
   Do
    planted! = fnNUMKEYS%(26, 19, 6)
    If planted! > food% Then procIMPOS()
   Loop Until planted! <= food%
   Inc food%, -planted!
  EndIf
  procSPACE()
 Else
  Local i%, key%, cb$ = "people_change_cb"
  workers% = (people% \ 20) * 5
  farmers% = (people% \ 20) * 5
  soldiers% = (people% \ 20) * 5
  twm.print_at(28, 14, Format$(workers%, "%4g"))
  twm.print_at(28, 15, Format$(farmers%, "%4g"))
  twm.print_at(28, 16, Format$(soldiers%, "%4g"))
  Do
   Select Case i%
    Case 0
     workers% = fnNUMGAMEPAD%(26, 14, workers%, people% - farmers% - soldiers%, key%, cb$)
    Case 1
     farmers% = fnNUMGAMEPAD%(26, 15, farmers%, people% - workers% - soldiers%, key%, cb$)
    Case 2
     soldiers% = fnNUMGAMEPAD%(26, 16, soldiers%, people% - workers% - farmers%, key%, cb$)
   End Select
   Select Case key%
    Case ctrl.A
     If workers% + farmers% + soldiers% = people% Then
      procOK()
      Exit Do
     Else
      procINVALID()
     EndIf
    Case ctrl.UP
     If i% = 0 Then procINVALID() Else Inc i%, -1
    Case ctrl.DOWN
     If i% = 2 Then procINVALID() Else Inc i%
    Case ctrl.START
     procOK()
     procMENU()
    Case Else
     procINVALID()
   End Select
  Loop
  procKCL()
  If season% = 2 Then
   twm.print_at(0, 13, "How many baskets of rice will be  ")
   twm.print_at(0, 14, "planted in the fields....         ")
   twm.print_at(0, 15, "                                  ")
   twm.print_at(0, 16, "                                  ")
   planted! = Min(food% \ 3, 500)
   Do
    planted! = fnNUMGAMEPAD%(26, 14, planted!, food%, key%)
    If (key% = ctrl.A) And (planted! > 0) Then
     procOK()
     Exit Do
    Else
     procINVALID()
    EndIf
   Loop
   Inc food%, -planted!
  EndIf
 EndIf
End Sub

Sub people_change_cb(y%, value%)
 Local remaining%
 Select Case y%
  Case 14
   remaining% = people% - farmers% - soldiers% - value%
  Case 15
   remaining% = people% - workers% - soldiers% - value%
  Case 16
   remaining% = people% - farmers% - workers% - value%
  Case Else
   Error "Invalid state"
 End Select
 Local msg$
 Select Case remaining%
  Case 0 : msg$ = CONTINUE_MSG$
  Case 1 : msg$ = "1 idle villager"
  Case Else : msg$ = Str$(remaining%) + " idle villagers"
 End Select
 twm.print_at(0, Choice(HEIGHT = 20, 18, 21), str.centre$(msg$, twm.w% - 2))
End Sub

Sub procIMPOS()
 twm.inverse(1)
 twm.bold(1)
 twm.print_at(5, 20, " I M P O S S I B L E ")
 twm.inverse(0)
 twm.bold(0)
 Pause 2000
 procSPACE()
 twm.print_at(5, 20, "                     ")
End Sub

Sub procHEADER()
 twm.foreground(twm.WHITE%)
 twm.bold(1)
 Const y% = Choice(HEIGHT = 20, 0, 1)
 twm.print_at(1,  y%, season_name$(season%) + " Season")
 twm.print_at(28, y%, "Year " + Str$(year%))
 twm.bold(0)
End Sub

Sub procATTACK()
 If num_flooded% = 3 Then Exit Sub
 Select Case season%
  Case 1    : If Rnd() < 0.5 Then Exit Sub
  Case 2    : If Rnd() < 0.2 Then Exit Sub
  Case 3    : If Rnd() < 0.6 Then Exit Sub
  Case Else : Error "Unknown season " + Str$(season%)
 End Select
 was_attacked% = 1
 Local village%
 Do
  village% = fnRND%(3)
 Loop Until Not flooded%(village%)
 Local x% = 32, y%
 Local wx% = vx%(village%)
 Local wy% = vy%(village%) - 1
 Local d%
 If wy% < HEIGHT - 8 Then
  y% = HEIGHT - 12 : d% = -1
 Else
  y% = HEIGHT - 8 : d% = 1
 EndIf
 Local sy% = y%
 twm.foreground(twm.RED%)
 Do
  If Not sound.is_playing%(sound.FX_FLAG%) Then sound.play_fx(FX_ATTACK%())
  twm.print_at(x%, y%, " ")
  If y% = wy% Then Exit Do
  Inc y%, d%
  twm.print_at(x%, y%, THIEF$)
  Pause 50
 Loop
 Do While x% > wx%
  If Not sound.is_playing%(sound.FX_FLAG%) Then sound.play_fx(FX_ATTACK%())
  Inc x%, -1
  twm.print_at(x%, y%, THIEF$)
  Pause 1000 * (1 - Min(0.9, (x% - wx%) / 5))
  twm.print_at(x%, y%, Choice(x% = 29, Chr$(222), " "))
 Loop
 twm.foreground(twm.GREEN%)
 Local i%
 For i% = 1 To 40
  If Not sound.is_playing%(sound.FX_FLAG%) Then sound.play_fx(FX_ATTACK%())
  twm.print_at(x%, y% + 1, Mid$("\|/-", 1 + i% Mod 4, 1))
  Pause 40
 Next
 procVDRAW(village%)
 twm.foreground(twm.RED%)
 Do While x% < 32
  If Not sound.is_playing%(sound.FX_FLAG%) Then sound.play_fx(FX_ATTACK%())
  twm.print_at(x%, y%, Choice(x% = 29, Chr$(222), " "))
  Inc x%
  twm.print_at(x%, y%, THIEF$)
  Pause 40
 Loop
 Do While y% <> sy%
  If Not sound.is_playing%(sound.FX_FLAG%) Then sound.play_fx(FX_ATTACK%())
  twm.print_at(x%, y%, " ")
  Inc y%, -d%
  twm.print_at(x%, y%, THIEF$)
  Pause 50
 Loop
 Select Case season%
  Case 1 : i% = 200 + fnRND%(70) - soldiers%
  Case 2 : i% = 30 + fnRND%(200) - soldiers%
  Case 3 : i% = fnRND%(400) - soldiers%
  Case Else
   Error "Unknown season: " + Str$(season%)
 End Select
 If i% < 0 Then i% = 0
 thief_deaths% = Int(soldiers% * i% / 400)
 soldiers% = soldiers% - thief_deaths%
 thief_losses% = Int(i% * food% / 729 + fnRND%(2000 - soldiers%) / 10)
 If thief_losses% < 0 Then
  thief_losses% = 0
 ElseIf thief_losses% > 2000 Then
  thief_losses% = 1900 + fnRND%(200)
 EndIf
 Inc food%, -thief_losses%
End Sub

Sub procFLOOD()
 Local fs!
 Select Case season%
  Case 1    : fs! = fnRND%(330) / (workers% + 1)
  Case 2    : fs! = (fnRND%(100) + 60) / (workers% + 1)
  Case 3    : Exit Sub
  Case Else : Error "Unknown season " + Str$(season%)
 End Select
 If fs! < 1.0 Then Exit Sub
 was_flooded% = 1
 sound.play_fx(FX_FLOOD%())
 Local x% = 6
 Local y% = fnRND%(8) + 10
 twm.foreground(twm.YELLOW%)
 twm.print_at(1, y%, Chr$(219) + Chr$(219) + Chr$(219) + Chr$(219) + Chr$(219) + Chr$(219))
 Local k%, key%, v%, w1%, w2%
 fs! = fnRND%(Choice(fs! < 2.0, 2.0, 4.0))
 procKCL()
 For k% = 1 To fs! * 100
  Do
   Select Case fnRND%(4)
    Case 1 : If x% < 25 Then Inc x%     : Exit Do
    Case 2 : If x% > 6  Then Inc x%, -1 : Exit Do
    Case 3 : If y% < HEIGHT - 3 Then Inc y% : Exit Do
    Case 4 : If y% > 3  Then Inc y%, -1 : Exit Do
   End Select
  Loop
  For v% = 1 To 3
   w1% = vx%(v%) - x%
   w2% = y% - vy%(v%)
   If w2% = 0 Or w2% = 1 Then
    If w1% = 0 Or w1% = 1 Then flooded%(v%) = 1 : Inc num_flooded%
    If w1% = -1 Then Exit For
   EndIf
  Next
  twm.print_at(x%, y%, Chr$(219))
  If Not key% Then key% = fnWAITFORKEY%(100)
 Next
 Local orig_pop%  = workers% + farmers% + soldiers%
 workers% = Int((workers% / 10) * (10 - fs!))
 farmers% = Int((farmers% / 10) * (10 - fs!))
 soldiers% = Int((soldiers% / 6) * (6 - num_flooded%))
 flood_deaths% = orig_pop% - workers% - farmers% - soldiers%
 flood_losses% = Int(food% * num_flooded% / 6)
 Inc food%, -flood_losses%
 Select Case season%
  Case 1    :
  Case 2    : planted! = planted! * (20 - fs!) / 20
  Case 3    : planted! = planted! * (10 - fs!) / 10
  Case Else : Error "Unknown season " + Str$(season%)
 End Select
End Sub

Sub procCALCULATE()
 If farmers% = 0 Then
  planted! = 0
 Else
  Select Case season%
   Case 1 :
   Case 2
    If planted! > 1000 Then planted! = 1000
    planted! = planted! * (farmers% - 10) / farmers%
   Case 3
    If planted! > 0 Then planted! = 18 * (11 + fnRND%(3)) * (0.05 - 1 / farmers%) * planted!
    If planted! > 0 Then food% = food% + Int(planted!)
   Case Else
    Error "Unknown season " + Str$(season%)
  End Select
 EndIf
 starvation_deaths% = 0
 people% = workers% + farmers% + soldiers%
 If people% <= 0 Then Exit Sub
 Local t! = food% / people%
 If t! > 5 Then
  t! = 4
 ElseIf t! < 2 Then
  people% = 0
 ElseIf t! > 4 Then
  t! = 3.5
 Else
  starvation_deaths% = Int(people% * (7 - t!) / 7)
  t! = 3
 EndIf
 If people% > 0 Then
  Inc people%, -starvation_deaths%
  food% = Int(food% - people% * t! - starvation_deaths% * t! / 2)
  If food% < 0 Then food% = 0
 EndIf
End Sub

Sub procENDSEASON()
 Pause 2000
 If food% <= 0 Then
  procYELLOW()
  twm.print_at(0,  7, "There was no food left. All of the")
  twm.print_at(0,  8, "people have run off and joined up")
  twm.print_at(0,  9, "with the thieves after " + Str$(turn%) + " seasons")
  twm.print_at(0, 10, "of your misrule")
  procSPACE()
  Exit Sub
 EndIf
 If people% <= 0 Then
  procYELLOW()
  twm.print_at(0,  8, "There is no-one left! They have all")
  twm.print_at(0,  9, "been killed off by your decisions ")
  twm.print_at(0, 10, "after only " + Str$(year%) + Choice(year% = 1, " year.", " years."))
  procSPACE()
  Exit Sub
 EndIf
 Local f1! = people% / (flood_deaths% + thief_deaths% + starvation_deaths% + 1)
 Local f2! = food% / (flood_losses% + thief_losses% + 1)
 Local msg$
 If f2! < f1! Then f1! = f2!
 If f2! < 2 Then
  msg$ = "Disastrous Losses!"
 ElseIf f1! < 4 Then
  msg$ = "Worrying losses!"
 ElseIf f1! < 8 Then
  msg$ = "You got off lightly!"
 ElseIf food% / people% < 4 Then
  msg$ = "Food supply is low."
 ElseIf food% / people% < 2 Then
  msg$ = "Starvation Imminent!"
 ElseIf was_attacked% + was_flooded% + starvation_deaths% > 0 Then
  msg$ = "Nothing to worry about."
 Else
  Local y% = Choice(HEIGHT = 20, 8, 11)
  twm.bold(1)
  twm.print_at(1, y%,     "                                      ")
  twm.print_at(1, y% + 1, "             A quiet season           ")
  twm.print_at(1, y% + 2, "                                      ")
  twm.bold(0)
  Pause 2000
  Exit Sub
 EndIf
 procYELLOW()
 Const y% = Choice(HEIGHT = 20, 1, 2)
 twm.print_at(3, y%, "Village Leader's Report")
 twm.inverse(1)
 twm.print_at(13 - Len(msg$) / 2, y% + 2, " " + msg$ + " ")
 twm.inverse(0)
 twm.print_at(0, y% + 4, "In the " + season_name$(season%) + " Season of year " + Str$(year%))
 twm.print_at(0, y% + 5, "of your reign, the kingdom has")
 twm.print_at(0, y% + 6, "suffered these losses:")
 twm.print_at(0, y% + 8,  "Deaths from floods......... " + Format$(flood_deaths%, "%4g"))
 twm.print_at(0, y% + 9,  "Deaths from the attacks.... " + Format$(thief_deaths%, "%4g"))
 twm.print_at(0, y% + 10, "Deaths from starvation..... " + Format$(starvation_deaths%, "%4g"))
 twm.print_at(0, y% + 11, "Baskets of rice")
 twm.print_at(0, y% + 12, "  lost during the floods... " + Format$(flood_losses%, "%4g"))
 twm.print_at(0, y% + 13, "Baskets of rice")
 twm.print_at(0, y% + 14, "  lost during the attacks.. " + Format$(thief_losses%, "%4g"))
 twm.print_at(0, y% + 16, "The village census follows.")
 procSPACE()
End Sub

Function fnRITUAL%()
 Const y% = Choice(HEIGHT = 20, 1, 3)
 procYELLOW()
 twm.print_at(2, y%,     "We have survived for " + Str$(year%) + " years")
 twm.print_at(2, y% + 1, "under your glorious control.")
 twm.print_at(2, y% + 2, "By an ancient custom we must")
 twm.print_at(2, y% + 3, "offer you the chance to lay")
 twm.print_at(2, y% + 4, "down this terrible burden and")
 twm.print_at(2, y% + 5, "resume a normal life.")
 twm.print_at(2, y% + 7, "In the time honoured fashion")
 twm.print_at(2, y% + 8, "I will now ask the ritual")
 twm.print_at(2, y% + 9, "question:")
 Pause 2000
 twm.print_at(2, y% + 11, "Are you prepared to accept")
 twm.print_at(2, y% + 12, "the burden of decision again?")
 twm.print_at(2, y% + 14, "You need only answer Yes or No")
 twm.print_at(2, y% + 15, "for the people will understand")
 twm.print_at(2, y% + 16, "your reasons.")
 fnRITUAL% = fnYESORNO%(y% + 18)
End Function

Sub procADDTHIEVES()
 Const y% = Choice(HEIGHT = 20, 7, 8)
 procYELLOW()
 twm.print_at(0, y%,     "Thieves have come out of the")
 twm.print_at(0, y% + 1, "mountain to join you. They")
 twm.print_at(0, y% + 2, "have decided that it will be")
 twm.print_at(0, y% + 3, "easier to grow the rice than")
 twm.print_at(0, y% + 4, "to steal it!")
 procSPACE()
 people% = people% + 50 + fnRND%(100)
End Sub

Sub procYELLOW()
 twm.switch(win1%)
 twm.cls()
 twm.switch(win2%)
 twm.cls()
 twm.foreground(twm.YELLOW%)
End Sub

Function fnWAITFORKEY%(duration%)
 Local expires% = Timer + duration%, key%
 Do While Timer < expires%
  Call CTRL$, key%
  If key% = ctrl.A Then Exit Do
 Loop
 fnWAITFORKEY% = (key% = ctrl.A)
End Function

Sub procKCL()
 Pause 100
 ctrl.term_keys()
 Local key%
 Do : Call ctrl$, key% : Loop Until Not key%
 ctrl.init_keys()
End Sub

Function fnGPI$(expect_num%, max_length%)
 Local k$, kcode%, x% = twm.x%, y% = twm.y%
 twm.print_at(x%, y%, String$(max_length%, " "))
 twm.print_at(x% - 1, y%, " ")
 ctrl.term_keys()
 twm.enable_cursor(1)
 Do
  Do : k$ = Inkey$ : Loop Until k$ <> ""
  kcode% = Asc(k$)
  Select Case kcode%
   Case 10, 13
    Exit Do
   Case 8, 127
    If fnGPI$ <> "" Then
     fnGPI$ = Left$(fnGPI$, Len(fNGPI$) - 1)
     twm.print_at(x%, y%, String$(max_length%, " "))
     twm.print_at(x% - 1, y%, " " + fnGPI$)
    EndIf
   Case < 32, > 126
    procINVALID()
   Case Else
    If expect_num% And (kcode% < 48 Or kcode% > 57) Then
     procINVALID()
    ElseIf Len(fnGPI$) = max_length% Then
     procINVALID()
    Else
     twm.print(k$)
     Cat fnGPI$, k$
    EndIf
  End Select
 Loop
 ctrl.init_keys()
 twm.enable_cursor(0)
End Function

Function fnYESORNO%(y%)
 procKCL()
 Local key%, update% = 1
 Do
  If update% Then
   If fnYESORNO% < 0 Then procINVALID() : fnYESORNO% = 0
   If fnYESORNO% > 1 Then procINVALID() : fnYESORNO% = 1
   If fnYESORNO% Then twm.inverse(1)
   twm.print_at(11, y%, " Yes ")
   twm.inverse(0)
   If Not fnYESORNO% Then twm.inverse(1)
   twm.print_at(18, y%, " No ")
   twm.inverse(0)
   update% = 0
  EndIf
  Call CTRL$, key%
  If key% Then
   Select Case key%
    Case 0
    Case ctrl.A, ctrl.SELECT : Exit Function
    Case ctrl.LEFT : Inc fnYESORNO% : update% = 1
    Case ctrl.RIGHT : Inc fnYESORNO%, -1 : update% = 1
    Case ctrl.START
     procOK()
     procMENU()
     key% = 0
   End Select
  Else
   If ctrl.keydown%(121) Then
    fnYESORNO% = 1
    update% = 1
   ElseIf ctrl.keydown%(110) Then
    fnYESORNO% = 0
    update% = 1
   EndIf
  EndIf
  If update% Then procOK() Else If key% Then procINVALID()
Loop
ctrl.init_keys()
End Function

Function fnNUMGAMEPAD%(x%, y%, initial%, max_value%, key%, callback$)
 twm.print_at(x%, y%, Chr$(&h95) + "      " + Chr$(&h94))
 Local buzz%, delta% = Choice(max_value% < 1000, 5, 25)
 Local update% = 1, value% = initial%
 key% = 0
 Do
  If update% Then
   Select Case value%
    Case < 0
     Inc buzz%
     value% = 0
    Case > max_value%
     If value% - max_value% >= delta% Then Inc buzz%
    Case Else
     If value% Mod delta% Then value% = (value% \ delta%) * delta% + delta%
     buzz% = 0
   End Select
   value% = Min(value%, max_value%)
   twm.inverse(1)
   twm.print_at(x% + 2, y%, Format$(value%, "%4g"))
   twm.inverse(0)
   If Len(callback$) Then Call callback$, y%, value%
   If buzz% >= 10 Then procINVALID()
   Pause 100
  EndIf
  Call CTRL$, key%
  Select Case key%
   Case 0          : update% = 0
   Case ctrl.LEFT  : Inc value%, -delta% : update% = 1
   Case ctrl.RIGHT : Inc value%, delta% : update% = 1
   Case Else       : Exit Do
  End Select
 Loop
 twm.print_at(x%, y%, "  " + Format$(value%, "%4g") + "  ")
 fnNUMGAMEPAD% = value%
End Function

Function fnNUMKEYS%(x%, y%, max_len%)
 twm.print_at(x%, y%)
 fnNUMKEYS% = Val(fnGPI$(1, max_len%))
 If fnNUMKEYS% = 0 Then twm.print_at(x%, y%, "0")
End Function

Function fnRND%(x%)
 fnRND% = Int(Rnd() * x%) + 1
End Function

Sub procINVALID()
 sound.play_fx(sound.FX_BLART%())
 Pause ctrl.UI_DELAY
End Sub

Sub procOK()
 sound.play_fx(sound.FX_SELECT%())
 Pause ctrl.UI_DELAY
End Sub

Sub break_cb()
 procEND(1)
End Sub

Sub procEND(break%)
 gamemite.end(break%)
End Sub

Sub music_done_cb()
 Const is_gamemite% = 1
 If music_track% = 1 Then
  sound.music_volume% = Choice(is_gamemite%, 5, 10)
  sound.play_music(MUSIC_AUTUMN_FESTIVAL%(), "music_done_cb")
  music_track% = 2
 Else
  sound.music_volume% = Choice(is_gamemite%, 10, 15)
  sound.play_music(MUSIC_MO_LI_HUA%(), "music_done_cb")
  music_track% = 1
 EndIf
End Sub

attack_fx_data:
Data 48
Data 3
Data &h0033000000000034, &h0000003200000000, &h0000310000310000, &hFFFF000000000000
Data &hFFFFFFFFFFFFFFFF, &hFFFFFFFFFFFFFFFF
flood_fx_data:
Data 192
Data 3
Data &h0031000031000031, &h3200003200003100, &h0000320000320000, &h0033000033000033
Data &h3400003400003300, &h0000340000340000, &h0035000035000035, &h3600003600003500
Data &h0000360000360000, &h0037000037000037, &h3800003800003700, &h0000380000380000
Data &h0039000039000039, &h3A00003A00003900, &h00003A00003A0000, &h003B00003B00003B
Data &h3C00003C00003B00, &h00003C00003C0000, &h003D00003D00003D, &h3D00003D00003D00
Data &h00003D00003D0000, &hFFFFFFFFFF000000, &hFFFFFFFFFFFFFFFF, &hFFFFFFFFFFFFFFFF
autumn_festival_music_data:
Data 1320
Data 3
Data &h003C2B003E2B003E, &h3A2B373A2B003C2B, &h2B373A2B373A2B37, &h00412B00002B0000
Data &h3F2C003F2B00412B, &h2C003E2C003E2C00, &h383C2C383C2C383C, &h002C00002C383C2C
Data &h2C00002C00002C00, &h00382E003A2E003A, &h372E00372E00382E, &h2E00372E00372E00
Data &h00352E00002E0000, &h373000372E00352E, &h3000383000383000, &h0037300037300037
Data &h3A30003A30003730, &h30003A30003A3000, &h003C2B003E2B003E, &h3A2B373A2B003C2B
Data &h2B373A2B373A2B37, &h00412B00002B0000, &h3F2C003F2B00412B, &h2C003E2C003E2C00
Data &h383C2C383C2C383C, &h002C00002C383C2C, &h2C00002C00002C00, &h003F2E003E2E003E
Data &h412E3A412E003F2E, &h2E3A412E3A412E3A, &h00432E00432E0043, &h3F30003F2E00432E
Data &h30003E30003E3000, &h003C30003C30003C, &h0030000030003C30, &h3000003000003000
Data &h003C2B003E2B003E, &h3A2B373A2B003C2B, &h2B373A2B373A2B37, &h00412B00002B0000
Data &h3F2C003F2B00412B, &h2C003E2C003E2C00, &h383C2C383C2C383C, &h002C00002C383C2C
Data &h2C00002C00002C00, &h00382E003A2E003A, &h372E00372E00382E, &h2E00372E00372E00
Data &h00352E00002E0000, &h373000372E00352E, &h3000383000383000, &h0037300037300037
Data &h3A30003A30003730, &h30003A30003A3000, &h003C2B003E2B003E, &h3A2B373A2B003C2B
Data &h2B373A2B373A2B37, &h00412B00002B0000, &h3F2C003F2B00412B, &h2C003E2C003E2C00
Data &h383C2C383C2C383C, &h002C00002C383C2C, &h2C00002C00002C00, &h003F2E003E2E003E
Data &h412E3A412E003F2E, &h2E3A412E3A412E3A, &h00432E00432E0043, &h3F30003F2E00432E
Data &h30003E30003E3000, &h003C30003C30003C, &h0030000030003C30, &h3000003000003000
Data &h003C2B003E2B003E, &h3A37003A2B003C2B, &h00003C37003C3700, &h003A37003E37003E
Data &h412C004137003A37, &h2C003F2C003F2C00, &h003F38003E38003E, &h4138004100003F38
Data &h3800413800413800, &h00412E00432E0043, &h3F3A003F2E00412E, &h0000433A00433A00
Data &h00443A00463A0046, &h433000433A00443A, &h3000413000413000, &h00413C003F3C003F
Data &h3E3C003E3C00413C, &h3C00003C003E3C00, &h003C2B003E2B003E, &h3A37003A2B003C2B
Data &h00003C37003C3700, &h003A37003E37003E, &h412C004137003A37, &h2C003F2C003F2C00
Data &h003F38003E38003E, &h4138004100003F38, &h3800413800413800, &h00412E00432E0043
Data &h3F3A003F2E00412E, &h0000433A00433A00, &h00443A00463A0046, &h433000433A00443A
Data &h3000413000413000, &h00413C003F3C003F, &h3E3C003E3C00413C, &h3C003F3C003F3C00
Data &h3D00310041313D41, &h00384100313D0031, &h3844003844003841, &h44003D48003D4800
Data &h41313D413D44003D, &h313D00313D003100, &h4400384100384100, &h003D480038440038
Data &h3D44003D44003D48, &h3D002E41002E4100, &h003541002E3D002E, &h3544003544003541
Data &h44003A48003A4800, &h002E41003A44003A, &h2E3D002E3D002E41, &h4400354100354100
Data &h003A480035440035, &h3A44003A44003A48, &h3D002F3F002F3F00, &h003B3F002F3D002F
Data &h0044003B44003B3F, &h3D003B3F003B3F00, &h002F3F003B3D003B, &h2F3D002F3D002F3F
Data &h44003B3F003B3F00, &h003B3F000044003B, &h3B3D003B3D003B3F, &h3D00213F00213F00
Data &h2D283F2D213D0021, &h00440028442D283F, &h3D2D283F2D283F2D, &h00213F00283D2D28
Data &h213D00213D00213F, &h442D283F2D283F2D, &h2D283F2D00440028, &h283D2D283D2D283F
Data &h3D27203F27203F27, &h27203F27203D2720, &h204427204427203F, &h3D27203F27203F27
Data &h27203F27203D2720, &h203D27203D27203F, &h4427203F27203F27, &h27203F2720442720
Data &h203D27203D27203F, &h2400200000200000, &h0020270020240020, &h202C00202C002027
Data &h3300203000203000, &h0020380020330020, &h203A00203A002038, &h3F00203C00203C00
Data &h00204400203F0020, &h2046002046002044, &h4800204800204800, &h0020000020480020
Data &hFFFFFF0000002000
mo_li_hua_music_data:
Data 696
Data 3
Data &h2C35002535002535, &h35003135002C0000, &h002C38002C380031, &h313D002A3A002A3A
Data &h0000363D00310000, &h00313A00313A0036, &h2C38002538002538, &h38003138002C0000
Data &h00353A00353A0031, &h3138002C38002C38, &h3800353800313800, &h0031380031380035
Data &h2C35002535002535, &h35003135002C0000, &h002C38002C380031, &h313D002A3A002A3A
Data &h0000363D00310000, &h00313A00313A0036, &h2C38002538002538, &h38003138002C0000
Data &h00353A00353A0031, &h3138002C38002C38, &h3800353800313800, &h0031000031380035
Data &h2C38002538002538, &h38003138002C0000, &h002C00002C380031, &h2C38002938002938
Data &h35003135002C0000, &h002C38002C380031, &h313A002A3A002A3A, &h3A00363A00310000
Data &h00310000313A0036, &h3138002938002938, &h3800353800313800, &h0031380031380035
Data &h2C35002535002535, &h33002933002C3500, &h002C35002C350029, &h2A38002738002738
Data &h35002E35002A3800, &h002A33002A33002E, &h2C31002531002531, &h31002931002C0000
Data &h002C33002C330029, &h2C31002531002531, &h31002931002C3100, &h002C31002C310029
Data &h2C33002535002535, &h31003131002C3300, &h002C35002C350031, &h2C33003033003033
Data &h33003033002C3300, &h0033350033350030, &h2A38002238002238, &h3A00273A002A3800
Data &h00303D00303D0027, &h2C38002538002538, &h38003138002C3800, &h002C38002C380031
Data &h2C33002733002733, &h35003035002C3300, &h0033380033380030, &h2A35003033003033
Data &h31002E31002A3500, &h002A2E002A2E002E, &h302C002C2C002C2C, &h2C002A2C00302C00
Data &h00272C00272C002A, &h2C00002900002900, &h00003100002C0000, &h002C00002C000031
Data &h2A2E00222E00222E, &h31002E31002A2E00, &h002A31002A31002E, &h3033002733002733
Data &h3300333300303300, &h0030350030350033, &h2E33003131003131, &h31002E31002E3300
Data &h002A2E002A2E002E, &h252C00252C00252C, &h2C00252C00252C00, &h00252C00252C0025
Data &hFFFFFFFFFF000000, &hFFFFFFFFFFFFFFFF, &hFFFFFFFFFFFFFFFF
