' Transpiled on 07-01-2024 18:07:23
' Copyright (c) 2022-2023 Martin Herhaus
' (c) 1978 by Tomohiro Nishikado of Taito
Option Base 0
Option Default None
Option Explicit On
Const VERSION = 101303
' ../../mmbasic-third-party/pico-vaders/../splib/system.inc ++++
' Copyright (c) 2020-2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
' Preprocessor value GAMEMITE defined
Const sys.VERSION = 102201
Const sys.NO_DATA$ = Chr$(&h7F)
Const sys.CRLF$ = Chr$(13) + Chr$(10)
Const sys.FIRMWARE = Int(1000000 * Mm.Info(Version))
Const sys.SUCCESS = 0
Const sys.FAILURE = -1
Dim sys.break_flag%
Dim sys.err$

Function sys.format_version$(v%)
 Const v_% = Choice(v%, v%, sys.VERSION), a% = v_%\10^5, b% = (v_%-a%*10^5)\10^3
 Local c% = v_%-a%*10^5-b%*10^3, s$ = Str$(a%) + "." + Str$(b%)
 Select Case c%
  Case < 100 : Cat s$, " alpha "
  Case < 200 : Cat s$, " beta " : Inc c%, -100
  Case < 300 : Cat s$, " RC " : Inc c%, -200
  Case Else  : Cat s$, "." : Inc c%, -300
 End Select
 sys.format_version$ = s$ + Str$(c%)
End Function

Sub sys.override_break(callback$)
 sys.break_flag% = 0
 Option Break 4
 If Len(callback$) Then
  Execute "On Key 3, " + callback$ + "()"
 Else
  On Key 3, sys.break_handler()
 EndIf
End Sub

Sub sys.break_handler()
 Inc sys.break_flag%
 If sys.break_flag% > 1 Then
  sys.restore_break()
  End
 EndIf
End Sub

Sub sys.restore_break()
 sys.break_flag% = 0
 On Key 3, 0
 Option Break 3
End Sub

' ---- ../../mmbasic-third-party/pico-vaders/../splib/system.inc
' ../../mmbasic-third-party/pico-vaders/../splib/ctrl.inc ++++
' Copyright (c) 2022-2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Const ctrl.R      = &h01
Const ctrl.START  = &h02
Const ctrl.HOME   = &h04
Const ctrl.SELECT = &h08
Const ctrl.L      = &h10
Const ctrl.DOWN   = &h20
Const ctrl.RIGHT  = &h40
Const ctrl.UP     = &h80
Const ctrl.LEFT   = &h100
Const ctrl.ZR     = &h200
Const ctrl.X      = &h400
Const ctrl.A      = &h800
Const ctrl.Y      = &h1000
Const ctrl.B      = &h2000
Const ctrl.ZL     = &h4000
Const ctrl.OPEN  = -1
Const ctrl.CLOSE = -2
Const ctrl.SOFT_CLOSE = -3
Const ctrl.PULSE = 0.001
Const ctrl.UI_DELAY = 200
Dim ctrl.open_drivers$
Dim ctrl.key_type%
Dim ctrl.key_map%(31 + Mm.Info(Option Base))

Sub ctrl.init_keys(use_inkey%, period%, nbr%)
 ctrl.term_keys()
 ctrl.key_type% = 0
 On Key ctrl.on_key()
End Sub

Sub ctrl.on_key()
 Poke Var ctrl.key_map%(), Asc(LCase$(Inkey$)), 1
End Sub

Sub ctrl.term()
 ctrl.term_keys()
 On Error Ignore
 Do While Len(ctrl.open_drivers$)
  Call Field$(ctrl.open_drivers$, 1), ctrl.CLOSE
 Loop
 On Error Abort
End Sub

Sub ctrl.term_keys()
 On Key 0
 Memory Set Peek(VarAddr ctrl.key_map%()), 0, 256
 Do While Inkey$ <> "" : Loop
End Sub

Function ctrl.keydown%(i%)
 ctrl.keydown% = Peek(Var ctrl.key_map%(), i%)
 If ctrl.key_type% = 0 Then Poke Var ctrl.key_map%(), i%, 0
End Function

Function ctrl.poll_multiple$(drivers$(), mask%, duration%, key%)
 Local expires% = Choice(duration%, Timer + duration%, &h7FFFFFFFFFFFFFFF), i%
 Do
  For i% = Bound(drivers$(), 0) To Bound(drivers$(), 1)
   key% = ctrl.poll_single%(drivers$(i%), mask%)
   If key% Then ctrl.poll_multiple$ = drivers$(i%) : Exit Do
  Next
 Loop While Timer < expires%
 If duration% Then duration% = Max(0, expires% - Timer)
End Function

Function ctrl.poll_single%(driver$, mask%)
 On Error Ignore
 Call driver$, ctrl.OPEN
 If Mm.ErrNo = 0 Then
  Local key%, t% = Timer + 5
  Do
   Call driver$, key%
   ctrl.poll_single% = key% And mask%
   If ctrl.poll_single% Then
    Do While key% : Pause 5 : Call driver$, key% : Loop
    Exit Do
   EndIf
  Loop While Timer < t%
  Call driver$, ctrl.SOFT_CLOSE
 EndIf
 On Error Abort
End Function

Sub ctrl.wait_until_idle(d1$, d2$, d3$, d4$, d5$)
 Local k%
 Do
  Call d1$, k%
  If Not k% Then If Len(d2$) Then Call d2$, k%
  If Not k% Then If Len(d3$) Then Call d3$, k%
  If Not k% Then If Len(d4$) Then Call d4$, k%
  If Not k% Then If Len(d5$) Then Call d5$, k%
  If Not k% Then Exit Do
  Pause 5
 Loop
End Sub

Sub keys_cursor(x%)
 If x% < 0 Then Exit Sub
 x% =    ctrl.keydown%(32)  * ctrl.A
 Inc x%, ctrl.keydown%(128) * ctrl.UP
 Inc x%, ctrl.keydown%(129) * ctrl.DOWN
 Inc x%, ctrl.keydown%(130) * ctrl.LEFT
 Inc x%, ctrl.keydown%(131) * ctrl.RIGHT
End Sub

Sub keys_cursor_ext(x%)
 If x% < 0 Then Exit Sub
 x% =    ctrl.keydown%(32)  * ctrl.A
 Inc x%, ctrl.keydown%(98)  * ctrl.B
 Inc x%, (ctrl.keydown%(101) Or ctrl.keydown%(113)) * ctrl.SELECT
 Inc x%, ctrl.keydown%(115) * ctrl.START
 Inc x%, ctrl.keydown%(128) * ctrl.UP
 Inc x%, ctrl.keydown%(129) * ctrl.DOWN
 Inc x%, ctrl.keydown%(130) * ctrl.LEFT
 Inc x%, ctrl.keydown%(131) * ctrl.RIGHT
End Sub

Sub ctrl.open_driver(d$)
 Cat ctrl.open_drivers$, d$ + ","
End Sub

Sub ctrl.close_driver(d$)
 Local idx% = InStr(ctrl.open_drivers$, d$)
 Select Case idx%
  Case 0
  Case 1
   ctrl.open_drivers$ = Mid$(ctrl.open_drivers$, Len(d$) + 2)
  Case Else
   ctrl.open_drivers$ = Mid$(ctrl.open_drivers$, 1, idx% - 1) + Mid$(ctrl.open_drivers$, idx% + Len(d$) + 1)
 End Select
End Sub

Sub ctrl.gamemite(x%)
 Select Case x%
  Case >= 0
   x% = Port(GP12,2,GP11,2,GP8,1,GP8,1,GP11,1,GP10,1,GP9,1,GP13,3,GP13,3)
   x% = (x% Xor &h7FFF) And &h29EA
   Exit Sub
  Case ctrl.OPEN
   Local i%
   For i% = 8 To 15 : SetPin Mm.Info(PinNo "GP" + Str$(i%)), Din, PullUp : Next
   ctrl.open_driver("ctrl.gamemite")
  Case ctrl.CLOSE, ctrl.SOFT_CLOSE
   Local i%
   For i% = 8 To 15 : SetPin Mm.Info(PinNo "GP" + Str$(i%)), Off : Next
   ctrl.close_driver("ctrl.gamemite")
 End Select
End Sub

Function str.wwrap$(s$, p%, len%)
 Const slen% = Len(s$)
 Local ch%, q%, word$
 For q% = p% To slen% + 1
  ch% = Choice(q% > slen%, 0, Peek(Var s$, q%))
  Select Case ch%
   Case 0, &h0A, &h0D, &h20
    If Len(str.wwrap$) + Len(word$) > len% Then
     If Len(word$) > len% Then
      word$ = Left$(word$, len% - Len(str.wwrap$))
      Cat str.wwrap$, word$
      Inc p%, Len(word$)
     EndIf
     Exit For
    EndIf
    Cat str.wwrap$, word$
    p% = q% + 1
    Select Case ch%
     Case &h0D
      If Choice(p% > slen%, 0, Peek(Var s$, p%)) = &h0A Then Inc p%
      Exit For
     Case &h20
      If Len(str.wwrap$) = len% Then Exit For
      Cat str.wwrap$, " "
      word$ = ""
     Case Else
      Exit For
    End Select
   Case Else
    Cat word$, Chr$(ch%)
  End Select
 Next
 p% = Min(p%, slen% + 1)
End Function

' ---- ../../mmbasic-third-party/pico-vaders/../splib/string.inc
' ../../mmbasic-third-party/pico-vaders/../splib/msgbox.inc ++++
' Copyright (c) 2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Const msgbox.NO_PAGES = &h01

Function msgbox.show%(x%, y%, w%, h%, msg$, buttons$(), default%, ctrl$, fg%, bg%, frame%, flags%)
 Const base% = Mm.Info(Option Base), num% = Bound(buttons$(), 1) - base% + 1
 Local i%, btn_x%(num%), p% = 1
 btn_x%(base%) = x% + 2
 For i% = base% + 1 To base% + num% - 1
  btn_x%(i%) = btn_x%(i% - 1) + Len(buttons$(i% - 1)) + 5
 Next
 msgbox.box(x%, y%, w%, h%, 1, Choice(frame% = -1, fg%, frame%), bg%)
 i% = y% + 2
 Do While p% <= Len(msg$)
  msgbox.print_at(x% + 2, i%, str.wwrap$(msg$, p%, w% - 4), fg%, bg%)
  Inc i%
 Loop
 Local key%, released%, valid% = 1
 msgbox.show% = default%
 Do
  If sys.break_flag% Then msgbox.show% = default% : Exit Function
  If valid% Then
   For i% = base% To base% + num% - 1
    msgbox.button(btn_x%(i%), y% + h% - 4, buttons$(i%), i% = msgbox.show%, fg%, bg%)
   Next
   If Not flags% And msgbox.NO_PAGES Then FrameBuffer Copy F , N
   valid% = 0
  EndIf
  Call ctrl$, key%
  If Not key% Then keys_cursor(key%)
  If Not key% Then released% = 1 : Continue Do
  If Not released% Then key% = 0 : Continue Do
  valid% = 0
  Select Case key%
   Case ctrl.A, ctrl.SELECT
    key% = ctrl.SELECT
    valid% = 1
   Case ctrl.LEFT
    If msgbox.show% > 0 Then Inc msgbox.show%, -1 : valid% =1
   Case ctrl.RIGHT
    If msgbox.show% < num% - 1 Then Inc msgbox.show% : valid% =1
  End Select
  msgbox.beep(valid%)
  Pause ctrl.UI_DELAY - 100
 Loop Until key% = ctrl.SELECT
 ctrl.wait_until_idle(ctrl$, "keys_cursor")
End Function

Sub msgbox.button(x%, y%, txt$, selected%, fg%, bg%)
 msgbox.box(x%, y%, Len(txt$) + 4, 3, 0, fg%, bg%)
 Const fg_% = Choice(selected%, bg%, fg%)
 Const bg_% = Choice(selected%, fg%, bg%)
 msgbox.print_at(x% + 2, y% + 1, txt$, fg_%, bg_%)
End Sub

Sub msgbox.box(x%, y%, w%, h%, dbl%, fg%, bg%)
 Const fh% = Mm.Info(FontHeight), fw% = Mm.Info(FontWidth)
 Local d% = fw% \ 2
 Box x% * fw%, y% * fh%, w% * fw%, h% * fh%, , bg%, bg%
 Box x% * fw% + d%, y% * fh% + d%, w% * fw% - 2 * d%, h% * fh% - 2 * d%, 1, fg%
 Inc d%, d%
 If dbl% Then Box x% * fw% + d%, y% * fh% + d%, w% * fw% - 2 * d%, h% * fh% - 2 * d%, 1, fg%
End Sub

Sub msgbox.print_at(x%, y%, s$, fg%, bg%)
 Text x% * Mm.Info(FontWidth), y% * Mm.Info(FontHeight), s$, , , , fg%, bg%
End Sub

Sub msgbox.beep(valid%)
 If valid% Then
  Local notes!(3) = (987.77, 1567.98, 1975.53, 30.87)
 Else
  Local notes!(4) = (1046.50, 987.77, 739.99, 698.46, 30.87)
 EndIf
 Play Stop
 Local i%
 For i% = Bound(notes!(), 0) To Bound(notes!(), 1)
  If notes!(i%) > 16.0 Then Play Sound 4, B, S, notes!(i%), 25
  Pause 40
 Next
 Play Stop
End Sub

' ---- ../../mmbasic-third-party/pico-vaders/../splib/msgbox.inc
' ../../mmbasic-third-party/pico-vaders/../splib/gamemite.inc ++++
' Copyright (c) 2023 Thomas Hugo Williams
' License MIT <https://opensource.org/licenses/MIT>
Function gamemite.file$(f$)
 If InStr("A:/B:/", UCase$(Left$(f$, 3))) Then
  gamemite.file$ = f$
 Else
  Local f_$ = "A:/GameMite" + Choice(f$ = "", "", "/" + f$), x%
  x% = Mm.Info(Exists File f_$)
  If Not x% Then
   f_$ = "B" + Mid$(f_$, 2)
   On Error Skip
   x% = Mm.Info(Exists File f_$)
  EndIf
  If Not x% Then f_$ = "A" + Mid$(f_$, 2)
  gamemite.file$ = f_$
 EndIf
End Function

Sub gamemite.end(break%)
 FrameBuffer Write N
 Colour Rgb(White), Rgb(Black)
 Cls
 sys.restore_break()
 On Error Skip : sound.term()
 On Error Skip : ctrl.term()
 On Error Skip
 twm.enable_cursor(1)
 If break% Then
  Const f$ = "", msg$ = "Exited due to Ctrl-C"
 Else
  Const f$ = gamemite.file$("menu.bas")
  Const x% = Mm.Info(Exists File f$)
  Const msg$ = Choice(x%, "Loading menu ...", "Menu program not found!")
 EndIf
 Text 160, 110, msg$, CM
 If Len(f$) Then Run f$ Else End
End Sub

' ---- ../../mmbasic-third-party/pico-vaders/../splib/gamemite.inc
sys.override_break("break_cb")
Dim CONTROLLERS$(1) = ("keys_cursor_ext", "ctrl.gamemite")
Const VERSION_STRING$ = "Game*Mite Version " + sys.format_version$(VERSION)
ctrl.init_keys()
FrameBuffer Create
Font 1
Const HIGH_SCORE_FILENAME$ = "A:/high-scores/pico-vaders.csv"
Const X_MAX% = 204
Dim ctrl$
Dim alien$(3, 2)
Dim aliens%(55, 4)
Dim ply$(3)
Dim bnk%(4, 2, 8)
Dim a_bomb%(10, 4)
Dim noise%(200)
Dim uxpl%(3)
Dim snd%(4) = (100, 90, 85, 80, 70)
Dim udir%
Dim ux%
Dim ua%
Dim uscr%
Dim UfoSndMin% = 800, UfoSndMax% = 1100, UfoSnd% = 800, Ustp% = 100
Dim anr% = 55
Dim myst% = 0
Dim score%
Dim high_score%
Dim mvsnd% = 0
Dim adir% = 1
Dim ba%, bx%, by%
Dim plx%
Dim a_ground%
Dim num_aliens%
Dim trn%
Dim plhit%
Dim bombs_out%
Dim next_frame%
Dim game_over%
Dim y_pos%
Dim xpl$
Dim uf1$, uf2$
Dim level%
Dim lives%
Dim anim%
Dim tick%
Dim bn%
Dim bmax%
Dim dummy%
init_gfx()
init_sound()
read_high_score()
Cls
new_game_label:
intro()
Call ctrl$, ctrl.OPEN
ctrl.wait_until_idle(ctrl$)
plx% = 103 : y_pos% = 48
anim% = 1 : tick% = 1
level% = 1 : lives% = 3 : score% = 0 : game_over% = 0
next_level_label:
num_aliens% = 55
bn% = 1
bmax% = Min(2 + Int(level% / 2), 10)
ua% = 0
setup_aliens()
draw_screen()
next_life_label:
plhit% = 0
clear_bombs()
Box 72, 232, 40, 8, 1, 0, 0
If lives% > 1 Then Gui Bitmap 72, 232, ply$(1), 16, 8, 1, Rgb(Green), 0
If lives% > 2 Then Gui Bitmap 88, 232, ply$(1), 16, 8, 1, Rgb(Green), 0
Do
 next_frame% = Timer + 15
 move_single()
 draw_player()
 move_player()
 draw_bullet()
 draw_bomb()
 If Not(tick% Mod 16) Then drop_bomb()
 If Not(tick% Mod 4) Then draw_ufo()
 Inc tick%
 start_ufo()
 If num_aliens% = 0 Then Exit Do
 If plhit% Then Exit Do
 If a_ground% Then expl_player() : game_over% = 1 : Exit Do
 Inc bn% : If bn% > bmax% Then bn% = 1
 Do While Timer < next_frame% : Loop
Loop
If plhit% Then
 explode_player()
 Inc lives%, -1
 If lives% = 0 Then game_over% = 1 : Goto game_over_label
 dummy% = twait%(2000)
 Goto next_life_label
EndIf
If num_aliens% = 0 Then
 Inc level%
 If level% < 6 Then Inc y_pos%, 8
 dummy% = twait%(2000)
 Goto next_level_label
EndIf
game_over_label:
If game_over% Then
 write_high_score()
 show_game_over()
 Goto new_game_label
EndIf

Sub init_gfx()
 Local a%, al%, i%, n%
 Restore sr1
 For al% = 1 To 3
  For i% = 1 To 2
   alien$(al%, i%) = ""
   For n% = 1 To 16
    Read a%
    Cat alien$(al%, i%), Chr$(a%)
   Next
  Next
 Next
 For i% = 1 To 3
  ply$(i%) = ""
  For n% = 1 To 16 : Read a% : Cat ply$(i%), Chr$(a%) : Next
 Next
 Restore xpld
 xpl$ = ""
 For n% = 1 To 16 : Read a% : Cat xpl$, Chr$(a%) : Next
 Restore ufo
 uf1$ = ""
 For n% = 1 To 16 : Read a% : Cat uf1$, Chr$(a%) : Next
 uf2$ = ""
 For n% = 1 To 16 : Read a% : Cat uf2$, Chr$(a%) : Next
End Sub

Sub init_sound()
 Local i%
 For i% = 1 To 200 : noise%(i%) = Int(Rnd * 1000) : Next
End Sub

Sub read_high_score()
 If Mm.Info(Exists File HIGH_SCORE_FILENAME$) Then
  Local s$
  Open HIGH_SCORE_FILENAME$ For Input As #1
  Line Input #1, s$
  high_score% = Val(Field$(s$, 2, ","))
  Close #1
 EndIf
End Sub

Sub write_high_score()
 If Not Mm.Info(Exists Dir "A:/high-scores") Then
  Const drv$ = Mm.Info$(Drive)
  Drive "A:"
  MkDir "A:/high-scores"
  Drive drv$
 EndIf
 Open HIGH_SCORE_FILENAME$ For Output As #1
 Print #1, "PLAYER 1, " Str$(high_score%)
 Close #1
End Sub

Sub clear_bombs()
 Local i%
 For i% = 1 To 10
  If a_bomb%(i%, 3) Then
   Line 50 + a_bomb%(i%, 1), a_bomb%(i%, 2), 50 + a_bomb%(i%, 1), a_bomb%(i%, 2) + 4, , Rgb(Black)
  EndIf
  a_bomb%(i%, 3) = 0
 Next
 bombs_out% = 0
 If ba% Then Line 50 + bx%, by%, 50 + bx%, by% + 4, , Rgb(Black)
 ba% = 0
End Sub

Sub intro()
 Local key%, y%
 If ctrl$ <> "" Then ctrl.wait_until_idle(ctrl$)
 Box 0, 30, 320, 210, , 0, 0
 inc_score(0, 1)
 Const txt$ = "Press START to play"
 Text 160, 216, txt$, CT, , , Rgb(Green)
 Box 50, 229, 220, 1, , , Rgb(Green)
 y% = 30
 Text 144, y%, "PLA"
 Text 176, y% + Mm.Info(FontHeight) - 2 , "Y", I : Inc y%, 18
 If Not key% Then key% = poll_ctrl%(600)
 Text 160, y%, "PICOVADERS", CT : Inc y%, 25
 If Not key% Then key% = poll_ctrl%(600)
 Text 160, y%, "*SCORE ADVANCE TABLE*", CT: Inc y%, 20
 If Not key% Then key% = poll_ctrl%(600)
 Gui Bitmap 104, y%, uf1$, 16, 8, 1, Rgb(Red), 0
 Text 130, y%, "= ? MYSTERY" : Inc y%, 18
 If Not key% Then key% = poll_ctrl%(600)
 Gui Bitmap 104, y%, alien$(1, 1), 16, 8, 1, Rgb(White), 0
 Text 130, y%, "=30 POINTS" : Inc y%, 20
 If Not key% Then key% = poll_ctrl%(600)
 Gui Bitmap 104, y%, alien$(2, 1), 16, 8, 1, Rgb(White), 0
 Text 130, y%, "=20 POINTS" : Inc y%, 20
 If Not key% Then key% = poll_ctrl%(600)
 Gui Bitmap 104, y%, alien$(3, 1), 16, 8, 1, Rgb(White), 0
 Text 130, y%, "=10 POINTS" : Inc y%, 2 * Mm.Info(FontHeight)
 If Not key% Then key% = poll_ctrl%(600)
 If InStr(Mm.Device$, "PicoMite") Then Font 7
 Text 160, y%, "(C) 1978 BY TAITO", CT
 Inc y%, Mm.Info(FontHeight) + 1
 Text 160, y%, UCase$(VERSION_STRING$), CT
 Inc y%, Mm.Info(FontHeight) + 1
 Text 160, y%, "2022-2023 BY MARTIN HERHAUS", CT
 Font 1
 If Not key% Then key% = poll_ctrl%(2000)
 Local x% = 271
 Do While (x% > 177) And (Not key%)
  key% = intro_alien%(x%, -1)
 Loop
 Do While (x% < 278) And (Not key%)
  Text x% + 1, 40, "Y", I
  key% = intro_alien%(x%, 1)
 Loop
 Do While (x% > 176) And (Not key%)
  Text x% - 7, 30, "Y"
  key% = intro_alien%(x%, -1)
 Loop
 Do While (x% < 270) And (Not key%)
  key% = intro_alien%(x%, 1)
 Loop
 Text 168, 30, "Y"
 Box 174, 30, 320 - 174, 10, , 0, 0
 If key% Then
  msgbox.beep(1)
  Pause 1000
 Else
  key% = poll_ctrl%()
  msgbox.beep(1)
 EndIf
End Sub

Function intro_alien%(x%, dir%)
 Inc x%, dir%
 Select Case x%
  Case < 270
   Gui Bitmap x%, 30, alien$(1, 1 + (x% Mod 2)), 16, 8, 1, Rgb(White), 0
  Case 270
   Gui Bitmap x%, 30, alien$(1, 1 + (x% Mod 2)), 16, 8, 1, Rgb(Black), 0
 End Select
 intro_alien% = poll_ctrl%(30)
End Function

Function poll_ctrl%(duration%)
 Local d% = duration%
 Do While d% > 0 Or duration% = 0
  ctrl$ = ctrl.poll_multiple$(CONTROLLERS$(), ctrl.A Or ctrl.START Or ctrl.SELECT, d%, poll_ctrl%)
  If poll_ctrl% <> ctrl.SELECT Then Exit Do
  Call ctrl$, ctrl.OPEN
  on_quit()
  Call ctrl$, ctrl.CLOSE
  poll_ctrl% = 0
 Loop
End Function

Function twait%(duration%, mask%)
 Local t% = Timer + duration%
 Do While Timer < t%
  Call ctrl$, twait%
  If twait% = ctrl.SELECT Then on_quit()
  twait% = twait% And mask%
  If twait% Then Exit Do
  Pause 5
 Loop
End Function

Sub on_quit()
 msgbox.beep(1)
 Local buttons$(1) Length 3 = ("Yes", "No")
 Const msg$ = "    Quit game?"
 Const x% = 9, y% = 5, fg% = Rgb(White), bg% = Rgb(Black), frame% = Rgb(Green)
 FrameBuffer Copy N , F
 Const a% = msgbox.show%(x%, y%, 22, 9, msg$, buttons$(), 1, ctrl$, fg%, bg%, frame%, msgbox.NO_PAGES)
 If buttons$(a%) = "Yes" Then end_program()
 FrameBuffer Copy F , N
 ctrl.wait_until_idle(ctrl$)
End Sub

Sub break_cb()
 end_program(1)
End Sub

Sub end_program(break%)
 gamemite.end(break%)
End Sub

Sub start_ufo()
 ufo_x()
 If myst% > 20 And ua% = 0 Then
  ua% = 1
  myst% = 0
  udir% = Choice(Int(Rnd * 2) = 1, -2, 2)
  ux% = Choice(udir% = 2, 0, X_MAX%)
  Select Case Int(Rnd * 10)
   Case 7 To 8 : uscr% = 100
   Case 9 :      uscr% = 150
   Case Else:    uscr% = 50
  End Select
 EndIf
End Sub

Sub drop_bomb()
 If bombs_out% >= bmax% Then Exit Sub
 Local aln%
 For aln% = 55 To 1 Step -1
  If Not aliens%(aln%, 4) Then Continue For
  For bn% = 1 To 10
   If a_bomb%(bn%, 3) Then
    If a_bomb%(bn%, 4) = aln% Then bn% = 0 : Exit For
   EndIf
  Next
  If Not bn% Then Continue For
  Select Case aliens%(aln%, 1)
   Case < plx% - 8, > plx% + 8
    If Int(Rnd * 25) Then Continue For
  End Select
  If aln% > 44 Then Exit For
  If Not aliens%(aln% + 11, 4) Then Exit For
 Next
 If Not aln% Then Exit Sub
 For bn% = 1 To 10
  If Not a_bomb%(bn%, 3) Then
   a_bomb%(bn%, 1) = aliens%(aln%, 1) + 8
   a_bomb%(bn%, 2) = aliens%(aln%, 2) + 6
   a_bomb%(bn%, 3) = 1
   a_bomb%(bn%, 4) = aln%
   Inc bombs_out%
   Exit For
  EndIf
 Next
End Sub

Sub draw_bomb()
 Local i%
 For i% = 1 To 10
  If a_bomb%(i%, 3) = 1 Then
   Line 50 + a_bomb%(i%, 1), a_bomb%(i%, 2), 50 + a_bomb%(i%, 1), a_bomb%(i%, 2) + 4, , 0
   Inc a_bomb%(i%, 2), 1
   If hit_bunker%(a_bomb%(i%, 1), a_bomb%(i%, 2) + 4) Then
    a_bomb%(i%, 3) = 0
    Inc bombs_out%, -1
    Exit Sub
   EndIf
   If a_bomb%(i%, 2) > 224 Then
    a_bomb%(i%, 3) = 0
    Inc bombs_out%, -1
    Exit Sub
   EndIf
   Line 50 + a_bomb%(i%, 1), a_bomb%(i%, 2), 50 + a_bomb%(i%, 1), a_bomb%(i%, 2) + 4, , Rgb(Yellow)
   If ba% Then
    Select Case a_bomb%(i%, 1)
     Case bx% - 2 To bx% + 2
      Select Case a_bomb%(i%, 2)
       Case by% - 4 To by%
        ba% = 0 : a_bomb%(i%, 3) = 0
        Inc bombs_out%, -1
        explode(42 + a_bomb%(i%, 1), a_bomb%(i%, 2), 0)
        Exit Sub
      End Select
    End Select
   EndIf
   If a_bomb%(i%, 2) > 210 Then
    If a_bomb%(i%, 1) >= plx% And a_bomb%(i%, 1) < plx% + 16 Then plHit% = 1
   EndIf
  EndIf
 Next
End Sub

Sub draw_ufo()
 If ua% = 0 Then Exit Sub
 Play Tone UfoSnd%, UfoSnd%, 150
 Inc UfoSnd%, Ustp%
 If UfoSnD% = UfoSndMin% Or UfoSnd% > UfoSndMax% Then Ustp% = -Ustp%
 Box 50 + ux%, 32, 16, 10, , 0, 0
 Inc ux%, udir%
 If ux% > X_MAX% Or ux% < 0 Then ua% = 0 : Exit Sub
 Gui Bitmap 50 + ux%, 32, uf1$, 16, 8, 1, Rgb(Red), 0
End Sub

Sub ufo_x()
 If Not Uxpl%(1) Then Exit Sub
 Inc Uxpl%(3)
 Play Tone 900 + 15 * Uxpl%(3), 900 + 15 * Uxpl%(3), 100
 Select Case uxpl%(3)
  Case 40
   Text 58 + uxpl%(2), 30, " " + Str$(uscr%) + " ", C, , , Rgb(Red)
  Case 70
   Text 58 + uxpl%(2), 30, " " + Str$(uscr%) + " ", C, , , Rgb(Black)
   Uxpl%(1) = 0
   Uxpl%(3) = 0
   inc_score(uscr%)
 End Select
End Sub

Sub draw_bunkers()
 Local i%, j%
 For i% = 0 To 3
  draw_bunker(80 + i% * 45, 184)
  For j% = 1 To 8
   bnk%(i% + 1, 1, j%) = 1
   bnk%(i% + 1, 2, j%) = 1
  Next
 Next
End Sub

Sub draw_bunker(bx%, by%)
 Box bx%, by% + 4, 22, 12, , Rgb(Green), Rgb(Green)
 Box bx% + 1, by% + 3, 20, 1, , Rgb(Green), Rgb(Green)
 Box bx% + 2, by% + 2, 18, 1, , Rgb(Green), Rgb(Green)
 Box bx% + 3, by% + 1, 16, 1, , Rgb(Green), Rgb(Green)
 Box bx% + 4, by%, 14, 1, , Rgb(Green), Rgb(Green)
 Box bx% + 5, by% + 14, 12, 2, , 0, 0
 Box bx% + 6, by% + 13, 10, 1, , 0, 0
 Box bx% + 7, by% + 12, 8, 1, , 0, 0
End Sub

Function hit_bunker%(TsX%, Tsy%)
 Local bhx%, bhy%
 Select Case TsY%
  Case 184 To 200
   Select Case TsX%
    Case 30 To 51
     bhy% = Int((Tsy% - 184) / 8)
     bhx% = 1 + Int((TsX% - 30) / 3)
     If Bnk%(1, bhy%, bhx%) = 1 Then
      Bnk%(1, bhy%, bhx%) = 0
      hit_bunker% = 1
      Line 50 + TsX%, Tsy%, 50 + TsX%, TsY% + 4, , 0
      debunk 50 + TsX%, tsy%
     EndIf
    Case 75 To 96
     bhy% = Int((TsY% - 184) / 8)
     bhx% = 1 + Int((TsX% - 75) / 3)
     If Bnk%(2, bhy%, bhx%) = 1 Then
      Bnk%(2, bhy%, bhx%) = 0
      hit_bunker% = 2
      Line 50 + TsX%, Tsy%, 50 + TsX%, TsY% + 4, , 0
      debunk 50 + TsX%, TsY%
     EndIf
    Case 120 To 141
     bhy% = Int((TsY% - 184) / 8)
     bhx% = 1 + Int((TsX% - 120) / 3)
     If Bnk%(3, bhy%, bhx%) = 1 Then
      Bnk%(3, bhy%, bhx%) = 0
      hit_bunker% = 3
      Line 50 + TsX%, Tsy%, 50 + TsX%, TsY% + 4, , 0
      debunk 50 + TsX%, TsY%
     EndIf
    Case 165 To 186
     bhy% = Int((TsY% - 184) / 8)
     bhx% = 1 + Int((TsX% - 165) / 3)
     If Bnk%(4, bhy%, bhx%) = 1 Then
      Bnk%(4, bhy%, bhx%) = 0
      hit_bunker% = 4
      Line 50 + TsX%, Tsy%, 50 + TsX%, TsY% + 4, , 0
      debunk 50 + TsX%, TsY%
     EndIf
   End Select
 End Select
End Function

Sub debunk(x%, y%)
 Local i%
 For i% = 1 To 40 : Pixel x% - 3 + Rnd * 8, y% - 5 + Rnd * 8, 0 : Next
End Sub

Sub draw_bullet()
 If Not ba% Then Exit Sub
 Line 50 + bx%, by%, 50 + bx%, by% + 4, , Rgb(Black)
 Inc by%, -2
 If by% <= 32 Then ba% = 0 : Exit Sub
 Line 50 + bx%, by%, 50 + bx%, by% + 4, , Rgb(White)
 If by% Mod 8 Then Exit Sub :
 If collision%(bx%, by%) Then
  Line 50 + bx%, by%, 50 + bx%, by% + 4, , 0
  ba% = 0
 EndIf
 If hit_bunker%(bx%, by%) Then ba% = 0 : Exit Sub
 If ua% Then
  Select Case by%
   Case 32 To 40
    Select Case bx%
     Case ux% To ux% + 15
      uxpl%(1) = 1 : uxpl%(2) = ux% : uxpl%(3) = 0
      Gui Bitmap 50 + ux%, 32, uf2$, 16, 8, 1, Rgb(Red), 0
      ua% = 0
    End Select
  End Select
 EndIf
End Sub

Function collision%(x%, y%)
 Local ax%, ay%, i%
 Select Case y%
  Case y_pos% + 16 To 214
   For i% = 1 To 55
    If aliens%(i%, 4) Then
     ax% = aliens%(i%, 1) : ay% = aliens%(i%, 2)
     Select Case x%
      Case ax% + 1 To ax% + 13
       Select Case y%
        Case ay% To ay% + 7
         collision% = 1
         explode(ax% + 50, ay%, 1)
         aliens%(i%, 4) = 0
         Inc num_aliens%, -1
         inc_score(40 - (10 * aliens%(i%, 3)))
         Exit Function
       End Select
     End Select
    EndIf
   Next i%
 End Select
End Function

Sub inc_score(delta%, full%)
 Inc score%, delta%
 high_score% = Max(score%, high_score%)
 print_score_at(74, 16, score%)
 If (score% = high_score%) Or full% Then print_score_at(214, 16, high_score%)
 If full% Then Text 58, 0, "SCORE<1>" : Text 198, 0, "HI-SCORE"
End Sub

Sub print_score_at(x%, y%, score%)
 Local s$ = Str$(score%)
 If Len(s$) < 4 Then s$ = String$(4 - Len(s$), "0") + s$
 Text x%, y%, s$
End Sub

Sub explode(x%, y%, snd%)
 Local i%
 Gui Bitmap x%, y%, xpl$, 16, 8, 1, Rgb(Yellow), 0
 draw_ufo()
 If snd% = 1 Then
  For i% = 1 To 75
   Play Tone noise%(i%), noise%(i%), 2
   Pause 1
  Next
  Play Stop
 Else
  Pause 20
 EndIf
 draw_ufo()
 Box x%, y%, 16, 10, , 0, 0
End Sub

Sub move_player()
 Local i%, key%
 Call ctrl$, key%
 Select Case key%
  Case 0
   Exit Sub
  Case ctrl.LEFT
   If plx% > 16 Then Inc plx%, -1
  Case ctrl.RIGHT
   If plx% < 188 Then Inc plx%, 1
  Case ctrl.A
   If ba% Then Exit Sub
   If Not ua% Then Inc myst%, Int(Rnd * 3)
   ba% = 1 : bx% = plx% + 7 : by% = 210
   For i% = 1000 To 1 Step -50 : Play Tone 1000 + i%, 1000 + i%, 5 : Pause 2 : Next
  Case ctrl.SELECT, ctrl.START
   on_quit()
 End Select
End Sub

Sub draw_player()
 Gui Bitmap 50 + plx%, 214, ply$(1), 16, 8, 1, Rgb(Green), 0
End Sub

Sub explode_player()
 Local i%, nse%
 For i% = 1 To 3
  Gui Bitmap 50 + plx%, 214, ply$(2), 16, 8, 1, Rgb(Green), 0
  For nse% = 1 To 100 : Play Tone noise%(nse%), noise%(nse%), 2 : Pause 1 : Next
  Gui Bitmap 50 + plx%, 214, ply$(3), 16, 8, 1, Rgb(Green), 0
  For nse% = 100 To 200 : Play Tone noise%(nse%), noise%(nse%), 2 : Pause 1 : Next
 Next
 For nse% = 1 To 200 : Play Tone noise%(nse%), noise%(nse%), 2 : Pause 1 : Next
 Play Stop
 dummy% = twait%(500)
 clear_bombs()
 Box 50 + plx%, 214, 16, 10, , 0, 0
End Sub

Sub setup_aliens()
 Local at%, num% = 1, r%, n%
 a_ground% = 0
 For r% = 1 To 5
  Select Case r%
   Case 1:    at% = 1
   Case 2, 3: at% = 2
   Case Else: at% = 3
  End Select
  For n% = 1 To 11
   aliens%(num%, 1) = n% * 16
   aliens%(num%, 2) = y_pos% + r% * 16
   aliens%(num%, 3) = at%
   aliens%(num%, 4) = 1
   Inc num%
  Next
 Next
 trn% = 0
End Sub

Sub draw_screen()
 Cls
 Box 50, 229, 220, 1, , , Rgb(Green)
 inc_score(0, 1)
 Text 46, 230, Str$(level%)
 draw_bunkers()
End Sub

Sub draw_aliens()
 Local i%, ax%, ay%, at%
 For i% = 55 To 1 Step -1
  ax% = 50 + aliens%(i%, 1)
  ay% = aliens%(i%, 2)
  at% = aliens%(i%, 3)
  If aliens%(i%, 4) Then
   Box ax%, ay%, 16, 10, , 0, 0
   Gui Bitmap ax%, ay%, alien$(at%, anim%), 16, 8, 1, Rgb(White), 0
  EndIf
 Next
End Sub

Sub move_single()
 Do While Not aliens%(anr%, 4)
  Inc anr%, -1
  If anr% < 1 Then
   anr% = 55
   If trn% = 1 Then adir% = -adir% : down_aliens() : draw_aliens() : trn% = 0
   Inc mvsnd% : mvsnd% = mvsnd% And 3
   If Not ua% Then Play Tone snd%(mvsnd% + 1), snd%(mvsnd% + 1), 80
   anim% = Choice(anim% = 1, 2, 1)
  EndIf
 Loop
 Local ax% = aliens%(anr%, 1), ay% = aliens%(anr%, 2), at% = aliens%(anr%, 3)
 Box ax% + 50, ay%, 16, 10, , 0, 0
 Inc ax%, adir%
 Gui Bitmap ax% + 50, ay%, alien$(at%, anim%), 16, 8, 1, Rgb(White), 0
 aliens%(anr%, 1) = ax%
 If ax% >= X_MAX% Or ax% < 1 Then trn% = 1
 Inc anr%, -1
End Sub

Sub down_aliens()
 Local ax%, ay%, i%
 For i% = 55 To 1 Step -1
  If aliens%(i%, 4) Then
   ax% = aliens%(i%, 1) : ay% = aliens%(i%, 2)
   Box ax% + 50, ay%, 16, 10, , 0, 0
   aliens%(i%, 2) = ay% + 8
   If ay% + 8 >= 202 Then a_ground% = 1
  EndIf
 Next
End Sub

Sub show_game_over()
 ctrl.wait_until_idle(ctrl$)
 Box 110, 92, 100, 44, 1, 0, 0
 Text 160, 100, "PLAYER<1>", C
 Do
  Text 160, 116, "GAME OVER", C
  If twait%(600, ctrl.A Or ctrl.START) Then Exit Do
  Text 160, 116, "         ", C
  If twait%(600, ctrl.A Or ctrl.START) Then Exit Do
 Loop
End Sub

sr1:
Data 1, 128, 3, 192, 7, 224, 13, 176, 15, 240, 5, 160, 8, 16, 4, 32
Data 1, 128, 3, 192, 7, 224, 13, 176, 15, 240, 2, 64, 5, 160, 10, 80
sr2:
Data 8, 32, 4, 64, 15, 224, 27, 176, 63, 248, 47, 232, 40, 40, 6, 192
Data 8, 32, 36, 72, 47, 232, 59, 184, 63, 248, 31, 240, 8, 32, 16, 16
sr3:
Data 7, 224, 31, 248, 63, 252, 57, 156, 63, 252, 14, 112, 25, 152, 48, 12
Data 7, 224, 31, 248, 63, 252, 57, 156, 63, 252, 14, 112, 25, 152, 12, 48
plyr:
Data 1, 0, 3, 128, 3, 128, 63, 248, 127, 252, 127, 252, 127, 252, 127, 252
Data 2, 0, 0, 16, 2, 160, 18, 0, 1, 176, 69, 168, 31, 228, 63, 245
Data 16, 4, 130, 25, 16, 192, 2, 2, 75, 97, 33, 196, 31, 224, 55, 228
xpld:
Data 4, 64, 34, 136, 16, 16, 8, 32, 96, 12, 8, 32, 18, 144, 36, 72
ufo:
Data 0, 0, 7, 224, 31, 248, 63, 252, 109, 182, 255, 255, 57, 156, 16, 8
ufo_xpl:
Data 148, 10, 64, 48, 143, 24, 31, 206, 58, 167, 143, 140, 5, 24, 136, 136
                                                                    