'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' PicoGamer menu program
Version$ = "1.21"
' save this in Flash Slot 1
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
WatchDog OFF  'just to make sure
Option EXPLICIT
Option DEFAULT INTEGER
Option ESCAPE

'debug
Dim integer debug=0
If debug=0 Then Option AUTORUN 1, NORESET
'debug

Const MaxFileDirs = 13

' codes generated by the buttons
Const bDOWN = &h01
Const bLEFT = &h02
Const bUP = &h04
Const bRIGHT = &h08
Const bSELECT = &h10
Const bSTART = &h20
Const bB = &h40
Const bA = &h80

' battery thresholds
Const BatMedThresh! = 3.42
Const BatLowThresh! = 3.15

' colours
Const cLogo = RGB(255,0,164)
Const cMain = RGB(white)
Const cBack = 0
Const cHint = RGB(cyan)

' global variables
Dim DirName$(20), NbrDirs, FileName$(20), NbrFiles
Dim Highlight, LastHighlight
Dim OnDriveB = 0
Dim i, j, t$, RefreshLCD, BDrive$, BDriveNew$, OnUSB

If debug=0 Then WatchDog 500
Drive "A:"

SetTick 600000, CheckBattery

' init the button inputs
For i = 8 To 15
SetPin MM.Info(PinNo "GP" + Str$(i)), Din, PullUp
Next

Do While GetKey() <> 0 : Loop   ' wait for any key presses to be removed
FRAMEBUFFER CREATE

InitDrive

Do
  ' this code is in a tight loop to keep the code in the CPU cache and avoid
  ' unnecessary refresh of the LCD, both of which cause noise on the power rail
  ' which in turn is amplified as audio noise
  Do
    i = GetKey()
    If i <> 0 Then RefreshLCD = 1
    If OnUSB <> Pin(GP24) Then RefreshLCD = 1
    BDriveNew$ = MM.Info(SDCARD)
    If BDrive$ <> BDriveNew$ Then RefreshLCD = 1
  Loop While RefreshLCD = 0

  If i <> 0 Then
    If i = bUP And Highlight > 0 Then
      Highlight = Highlight - 1
      DrawScreen
      MakeSound 1
    ElseIf i = bDOWN And Highlight < NbrDirs + NbrFiles - 1 Then
      Highlight = Highlight + 1
      DrawScreen
      MakeSound 1
    ElseIf i = bSELECT Or i = bSTART Then
      MakeSound 1
      If Highlight < NbrDirs Then
        If Highlight = 0 And DirName$(0) = "Up One Level" Then
          On Error Skip
          Chdir ".."
          If MM.Errno Then ErrorAbort "Cannot change directory"
        Else
          On Error Skip
          Chdir DirName$(Highlight)
          If MM.Errno Then ErrorAbort "Cannot change directory"
        EndIf
        ReadDirTree
        InitScreen
        DrawScreen
      Else
        WatchDog OFF
        CLS
        Text 160, 120, "Loading " + FileName$(Highlight - NbrDirs), CM, 1, 1, RGB(yellow), 0
        On Error Skip
        Run FileName$(Highlight - NbrDirs)
        If MM.Errno Then ErrorAbort "Cannot run " + FileName$(Highlight - NbrDirs)
      EndIf
    ElseIf i = bB And BDriveNew$ = "Ready"  And OnDriveB = 0 Then
      MakeSound 1
      Drive "B:"
      Chdir "/"
      OnDriveB = 1
      InitDrive
    ElseIf i = bA And Left$(Cwd$, 1) = "B" Then
      MakeSound 1
      Drive "A:"
      Chdir "/"
      OnDriveB = 0
      InitDrive
    Else
      MakeSound 0
    EndIf
  EndIf

  If OnDriveB And BDriveNew$ <> "Ready" Then
    MakeSound 0
    Drive "A:"
    Chdir "/"
    OnDriveB = 0
    InitDrive
  EndIf

  DrawScreen

Loop



Sub InitDrive
  Local DirError
  On Error Skip
  Chdir "/GameMite"
  DirError = MM.Errno

  If DirError Then
    NbrDirs = 0 : NbrFiles = 0
  Else
    ReadDirTree
  EndIf

  InitScreen
  DrawScreen

  If DirError Then
    Text 160, 120, "Cannot find", CB
    Text 160, 120, "/GameMite", CT
  ElseIf NbrDirs + NbrFiles = 0 Then
    Text 160, 120, "No Files", CM
  EndIf
End Sub



Sub ReadDirTree
  Local i, RemoveDir, fn$
  If debug=0 Then WatchDog 1000
  NbrDirs = 0
  If Len(Cwd$) > 12 Then
    DirName$(0) = "Up One Level"
    NbrDirs = 1
  EndIf
  DirName$(NbrDirs) = Dir$("*", DIR)
  Do
    If DirName$(NbrDirs) = "" Then Exit
    If NbrDirs > MaxFileDirs - 1 Then Exit
    NbrDirs = NbrDirs + 1
    DirName$(NbrDirs) = Dir$()
  Loop

  ' check that each sub dir actually holds at least one BASIC program
  If Len(Cwd$) > 12 Then i = 1 Else i = 0
  Do While i < NbrDirs
    RemoveDir = 1
    On Error Skip
    Chdir DirName$(i)               ' change into the dir
    If MM.Errno = 0 Then
      fn$ = ""
      On Error Skip
      fn$ = Dir$("*.bas", FILE)     ' and check for a BASIC file
      If fn$ <> "" Then RemoveDir = 0
      fn$ = Dir$("*.BAS", FILE)
      If fn$ <> "" Then RemoveDir = 0
      Chdir ".."
    EndIf
    If RemoveDir Then
      ' remove the directory if there were no BASIC files
      For j = i To NbrDirs - 2
        DirName$(j) = DirName$(j + 1)
      Next j
      NbrDirs = NbrDirs -1
    Else
      i = i + 1
    EndIf
  Loop

  NbrFiles = 0
  FileName$(NbrFiles) = Dir$("*.*", FILE)
  Do
    If FileName$(NbrFiles) = "" Then Exit
    If NbrFiles > MaxFileDirs - NbrDirs - 1 Then Exit
    If UCase$(Right$(FileName$(NbrFiles), 4)) = ".BAS" And FileName$(NbrFiles) <> "menu.bas" Then NbrFiles = NbrFiles + 1
    FileName$(NbrFiles) = Dir$()
  Loop

  ' sort the arrays
  If Len(Cwd$) > 12 Then
    bblSort DirName$(), 1, NbrDirs - 1
  Else
    bblSort DirName$(), 0, NbrDirs - 1
  EndIf
  bblSort FileName$(), 0, NbrFiles - 1

  Highlight = 0
End Sub


' clear the screen and draw the banner
Sub InitScreen
  CLS
  On Error Skip
  Load IMAGE "A:/GameMite/splash.bmp", 32, 88
  If MM.Errno=0 Then
    WatchDog off : Pause 2000 : CLS
    If debug=0 Then WatchDog 500
  End If
  Text 160, 0, "GameMite", CT, 3, 1, cLogo, cBack
  Text 160, 24, Right$(Cwd$, 42), CT, 1, 1, cLogo, cBack
  LastHighlight = 9999
  RefreshLCD = 1
End Sub


' draw the menu screen except for the banner
' this is called when RefreshLCD = 1
Sub DrawScreen
  Local i, j, t$
  Static Level

  For i = 0 To NbrDirs - 1
    If i = Highlight Then
      Text 160, 50 + i * 12, " " + DirName$(i) + " <DIR> ", CT, 1, 1, cBack, cMain
     Else
      Text 160, 50 + i * 12, " " + DirName$(i) + " <DIR> ", CT, 1, 1, cMain, cBack
     EndIf
  Next i
  For j = 0 To NbrFiles - 1
    If j + i = Highlight Then
      Text 160, 50 + (i + j) * 12, " " + Left$(FileName$(j),  Len(FileName$(j)) - 4) + " ", CT, 1, 1, cBack, cMain
    Else
      Text 160, 50 + (i + j) * 12, " " + Left$(FileName$(j),  Len(FileName$(j)) - 4) + " ", CT, 1, 1, cMain, cBack
    EndIf
  Next j

  If BDriveNew$ = "Ready" Then If Left$(Cwd$, 1) = "A" Then t$ = "   B = SD Card" Else t$ = "  A = Internal Drive"
  Text 160, 238-24, "       Use \146 \147 and SELECT" + t$ + "       ", CT, 1, 1, cHint, cBack

  If Pin(GP24) Then
    Level = 0
    Text 160, 238-12, "     ON USB POWER      ", CT, 1, 1, RGB(cyan), cBack
  ElseIf Pin(GP29) * 3 > BatMedThresh! Then
    If Level < 1 Then Level = 1
  ElseIf Pin(GP29) * 3 > BatLowThresh! Then
    If Level < 2 Then Level = 2
  Else
    If Level < 3 Then Level = 3
  EndIf
  If Level = 1 Then Text 160, 238-12, "  BATTERY LEVEL: HIGH  ", CT, 1, 1, RGB(green), cBack
  If Level = 2 Then Text 160, 238-12, " BATTERY LEVEL: MEDIUM ", CT, 1, 1, RGB(yellow), cBack
  If Level = 3 Then Text 160, 238-12, "  BATTERY LEVEL: LOW   ", CT, 1, 1, RGB(red), cBack

  RefreshLCD = 0
  BDrive$ = BDriveNew$
  OnUSB = Pin(GP24)
End Sub


' get a key input
Function GetKey()
  Static integer lastkey, t1
  Local integer thiskey
  If debug=0 Then WatchDog 500
  thiskey = (Port(GP8, 8) Xor &h7FFF) And &HFF
  If thiskey = 0 Then lastkey = 0 : t1 = &H7FFFFFFFFFFFFFFF : Exit Function
  If thiskey = lastkey Then
    If Timer < t1 Then Exit Function
    t1 = Timer + 75
  Else
    t1 = Timer + 250
  EndIf
  lastkey = thiskey
  GetKey = thiskey
End Function


' make a confirmation sound or an error sound
' from PicoVaders by MARTIN HERHAUS
Sub MakeSound(valid%)
 If valid% Then
  Local notes!(3) = (987.77, 1567.98, 1975.53, 30.87)
 Else
  Local notes!(4) = (1046.50, 987.77, 739.99, 698.46, 30.87)
 EndIf
 Play Stop
 Local i%
 For i% = Bound(notes!(), 0) To Bound(notes!(), 1)
  If notes!(i%) > 16.0 Then Play Sound 4, B, S, notes!(i%), 25
  Pause 40
 Next
 Play Stop
End Sub


Sub ErrorAbort Msg$
  MakeSound 0
  Box 30, 60, 260, 110, 2, RGB(red), 0
  Text 160, 80, "Error", CM, 2, 1, RGB(red), 0
  Text 160, 100, Msg$, CM, 2, 1, RGB(red), 0
  RBox 115, 125, 90, 30, , FG, 0
  Text 160, 140, " RESTART ", CM, 1, 1, 0, FG
  Do While GetKey() <> bSELECT
    If debug=0 Then WatchDog 500
  Loop
  MakeSound 1
  CLS
  Text 160, 120, "Loading Menu", CM, 1, 1, RGB(yellow), 0
  WatchDog OFF
  Flash RUN 1
End Sub


' called every 10 minutes to force a refresh of the LCD.
' this will update the battery level display
Sub CheckBattery
  RefreshLCD = 1
End Sub


' simple bubble sort
Sub bblSort arr$(), st, en
  Local i, j, t$
  If st >= en Then Exit Sub
  For i = st To en
    For j = st To en - i - 1
      If arr$(j) > arr$(j + 1) Then
        t$ = arr$(j)
        arr$(j) = arr$(j + 1)
        arr$(j + 1) = t$
      EndIf
    Next j
  Next i
End Sub
