  ' 2048 Game
  ' Version 1.0.0 for CMMD by William M Leue 22-Feb-2048
  ' original game created in 2014 by Gabrielle Cirulli.
  ' adapt for game*mite by Volhout
  
  ' known bug : end game not always well detected
  
  
  Option default integer
  Option base 1
  
  'for gamemite
  if instr(mm.device$,"VGA")then MODE 2
  if mm.info(platform)="Game*Mite" then gm=1 else gm=0 endif
  
  ' Constants
  Const SIDE   = 4
  Const CSIZE  = 46
  Const BWIDTH = 10
  Const BW     = SIDE*CSIZE
  Const BH     = SIDE*CSIZE
  Const CX     = MM.HRes\2 - (CSIZE*2+CSIZE\2) 'BW\2
  Const CY     = MM.VRes\2 - (CSIZE*2+CSIZE\2+2) 'BH\2
  
  ' Color Indices in Palette
  Const BCX    = 1
  Const CCX    = 2
  
  ' Commands
  Const UP    = 128
  Const DOWN  = 129
  Const LEFT  = 130
  Const RIGHT = 131
  Const ESC   = 27
  Const HOME  = 134
  
  ' Globals
  Dim board(SIDE, SIDE)
  Dim patterns(SIDE*SIDE, SIDE)
  Dim highest_power = 0
  Dim running = 0
  Dim zmap(2)
  
  ' Main Prgram
  'Open "debug.txt" For output As #1
  if gm then gm_init_keys
  MakePallette
  ReadPatterns
  ShowHelp
  InitGame
  HandleEvents
End
  
  ' Make Color Pallette
Sub MakePallette
  zmap(BCX) = RGB(rust)
  zmap(CCX) = RGB(lilac)
  '  map(BCX) = RGB(179, 135, 0)
  '  map(CCX) = RGB(255, 211, 76)
  '  map set
End Sub
  
  ' Read Patterns for Movement
Sub ReadPatterns
  Local i, j
  For i = 1 To SIDE*SIDE
    For j = 1 To SIDE
      Read patterns(i, j)
    Next j
  Next i
End Sub
  
  ' Initialize a Game
Sub InitGame
  Local row, col
  For row = 1 To SIDE
    For col = 1 To SIDE
      board(row, col) = 0
    Next col
  Next row
  highest_power = 1
  CreateRandomValue
  CreateRandomValue
  running = 1
  CLS
  DrawBoard
End Sub
  
  ' Create a random 1 or 2 power in a random vacant cell, if one exists.
Sub CreateRandomValue
  If BoardFull() Then Exit Sub
  Do
    row = RandInt(1, side)
    col = RandInt(1, side)
  Loop Until board(row, col) = 0
  board(row, col) = RandInt(1, 2)
  If board(row, col) > highest_power Then highest_power = board(row, col)
End Sub
  
  ' Draw the Board
Sub DrawBoard
  Local row, col, x, y, s, c, v$
  s = CSIZE + 2*BWIDTH
  s2 = CSIZE + BWIDTH
  For row = 1 To SIDE
    y = CY + (row-1)*s2
    For col = 1 To SIDE
      x = CX + (col-1)*s2
      c = GetCellColor(row, col)
      v$ = GetValue$(row, col)
      DrawCell x, y, s, v$, c
    Next col
  Next row
End Sub
  
  ' Draw a Cell of the Board
Sub DrawCell x, y, s, v$, c
  Local nx, ny
  Box x, y, s, s,, zmap(BCX), zmap(BCX)
  RBox x+BWIDTH, y+BWIDTH, CSIZE, CSIZE,6, 0, c
  nx = x + BWIDTH+CSIZE\2
  ny = y + BWIDTH+CSIZE\2
  If Len(v$) > 0 Then
    Text nx, ny, v$, "CM", 4,, RGB(black), -1
    Text nx+1, ny, v$, "CM", 4,, RGB(black), -1
  EndIf
End Sub
  
  ' Assign a color to a board cell depending on its current value
Function GetCellColor(row, col)
  Local float h, s, v
  Local r, g, b, p
  Local c = zmap(CCX)
  GetCellColor = c
  p = board(row, col)
  If p > 0 Then
    h = 240.0 - 240*((1.0*p)/11.0)
    s = 1.0
    v = 1.0
    HSV2RGB h, s, v, r, g, b
    GetCellColor = RGB(r, g, b)
  EndIf
End Function
  
  ' return the string numeric value of a board cell
  ' if that cell's power >= 1, else return the empty string.
Function GetValue$(row, col)
  Local nx, ny, p, v
  p = board(row, col)
  If p > 0 Then
    v = 2^p
    GetValue$ = Str$(v)
  Else
    GetValue$ = ""
  EndIf
End Function
  
  ' Get User Keyboard Inputs
Sub HandleEvents
  Local z$, cmd
  z$ = gm_Inkey$()
  Do
    Do
      z$ = gm_Inkey$()
    Loop Until z$ <> ""
    cmd = Asc(UCase$(z$))
    If cmd = ESC Then
      CLS
      if gm then run "menu.bas"
      end
    EndIf
    If cmd = HOME Then
      InitGame
    EndIf
    If running Then
      Select Case cmd
        Case UP
          Merge(UP)
        Case DOWN
          Merge(DOWN)
        Case LEFT
          Merge(LEFT)
        Case RIGHT
          Merge(RIGHT)
      End Select
      DrawBoard
    EndIf
    If GameOver() Then
      running = 0
      ShowGameOver
    EndIf
  Loop
End Sub
  
  ' Shift Values and Merge in the specified direction
Sub Merge cmd
  Local row, col
  Select Case cmd
    Case UP
      PushCellsUp
    Case DOWN
      PushCellsDown
    Case LEFT
      PushCellsLeft
    Case RIGHT
      PushCellsRight
  End Select
  CreateRandomValue
End Sub
  
  ' Push cells up and merge
Sub PushCellsUp
  Local row, col, p
  Local pat(SIDE)
  For col = 1 To SIDE
    row = 1
    MatchPattern row, col, 1, 0, pat()
    For row = 1 To SIDE
      p = pat(row)
      If p > 0 Then
        board(row-p, col) = board(row, col)
        board(row, col) = 0
      EndIf
    Next row
    MergeUp col
  Next col
End Sub
  
  ' Merge matching cells upwards
Sub MergeUp col
  Local row, nrow
  For row = 1 To SIDE-1
    If board(row, col) > 0 Then
      If board(row+1, col) = board(row, col) Then
        Inc board(row, col)
        If board(row, col) > highest_power Then highest_power = board(row, col)
        For nrow = row+2 To side
          board(nrow-1, col) = board(nrow, col)
        Next nrow
        board(SIDE, col) = 0
      EndIf
    EndIf
  Next row
End Sub
  
  ' Push cells down and merge
Sub PushCellsDown
  Local row, col, p
  Local pat(SIDE)
  For col = 1 To SIDE
    row = SIDE
    MatchPattern row, col, -1, 0, pat()
    For row = SIDE To 1 Step -1
      p = pat(row)
      If p > 0 Then
        board(row+p, col) = board(row, col)
        board(row, col) = 0
      EndIf
    Next row
    MergeDown col
  Next col
End Sub
  
  ' Merge matching cells downwards
Sub MergeDown col
  Local row, nrow
  For row = SIDE To 2 Step -1
    If board(row, col) > 0 Then
      If board(row-1, col) = board(row, col) Then
        Inc board(row, col)
        If board(row, col) > highest_power Then highest_power = board(row, col)
        For nrow = row-2 To 1 Step -1
          board(nrow+1, col) = board(nrow, col)
        Next nrow
        board(1, col) = 0
      EndIf
    EndIf
  Next row
End Sub
  
  ' Push cells Left and merge
Sub PushCellsLeft
  Local row, col, p
  Local pat(SIDE)
  For row = 1 To SIDE
    col = 1
    MatchPattern row, col, 0, 1, pat()
    For col = 1 To SIDE
      p = pat(col)
      If p > 0 Then
        board(row, col-p) = board(row, col)
        board(row, col) = 0
      EndIf
    Next col
    MergeLeft row
  Next row
End Sub
  
  ' Merge matching cells leftwards
Sub MergeLeft row
  Local col, ncol
  For col = 1 To SIDE-1
    If board(row, col) > 0 Then
      If board(row, col+1) = board(row, col) Then
        Inc board(row, col)
        If board(row, col) > highest_power Then highest_power = board(row, col)
        For ncol = col+2 To SIDE
          board(row, ncol-1) = board(row, ncol)
        Next ncol
        board(row, SIDE) = 0
      EndIf
    EndIf
  Next col
End Sub
  
  ' Push cells right and merge
Sub PushCellsRight
  Local row, col, p
  Local pat(SIDE)
  For row = 1 To SIDE
    col = SIDE
    MatchPattern row, col, 0, -1, pat()
    For col = SIDE To 1 Step -1
      p = pat(col)
      If p > 0 Then
        board(row, col+p) = board(row, col)
        board(row, col) = 0
      EndIf
    Next col
    MergeRight row
  Next row
End Sub
  
  ' Merge matching cells rightwards
Sub MergeRight row
  Local col, ncol
  For col = SIDE To 2 Step -1
    If board(row, col) > 0 Then
      If board(row, col-1) = board(row, col) Then
        Inc board(row, col)
        If board(row, col) > highest_power Then highest_power = board(row, col)
        For ncol = col-2 To 1 Step -1
          board(row, ncol+1) = board(row, ncol)
        Next ncol
        board(row, 1) = 0
      EndIf
    EndIf
  Next col
End Sub
  
  ' Find the pattern of values that matches a template.
  ' We add up the non-zero cells not by their values, but
  ' by the powers of 2 that match their location. This yields
  ' an index into the template array which gives the spaces
  ' to be shifted during a move in any direction.
Sub MatchPattern row, col, dr, dc, pat()
  Local i, index, p = 3, crow, ccol, px
  index = 0 : crow = row : ccol = col
  For i = 1 To SIDE
    If board(crow, ccol) > 0 Then
      Inc index, 2^p
    EndIf
    Inc crow, dr : Inc ccol, dc : Inc p, -1
  Next i
  Inc index, 1
  If dr <> 0 Then
    px = row
  Else
    px = col
  EndIf
  For i= 1 To 4
    pat(px) = patterns(index, i)
    If dr <> 0 Then
      Inc px, dr
    Else
      Inc px, dc
    EndIf
  Next i
End Sub
  
  ' Returns 1 if board is full or zero if not
Function BoardFull()
  Local row, col
  For row = 1 To SIDE
    For col = 1 To SIDE
      If board(row, col) = 0 Then
        BoardFull = 0
        Exit Function
      EndIf
    Next col
  Next row
  BoardFull = 1
End Function
  
  ' The game is over when all cells have non-zero values and
  ' no cells can be merged
Function GameOver()
  Local row, col, p1, p2, f
  GameOver = 0
  f = BoardFull()
  If f Then
    For row = 1 To SIDE
      For col = 1 To SIDE-1
        p1 = board(row, col)
        p2 = board(row, col+1)
        If p1 = p2 Then Exit Function
      Next col
    Next row
    For col = 1 To SIDE
      For row = 1 To SIDE-1
        p1 = board(row, col)
        p2 = board(row+1, col)
        If p1 = p2 Then Exit Function
      Next row
    Next col
    GameOver = 1
  EndIf
End Function
  
  ' Show the Game Over
Sub ShowGameOver
  Local m$
  cls
  Text MM.HRes\2, 0, "Game Over", "CT", 5,, RGB(yellow), -1
  m$ = "Highest Power of 2 Achieved: " + Str$(2^highest_power)
  Text MM.HRes\2, 40, m$, "CT", 4,, RGB(white), -1
  If highest_power >= 11 Then
    Text MM.HRes\2, 60, "*** WINNER ***", "CT", 4,, RGB(100, 100, 255), -1
  EndIf
  if gm then
    Text MM.HRes\2, MM.VRes-2, "Press START Key for a New Game", "CB", 4,, RGB(green), -1
  else
    Text MM.HRes\2, MM.VRes-2, "Press Home Key for a New Game", "CB", 4,, RGB(green), -1
  end if
End Sub
  
  ' Offer Help
Sub ShowHelp
  cls
  Text MM.HRes\2, 0, "Rules for the 2048 Game", "CT", 4,, RGB(cyan)
  Font 8
  text 0,20,"   The goal of the 2048 game is to merge cells on a 4x4 board until you get to"
  text 0,30,"the value of 2048 (or up to 131,072, which is the highest possible value)."
  text 0,50,"   The board starts out with all cells empty except for 2 random cells, which"
  text 0,60,"have the values of 2 or 4, randomly chosen. Use the arrow keys to slide cells"
  text 0,70,"up, down, left, and right. All the cells on the board will be slid as far as"
  text 0,80,"possible in the chosen direction."
  text 0,100,"   Each time you slide cells in a direction, any two cells which are adjacent"
  text 0,110,"in that direction and which have the same value will be merged into a single"
  text 0,120,"cell that has the sum of the values of the two cells. So for instance, if you"
  text 0,130,"press the LEFT arrow and there are two adjacent cells in a row, each having a"
  TEXT 0,140,"2 in them, they will be merged into a single cell having a 4 in it."
  text 0,160,"   If there are 3 adjacent cells having the same value, only the two cells "
  text 0,170, "closest to the edge that the cells are sliding towards will get merged."
  text 0,180, "But if there are 4 adjacent cells having the same value, then each pair of"
  text 0,190, "cells will be merged. However, the resulting pair of identical cells of the"
  text 0,200, "next higher value will require another key press to merge."
  text 0,220, "   After each move, an empty cell will be randomly filled with a 2 or a 4."
  Text MM.HRes\2, MM.VRes-10, "Press Any Key to Continue",,,, RGB(yellow)
  Do
  Loop Until gm_Inkey$() <> ""
  cls
  Text MM.HRes\2, 0, "Rules for the 2048 Game", "CT", 4,, RGB(cyan)
  Font 8
  text 0,20,"   The game is over when all the cells are filled or there are no more adjacent"
  text 0,30,"cells that can be merged with a move in any direction."
  text 0,50,"   You can press the HOME key at any time to start a new game. To quit the"
  text 0,60,"program, press the ESCAPE key."
  text 0,80,"   The 2048 game was invented by Gabriele Cirulli in 2014. This version for the"
  text 0,90,"CMM2 was reverse-engineered by William M. Leue using the Wikipedia description"
  text 0,100,"of the game."
  if gm then text 0,120,"  Press SELECT any time to quit"
  Text MM.HRes\2, MM.VRes-10, "Press Any Key to Continue",,,, RGB(yellow)
  Do
  Loop Until gm_Inkey$() <> ""
End Sub
  
  ' return a uniformly distributed random integer in the specified closed range
Function RandInt(a As integer, b As integer)
  Local integer v, c
  c = b-a+1
  Do
    v = a + (b-a+2)*Rnd()
    If v >= a And v <= b Then Exit
  Loop
  RandInt = v
End Function
  
  ' Convert an HSV value to its RGB equivalent
  ' The S and V values must be in range 0..1; the H value must
  ' be in range 0..360. The RGB values will be in range 0..255.
Sub HSV2RGB h As float, s As float, v As float, r, g, b
  Local float i, hh, f, p, q, t, x, c, rp, gp, bp
  c = v*s
  hh = h/60.0
  i = Int(hh)
  f = hh - i
  p = v*(1-s)
  q = v*(1-s*f)
  t = v*(1-s*(1-f))
  x = c*(1.0 - hh Mod 2 - 1)
  
  Select Case i
    Case 0
      rp = v : gp = t : bp = p
    Case 1
      rp = q : gp = v : bp = p
    Case 2
      rp = p : gp = v : bp = t
    Case 3
      rp = p : gp = q : bp = v
    Case 4
      rp = t : gp = p : bp = v
    Case 5
      rp = v : gp = p : bp = q
  End Select
  r = rp*255.0 : g = gp*255.0 : b = bp*255.0
End Sub
  
sub gm_init_keys
  setpin gp8,din,pullup  'down
  setpin gp9,din,pullup  'left
  setpin gp10,din,pullup 'up
  setpin gp11,din,pullup 'right
  setpin gp12,din,pullup 'select
  setpin gp13,din,pullup 'start
  setpin gp14,din,pullup 'B
  setpin gp15,din,pullup 'A
end sub
  
function gm_inkey$()
  gm_inkey$=""
  if gm then
    if pin(gp8)=0 then gm_inkey$=chr$(129)
    if pin(gp9)=0 then gm_inkey$=chr$(130)
    if pin(gp10)=0 then gm_inkey$=chr$(128)
    if pin(gp11)=0 then gm_inkey$=chr$(131)
    if pin(gp12)=0 then gm_inkey$=chr$(27)
    if pin(gp13)=0 then gm_inkey$=chr$(134)
    if gm_inkey$<>"" then pause 200 'debounce release time
  else
    gm_inkey$=inkey$
  end if
end function
  
  
  ' Cell Population templates for shifting.
  Data 0, 0, 0, 0
  Data 0, 0, 0, 3
  Data 0, 0, 2, 0
  Data 0, 0, 2, 2
  Data 0, 1, 0, 0
  Data 0, 1, 0, 2
  Data 0, 1, 1, 0
  Data 0, 1, 1, 1
  Data 0, 0, 0, 0
  Data 0, 0, 0, 2
  Data 0, 0, 1, 0
  Data 0, 0, 1, 1
  Data 0, 0, 0, 0
  Data 0, 0, 0, 1
  Data 0, 0, 0, 0
  Data 0, 0, 0, 0
