  ' ChemiChaos
  ' by vegipete, December 2020
  '
  ' required support files (place in same directory):
  ' ChemiChaosSprites.png
  ' CCRedHand.spr
  '
  ' Sort the Chemical Balls in the Test Tubes
  ' Move with the arrow keys
  ' Pick and place with the space bar
  ' Restart level with R  (upper or lower case for letter commands)
  ' Toggle stats with C
  ' Quit with Esc
  ' Replace picked up ball with Z (undocumented)
  '
  '   v 1.3   Mouse intialization fixes
  '   v 1.2   Mouse improvements, more levels, key press & mouse click counting
  '   v 1.1   Mouse control, change to level numbering
  '   v 1.0   Original release, graphics tweaks, more levels + counter, intro text
  '
  '===========================================
  ' Volhout, April 2024
  ' Adapted for 320x240 IlI9341 LCD screen for Game*Mite by Volhout
  '
  '   V 1.4   functional with CDC keyboard, also on VGA with color degradation
  '   V 1.5   game*mite buttons
  '   V 1.6t  finetuning, implemented mm.info(path$)
  '   V 1.7   finetuning, remove mm.info(path) since v6.00.03rc7 does things different
  
  
  dim keypress
  dim fname$
  dim levelnum
  dim movingball
  dim vials(9,4)     ' 9 vials, each can hold 4 balls
  dim vialsbak(9,4)  ' 9 vials, restore copy
  dim ballcols(6) = (0,1,2,3,4,5,6) ' allow shuffling of ball colours
  dim m$
  dim integer movecount(4)
  dim countvisible = 0
  
  'platform specific
  'loca$=choice(mm.info(path)="NONE","B:/chaos",MM.info(path)+"/")
  'loca$=choice(mm.info(path)="NONE","B:/release/chemichaos/",MM.info(path)+"/")
  loca$=""
  vga=instr(mm.device$,"VGA")
  gm=(mm.info$(platform)="Game*Mite")
  
  'platform specific setup
  if vga then
    mode 2                                                'setup 320x240 color video
    cls : load image loca$+"ChemiChaosSpritesPico_16.bmp" 'load 16 color sprites
  else
    if gm then a=ctrl_gamemite(1)                         'setup buttons Game*Mite
    cls : load image loca$+"ChemiChaosSpritesPico3.bmp"   'load 16 bit color sprites
  end if
  
  'loadsprites into memory by reading them from screen
  spriteread
  'spriteshow : end 'debug, to see to copy has worked
  
  'sprite file is a mouse cursor, but doubles as total keys pressed storage
  open loca$+"CCRedHand.spr" for random as #1
  seek #1, 324
  movecount(4) = val(input$(12,#1))
  close #1
  
  'start the game intro screen (erase the sprite file)
  cls rgb(white)
  
  levels = 1
  levelnum = 0
  levelball = 0
  restore gamelevels
  ShuffleBCols
  xpos = 1
  gameover = 0
  newclick = 0
  
  text 160,20,"CHEMICAL CHAOS",CM,1,2,RGB(red),RGB(white)
  text 160,40,"v1.3    by vegipete, Jan 2021","CT",1,1,RGB(BLUE),rgb(white)
  text 160,70,"There is chaos and confusion all","CT",1,1,0,rgb(white)
  text 160,82,"through the chemistry lab! The","CT",1,1,0,rgb(white)
  text 160,94,"chemicals have been mixed. Your task","CT",1,1,0,rgb(white)
  text 160,106,"is to combat the chaos and restore","CT",1,1,0,rgb(white)
  text 160,118,"order by sorting the chemicals.","CT",1,1,0,rgb(white)
  text 160,130,"Move the coloured balls one by one","CT",1,1,0,rgb(white)
  text 160,142,"until each test tube contains a single","CT",1,1,0,rgb(white)
  text 160,154,"colour. However, you can not drop a","CT",1,1,0,rgb(white)
  text 160,166,"ball on a different coloured one!","CT",1,1,0,rgb(white)
  if mm.device$="PicoMiteVGA" then
    text 160,178,"Use the arrow keys to move.","CT",1,1,RGB(BLUE),rgb(white)
    text 160,190,"Select and drop with the space bar.","CT",1,1,RGB(BLUE),rgb(white)
    text 160,202,"Press R to restart if you get stuck.","CT",1,1,rgb(blue),rgb(white)
    text 160,214,"Press Esc to quit and call HazMat.","CT",1,1,rgb(blue),rgb(white)
    text 160,226,"Press 'C' to toggle stats.","CT",1,1,rgb(blue),rgb(white)
  else
    text 160,178,"Use left/right keys to move.","CT",1,1,RGB(BLUE),rgb(white)
    text 160,190,"Select and drop with B","CT",1,1,RGB(BLUE),rgb(white)
    text 160,202,"Press A to restart if you get stuck.","CT",1,1,rgb(blue),rgb(white)
    text 160,214,"Press SELECT to quit and call HazMat.","CT",1,1,rgb(blue),rgb(white)
    text 160,226,"Press START to toggle stats.","CT",1,1,rgb(blue),rgb(white)
  end if
  
  ' add some colour balls to the info screen
  for i=1 to 3
    blit write i,10,20*(i-1)+6,4
    blit write 3+i,292,20*(i-1)+6,4
  next
  pause 1000
  
  'keyboard UI to start the game
  flushkey                        ' clear any key presses
  do : loop until getkeyval()     ' wait for a new key press
  
  'start the game screen
  cls rgb(white)
  text 160,20,"CHEMICAL CHAOS",CM,1,2,RGB(red),RGB(white)
  text 160,34,"v1.3    by vegipete, Jan 2021","CT",1,1,RGB(BLUE),rgb(white)
  movecount(1) = 0                ' total keypress this run
  
  
  '===========================================
  'MAIN LOOP
  do
    if MixVials() = 0 then exit do  ' no more levels
    
    offset = (9-nvials)*18  ' to centre the vials in the playfield
    ShowLevel
    movecount(2) = 0        ' total keypress this level
    movecount(3) = 0        ' total keypress this attempt
    ShowCounts
    
    do
      i = GetBall()               ' pick up a ball
      if i then PutBall(i)        ' and drop this ball again
      if TestDone() then exit do  ' this level has been defused
      if gameover then exit do    ' player quit
    loop
    if gameover then exit do      ' player quit
    ShowSafe
    ShuffleBCols
    levels = levels + 1
    
    do : loop until getkeyval()   ' wait for keypress
    flushkey                      ' clear any keypresses
    
  loop
  
  open loca$+"/CCRedHand.spr" for random as #1
  seek #1, 324
  print #1, left$(str$(movecount(4)) + space$(15), 12);
  close #1
  
  box 0,190,mm.hres,48,1,rgb(white),rgb(white)  ' clear bottom screen
  if gameover then                              ' player quit
    text 160,200,"Send in the HazMat team...","CT",1,1,rgb(red),rgb(white)
  else
    text 160,200,"All is well. Chaos has been tamed.","CT",1,1,rgb(GREEN),rgb(white)
  endif
  pause 2500
  
  if gm then
    run "a:GameMite/menu.bas"
  else
    cls : print "type RUN to restart game"
  end if
end
  
  
  
  '===========================================
  ' Draw the pth vial, erasing anything that might be there already
  ' p = [1,nvials]
sub ShowVial(p)
  blit write 10,offset+35*p-33,105,0
end sub
  
  '===========================================
  ' Draw ball number n at yth level in xth vial
  ' n = [1-7] colour
  ' x = [1-9] vial
  ' y = [0-4] level (0 = above)
sub DrawBall(n,x,y)
  local ypos
  if y then
    ypos = 203-18*y   ' ball in vial
  else
    ypos = 60         ' ball above vial
  endif
  if n then
    blit write n,offset+35*x-25,ypos,4 ' coloured ball
  else
    blit write 9,offset+35*x-25,ypos,4 ' coloured ball
  endif
end sub
  
  '===========================================
  ' Shuffle the ball colours around for variety
sub ShuffleBCols
  local i, tmp, n
  for i = 0 to 6
    n = int(rnd * 7)
    tmp = ballcols(i)
    ballcols(i) = ballcols(n)
    ballcols(n) = tmp
  next i
end sub
  
  '===========================================
  ' Show current level
  ' nvials is of interest, as is vials(9,4)
sub ShowLevel
  local i,j
  
  box 0,50,MM.HRES,160,0,rgb(white),rgb(white) ' erase vials and "SAFE" message
  for i = 1 to nvials
    ShowVial(i)
    for j = 1 to 4
      DrawBall(vials(i,j),i,j+1)
    next j
  next i
  if xpos > nvials then xpos = nvials
  combi$="Level " + str$(levelball) + "." + str$(levelnum) + " "
  text 160,210,combi$,"CT",1,1,0,rgb(white)
end sub
  
  '===========================================
function TestDone()
  local i,j
  
  TestDone = 0
  for i = 1 to nvials
    for j = 2 to 4
      if vials(i,j) <> vials(i,1) then exit function
    next j
  next i
  TestDone = 1
end function
  
  '===========================================
  ' return number of ball selected,
  ' return 0 if no ball selected
function GetBall()
  local k,j,res
  
  blit write 8,offset+35*xpos-25,85,0  'arrow up
  GetBall = 0
  do
    'flushkey            'clear key fifo
    k = getkeyval()     'get a new key
    select case k
      case 130    ' left arrow
        if xpos > 1 then
          AnotherKeyPress
          box offset+35*xpos-25,85,18,18,1,rgb(white),rgb(white) 'remove old arrow
          xpos = xpos - 1
          blit write 8,offset+35*xpos-25,85,0  'arrow up
        endif
      case 131    ' right arrow
        if xpos < nvials then
          AnotherKeyPress
          box offset+35*xpos-25,85,18,18,1,rgb(white),rgb(white) 'remove old arrow
          xpos = xpos + 1
          blit write 8,offset+35*xpos-25,85,0  'arrow up
        endif
      case  67    ' "C"   toggle count data on and off
        ToggleCounts
      case  27    ' [ESC]
        gameover = 1
        exit do
      case  32    ' [SPACE] - select top ball from this vial
        AnotherKeyPress
        j = 4
        res = 0
        do
          if vials(xpos,j) > 0 then ' found a ball
            res = xpos
            movingball = vials(xpos,j)    ' actual ball colour
            exit do
          endif
          j = j - 1
        loop until j = 0
        if res then
          vials(xpos,j) = 0   ' clear location
          DrawBall(0,res,j+1)   ' erase ball from vial
          GetBall = res
          exit do
        endif
      case 82     ' "R"   restart
        AnotherKeyPress
        movecount(3) = 0  ' total keypress this attempt
        ShowCounts
        math scale vialsbak(),1,vials()  ' restore starting configuration
        ShowLevel
        exit do
    end select
  loop
end function
  
  '===========================================
  ' take top ball from src and put it somewhere
sub PutBall(src)
  local j,k
  
  blit write 8,offset+35*xpos-25,85,2  'arrow down
  
  DrawBall(movingball,src,0)   ' coloured ball above vial
  do
    'flushkey              'clear key fifo
    k = getkeyval()       'get new key
    select case k
      case 130    ' left arrow
        if xpos > 1 then
          AnotherKeyPress
          DrawBall(0,xpos,0)            ' erase coloured ball above vial
          box offset+35*xpos-25,85,18,18,1,rgb(white),rgb(white) 'remove old arrow
          xpos = xpos - 1
          DrawBall(movingball,xpos,0)   ' draw coloured ball above vial
          blit write 8,offset+35*xpos-25,85,2  'arrow down
        endif
      case 131    ' right arrow
        if xpos < nvials then
          AnotherKeyPress
          DrawBall(0,xpos,0)            ' erase coloured ball above vial
          box offset+35*xpos-25,85,18,18,1,rgb(white),rgb(white) 'remove old arrow
          xpos = xpos + 1
          DrawBall(movingball,xpos,0)   ' draw coloured ball above vial
          blit write 8,offset+35*xpos-25,85,2  'arrow down
        endif
      case  90    ' [Z/z]   'undocumented' undo command - replace wrongly selected ball
        AnotherKeyPress
        DrawBall(0,xpos,0)  ' erase coloured ball above pointer
        for j = 1 to 4
          if vials(src,j) = 0 then     ' find top spot
            vials(src,j) = movingball  ' put the ball back
            DrawBall(movingball,src,j+1) ' re-draw coloured ball in vial
            exit do
          endif
        next j
      case  67    ' "C"   toggle count data on and off
        ToggleCounts
      case  27    ' [ESC]
        gameover = 1
        exit do
      case  32    ' [SPACE] - place ball
        blit write 8,offset+35*xpos-25,85,2  'arrow down
        if vials(xpos,4) = 0 then     ' there is room in this vial
          AnotherKeyPress
          top = 0
          for j = 1 to 4
            if vials(xpos,j) = 0 then   ' found a spot
              if (top = 0) or (top = movingball) then
                vials(xpos,j) = movingball    ' move the ball
                DrawBall(0,xpos,0)            ' erase coloured ball above vial
                DrawBall(movingball,xpos,j+1) ' draw coloured ball in vial
                exit do
              endif
            else
              top = vials(xpos,j)
            endif
          next j
        endif
      case 82     ' "R"   restart
        AnotherKeyPress
        movecount(3) = 0  ' total keypress this attempt
        ShowCounts
        math scale vialsbak(),1,vials()  ' restore starting configuration
        ShowLevel
        exit do
    end select
  loop
  movingball = 0
end sub
  
  '===========================================
sub AnotherKeyPress
  local c$
  movecount(1) = movecount(1) + 1  ' another keypress this level
  movecount(2) = movecount(2) + 1  ' another keypress this level
  movecount(3) = movecount(3) + 1  ' another keypress this attempt
  movecount(4) = movecount(4) + 1
  ShowCounts
end sub
  
  '===========================================
sub ShowCounts
  if countvisible then
    local x=32,y=200
    text x,y,str$(movecount(1)),"RT",7,1,rgb(blue),rgb(white)
    text x,y+10,str$(movecount(2)),"RT",7,1,rgb(blue),rgb(white)
    text x,y+20,str$(movecount(3)),"RT",7,1,rgb(blue),rgb(white)
    text x,y+30,str$(movecount(4)),"RT",7,1,rgb(blue),rgb(white)
  end if
end sub
  
  '===========================================
sub ToggleCounts
  local x=36,y=200
  if countvisible then
    countvisible = 0
    box 0,y,108,48,1,rgb(white),rgb(white)
  else
    countvisible = 1
    text x,y,"This attempt","LT",7,1,rgb(blue),rgb(white)
    text x,y+10,"This level","LT",7,1,rgb(blue),rgb(white)
    text x,y+20,"This game","LT",7,1,rgb(blue),rgb(white)
    text x,y+30,"Total","LT",7,1,rgb(blue),rgb(white)
    ShowCounts
  end if
end sub
  
  '===========================================
sub ShowSafe
  box 0,50,mm.hres,54,1,rgb(white),rgb(white)
  'box 80,55,160,44,2,rgb(green),rgb(white)
  blit write 11,114,60
end sub
  
  '===========================================
  ' Read another level from the data
function MixVials()
  local i,j,mix
  local c$
  
  math set 0,vials()    ' start with empty vials
  read nballs
  if nballs = 0 then
    MixVials = 0
    exit function
  endif
  
  if nballs = levelball then
    levelnum = levelnum + 1
  else
    levelnum = 1
    levelball = nballs
  endif
  
  m$ = ""
  read nvials
  if nvials = -1 then
    
    nvials = nballs + 2
    for i = 1 to nballs
      m$ = m$ + string$(4,str$(i))
    next i
    
    for i = 1 to len(m$)  ' scramble m$
      c$ = mid$(m$,i,1)
      j = int(rnd * len(m$)) + 1
      mid$(m$,i,1) = mid$(m$,j,1)
      mid$(m$,j,1) = c$
    next i
    
    for i = 1 to nvials   ' fill with data from m$
      for j = 1 to 4
        vials(i,j) = val(left$(m$,1))
        m$ = mid$(m$,2)
      next j
    next i
    
  else
    for i = 1 to nvials   ' fill with data
      read mix
      m$ = m$ + str$(mix)
      for j = 1 to 4
        vials(i,j) = mix mod 10
        mix = mix \ 10
      next j
    next i
  endif
  
  math scale vials(),1,vialsbak()  ' save starting configuration
  MixVials = 1
end function
  
  '===========================================
  ' read sprites from the LCD that is 16bit color
sub spriteread
  blit read 1,0,0,18,18     'light green ball
  blit read 2,0,18,18,18    'red ball
  blit read 3,0,36,18,18    'blue ball
  blit read 4,18,0,18,18    'yellow ball
  blit read 5,18,18,18,18   'dark green ball
  blit read 6,18,36,18,18   'pink ball
  blit read 7,36,0,18,18    'purple ball
  blit read 8,36,18,18,18   'arrow
  blit read 9,36,36,18,18   'empty place
  blit read 10,54,0,33,85   'vial
  blit read 11,0,84,91,33   'safe
end sub
  
  '===========================================
  ' for debug, show the read sprites
sub spriteshow
  cls rgb(magenta)
  for i=1 to 9
    blit write i,20,22*i,4
  next
  blit write 10,100,20,4
  blit write 11,150,20,4
end sub
  
  '===========================================
  ' Read a key from the keyboard, or game*mite button
  ' translate the button to a key code
function getkeyval()
  local a
  static old_a
  
  'first check keyboard
  getkeyval=asc(ucase$(inkey$))
  
  'then check game*mite buttons
  if getkeyval=0 And gm<>0 then
    a=ctrl_gamemite(0)
    'if a then
    if a<>old_a then
      getkeyval=a
      old_a=a
    end if
    'end if
    pause 100
  end if
  'pause 10 'debounce
end function
  
  '===========================================
  ' Clear the key buffer
sub flushkey
  do while inkey$ <> "" : loop    ' clear any key presses
end sub
  
  '===========================================
  ' Game*Mite controls copied from PETSCII
Function ctrl_gamemite(initi)
  
  If Not initi Then
    
    'read the buttons and convert to ASCII codes equal the keyboard controls
    Local bits = Inv Port(GP8, 8) And &hFF, s%
    
    Select Case bits
        Case 0    : s% = 0    'no key
        Case &h01 : s% = 32   'down (pickup/drop)
        Case &h02 : s% = 130  'left
        Case &h04 : s% = 32   'up (pickup/drop)
        Case &h08 : s% = 131  'right
        Case &h10 : s% = 27   'Select = ESC (stop)
        Case &h20 : s% = 67   'Start = C (counters)
        Case &h40 : s% = 32   'B = SPACE (pickup/drop)
        Case &h80 : s% = 82   'A = R(edo)
    End Select
    ctrl_gamemite = s%
    Exit Function
    
  Else
    ' Initialise GP8-GP15 as digital inputs with PullUp resistors
    Local i
    For i = 8 To 15
      SetPin MM.Info(PinNo "GP" + Str$(i)), Din, PullUp
    Next
  EndIf
  
End Function
  
  
  '===========================================
  ' data format:
  ' #balls, #vials, ball pattern for each vial
  ' if #vials = -1 then fill (#balls + 2) vials randomly
gamelevels:
  data 1,2,11,11                ' trivial one to get startednew
  data 2,3,1221,2112,0
  data 2,3,1212,2121,0
  data 2,5,1121,1211,2111,1112,0
  data 3,5,1231,3321,2231,0,0   ' this one can't be done in only 4 vials
  data 3,-1
  data 3,-1
  data 3,-1
  data 3,4,1213,2231,3213,0
  data 3,4,2313,2123,2311,0
  data 3,4,2313,2232,1113,0
  data 3,4,1211,3323,1232,0
  data 3,4,2132,3221,3311,0
  data 3,4,2221,2133,1133,0
  'data 3,4,1233,1212,2133,0
  'data 3,4,1232,3121,1323,0
  data 4,-1
  data 4,-1
  data 4,-1
  data 4,-1
  data 4,5,2321,1412,4412,4333,0
  data 4,5,4232,1231,2443,3114,0
  data 4,5,3124,2121,2444,3331,0
  data 4,5,1224,4232,4311,4133,0
  data 4,5,2141,4333,3242,4121,0
  data 5,-1
  data 5,-1
  data 5,-1
  data 5,-1
  data 5,-1
  data 5,-1
  data 5,6,5154,3321,4222,3415,1534,0
  data 5,6,4131,2422,5412,5313,4553,0
  data 5,6,2154,2543,5414,2251,1333,0
  data 5,6,3214,2453,2431,2135,5541,0
  data 6,-1
  data 6,-1
  data 6,-1
  data 6,-1
  data 6,-1
  data 6,7,1642,5624,4161,3623,5432,5315,0
  data 6,7,6413,5124,3531,4265,6153,6224,0
  data 6,7,6342,5265,2341,4534,6152,6131,0
  data 6,7,2151,5634,6436,6514,3431,2225,0
  data 6,7,1324,4636,5413,6132,5562,5241,0
  data 7,-1
  data 7,-1
  data 7,-1
  data 7,-1
  data 7,-1
  data 7,-1
  data 7,-1
  data 7,8,2127,4665,4231,3776,4335,6151,4572,0
  data 7,8,4311,5562,2346,7773,6245,6124,3751,0
  data 7,8,2715,2136,2761,7634,5744,6552,3431,0
  
  data 0,0  ' indicate end of data
