
DIM level(21) AS STRING LENGTH 40
level(0) =  "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
level(1) =  "w......D.D.D.W........r..r..r..rrrr....W"
level(2) =  "w...W  DD ..DrD.D.....r..r..r..rD.r....W"
level(3) =  "w..fW..D...D.W..D.D...rrrr..r..rrrr....W"
level(4) =  "w..DW.....D..D.....r..r..r..r..r..r....W"
level(5) =  "w.D.WD.D...D.W...D.wwwwwwww............W"
level(6) =  "w...W.D.D.D....D...r........W........W.W"
level(7) =  "wD..W...D..D.W..D..wwwwwwww............W"
level(8) =  "w...W.D..D.D.......r........W...r....W.W"
level(9) =  "w...W........W.....wwwwwwww............W"
level(10) = "w...W.......................W........W.W"
level(11) = "w...W........W.........................W"
level(12) = "w...W..............r........W........W.W"
level(13) = "w...W........W.....www..www............W"
level(14) = "w...W......................W........W..W"
level(15) = "w...W........W.....wwwwwwww............W"
level(16) = "w...W.......................W........W.W"
level(17) = "w...W........W.....wwwwwwww............W"
level(18) = "w...W............DD.........W........W.W"
level(19) = "w....................................W.W"
level(20) = "w......................................W"
level(21) = "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"


'IMPORTANT! INTERNAL TILE ENCODING:
'
'Each tile/monster/rockford/etc is encoded in a 64 bit Integer
'
'                        64      56      48      40      32      24      16       8       0
'                         /       /       /       /       /       /       /       /       /
CONST EMPTY_MASK  =     &B0000000000000000000000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST ASCII_MASK  =     &B0000000000000000000000000000000000000000000000000000000011111111
'                         /       /       /       /       /       /       /       /       /
CONST XCOORD_MASK =     &B0000000000000000000000000000000000000000000000111111111100000000
'                         /       /       /       /       /       /       /       /       /
CONST YCOORD_MASK =     &B0000000000000000000000000000000000001111111111000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST SPRITE_PAGE_MASK= &B0000000000000000000000000000000011110000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST SPRITE_ROW_MASK = &B0000000000000000000000000000111100000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST SPRITE_FRAME_MASK=&B0000000000000000000000001111000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST ROUNDED_MASK =    &B0000000000000000000000010000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST ANIMATED_MASK =   &B0000000000000000000000100000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST DIR_MASK  =       &B0000000000000000001111000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST LEFT_MASK  =      &B0000000000000000001000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST RIGHT_MASK  =     &B0000000000000000000001000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST UP_MASK  =        &B0000000000000000000100000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST DOWN_MASK  =      &B0000000000000000000010000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST LEFTDOWN_MASK =   &B0000000000000000001010000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST RIGHTDOWN_MASK=   &B0000000000000000000011000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST EXPLODING_MASK=   &B0000000000000000010000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST ACTIVATED_MASK=   &B0000000000000000100000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST ACTIVETIME_MASK=  &B0000000011111111000000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST HEAVY_MASK  =     &B0000000100000000000000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST EDIBLE_MASK  =    &B0000001000000000000000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST SCANNED_MASK =    &B0000010000000000000000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST INERT_MASK =      &B0000100000000000000000000000000000000000000000000000000000000000



FUNCTION GETBDF( tile AS INTEGER ) AS STRING
  GETBDF = CHR$(tile AND ASCII_MASK)
END FUNCTION

FUNCTION SETBDF( tile AS INTEGER, bdf AS STRING ) AS INTEGER
  SETBDF = ((tile AND INV ASCII_MASK) OR (ASC(bdf) AND ASCII_MASK))
END FUNCTION


FUNCTION GETXCOORD( tile AS INTEGER ) AS INTEGER
  GETXCOORD = ((tile AND XCOORD_MASK) >> 8)
END FUNCTION

FUNCTION SETXCOORD( tile AS INTEGER, xCoord AS INTEGER ) AS INTEGER
  SETXCOORD = (TILE AND INV XCOORD_MASK) OR (XCOORD_MASK AND (xCoord << 8))
END FUNCTION


FUNCTION GETYCOORD( tile AS INTEGER ) AS INTEGER
  GETYCOORD = ((tile AND YCOORD_MASK) >> 18)
END FUNCTION

FUNCTION SETYCOORD( tile AS INTEGER, yCoord AS INTEGER ) AS INTEGER
  SETYCOORD = (TILE AND INV YCOORD_MASK) OR (YCOORD_MASK AND (yCoord << 18))
END FUNCTION


FUNCTION GETSPRITEPAGE( tile AS INTEGER ) AS INTEGER
  GETSPRITEPAGE = ((tile AND SPRITE_PAGE_MASK) >> 28)
END FUNCTION

FUNCTION SETSPRITEPAGE( tile AS INTEGER, spage AS INTEGER ) AS INTEGER
  SETSPRITEPAGE = (TILE AND INV SPRITE_PAGE_MASK) OR (SPRITE_PAGE_MASK AND (spage << 28))
END FUNCTION


FUNCTION GETSPRITEROW( tile AS INTEGER ) AS INTEGER
  GETSPRITEROW = ((tile AND SPRITE_ROW_MASK) >> 32)
END FUNCTION

FUNCTION SETSPRITEROW( tile AS INTEGER, row AS INTEGER ) AS INTEGER
  SETSPRITEROW = (TILE AND INV SPRITE_ROW_MASK) OR (SPRITE_ROW_MASK AND (row << 32))
END FUNCTION


FUNCTION GETSPRITEFRAMES( tile AS INTEGER ) AS INTEGER
  GETSPRITEFRAMES = ((tile AND SPRITE_FRAME_MASK) >> 36)
END FUNCTION

FUNCTION SETSPRITEFRAMES( tile AS INTEGER, frames AS INTEGER ) AS INTEGER
  SETSPRITEFRAMES = (TILE AND INV SPRITE_FRAME_MASK) OR (SPRITE_FRAME_MASK AND (frames << 36))
END FUNCTION




FUNCTION GETROUNDED( tile AS INTEGER ) AS INTEGER
  GETROUNDED = (tile AND ROUNDED_MASK)
END FUNCTION

FUNCTION SETROUNDED( tile AS INTEGER ) AS INTEGER
  SETROUNDED = (tile OR ROUNDED_MASK)
END FUNCTION

FUNCTION CLEARROUNDED( tile AS INTEGER ) AS INTEGER
  CLEARROUNDED = tile AND INV ROUNDED_MASK
END FUNCTION


FUNCTION GETANIMATED( tile AS INTEGER ) AS INTEGER
  GETANIMATED = tile AND ANIMATED_MASK
END FUNCTION

FUNCTION SETANIMATED( tile AS INTEGER ) AS INTEGER
  SETANIMATED = (tile OR ANIMATED_MASK)
END FUNCTION


FUNCTION GETHEAVY( tile AS INTEGER ) AS INTEGER
  GETHEAVY = tile AND HEAVY_MASK
END FUNCTION

FUNCTION SETHEAVY( tile AS INTEGER ) AS INTEGER
  SETHEAVY = (tile OR HEAVY_MASK)
END FUNCTION


FUNCTION GETEDIBLE( tile AS INTEGER ) AS INTEGER
  GETEDIBLE = tile AND EDIBLE_MASK
END FUNCTION

FUNCTION SETEDIBLE( tile AS INTEGER ) AS INTEGER
  SETEDIBLE = (tile OR EDIBLE_MASK)
END FUNCTION


FUNCTION GETDIR( tile AS INTEGER ) AS INTEGER
  GETDIR = tile AND DIR_MASK
END FUNCTION 

FUNCTION SETDIR( tile AS INTEGER, dir AS INTEGER ) AS INTEGER
  SETDIR = (tile AND (INV DIR_MASK)) OR dir
END FUNCTION


FUNCTION GETSCANNED( tile AS INTEGER ) AS INTEGER
  GETSCANNED = tile AND SCANNED_MASK
END FUNCTION

FUNCTION SETSCANNED( tile AS INTEGER ) AS INTEGER
  SETSCANNED = (tile OR SCANNED_MASK)
END FUNCTION

FUNCTION CLEARSCANNED( tile AS INTEGER ) AS INTEGER
  CLEARSCANNED = tile AND INV SCANNED_MASK
END FUNCTION


FUNCTION GETINERT( tile AS INTEGER ) AS INTEGER
  GETINERT = tile AND INERT_MASK
END FUNCTION

FUNCTION SETINERT( tile AS INTEGER ) AS INTEGER
  SETINERT = (tile OR INERT_MASK)
END FUNCTION

FUNCTION CLEARINERT( tile AS INTEGER ) AS INTEGER
  CLEARINERT = tile AND INV INERT_MASK
END FUNCTION



'Converts data from an array that represents a room by one string per row to a 2d numeric array
'
'w - width of each string line
'h - the number of lines in bdfData$
'bdfData - array of strings where each line represents one row
'board - target 2d array that represents the board
SUB BDF2BOARD w, h, bdfData() AS STRING, board() AS INTEGER
  LOCAL textLine$, symbol$, n, m
  FOR n = 0 TO h-1
    FOR m = 0 TO w-1
      symbol$ = MID$(bdfData(n),m+1,1)
      board(m,n) = BDF2TILE(symbol$)
    NEXT m
  NEXT n
END SUB


'Pretty prints a 2d array starting from its top left corner
'
'w - width of the printed output
'h - height of the printed output
'array - array to print
'ascii - show content as ascii if non zero
SUB PPRINT2D w, h, array() AS INTEGER, ascii
  LOCAL encoded AS STRING
  LOCAL n AS INTEGER
  LOCAL m AS INTEGER
  FOR n = 0 TO h-1
    FOR m = 0 TO w-1
      encoded = GETBDF(array(m,n))
      IF ascii = 0 THEN PRINT encoded; " "; ELSE PRINT CHR$(encoded); " ";
    NEXT m
    PRINT
  NEXT n
END SUB

FUNCTION SETSPRITEINFO(tile AS INTEGER, spage AS INTEGER, row AS INTEGER, frameCount AS INTEGER )
  SETSPRITEINFO = SETSPRITEFRAMES(SETSPRITEROW(SETSPRITEPAGE(tile,spage),row),frameCount)
END FUNCTION

SUB LOADSPRITESFOR bdf AS STRING, name AS STRING, resolution AS INTEGER, pgOverride AS INTEGER
  LOCAL layer = 1
  LOCAL tile = BDF2TILE(bdf)
  LOCAL row = GETSPRITEROW(tile)
  LOCAL spage
  IF pgOverride >= 0 THEN 
    spage = pgOverride 
  ELSE 
    spage = GETSPRITEPAGE(tile)
  ENDIF
  PAGE WRITE spage
  SPRITE LOAD name + STR$(resolution) + ".spr",1
  LOCAL n
  FOR n = 1 TO GETSPRITEFRAMES(tile)
    SPRITE SHOW n,(n-1)*resolution,(row-1)*resolution,layer
  NEXT n
  SPRITE CLOSE ALL
END SUB

SUB LOADALLSPRITES16 pgOverride AS INTEGER
  LOADSPRITESFOR "W", "steelwall",16, pgOverride
  LOADSPRITESFOR "w", "wall",16, pgOverride
  LOADSPRITESFOR ".", "dirt",16, pgOverride
  LOADSPRITESFOR " ", "emptyspace",16, pgOverride
  LOADSPRITESFOR "D", "diamond",16, pgOverride
  LOADSPRITESFOR "r", "rock",16, pgOverride
  LOADSPRITESFOR "f", "rockford",16, pgOverride
END SUB

FUNCTION BDF2TILE( bdf AS STRING ) AS INTEGER
  LOCAL tile = SETBDF(0,bdf)
  IF bdf = "W" THEN 
    BDF2TILE = SETINERT(SETSPRITEINFO(tile,3,1,1))
  ELSEIF bdf = "w" THEN 
    BDF2TILE = SETINERT(SETROUNDED(SETSPRITEINFO(tile,3,2,1)))
  ELSEIF bdf = "." THEN 
    BDF2TILE = SETINERT(SETEDIBLE(SETSPRITEINFO(tile,3,3,1)))
  ELSEIF bdf = " " THEN 
    BDF2TILE = SETINERT(SETEDIBLE(SETSPRITEINFO(tile,3,4,1)))
  ELSEIF bdf = "D" THEN 
    BDF2TILE = SETANIMATED(SETEDIBLE(SETHEAVY(SETROUNDED(SETSPRITEINFO(tile,3,5,15)))))
  ELSEIF bdf = "r" THEN 
    BDF2TILE = SETHEAVY(SETROUNDED(SETSPRITEINFO(tile,3,6,1)))
  ELSEIF bdf = "f" THEN 
    BDF2TILE = SETANIMATED(SETSPRITEINFO(tile,3,7,4))
  ENDIF
END FUNCTION

