Option Base 1
Option Explicit

Type TPerson
  phone As integer
  surname As string Length 8
  name As string Length 7
  padding As string Length 2 'alignment to uint32_t seems OK, L=6 for uint64_t
End Type

Dim people(2) As TPerson ' = (1234,"Marther","Peter", 5678,"Graham","Geoff")

people(1).phone = 1234
people(1).surname = "Marther"
people(1).name = "Peter"

people(2).phone = 5678
people(2).surname = "Graham"
people(2).name = "Geoff"

Dim i As integer
Dim o As integer

Print "SIZEOF(TPerson)="; Struct(SIZEOF "TPerson")
Print "OFFSET(TPerson,name)="; Struct(OFFSET "TPerson", "name")
o = Peek(VARADDR people(1).name) - Peek(VARADDR people(1))
Print "OFFSETOF(TPerson,name)="; o; " =0x"; Hex$(o)

Print "VARADDR(people(1))=0x"; Hex$(Peek(VARADDR people(1)))
Print "VARADDR(people(2))=0x"; Hex$(Peek(VARADDR people(2)))
Print "Bound(people(),1)="; Bound(people(),1)

Dim pt As TPerson

Dim p1 As TPerson
p1 = people(1)
Print "Struct Print p1:"
Struct Print p1

Print "At start:"
Print "TPerson.Print(people(1)):"
TPerson.Print(people(1))

people(1) = p1
TPerson.S9999(people(1))
Print "After TPerson.S9999(people(1))"
Print "TPerson.Print(people(1)):"
TPerson.Print(people(1))

people(1) = p1
TPerson.ByRef(people(1))
Print "After TPerson.ByRef(people(1))"
Print "TPerson.Print(people(1)):"
TPerson.Print(people(1))

people(1) = p1
Print "After people(1) = p1"
Print "TPerson.Print(people(1)):"
TPerson.Print(people(1))

' Same behavior as TPerson.Print(ByRef ..)
Print "TPerson.Print2(people(2)):"
TPerson.Print2(people(2))

people(1) = p1
' Throws error: "Error : Expected a structure variable: people(1)"
'TPerson.ByVal(people(1))
'Print "After TPerson.ByVal(people(1))"
'Print "TPerson.Print(people(1)):"
'TPerson.Print(people(1))

people(1) = p1
pt = people(1)
' Throws error: "Error : Expected a structure variable: pt"
'TPerson.ByVal(pt)

TPerson.S9999(pt)
Print "After TPerson.S9999(pt)"
Print "TPerson.Print(pt):"
' Throws error: "Error : Array dimensions" (inside Sub!, same at TPerson.Print2)
'TPerson.Print(pt)

End

Sub TPerson.Print(ByRef me As TPerson)
  ' Throws error: "Error : Array dimensions"
  'Struct Print me

  ' Prints whole array people():
  'Struct Print me()

  Local p As TPerson
  ' Throws error: "Error : Array dimensions"
  'p = me
  ''Struct Print p

  ' Works: !!!
  Struct Print me(1)  ' Prints the array-element passed by arg!
End Sub

' Without 'ByRef' but behaves the same as TPerson.Print(ByRef ..)
Sub TPerson.Print2(me As TPerson)
  ' Throws error: "Error : Array dimensions"
  'Struct Print me

  ' Prints whole array people():
  'Struct Print me()

  ' Works: !!!
  Struct Print me(1)  ' Prints the array-element passed by arg!
End Sub

Sub TPerson.S9999(me As TPerson)
  me.phone = 9999
End Sub

Sub TPerson.ByRef(ByRef me As TPerson)
  me.phone = 9999
End Sub

Sub TPerson.ByVal(ByVal me As TPerson)
  me.phone = 9999
End Sub

Sub TPerson.Save(ByRef me As TPerson)
  Open "a:/fpeople_u.bin" For Random As #2
  For i=1 To 2
    Struct Save #2, people(i)
  Next i
  Close #2
End Sub
