'WiFi Scanner v1.0 ZS1CE
'Graphing function available through graphrssi.html which autorefreshes

'Wait for first console output before launching the graphing
'***********************************************************

'Auto web scan and graphing refresh currently set for 60 seconds

'OPTION declarations
'===================
'  Option WEB MESSAGES ON 'Turn off status messages here for 5.07.08b12+
  Option BASE 0
  Option Escape ON

'Set the follwoing OPTIONS at the console prompt
'===============================================
' OPTION AUTORUN ON 'Automatically recover from restarts
' OPTION TCP SERVER PORT 80, 20000 'Used for graphing. Note extended timeout
' OPTION DISPLAY 41,140 'Change to your preference noting some longer code lines below

'Log program starts. Keep track of program start events
'======================================================
  Open "log.txt" For Append As #1
    Print #1, Date$ "," Time$ "," MM.Info(BOOT COUNT)
  Close #1

'Get connected to the WiFi
'=========================
  If MM.Info(ip address) = "0.0.0.0" Then
    Print "Failure to connect to the Internet - Restart"
    CPU restart
  EndIf

'Set the Pico W RTC using NTP server
'===================================
  On ERROR SKIP 5
    WEB NTP -6 'Saskatoon
      If MM.Errno Then WEB NTP -6
        If MM.Errno Then WEB NTP -6
          If MM.Errno Then Print "Failure to connect to the NTP Server" : CPU RESTART

'Use this IP Adress to access graphrssi.htm
'==========================================
  Print "Use :";MM.Info(IP ADDRESS);"/graphrssi.html to access graphing" 'IP Adress to access graphing

'Variable declaration Area
'=========================
'Floats
  RSSI=-100'Initialise the RSSI varibale
'Arrays
  Dim Integer List%(1024), Buff1%(512)  'Longstring buffers for web scan and web server
  TickMinute=60000  'Tick every 1m to do web scan

'Tick & Web decalration area
  SetTick TickMinute, MinuteLoop, 1 '1m timer-Taps
  WEB TCP INTERRUPT ServiceWebInterrupt 'Web server handler interrupt handler declaration

'Main program starts here
'========================
  WEB Scan List%()
'     LongString Print List%()
      DisplaySSIDList
      MakeSelection

'Sit and wait for exit signal
'============================
  Do While Inkey$ <> "!"
    Dummy$=Inkey$
      If Dummy$="!" Then Exit '! used to exit program. Change to suit your preference
  Loop

'Used for initial SSID listing to console
'========================================
  Sub DisplaySSIDList
    LongString Print List%()
  End Sub

'Get SSID in plain text noting that its case sensitive
'=====================================================
  Sub MakeSelection
    Input "Type in SSID to monitor (case sensitive) ", InputString$$
    InputString$=InputString$+"   " '3 spaces added to prevent selecting duplicate substring SSID
      If LInStr(List%(), InputString$) = 0 Then
        Print "No such SSID: "InputString$
        Print "Exit program and try again"
        Exit
        Exit Sub
      Else
        Print "Monitoring " InputString$
        Print "Wait for first RSSI before launching graphing"
      EndIf
  End Sub

'Do WiFi SSID scan every 1 minute
'================================
  Sub MinuteLoop
    WEB Scan List%()  'Get WiFi SSID list
    ExtractRSSI 'Get the targetted SSID's RSSI
    AssembleJSONString  'Assemble the JSON string for graphing of RSSI
  End Sub

'Extract the RSSI for SSID from the List%()
'==========================================
  Sub ExtractRSSI
'      LongString Print List%()
      p1%=LInStr(List%(), InputString$)
    If p1%<>0 Then
      RSSI=Val(LGetStr$(List%(),p1%+38,6))
      Print RSSI;" "; 'Output RSSI to console indicates life
    Else
      Print "No SSID: "InputString$; " found"
      Exit Sub
    EndIf
  End Sub

'-----------------------------------------------------------------------------------------
'Web server restricted to GET only for browser compatibility. POST doesnt work with Safari
'-----------------------------------------------------------------------------------------
  Sub ServiceWebInterrupt
    Local a%, p1%, p2%, file$, buff%(512)
      For a% = 1 To MM.Info(MAX CONNECTIONS)
        If Not (MM.Info(TCP Request a%)) Then Continue For 'Skip non connections
          WEB TCP READ a%, buff%()
            If LInStr(buff%(),"GET") Then p1%=LInStr(buff%(),"GET") '[GET /filename HTTP1.1] GET pointer
              p2% = LInStr(buff%(),"HTTP") 'HTTP pointer
            If p1% <> 0 And p2% <> 0 And p2%>p1% Then
              file$=LCase$(LGetStr$(buff%(), p1%+4, p2% - p1% - 5))
            EndIf
      On ERROR SKIP
        Open file$ For Input As #1 ' check that the file exists
          If Not(MM.Errno) Then
             Close #1
            Else
            WEB TRANSMIT PAGE a%,"404.html"
            WEB TRANSMIT CODE a%, 404
             Print "404"
            Exit Sub
          EndIf
      Select Case Right$(file$, 4)
        Case "html", ".htm", ".txt"
          WEB TRANSMIT PAGE a%, file$
        Case ".ico"
          WEB TRANSMIT FILE a%, file$, "image/vnd.microsoft.icon"
        Case "s.js", "s.gz"
          WEB TRANSMIT FILE a%, file$, "text/html"
        Case "/all"
          AssembleJSONResponseHeader
          On ERROR SKIP
            WEB TCP SEND a%, Buff1%()
              If MM.Errno Then
                WEB CLOSE TCP CLIENT
                Exit Sub
              EndIf
            WEB TCP CLOSE a%
      End Select
        EndIf
    Next a%

'Ensuring no orphan TCP connections remain
  For a%=1 To MM.Info(max connections)
    On error skip
      WEB TCP Close a%
    Next a%
  End Sub

'Assemble JSON String for graphing RSSI
'======================================
  Sub AssembleJSONString
    JSON$=""  'Clear JSON$
    JSON$="{\qa\q:"+Str$(RSSI,4,0)+"}"  '\q is " using OPTION ESCAPE
    PayLoad$=Str$(Len(JSON$)) 'Length of JSON string
  End Sub

'Assemble HTTP response Headers
'==============================
  Sub AssembleJSONResponseHeader
    AssembleJSONString  'Assemble JSON String for graphing RSSI
    LongString CLEAR Buff1%()
      Open "JSONHeader.txt" For Input As #1 'Read HTTP Header from file
        LongString Append Buff1%(),Input$(80,#1)+PayLoad$+Input$(4, #1)+JSON$ 'Assemble HTTP response header
      Close #1  'close the JSONHeader.txt file
  End Sub
