  ' program chebyshev_planet.bas      April 18, 2017
  
  ' this MMBASIC eXtreme program demonstrates how
  ' to evaluate a Chebyshev ephemeris of a planet
  
  ' MicroMite eXtreme version
  
  '''''''''''''''''''''''''''
  
  option default float
  
  option base 1
  
  dim rplanet(3)
  
  ' global constants
  
  const pi2 = 2.0 * pi, pidiv2 = 0.5 * pi, dtr = pi / 180.0, rtd = 180.0 / pi
  
  ' astronomical unit (kilometers)
  
  const aunit = 149597870.691
  
  ''''''''''''''''''''''''''''''''
  ' read Chebyshev fit information
  ''''''''''''''''''''''''''''''''
  
  read nfit%, jdtdb1, jdtdb2
  
  dim rx_poly(nfit% + 1), ry_poly(nfit% + 1), rz_poly(nfit% + 1)
  
  for i% = 1 to nfit% + 1
    
    read rx_poly(i%), ry_poly(i%), rz_poly(i%)
    
  next i%
  
  DATA 	 8	, 	2.457754500000000e+06	, 	2.457934500000000e+06
  
  DATA 	2.134027806840957e+00	, 	9.543189911061361e-01	, 	9.526177383988093e-01
  DATA 	5.025062341641460e-01	, 	-1.011766017306525e+00	, 	2.578044803884425e-01
  DATA 	-2.061765652841142e-01	, 	-1.016497634075366e-01	, 	-9.178213299413558e-02
  DATA 	-7.742654456397965e-03	, 	3.427965375902610e-02	, 	-4.478568639960727e-03
  DATA 	3.618432401314320e-03	, 	-2.814447861892135e-04	, 	1.667665978260282e-03
  DATA 	-2.242729009804329e-04	, 	-3.592688884894230e-04	, 	-9.322115006743514e-05
  DATA 	-1.648858407963003e-05	, 	4.950032674587589e-05	, 	-8.975809782349772e-06
  DATA 	6.131230013436036e-06	, 	-1.509914071353948e-06	, 	2.886863315435898e-06
  DATA 	-6.305023166742875e-07	, 	-6.085663471797373e-07	, 	-2.778759310652511e-07
  
  ' beginning and end of valid time interval
  ' in Julian centuries wrt 1/1.5/2000 TDB
  
  ta = (jdtdb1 - 2451545.0) / 36525.0
  
  tb = (jdtdb2 - 2451545.0) / 36525.0
  
  ''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' evaluate ephemeris at initial date + 30.56788 days
  ''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  delta_days = 30.56788
  
  jdtdb = jdtdb1 + delta_days
  
  x = (jdtdb - 2451545.0) / 36525.0
  
  teval(ta, tb, nfit%, ry_poly(), x, rplanet(1))
  
  teval(ta, tb, nfit%, rx_poly(), x, rplanet(2))
  
  teval(ta, tb, nfit%, rz_poly(), x, rplanet(3))
  
  ' print position vector and magnitude
  
  print " "
  print "planet position vector and magnitude"
  print "------------------------------------"
  print " "
  
  print "r_x  = ", str$(aunit * rplanet(1), 0, 8), " kilometers"
  print " "
  print "r_y  = ", str$(aunit * rplanet(2), 0, 8), " kilometers"
  print " "
  print "r_z  = ", str$(aunit * rplanet(3), 0, 8), " kilometers"
  print " "
  print "rmag = ", str$(aunit * vecmag(rplanet()), 0, 8), " kilometers"
  print " "
  
end
  
  '''''''''''''''''''''''''''''''
  '''''''''''''''''''''''''''''''
  
sub teval(fa, fb, n%, c(), x, tf)
  
  ' evaluate chebyshev series subroutine
  
  ''''''''''''''''''''''''''''''''''''''
  
  f1 = 0.0
  
  f2 = 0.0
  
  xx = (2.0 * x - fa - fb) / (fb - fa)
  
  xx2 = 2.0 * xx
  
  for i% = n% to 1 step -1
    
    oldf1 = f1
    
    f1 = xx2 * f1 - f2 + c(i% + 1)
    
    f2 = oldf1
    
  next i%
  
  tf = xx * f1 - f2 + 0.5 * c(1)
  
end sub
  
  ''''''''''''''''''
  ''''''''''''''''''
  
function vecmag(a())
  
  ' vector magnitude function
  
  ' input
  
  '  { a } = column vector ( 3 rows by 1 column )
  
  ' output
  
  '  vecmag = scalar magnitude of vector { a }
  
  vecmag = sqr(a(1) * a(1) + a(2) * a(2) + a(3) * a(3))
  
end function
  

