'Colour Maximite colour cycling trick.
'Note: uses non-standard techniques: run at your own risk.
'by ceptimus. August 2019.

'with an LCD monitor connected via VGA you should see impossible colours
'with an CRT VGA monitor you may see pixels to the left of the normal display
'Comments to The Back Shed Forum thread, or to ceptimus@ceptimus.co.uk

'r is the amount to dim red by, g the amount to dim green, b blue
'only bits 0-3 in r,g,b seem to affect the dimming, so there's no point
'using numbers bigger than 15
'it seems that it's the number of bits set in r,g, and b that matters
'you can set 1,2,3, or 4 bits but the pattern doesn't seem to make much
'difference, so &B1001 (9) gives the same dimming effect As &B0011 (3)

Sub pokeColours(r,g,b)
  Local j

  For j=3 To 7743 Step 36
    Poke rvideo,j,r
    Poke gvideo,j,g
    Poke bvideo,j,b
  Next
End Sub

Mode 4:Cls
Print"Demonstrating colour-cycling"
Print "for VGA monitors"
For c=1 To 7
  For x=0 To 15
    Line(c*16+x,40)-(c*16+x+80,200),c
  Next
Next
For i=0 To 4095 Step 14 'step 14 is just to speed it up - could go step 1
  r= i And &B000000001111
  g=(i And &B000011110000) \ 16
  b=(i And &B111100000000) \ 256
  pokeColours(r,g,b)
Next

'fade to black
For i=0 To 4
  b=2^i-1
  pokeColours(b,b,b)
  Pause 300
Next
Pause 1000
pokeColours(0,0,0) 'back to normal


