'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Micromite Controlled AD9833 Signal Generator   
' SignalGeneratorAD9833_v1.0.bas
' Gerry Allardice Apr 16
' V1.00 21/4/2016 
'''''''''''' Acknowledgements'''''''''''''''''''''''''''''''''
' SPI control code by Peter Mather (@MatherP of TBS) 
' Touch interface routines based on those found in
' Geoff Graham's programs:
'   Garage Parking Assistant Dec 15
'   Boat Computer            Feb 16
' Font containing graphic symbols created using
' FontTweak program by @TassieJim
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Requires MMBasic 5.1 or later and an ILI9341 based LCD panel with touch
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'''''''' Command Line setup of LCD and Touch and Calibration ''''''''''''''''
'OPTION LCDPANEL ILI9341,L,4,5,6
'OPTION TOUCH 7,2
'GUI CALIBRATE
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Turn on the backlight if required.
SETPIN 26 ,DOUT
PIN(26)=0  'may need to be 0 or 1 depending on how backlight is driven for the LCD



Option Autorun On
Option Explicit
Option Default Integer
'DIM CT,RT,CM,cyan,yellow,white,blue,green,magenta  'Dont show in MMEDIT as single use variable

' Micromite pin allocation and AD9833 wiring for modules 0 and 1
'AD9833 pin        Micromite
'  CS0 ----> 10
'  CS1 ----> 16
'  DAT ----> 3   SPI-OUT
'  CLK ----> 25  SPI-CLK
'  FSY0 ----> 9
'  FSY1 ----> 15
'  GND ----> 8  or any GND
'  VCC ----> 13 or any 3.3V
DIM selectedmodule=0
'Module 0
CONST CS0%=10 '  pin for MCP41010 chip select (CS) pin on digital potentiometer
CONST FSY0%=9 ' pin for AD9833 chip select(FSY) pin on module
'Module 1
CONST CS1%=16 ' pin for MCP41010 chip select (CS) pin on digital potentiometer
CONST FSY1%=15 ' pin for AD9833 chip select(FSY) pin on module
'CONST T_IRQ=2  'Touch Interupt
DIM INTEGER T_IRQ
'Get the Touch Interrupt.
'http://www.thebackshed.com/forum/forum_posts.asp?TID=8575 for reading Options
T_IRQ=peek(byte peek(word &H9D000090) + 23) 'read the Touch Interupt
' set interrupt to detect touch if using interupt
SetPin T_IRQ, INTL, TouchDown
SetPin T_IRQ, OFF   'Turn it off as not required

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' colours used 
Const cBGnd = RGB(96, 96, 150)      ' background colour
Const cBorder = RGB(blue)           ' border colour
      ' 


Const cTitle = RGB(green)           ' title colour
Const cEntry = RGB(yellow)          ' colour used for the entry
CONST cButton =RGB(cyan)            ' the key colour
Const cSave = RGB(white)            ' the save button

' other colours used in keypad entry screens
Const cDel = RGB(magenta)           ' the delete button
Const cSpecial = RGB(248, 184, 184) ' special buttons

'Define the fonts used
CONST fSmall=1
CONST fStandard=2
CONST fGraphics=4   'font used to store graphic symbols


Dim Integer key_coord(20, 5)
Dim Integer key_font(20)
Dim String key_caption(20)
DIM Integer selected(20),selected0(20),selected1(20)

DIM INTEGER nbr,x,c
Dim Integer  fChanged=0,gChanged=0,wavetype,gain,slidervalue, frequency,wavetype0,gain0,slidervalue0, frequency0,wavetype1,gain1,slidervalue1, frequency1

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'
' AD9833 Control Bits
'
CONST B28%=&H2000
'CONST HLB%=&H1000
'CONST FSELECT%=&H800
'CONST PSELECT%=&H400
CONST RESET%=&H100
'CONST SLEEP1%=&H80
CONST SLEEP12%=&H40
CONST OPBITEN%=&H20
CONST DEV2%=8
CONST MODE%=2
'

'
' Output modes 
'
CONST triangle=1
CONST sine=0
CONST square=-1
'
'Module 0
pin(CS0%)=1
PIN(FSY0%)=1
setpin CS0%,dout
setpin FSY0%,dout
'Module 1
pin(CS1%)=1
PIN(FSY1%)=1
setpin CS1%,dout
setpin FSY1%,dout

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
pause 2000 'wait for signal genrator to initialise
' restore the settings.  
Var Restore
'Check if values have been saved. If not set them to default

IF frequency0=0 then
 frequency0=10000
 gain0=150
 wavetype0=sine
 slidervalue0=5
end if

IF frequency1=0 then
 frequency1=10000
 gain1=150
 wavetype1=sine
 slidervalue1=5
end if

selected(8)=1:selected(9)=0  'channel 0 selected

selected0(2)=0:selected0(3)=0:selected0(4)=0
if wavetype0=square then 
  selected0(3)=1   'Square
else if wavetype0=triangle then
  selected0(4)=1   'Triangle
else
  selected0(2)=1  'Sine
End if  

selected1(2)=0:selected1(3)=0:selected1(4)=0
if wavetype1=square then 
  selected1(3)=1   'Square
else if wavetype1=triangle then
  selected1(4)=1   'Triangle
else
  selected1(2)=1  'Sine
End if   
  
'If GotTouch > 0 And GotTouch < MM.VRes/2 Then
'      ' the top half of the screen was touched 
'      SetPin 2, OFF                         ' no interrupts in the menus
'      GotTouch = -1
'     
'ElseIf GotTouch > MM.VRes/2 Then
'      ' if the bottom half was touched show the details menu
'      SetPin 2, OFF                         ' no interrupts in the menus
'      'WatchDog 600000                        ' reset after 10 minutes
'      'SetDetailMode                          ' show the details menu
'      SetPin 2, INTL, TouchDown             ' reinstate the interrupt
'      GotTouch = -1
'EndIf

CLS
fChanged=1   'Get it to update at startup
GetOptions


end
'
sub updateamplitude(i%,module%) ' Sets the output of the MCP41010 digital potentiometer (0-255)
  local j%=&H1100 OR (i% AND 255)
  if module%=0 then pin(CS0%)=0 else pin(CS1%)=0
  spi write 1,j%
  If module%=0 then PIN(CS0%)=1 else pin(CS1%)=1
end sub


'
sub updatefrequency(fin%, wave%,module%) 'Sets the frequency (Hz) and waveform of the AD9833 (Sine:wave%=0, Triangle:wave%=1, Square:wave%=-1)
  local oscillator%=25000000 'Crystal frequency
  local twoby28%=268435456 '2^28
  local f%=(fin%*twoby28%)\oscillator%
  LOCAL c%=0
  local f1%=(f% and &H3FFF) OR &H4000
  local f2%=(f%>>14) OR &H4000
  LOCAL p%=&B1100000000000000
  if wave% =triangle then c%=c% OR MODE%
  if wave%=square then c%=c% OR SLEEP12% OR OPBITEN% OR DEV2%
  if module%=0 then pin(FSY0%)=0 else pin(FSY1%)=0 
  spi write 5,c% OR RESET% OR B28%,f1%,f2%,p%,c%
'  print bin$(c% OR RESET% OR B28%,16)," ",bin$(f1%,16)," ",bin$(f2%,16)," ",bin$(p%,16)," ",bin$(c%,16)
  If module%=0 then PIN(FSY0%)=1 else pin(FSY1%)=1
end sub



SUB showbar(j%,xc%,yt%)
  Local bar$
  select case j% 
   case 0
     bar$=chr$(6)+chr$(12)
   case 1
     bar$= chr$(7)+chr$(12)
   case 2
     bar$= chr$(8)+chr$(12)
   case 3
     bar$= chr$(9)+chr$(12)
   case 4
    bar$= chr$(10)+chr$(12)
   case 5
     bar$= chr$(11)+chr$(12) 
   case 6
     bar$= chr$(11)+chr$(13) 
   case 7
     bar$= chr$(11)+chr$(14) 
   case 8
     bar$= chr$(11)+chr$(15) 
   case 9
     bar$= chr$(11)+chr$(16)  
   case 10    
    bar$= chr$(11)+chr$(17)
  end select
   Text xc%,yt%, bar$,CM , 4, 1,RGB(cyan), 0  
end sub
 
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' this is the touch interrupt used when the main screen is touched
' all it does is set a flag
Sub TouchDown
  GotTouch = Touch(y)
End Sub
  


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' routines to draw the option pages and get any changes
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' get the first page of options (frequency, offset and call GetThresholds)
Sub GetOptions
  LOCAL refresh%
  Local integer b
  refresh%=&HFFFFFFFFFFFFFFFF
  'CLS
  'Watchdog 600000      ' restart program after 10 minutes if no key pressed
      spi open 1000000,3,16 'MCP41010 seem to need mode 3
      
      gain0=getGain(frequency0,slidervalue0,wavetype0) 
      updateamplitude(gain0,0)
      gain1=getGain(frequency1,slidervalue1,wavetype1) 
      updateamplitude(gain1,1)
      SPI CLOSE
      spi open 1000000,2,16 'has to be mode 2 for AD9833
      updatefrequency(frequency0,wavetype0,0) 
      updatefrequency(frequency1,wavetype1,1)
      SPI CLOSE 
      'select module 0 at startup       
      selectedmodule=0
       if selectedmodule=0 then
       selected(2)=selected0(2)
       selected(3)=selected0(3)
       selected(4)=selected0(4)
       'selected(8)=selected0(8)
       'selected(9)=selected0(9)
       slidervalue=slidervalue0
       frequency=frequency0
       wavetype=wavetype0
     else
       selected(2)=selected1(2)
       selected(3)=selected1(3)
       selected(4)=selected1(4)
       'selected(8)=selected1(8)
       'selected(9)=selected1(9)
       slidervalue=slidervalue1
       frequency=frequency1
       wavetype=wavetype1
     
     end if 
  
  Do
     if (refresh%=&HFFFFFFFFFFFFFFFF) then  
       CLS
       'DrawButton 5, 0,5,0,70,34,RGB(yellow),CHR$(20),4
       'DrawButton 5, 0,120,0,70,34,RGB(yellow),CHR$(23),4
       'DrawButton 5, 0,235,0,70,34,RGB(red),CHR$(21),4
     end if
    'Text 225, 100, " "+str$(gain)+" ", LT, fStandard, 1
     
       ' draw/refresh the options and the change button
       if (refresh% AND &H1)   then DrawOption 0, RGB(240, 240, 240), "Frequency", 225,170, frequency, "Hz"
       'ClearButton 1
       if (refresh% AND &H2)   THEN DrawOptionButton 1, RGB(yellow), "",225, 0,RGB(yellow), Chr$(23),0
      
       if (refresh% AND &H4)   THEN DrawOptionButton 2, RGB(250, 192, 250), "Wave Form", 5, 38,cButton, chr$(1),selected(2)
       if (refresh% AND &H8)   THEN DrawOptionButton 3, RGB(250, 192, 250), "Wave Form", 115, 38,cButton, Chr$(2),selected(3)
       if (refresh% AND &H10)  THEN DrawOptionButton 4, RGB(250, 192, 250), "Wave Form", 225, 38,cButton, chr$(3),selected(4)
       ClearButton 5
       'if (refresh% AND &H2)   THEN DrawOption 1, RGB(250, 192, 250), "Amplitude", 100, gain, "%"
       if (refresh% AND &H20)  THEN DrawSliderButton 6, RGB(250, 192, 250), "Amplitude", 5, 106, chr$(18),slidervalue
       if (refresh% AND &H40)  THEN DrawSliderButton 7, RGB(250, 192, 250), "Amplitude", 225, 106, chr$(19),slidervalue
     
       if (refresh% AND &H80)   THEN DrawOptionButton 8, RGB(250, 192, 250), "", 5, 0,cButton, chr$(24),selected(8)
       if (refresh% AND &H100)  THEN DrawOptionButton 9, RGB(250, 192, 250), "", 115, 0, cButton,Chr$(25),selected(9)

    
    WATCHDOG OFF    'Stop any WATCHDOG timer 
    Do While Touch(x) = -1 : Loop  'Wait till touch 
    refresh%=&H0
    ' get the selected button and take action based on the button
    b = CheckButtonPress(0, 9)'Check buttons 0-7
    Select Case b
      Case 0   'FREQUENCY
        CheckButtonRelease b
        nbr = frequency
        GetInteger "Freq.(Hz)", nbr
        frequency = nbr
        fChanged=1
        if selectedmodule=0 then
          frequency0=frequency
          
        else
          frequency1=frequency
          
        endif  
        
        refresh%=&HFFFFFFFFFFFFFFFF
        
      Case 1 'save
        CheckButtonRelease b
        
          
          Var Save frequency0,wavetype0,slidervalue0,gain0,frequency1,wavetype1,slidervalue1,gain1
          
          refresh%=&HFFFFFFFFFFFFFFFF 
          MessageBox "Current Settings", "Saved!"     
'        nbr = gain
'        GetInteger "Amplitude (%)", nbr
'        If nbr > 255 Then
'           MessageBox "Invalid number", ">255"
'        elseIf nbr<0 then
'           MessageBox "Invalid number", "<0"      
'        Else
'           gain = nbr
'           gChanged=1
'           Var Save gain           
'           refresh%=&HFFFFFFFFFFFFFFFF
'          
'        EndIf
          
      Case 2       'Select SINE Option
          CheckButtonRelease b
          selected(2)=1
          selected(3)=0
          selected(4)=0
          wavetype=0
          fChanged=1
          
          'Var Save wavetype
          refresh%=&H1C
          if selectedmodule=0 then
            wavetype0=wavetype
          else
            wavetype1=wavetype
          endif
          gain=getGain(frequency,slidervalue,wavetype)
        
         
      Case 3       'select SQUARE Option
          CheckButtonRelease b
          selected(2)=0
          selected(3)=1
          selected(4)=0
          wavetype=-1
          fChanged=1
          'Var Save wavetype
          refresh%=&H1C
          if selectedmodule=0 then
            wavetype0=wavetype
          else
            wavetype1=wavetype
          endif  
          gain=getGain(frequency,slidervalue,wavetype)
          
      Case 4      'select TRIANGLE Option 
          CheckButtonRelease b
          selected(2)=0
          selected(3)=0
          selected(4)=1
          wavetype=1
          fChanged=1
          'Var Save wavetype
          refresh%=&H1C
          if selectedmodule=0 then
            wavetype0=wavetype
          else
            wavetype1=wavetype
          endif 
          gain=getGain(frequency,slidervalue,wavetype) 
       
      Case 5   ' FINISH BUTTON
        CheckButtonRelease b
        'Var Save gain, frequency,wavetype
        fChanged=1
        cls
        Exit SUB
        
      Case 6 'amplitude down
        CheckButtonRelease b
         if slidervalue>1 then 
           slidervalue=slidervalue-1
           gain=getGain(frequency,slidervalue,wavetype) 
           gChanged=1
           'Var Save gain           
           refresh%=&H20
           if selectedmodule=0 then
            slidervalue0=slidervalue
            gain0=gain
           else
            slidervalue1=slidervalue
            gain1=gain
           endif 
         ENDIF 
           
          
       Case 7 'amplitude up
        CheckButtonRelease b
        if slidervalue<10 then 
           slidervalue=slidervalue+1
           gain=getGain(frequency,slidervalue,wavetype) 
          'GetInteger "Amplitude (%)", nbr
          ' gain = nbr
           gChanged=1
           'Var Save gain           
           refresh%=&H40
           if selectedmodule=0 then
             slidervalue0=slidervalue
             gain0=gain
           else
             slidervalue1=slidervalue
             gain1=gain
           endif 
           
        END IF 
           
       Case 8 'Channel 0 selected
         CheckButtonRelease b
         if selectedmodule=1 then
         
          frequency1=frequency
          gain1=gain
          wavetype1=wavetype
          selected1(2)=selected(2)
          selected1(3)=selected(3)
          selected1(4)=selected(4)
          slidervalue1=slidervalue
           
          frequency=frequency0
          gain=gain0
          wavetype=wavetype0
          selected(2)=selected0(2)
          selected(3)=selected0(3)
          selected(4)=selected0(4)
          slidervalue=slidervalue0    
         end if          
         
         selectedmodule=0   
         selected(8)=1:selected(9)=0
         refresh%=&HFFFFFFFFFFFFFFFF 
          

       Case 9 'Channel 1 selected
         CheckButtonRelease b       
         if selectedmodule=0 then
          frequency0=frequency
          gain0=gain
          wavetype0=wavetype
          selected0(2)=selected(2)
          selected0(3)=selected(3)
          selected0(4)=selected(4)
          slidervalue0=slidervalue 
          
          frequency=frequency1
          gain=gain1
          wavetype=wavetype1
          selected(2)=selected1(2)
          selected(3)=selected1(3)
          selected(4)=selected1(4)
          slidervalue=slidervalue1    
         end if  
         selectedmodule=1
         selected(8)=0:selected(9)=1
         refresh%=&HFFFFFFFFFFFFFFFF
          
       Case -1
          ' no SET buttons have been touched, now check the main entries
'          y = Touch(y)
'          If y <> -1 And Touch(x) < MM.HRes - 70 Then
'            For i = 1 To 7
'              If y < (MM.VRes/7) * i Then
'                Circle 10, DetailMode * MM.VRes/7 + MM.VRes/14, 10, 2, 1, cSave, 0
'                DetailMode = i - 1
'                Circle 10, DetailMode * MM.VRes/7 + MM.VRes/14, 10, 2, 1, cSave, cEntry
'                Do While Touch(y) <> -1 : Loop
'                If Not DemoMode Then VAR Save DetailMode
'                Exit Sub
'              EndIf
'            Next i
'          EndIf   
        
    End Select
    If gchanged=1 then
      gChanged=0
      spi open 1000000,3,16   'MCP41010 seem to need mode 3
      updateamplitude(gain,selectedmodule) 'scale output 100%
      spi CLOSE
      'Text 225, 100, " "+str$(gain)+" ", LT, fStandard, 1
    end if
    if fChanged=1 then
      fChanged=0
      spi open 1000000,3,16  'MCP41010 seem to need mode 3 
      updateamplitude(gain,selectedmodule) 'scale output 100%
      spi CLOSE
      spi open 1000000,2,16 'has to be mode 2 for AD9833
      updatefrequency(frequency,wavetype,selectedmodule) 
      spi CLOSE
      'Text 225, 100, " "+str$(gain)+" ", LT, fStandard, 1
      
    end if 
'    if selectedmodule=0 then
'          frequency0=frequency
'          gain0=gain
'          wavetype0=wavetype
'          selected0(2)=selected(2)
'          selected0(3)=selected(3)
'          selected0(4)=selected(4)
'          slidervalue0=slidervalue
'    else
'         frequency1=frequency
'         gain1=gain
'         wavetype1=wavetype
'         selected1(2)=selected(2)
'         selected1(3)=selected(3)
'         selected1(4)=selected(4)
'         slidervalue1=slidervalue
'
'    endif
   
  Loop
End Sub
 Function getGain(freq as integer,slider as Integer,wave as integer) as integer
 
    
   Select CASE wave
    case sine,triangle     
    
     select CASE freq     
      case < 400000
        getGain=slider*18
      case < 500000 
        getGain=int(slider*18.5)
      case < 1000000
        getGain=int(slider*19.5)
      case < 2000000
        getGain=int(slider*22)
      case < 4000000
        getGain=int(slider*25.5)
      CASE ELSE
        getGain=int(slider*25.5)
     end select
    
    CASE square
      
       getGain=INT(7+slider*2)
   END SELECT   
 
 END FUNCTION



'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Draw options and get button presses
' These two subs draw the option title, value and a button labeled "CHANGE"
' The function CheckButtonPress() will check if a button has been touched.
'
' These routines use the arrays key_coord() and key_caption() to track the
' coordinates and size of each button and save its caption.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' draw a single option
Sub DrawSliderButton n As Integer, foreground As Integer, title As String, xpos as integer, ypos As Integer,label as String, value As Integer
  Const btn_width = 80 '120
  Const fonth = MM.FontHeight * 2
  Const pad_width = 4
  'Text MM.HRes/2, vert, chr$(1), CT, 4, 1, colour
  Text MM.HRes/2, ypos, title, CT, fStandard, 1, foreground,cBGnd
  showbar(value,MM.HRes/2,ypos+fonth+12+pad_width+1) 
  DrawButton n, 0,xpos,ypos + fonth + pad_width/2,btn_width,fonth + pad_width,cButton,label,fGraphics
end sub


' draw a single option
Sub DrawOptionButton n As Integer, foreground As Integer, title As String, xpos as integer, ypos As Integer,btn_colour As Integer,label as String, selected As Integer
  Const btn_width = 80 '120
  Const fonth = MM.FontHeight * 2
  Const pad_width = 4
  'Text MM.HRes/2, vert, chr$(1), CT, 4, 1, colour
  if title<>"" then 
    Text MM.HRes/2, ypos, title, CT, fStandard, 1, foreground,cBGnd
    DrawButton n, 0,xpos,ypos + fonth + pad_width/2,btn_width,fonth + pad_width,btn_colour,label,fGraphics
  else
    DrawButton n, 0,xpos,ypos ,btn_width,fonth + pad_width,btn_colour,label,fGraphics
  end if  
  if selected=1 then DrawButton n,2
End Sub

' draw a single option
Sub DrawOption n As Integer, foreground  As Integer, title As String,xpos as integer, ypos As Integer, value As integer, units As String
  Const btn_width = 80'120
  Const fonth = MM.FontHeight * 2
  Const pad_width = 4
  Text MM.HRes/2, ypos, title, CT, fStandard, 1, foreground,cBGnd
  If value <> -1 Then Text MM.HRes/2 + 50, ypos + fonth +pad_width, Str$(value) + " " + units, RT, fSmall, 2, foreground,cBGnd
  DrawButton n, 0,xpos,ypos + fonth + pad_width/2,btn_width,fonth + pad_width,cButton,"SET",fStandard
End Sub





'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Get an integer number
' when the user touches ENT (enter) the value is saved into the variable result
' which is parsed as reference as the second argument
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub GetInteger title As String, result As integer
  
  
  
  
  Local String s=""
  Local i, b
  ' these are the captions on each key
  Local String Scap(15) = ("7","8","9","","4","5","6","","1","2","3","Can","000","0","Del","ENT")
  'Local string strOriginal = str
  Const bw = MM.HRes\4, bh = MM.VRes\5

  CLS 0
  ' draw the title
  Text 0, 8, title + ": ", , 2, 1, cTitle, cBGnd
  
  For i = 0 To 15
    Select Case i
    CASE 3,7 'Not used
      ClearButton i 
    Case 11  'CAN
      DrawButton i, 0, bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, cSpecial, SCap(i),2   
    Case 14  'DEL
      DrawButton i, 0, bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, cDel, SCap(i),2 
    CASE 15 'ENT
      DrawButton i, 0, bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, cSave, SCap(i),2     
    case else
      DrawButton i, 0, bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, cButton, SCap(i),2    
    end select
  Next i

  
  Do
    'If Timer > 700 Then Text bw, 10, str + "_", , 2, 1, cEntry, 0 : Timer = 0
    'If Timer > 500 Then Text bw, 10, str + " ", , 2, 1, cEntry, 0
      b = CheckButtonPress(0, 15)
      Select Case b
       
        Case 0,1,2,4,5,6,8,9,10,12,13
          CheckButtonRelease b
          s = s + SCap(b)
          'Text bw, 10, s, , 2, 1, cEntry, 0
          Text Len(title + ": ") * 16, 8, s + " ", , 2, 1, cEntry, 0
        Case 11  'Cancel
          CheckButtonRelease b
          Exit Do
        Case 14  'DEL  
          CheckButtonRelease b
          If s <> "" Then s = Left$(s, Len(s) - 1)           
          Text Len(title + ": ") * 16, 8, s + " ", , 2, 1, cEntry, 0
        Case 15  'Enter
          CheckButtonRelease b
           If  s <> "" Then result = Val(s)
          Exit Do  
              
      End Select
    EndIf
  Loop

End Sub



'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Draw buttons and get button presses
'
' The subrouting DrawButton will draw a button (normally used when drawing
' the screen for input).
'
' The function CheckButtonPress() will check if a button has been touched.
' If it has it will set it to selected (reverse video) and return with the
' button's number.
'
' The subroutine CheckButtonRelease will wait for the touch to be released
' and will then draw the button as normal.
'
' These routines use the global arrays key_coord() and key_caption() to
' track the coordinates and size of each button and save its caption.
'
' IMPORTANT: These routines set the watchdog to 10 minutes.  If a button
'            has not been pressed within this time the Micromite will
'            restart.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Clear button coordinates if not currently used
Sub ClearButton n as integer
     
    key_coord(n,0) = 0 : key_coord(n,1) = 0 : key_coord(n,2) = 0 : key_coord(n,3) = 0
    key_coord(n,4) = 0 : key_caption(n) = "" :key_font(n) = 1
  

End Sub
' draw a button
Sub DrawButton n As Integer, mode As Integer, x As integer, y As integer, w As integer, h As integer, c As integer, s As string,f as Integer
  Local integer backcolour, forecolour

 
  If mode = 0 Then
    key_coord(n,0) = x : key_coord(n,1) = y : key_coord(n,2) = w : key_coord(n,3) = h
    key_coord(n,4) = c : key_caption(n) = s :key_font(n) = f
  EndIf

  If mode > 1 Then
    backcolour = key_coord(n,4) : forecolour = 0    ' draw in reverse video if it is being touched
  Else
    backcolour = 0 : forecolour = key_coord(n,4)    ' a normal (untouched) button
  EndIf

  RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), backcolour
  Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n),CM , key_font(n), 1, forecolour, backcolour
 
End Sub


' check if a button has been touch and animate the button's image
' returns the button's number
Function CheckButtonPress(startn As Integer, endn As Integer) As Integer
  Local Integer xt, yt, n

  CheckButtonPress = -1
  If Touch(x) <> -1 Then
    ' we have a touch
    'WatchDog 600000                        ' reset after 10 minutes
    xt = Touch(x)
    yt = Touch(y)
    ' scan the array key_coord() to see if the touch was within the
    ' boundaries of a button
    For n = startn To endn
      If xt > key_coord(n,0) And xt < key_coord(n,0) + key_coord(n,2) And yt > key_coord(n,1) And yt < key_coord(n,1) + key_coord(n,3) Then
        ' we have a button press
        ' draw the button as pressed
        DrawButton n, 2
        CheckButtonPress = n
        Exit For
      EndIf
    Next n
  EndIf
End Function


' wait for the touch to be released and then draw the button as normal
Sub CheckButtonRelease n As integer
  ' if a button is currently down check if it has been released
  Do While Touch(x) <> -1 : Loop   ' wait for the button to be released
  DrawButton n, 1                  ' draw the button as normal (ie, not pressed)
End Sub



'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' this handy routine draws a message box with an OK button
' then waits for the button to be touched
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MessageBox s1 As String, s2 As String
  Local integer w
  If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
  w = w * 8     ' get the width of the text (used for the box width)

  ' draw the box and the message in it
  RBox MM.HRes/2 - w - 20, 60, w * 2 + 40, 130, , RGB(yellow), 0
  Text MM.HRes/2, 70, s1, CT, 1, 2, RGB(white)
  Text MM.HRes/2, 100, s2, CT, 1, 2, RGB(white)

  ' draw the OK button
  RBox 110, 140, 100, 34, , cButton
  Text MM.HRes/2, 157, "OK", CM, 1, 2, cButton

  ' wait for the button to be touched
  Do While Not (Touch(x) > 110 And Touch(x) < 210 And Touch(y) > 140 And Touch(y) < 180) : Loop

  ' draw the OK button as depressed
  RBox 110, 140, 100, 34, , cButton, cButton
  Text MM.HRes/2, 157, "OK", CM, 1, 2, 0, cButton

  ' wait for the touch to be removed
  Do While Touch(x) <> -1 : Loop
End Sub




'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' embedded fonts
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''




' Font: Hom_16x24_LE
' Includes all ASCII characters
DefineFont #2
  5F201810 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 80010000 80018001
  80018001 80018001 00018001 00010001 00000000 80010000 00008001 00000000
  00000000 00000000 700E0000 700E700E 2004700E 20042004 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 20010000 20012001
  20012001 F80F2001 40024002 F01F4002 40024002 40024002 40024002 00000000
  00000000 00000000 80008000 E8018000 08041802 00040004 E0010002 08001000
  08080800 E00B100C 80008000 80008000 00000000 00000000 00070000 40108008
  40104010 1C078008 0007E000 88007038 04010401 88000401 00007000 00000000
  00000000 00000000 00000000 00000000 C004A003 00040004 00060002 20113009
  4010C010 A0086010 00001807 00000000 00000000 00000000 70000000 E0007000
  8001C000 00000001 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 10000000 20002000 40004000 80004000 80008000 80008000
  80008000 40004000 20004000 10002000 00000000 00000000 00080000 00040004
  00020002 00010002 00010001 00010001 00010001 00020002 00040002 00080004
  00000000 00000000 80000000 80008000 F007980C 6003C001 180C3006 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  80008000 80008000 FC1F8000 80008000 80008000 00008000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 00038003 00040006 00000000 00000000 00000000 00000000
  00000000 00000000 FC1F0000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 0000C001 00000000 00000000 00000000 08000000 10000800
  20001000 40002000 80004000 00018000 00020001 00040002 00080004 00000008
  00000000 00000000 00000000 3006C001 08081004 08080808 08080808 08080808
  08080808 30061004 0000C001 00000000 00000000 00000000 00000000 800E8001
  80008000 80008000 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 00000000 200CC003 10101010 10001000 40002000 00018000
  00040002 08100008 0000F81F 00000000 00000000 00000000 00000000 3008C007
  10001000 20001000 3000C003 08000800 08000800 300C0810 0000C003 00000000
  00000000 00000000 00000000 A0006000 20012001 20042002 20082004 20102008
  2000F81F 20002000 0000F801 00000000 00000000 00000000 00000000 0008F00F
  00080008 C00B0008 1000300C 08000800 08000800 30181000 0000C007 00000000
  00000000 00000000 00000000 0003F000 00040006 E0090008 080C100A 08080808
  08080808 10060804 0000E001 00000000 00000000 00000000 00000000 1010F01F
  20002010 40002000 40004000 80004000 80008000 00010001 00000001 00000000
  00000000 00000000 00000000 2004C003 10081008 10081008 E0072004 08101008
  08100810 300C1008 0000C003 00000000 00000000 00000000 00000000 3006C001
  0808180C 08080808 28061804 0800C801 10000800 60001000 0000800F 00000000
  00000000 00000000 00000000 00000000 00000000 C001C001 0000C001 00000000
  00000000 C001C001 0000C001 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 0000C001 00000000 00000000 C001C001 00038003 00040006
  00000000 00000000 00000000 00000000 60001800 00068001 00300018 00060018
  60008001 00001800 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 0000FC3F FC3F0000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00060018 60008001 0C001800 60001800
  00068001 00000018 00000000 00000000 00000000 00000000 00000000 C0070000
  10082008 10001000 20001000 0001C000 00000001 80010000 00008001 00000000
  00000000 00000000 C0030000 1008200C 10101010 90107010 10111011 10111011
  78109010 00100010 300C0008 0000E003 00000000 00000000 00000000 C00F0000
  20024001 20022002 10041004 F80F1004 08080808 04100410 00001E3C 00000000
  00000000 00000000 00000000 F03F0000 04080808 04080408 F00F0808 04080808
  04080408 08080408 0000F03F 00000000 00000000 00000000 00000000 E4010000
  0C0C1406 00100408 00100010 00100010 04080010 18060C0C 0000E001 00000000
  00000000 00000000 00000000 E03F0000 08101810 04100410 04100410 04100410
  04100410 18100810 0000E03F 00000000 00000000 00000000 00000000 F83F0000
  08080808 80080808 800F8008 80088008 04080408 04080408 0000FC3F 00000000
  00000000 00000000 00000000 FC1F0000 04040404 40040404 C0074004 40044004
  00040004 00040004 0000C01F 00000000 00000000 00000000 00000000 C8030000
  1818280C 00200810 00200020 FC200020 08100820 100C0818 0000E003 00000000
  00000000 00000000 00000000 3E3E0000 08080808 08080808 F80F0808 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 00000000 F80F0000
  80008000 80008000 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 00000000 FE030000 10001000 10001000 10001000 10101000
  10101010 60082010 00008007 00000000 00000000 00000000 00000000 3C3E0000
  20081008 80084008 000B0009 4008800C 10082008 08081008 00001E3E 00000000
  00000000 00000000 00000000 803F0000 00040004 00040004 00040004 00040004
  04040404 04040404 0000FC3F 00000000 00000000 00000000 00000000 0E380000
  0C180C18 14141414 24122412 C4114411 04100410 04100410 00001E3C 00000000
  00000000 00000000 00000000 7E780000 08140818 08120812 08110811 88108810
  48104810 18102810 0000187E 00000000 00000000 00000000 00000000 E0030000
  0C18180C 02200410 02200220 02200220 04100220 180C0C18 0000E003 00000000
  00000000 00000000 00000000 F01F0000 04040804 04040404 08040404 0004F007
  00040004 00040004 0000C01F 00000000 00000000 00000000 00000000 E0030000
  0C18180C 02200410 02200220 02200220 04100220 180C0C18 8C01E003 0000F006
  00000000 00000000 00000000 E03F0000 08081008 08080808 10080808 4008E00F
  10082008 08081008 00000E3E 00000000 00000000 00000000 00000000 C8030000
  1810280C 00100810 C003000C 08003000 08100800 10140818 0000E013 00000000
  00000000 00000000 00000000 FC1F0000 84108410 84108410 80008000 80008000
  80008000 80008000 0000F007 00000000 00000000 00000000 00000000 7C3E0000
  08100810 08100810 08100810 08100810 08100810 10080810 0000E007 00000000
  00000000 00000000 00000000 3E3E0000 04100410 08080808 10041004 20021004
  20022002 C0014001 00008000 00000000 00000000 00000000 00000000 3E3E0000
  04100410 84108410 44114411 280A4809 280A280A 180C180C 0000180C 00000000
  00000000 00000000 00000000 3E3E0000 10040808 20021004 80004001 20024001
  10042002 08080808 00003E3E 00000000 00000000 00000000 00000000 1E3C0000
  10040808 20021004 40012002 80008000 80008000 80008000 0000F007 00000000
  00000000 00000000 00000000 F81F0000 10100810 40102010 80004000 00020001
  08040802 08100808 0000F81F 00000000 00000000 00000000 E0000000 80008000
  80008000 80008000 80008000 80008000 80008000 80008000 80008000 E0008000
  00000000 00000000 00080000 00040008 00020004 00010002 80000001 40008000
  20004000 10002000 08001000 00000800 00000000 00000000 80030000 80008000
  80008000 80008000 80008000 80008000 80008000 80008000 80008000 80038000
  00000000 00000000 80000000 2002C001 08081004 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  FF7F0000 00000000 80030000 C0018003 6000C000 00002000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 2008C007 10001000 3008D007 10101010 30081010 0000DC07 00000000
  00000000 00000000 00000000 00080038 00080008 0C0AF009 0208040C 02080208
  02080208 0C0A040C 0000F039 00000000 00000000 00000000 00000000 00000000
  00000000 180CE803 08100808 00100010 00100010 180C0C08 0000E003 00000000
  00000000 00000000 00000000 08003800 08000800 2818C807 08201810 08200820
  08200820 28181810 0000CE07 00000000 00000000 00000000 00000000 00000000
  00000000 180CE003 04100808 FC1F0410 00100010 0C0C0008 0000F003 00000000
  00000000 00000000 00000000 8401F800 00010001 0001F80F 00010001 00010001
  00010001 00010001 0000F80F 00000000 00000000 00000000 00000000 00000000
  00000000 2818CE07 08201810 08200820 08200820 28181810 0800C807 10000800
  C00F3000 00000000 00000000 00080038 00080008 100AE009 0808080C 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 80000000 80008000
  00000000 80008007 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 20000000 20002000 00000000 1000F00F 10001000 10001000
  10001000 10001000 10001000 20001000 800F6000 00000000 00000000 0004001C
  00040004 20047804 80044004 00070005 40048004 10042004 00003C1C 00000000
  00000000 00000000 00000000 8000800F 80008000 80008000 80008000 80008000
  80008000 80008000 0000FC1F 00000000 00000000 00000000 00000000 00000000
  00000000 C4183877 84108410 84108410 84108410 84108410 0000C67C 00000000
  00000000 00000000 00000000 00000000 00000000 100AE039 0808080C 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 00000000 00000000
  00000000 180CE003 04100808 04100410 04100410 180C0808 0000E003 00000000
  00000000 00000000 00000000 00000000 00000000 0C0AF039 0208040C 02080208
  02080208 0C0A040C 0008F009 00080008 003F0008 00000000 00000000 00000000
  00000000 2818CE07 08201810 08200820 08200820 28181810 0800C807 08000800
  7E000800 00000000 00000000 00000000 00000000 C402380E 00020003 00020002
  00020002 00020002 0000F01F 00000000 00000000 00000000 00000000 00000000
  00000000 1804E803 00040804 70008003 08000800 100C0808 0000E00B 00000000
  00000000 00000000 00000000 00040004 00040004 0004F01F 00040004 00040004
  00040004 18020004 0000E001 00000000 00000000 00000000 00000000 00000000
  00000000 08083838 08080808 08080808 08080808 28041808 0000CC03 00000000
  00000000 00000000 00000000 00000000 00000000 08083E3E 10040808 10041004
  20022002 C0014001 00008000 00000000 00000000 00000000 00000000 00000000
  00000000 04101E3C 84100410 48098808 48094809 30065005 00003006 00000000
  00000000 00000000 00000000 00000000 00000000 08083C1E 20021004 80004001
  20024001 08081004 00003C1E 00000000 00000000 00000000 00000000 00000000
  00000000 08103C3C 10080810 20081008 40042004 80024002 00018001 00020001
  803F0002 00000000 00000000 00000000 00000000 0808F80F 20001008 80004000
  00020001 08080804 0000F80F 00000000 00000000 00000000 60000000 80008000
  80008000 80008000 80008000 80000003 80008000 80008000 80008000 60008000
  00000000 00000000 00000000 80000000 80008000 80008000 80008000 80008000
  80008000 80008000 80008000 80008000 00000000 00000000 00030000 80008000
  80008000 80008000 80008000 80006000 80008000 80008000 80008000 00038000
  00000000 00000000 00000000 00000000 00000000 00000000 98190C0F 0000F030
  00000000 00000000 00000000 00000000 00000000
End DefineFont


' ArialNumFontPlus.bas
' Font type    : Special (SubSet)
' Font size    : 32x50 pixels
' Memory usage : 2204 bytes
DefineFont #3
  0B303220 00000000 00000000 00F00F00 00F81F00 00FE7F00 00FFFF00 00FFFF01
  801FF803 C00FF003 C007E007 E003C007 E003C00F F001800F F001800F F001801F
  F800001F F800001F F800001F F800001F FC00003F 7C00003E 7C00003E 7C00003E
  7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003F
  F800001F F800001F F800001F F800001F F001800F F001800F F001800F E003C007
  E003C007 C007E003 C00FF003 801FF801 00FFFF00 00FEFF00 00FC7F00 00F81F00
  00E00700 00000000 00000000 00000000 00000000 00000000 00F00000 00F00100
  00F00300 00F00700 00F00F00 00F01F00 00F03F00 00F07F00 00F0FF01 00F0FD03
  00F0F10F 00F0E10F 00F0810F 00F0010F 00F0010C 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00000000 00000000 00000000 00000000 00F00F00
  00FE7F00 00FFFF01 C0FFFF03 E0FFFF03 F00FE007 F003C00F F001800F F800001F
  F800001F F800003E 7C00003E 7C00003E 7C000000 7C000000 7C000000 78000000
  F8000000 F8010000 F0030000 F0070000 E00F0000 C01F0000 803F0000 007F0000
  00FE0000 00FC0100 00F80300 00F00700 00E00F00 00C01F00 00803F00 00007F00
  0000FE00 0000FC01 0000F803 0000F007 0000E007 0000C00F 0000800F 0000801F
  FCFFFF3F FCFFFF3F FCFFFF7F FCFFFF7F FCFFFF7F 00000000 00000000 00000000
  00000000 00F00F00 00FC3F00 00FEFF00 00FFFF01 80FFFF03 C01FE003 C00FC007
  E0078007 E003800F E003000F F003000F F001000F F0030000 E0030000 E0030000
  E0070000 C00F0000 C01F0000 803F0000 00FF0700 00FF0700 00FF0700 80FF0700
  C01F0000 E00F0000 E0030000 F0010000 F0000000 F8000000 F8000000 FC000000
  FC000000 FC000000 FC00001F FC00001F F800001F F801001F F801800F F003800F
  F007C00F E00FE007 C03FFC03 80FFFF01 00FFFF00 00FC7F00 00F00F00 00000000
  00000000 00000000 00000000 000F0000 001F0000 001F0000 003F0000 003F0000
  007F0000 007F0000 00FF0000 00FF0100 00FF0100 00FF0300 00DF0700 00DF0700
  009F0F00 009F0F00 001F1F00 001F3E00 001F7E00 001F7C00 001FF800 001FF800
  001FF001 001FE003 001FE003 001FC007 001FC007 001F800F 001F801F 001F001F
  001F003E FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F 001F0000 001F0000
  001F0000 001F0000 001F0000 001F0000 001F0000 001F0000 001F0000 001F0000
  001F0000 00000000 00000000 00000000 00000000 F0FFFF01 F0FFFF01 F0FFFF01
  F0FFFF01 F0FFFF01 0000E003 0000C003 0000C003 0000C003 0000C007 0000C007
  0000C007 0000C007 00008007 0000800F 00F0800F 00FE8F0F 80FFBF0F C0FFFF0F
  E0FFFF0F F007FF1F F003E01F F801C01F F800001F F8000000 FC000000 7C000000
  7C000000 7C000000 7C000000 7C000000 7C000000 7C000000 F800003F F800003F
  F800003F F000001F F001001F E003801F E007C00F C01FE007 80FFFF03 00FFFF03
  00FEFF01 00F87F00 00E00F00 00000000 00000000 00000000 00000000 00F00F00
  00FE3F00 00FFFF00 80FFFF01 C0FFFF03 E007E007 F003C007 F001C00F F800800F
  F800801F F800801F 0000001F 0000001F 0000003F 0000003F 0000003F 00F0033F
  00FC1F3F 00FE7F3F 80FFFF3F C0FFFF3F E00FF83F F003E03F F003E03F F801C03F
  F800803F F800803F 7C00003F 7C00003F 7C00003F 7C00003F 7C00003F 7C00003F
  7C00001F 7800801F F800801F F800801F F800800F F001C00F F003F007 E00FF803
  C0FFFF01 80FFFF00 00FF7F00 00FC1F00 00F00300 00000000 00000000 00000000
  00000000 FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FC000000 FC000000
  F8010000 F0010000 E0030000 E0030000 C0070000 800F0000 001F0000 003E0000
  007C0000 00FC0000 00F80000 00F00000 00F00100 00F00100 00E00300 00E00300
  00E00300 00C00700 00C00700 00800F00 00800F00 00800F00 00001F00 00001F00
  00001F00 00001F00 00003E00 00003E00 00003E00 00003E00 00003E00 00007C00
  00007C00 00007C00 00007C00 00007C00 0000F800 0000F800 0000F800 00000000
  00000000 00000000 00000000 00F00F00 00FE7F00 80FFFF00 80FFFF01 C01FF803
  E007E007 E003C007 F003C00F F001800F F001800F F001800F F001800F F001800F
  F001800F E003C007 E003C007 C007E003 8007F001 003FFC00 00FF7F00 00FC3F00
  00FE7F00 00FFFF00 C0FFFF03 E00FF007 F003C00F F001800F F801801F F800001F
  F800001F 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E F800001F
  F800001F F001800F F003800F E007C007 C00FF003 80FFFF01 00FFFF00 00FC3F00
  00F00F00 00000000 00000000 00000000 00000000 00F00F00 00FC3F00 00FFFF00
  80FFFF01 C0FFFF03 E01FF803 E007E007 F007E007 F003C00F F803C00F F801801F
  F801801F FC00001F FC00001F FC00001F FC00001F FC00001F FC00001F FC01801F
  FC01801F FC03C00F FC03C00F FC07E007 FC07E007 FC1FF803 FCFFFF01 FCFFFF00
  FCFEFF00 FCF87F00 FCE01F00 FC000000 FC000000 FC000000 FC000000 F8010000
  F801003F F001003F F003001F E007801F E00FC00F C03FE00F 80FFFF07 00FFFF03
  00FEFF01 00F8FF00 00E03F00 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00E00000 00F00100 00F80300 00F80300 00F80300 00F00100 00E00000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00E00000 00F00100
  00F80300 00F80300 00F80300 00F00100 00E00000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000
End DefineFont

' font_48x24_siggen.bas
' Font type    : Full (32 characters)
' Font size    : 48x24 pixels
' Memory usage : 4612 bytes
' Font adapted from: http://www.rinkydinkelectronics.com/r_fonts.php

DefineFont #4
  20011830 00007E00 FF010000 00000080 00C0C303 00070000 000000E0 0070000E
  001C0000 00000038 001C0038 00700000 0000000E 000E0070 00E00000 00000007
  000700E0 00C00000 00008003 C0010000 00000300 0700E000 E0000000 00000700
  0E007000 70000000 00000E00 1C003800 1C000000 00003800 70000E00 07000000
  0000E000 C0C30300 01000000 000080FF 007E0000 80FFFFFF FFFF0700 070080FF
  80FFFFFF 00E00700 07008003 800300E0 00E00700 07008003 800300E0 00E00700
  07008003 800300E0 00E00700 07008003 800300E0 00E00700 07008003 800300E0
  00E00700 07008003 800300E0 00E00700 07008003 800300E0 00E00700 07008003
  800300E0 00E00700 07008003 800300E0 00E00700 FFFFFF03 FF0300E0 00E0FFFF
  FFFFFF03 00003800 7C000000 00000000 0000EE00 C7010000 00000000 00808303
  01070000 000000C0 00E0000E 001C0000 00000070 00380038 00700000 0100001C
  000E00E0 00C00300 07000007 80030000 00000E00 1C00C001 E0000000 00003800
  70007000 38000000 0000E000 C0011C00 0E000000 00008003 00070700 03000000
  0000008E 00DC0100 00000000 000000F8 00700000 C0030000 00000300 0700C007
  C00F0000 00000F00 1E00C01F C03D0000 00003C00 7800C079 C0F10000 0100F000
  E001C0E1 C0C10300 0700C003 8007C081 C0010F00 1E00000F 001EC001 C0013C00
  7800003C 0078C001 C001F000 E00100F0 00E0C101 C301C003 800700C0 0080C701
  CF01000F 001E0000 0000DE01 FC01003C 00780000 0000F801 F00100F0 00E00000
  0000E001 00003800 7C000000 00000000 0000EE00 C7010000 00000000 00808303
  01070000 000000C0 00E0000E 001C0000 00000070 00380038 00700000 0100001C
  000E00E0 00C00300 07000007 80030000 00000E00 1C00C001 E0000000 00003800
  70007000 38000000 0000E000 C0011C00 0E000000 00008003 00070700 03000000
  0000008E 00DC0100 00000000 000000F8 00700000 FFFFFFFF 0080FFFF 00000000
  00000080 00800000 00000000 00000080 00800000 00000000 00000080 00800000
  00000000 00000080 00800000 00000000 00000080 00800000 00000000 00000080
  0080FE00 82000000 01000080 008082FC 82040100 F9030080 00808204 82040902
  09F20780 04808204 82040912 0912E48F 24888204 82040912 09122488 FFFF8204
  FFFFFFFF FFFFFFFF 0080FFFF 00000000 00000080 00800000 00000000 00000080
  00800000 00000000 00000080 00800000 00000000 00000080 00800000 00000000
  00000080 00800000 00000000 00000080 0080FE00 82000000 01000080 008082FC
  82040100 F9030080 00808204 82040902 09F20780 04808204 82040912 0912E48F
  E48F8204 82040912 0912E48F FFFF8204 FFFFFFFF FFFFFFFF 0080FFFF 00000000
  00000080 00800000 00000000 00000080 00800000 00000000 00000080 00800000
  00000000 00000080 00800000 00000000 00000080 00800000 00000000 00000080
  0080FE00 82000000 01000080 008082FC 82040100 F9030080 00808204 82040902
  09F20780 07808204 820409F2 09F2E78F E78F8204 820409F2 09F2E78F FFFF8204
  FFFFFFFF FFFFFFFF 0080FFFF 00000000 00000080 00800000 00000000 00000080
  00800000 00000000 00000080 00800000 00000000 00000080 00800000 00000000
  00000080 00800000 00000000 00000080 0080FE00 82000000 01000080 008082FC
  82040100 F9030080 00808204 8204F903 F9F30780 07808204 8204F9F3 F9F3E78F
  E78F8204 8204F9F3 F9F3E78F FFFF8204 FFFFFFFF FFFFFFFF 0080FFFF 00000000
  00000080 00800000 00000000 00000080 00800000 00000000 00000080 00800000
  00000000 00000080 00800000 00000000 00000080 00800000 00000000 00000080
  0080FE00 82000000 01000080 008082FC 82FC0100 F9030080 008082FC 82FCF903
  F9F30780 078082FC 82FCF9F3 F9F3E78F E78F82FC 82FCF9F3 F9F3E78F FFFF82FC
  FFFFFFFF FFFFFFFF 0080FFFF 00000000 00000080 00800000 00000000 00000080
  00800000 00000000 00000080 00800000 00000000 00000080 00800000 00000000
  00000080 00800000 00000000 00000080 0080FE00 FE000000 01000080 0080FEFC
  FEFC0100 F9030080 0080FEFC FEFCF903 F9F30780 0780FEFC FEFCF9F3 F9F3E78F
  E78FFEFC FEFCF9F3 F9F3E78F FFFFFEFC FFFFFFFF FFFFFFFF 0000FFFF 01000000
  00000000 0000F107 11040000 0F000000 000011E4 11240800 C81F0000 00001124
  11244810 48903F00 20001124 11244890 4890207F 20411124 11244890 48902041
  20411124 11244890 48902041 20411124 11244890 48902041 20411124 11244890
  48902041 20411124 11244890 48902041 20411124 11244890 48902041 FFFF1124
  FFFFFFFF FFFFFFFF 0000FFFF 01000000 00000000 0000F107 11040000 0F000000
  000011E4 11240800 C81F0000 00001124 11244810 48903F00 20001124 11244890
  4890207F 207F1124 11244890 4890207F 207F1124 11244890 4890207F 207F1124
  11244890 4890207F 207F1124 11244890 4890207F 207F1124 11244890 4890207F
  207F1124 11244890 4890207F FFFF1124 FFFFFFFF FFFFFFFF 0000FFFF 01000000
  00000000 0000F107 11040000 0F000000 000011E4 11240800 C81F0000 00001124
  11244810 48903F00 3F001124 11244890 48903F7F 3F7F1124 11244890 48903F7F
  3F7F1124 11244890 48903F7F 3F7F1124 11244890 48903F7F 3F7F1124 11244890
  48903F7F 3F7F1124 11244890 48903F7F 3F7F1124 11244890 48903F7F FFFF1124
  FFFFFFFF FFFFFFFF 0000FFFF 01000000 00000000 0000F107 11040000 0F000000
  000011E4 11240800 C81F0000 00001124 1124C81F C89F3F00 3F001124 1124C89F
  C89F3F7F 3F7F1124 1124C89F C89F3F7F 3F7F1124 1124C89F C89F3F7F 3F7F1124
  1124C89F C89F3F7F 3F7F1124 1124C89F C89F3F7F 3F7F1124 1124C89F C89F3F7F
  3F7F1124 1124C89F C89F3F7F FFFF1124 FFFFFFFF FFFFFFFF 0000FFFF 01000000
  00000000 0000F107 11040000 0F000000 000011E4 11E40F00 CF1F0000 000011E4
  11E4CF1F CF9F3F00 3F0011E4 11E4CF9F CF9F3F7F 3F7F11E4 11E4CF9F CF9F3F7F
  3F7F11E4 11E4CF9F CF9F3F7F 3F7F11E4 11E4CF9F CF9F3F7F 3F7F11E4 11E4CF9F
  CF9F3F7F 3F7F11E4 11E4CF9F CF9F3F7F 3F7F11E4 11E4CF9F CF9F3F7F FFFF11E4
  FFFFFFFF FFFFFFFF 0000FFFF 01000000 00000000 0000F107 F1070000 0F000000
  0000F1E7 F1E70F00 CF1F0000 0000F1E7 F1E7CF1F CF9F3F00 3F00F1E7 F1E7CF9F
  CF9F3F7F 3F7FF1E7 F1E7CF9F CF9F3F7F 3F7FF1E7 F1E7CF9F CF9F3F7F 3F7FF1E7
  F1E7CF9F CF9F3F7F 3F7FF1E7 F1E7CF9F CF9F3F7F 3F7FF1E7 F1E7CF9F CF9F3F7F
  3F7FF1E7 F1E7CF9F CF9F3F7F FFFFF1E7 FFFFFFFF 80030000 00000000 00008007
  800F0000 00000000 0000803F 80FF0000 03000000 000080FF 80FF0F00 3F000000
  000080FF 80FFFF00 FF030000 000080FF 80FFFF07 FF1F0000 000080FF 80FFFF1F
  FF070000 000080FF 80FFFF01 7F000000 000080FF 80FF1F00 07000000 000080FF
  80FF0100 00000000 0000807F 803F0000 00000000 0000800F 80070000 00000000
  00008003 00000F00 0F000000 00000080 00C00F00 0F000000 000000E0 00F80F00
  0F000000 000000FC 00FF0F00 0F000000 0000C0FF F0FF0F00 0F000000 0000FCFF
  FFFF0F00 0F000000 0080FFFF FFFF0F00 0F000000 0000FCFF F0FF0F00 0F000000
  0000E0FF C0FF0F00 0F000000 000000FE 00FE0F00 0F000000 000000F8 00E00F00
  0F000000 000000C0 00800F00 0F000000 00000000 0000E001 F0010000 00E0FF1F
  FF1FF801 FC0000E0 00600000 07807E00 3F00AE6E A86A0480 04801F0C 0F0CA86A
  AC6E0780 01801F0C 000CE86A E86A0100 3733330C 330C4E6A 00603033 FCFF7F0C
  7F0C0060 0060E4FF E4FF7F0C 7F0C0060 0060FCFF FCFF7F0C 7F0C0060 0060FCFF
  FCFF7F0C 330C0060 00603033 3033330C 000C0060 00600000 FFFFFF0F FF0F00E0
  00E0FFFF FF1F0000 E00000E0 00200010 0316E000 E000AEA8 A4280217 8217E000
  40002425 2427C31F E287FF1F FF1B2425 A428F283 FBF1E17B E17BA4A8 0020FCF0
  FE00E003 E0030020 0020FC00 F801FC03 FC030020 0020F003 E0070E00 070E0020
  0020C01F 8017071E 073C0020 00200017 00160F38 1E780020 00200010 00101C70
  18000020 00200010 00100000 00000020 00E0FF1F FF1F0000 E00000E0 00200010
  0016E000 E0000020 00200017 8017E000 40000020 0020C01F E087FF1F FF1B0020
  0020F083 F8F1E17B E17B0020 0020FCF0 7E00E003 E0030020 0020FC00 F801FC03
  FC030020 0020F003 E0070E00 070E0020 0020C01F 8017071E 073C0020 00200017
  00160F38 1E780020 00200010 00101C70 18000020 00200010 00100000 00000020
  00E0FF1F 00001800 1E000000 00000000 BD073A00 BF01005C 00502504 2584DF03
  EF070050 0058BDC7 A500F70F FB1F00D0 00D0A500 A407701E 303E009C 00000000
  0000303F 303F0000 00000000 000030FF FFFF0000 00F0FFFF 7FFEFF00 7F000080
  00007FFE 1EFC3F00 1F000000 00001CF8 78F00F00 03000000 0000F0C0 E0C10100
  00000000 0000C0F3 80730000 00000000 0000001F 00000000 00000000 00000000
  3030F807 FC0F003C 003C3030 30300C1C 0018000C 000C3030 30300018 0018000C
  000C3030 30300018 0018000C 000C3030 F03F0018 0018000C 000CF03F 30300018
  0018000C 000C3030 30300018 0018000C 000C3030 30300018 0018000C 000C3030
  30300C1C FC0F000C 003F3030 3030F807 0000003F 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 3030F807 FC0FC07F C0FF3030 30300C1C
  0018C0C0 C0003030 30300018 0018C000 C0003030 30300018 0018C000 C0003030
  F03F0018 0018C001 8003F03F 30300018 00180007 001E3030 30300018 0018007C
  00F03030 30300018 001800E0 00C03030 30300C1C FC0F00C0 E0FF3030 3030F807
  0000E0FF 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00008000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00008000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00008000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 80000000 00000000 00008000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 80000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00080000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000080 00000000 00000000
  00000000 00000000 00000000 00000000 00000020 00000000 00008000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 
End DefineFont

  
  DEFINEfONT #5
  03010808
  03070E1C 3870E0C0
  AFAFFFFF 00000000
  1C0E0703 C0E07038

  END DefineFont
  
