'MMEDIT!!! Basic Version = Micromite_Plus_V5.3#
'MMEDIT!!! Port = 10.0.0.204:23:30,150
'MMEDIT!!! Device = ESPBasic
'MMEDIT!!! Config = 100111100121010111101011010011
  '------------------------------------------------------------------------------'
  '       This code demonstrates the use of the simpleArrayGenerator.exe         '
  '       written by @Nathan from The Backshed Forum (TBS).                      '
  '       Details and code are in this forum post.                               ' 
  '       http://www.thebackshed.com/forum/forum_posts.asp?TID=10253&PN=7        '
  '                                                                              '
  '       Additional Directives that allow the config files for the              '  
  '       simpleArrayGenerator to be defined within the MMEDIT code window       '
  '       and the automated execution of simpleArrayGenerator  are provided      '
  '       by the MMReplace.exe utility which is called by MMEdit.                '
  '                                                                              '
  '       Author:   Disco4now TBS Forum                                          '
  '                                                                           '
  dim ProgTitle$ = "simpleArrayGenerator Test Suite"                             '
  '                                                                              '
  Dim ProgVer$   = "v1.0.0"                                                      '
  '                                                                              '
  Dim ProgDate$  = "03-Apr-2018"                                                 '
  '------------------------------------------------------------------------------'
 '  Directives:
 '  #ARRAYGENERATE       - Causes the defined arrays to be generated
 '  #ARRAYSTART [string|integer|float] [cfunction|csub] functionorsubname  - Start of array  
 '  : string1            - each element entry start a colon plus a space
 '  #ARRAYEND            - End of array
 '  #ARRAYINCLUDE functionorsubname  - Includes the file containg the specified CSUB/CFUNCTION

   'Uncomment to load library  
'#LIBRARYLOAD
  Option Explicit
  Option Default NONE
  
   'Set up some variables
  dim integer i,j,k%,l%,m%,z%=9999  '
  dim string a$
  
  ? "**************** Printing arrays and strings stored as CSUB/CFUNCTION code"
  MEMORY
  ? 
  'Code to printout the Integer Array stored. (CSUB version)
  ? "..........Integer Array from CSUB ..........."
  myIntArraySub(k%)     'gets the number of arrays
  myIntArraySub(0,l%)   'gets the number of elements in  array 0
  ? k%
  ? l%
  for i=0 to k%-1
    myIntArraySub(i,l%)  
    for j=0 to l%-1
     myIntArraySub(i,j,m%) 'get specified element from specified array
     ? m%;
    next j
    ?
  next i
   ?
  'Code to printout the String Array stored (CSUB Version)
  ? "..........String Array from CSUB ............."
  myStrArraySub(k%)
  ? k%
  for i=0 to k%-1
    myStrArraySub(i,a$)
     ? a$
  next i
  ?
  'Code to printout the Integer Array (CFunction Version)
  ? "..........Integer Array from CFUNCTION .............."
  k%=myIntArrayFunct()
   ? k%
  for i=0 to k%-1
    l%=myIntArrayFunct(i)
    ? l%," -> ";
    for j=0 to l%-1
     m%=myIntArrayFunct(i,j)
     ? m%;
     next j 
     ?
  next i
  ?
   'Code to printout the Float Array (CFunction Version)
  ? "..........Float Array from CFUNCTION .............." 
  k%=myFloatArrayFunct()
   ? k%
  for i=0 to k%-1
    l%=myFloatArrayFunct(i)
    ? l%," -> ";
    for j=0 to l%-1
     m%=myFloatArrayFunct(i,j)
     ? m%;
     next j 
     ?
  next i
  ?
  'Code to printout the String Array (CFunction Version)
  ? "..........String Array from CFUNCTION ............."
  a$=myStrArrayFunct(z%)
  ? z%
  for i=0 to z%-1
    a$=myStrArrayFunct(i%)
    ? a$
  next i


  
  
  '================================================================================================
  ' Setup Directives and data for arrays
  ' The lines between #ARRAYSTART and #ARRAYEND become the -cfg file for simpleArrayGenerator
  ' The parameters on #ARRAYSTART are used to generate the correct commandline parameters
  ' for simpleArrayGenerator.
  ' The ARRAYGENERATE can be commented once the CSUB/CFUNCTION is generated if the data is not changed.
  ' It can be left in so they generate fresh for each load if there is little performance impact.
  ' #ARRAYINCLUDE myStrArrayFunct   - Include the file generated by simpleArrayGenerator.exe for
  ' the specified function/sub at the specified location.
  '================================================================================================ 
#ARRAYGENERATE
#ARRAYSTART string cfunction myStrArrayFunct
: This is first string
: this is second string
: This is third string
: This is fourth string
: this is fifth string
: This is sixth string ..................................................
#ARRAYEND

#ARRAYSTART int cfunction myIntArrayFunct
: 1 2 3 4 5 6 7 8 9 10
: 10 20 30 40 50 60 70 80 90 100
: 2 3 4 5 6 7 8 9 10 11 12 13 14
#ARRAYEND

#ARRAYSTART float cfunction myFloatArrayFunct
: 1.0 2 3 4 5 6 7 8 9 10
: 10 20 30 40 50 60 70 80 90 -100.9
: 2 3 4 5 6 7 8 9 10 11.6
#ARRAYEND

#ARRAYSTART string csub myStrArraySub
: This is first string
: this is second string
: This is third string
: this is fouth string
: This is fifth string
#ARRAYEND

#ARRAYSTART int csub myIntArraySub
: 1 2 3 4 5 6 7 8 9 10
: 10 20 30 40 50 60 70 80 90 100
: 2 3 4 5 6 7 8 9 10 11
#ARRAYEND

'#LIBRARYSTART

#ARRAYINCLUDE myStrArrayFunct
#ARRAYINCLUDE myIntArraySub
#ARRAYINCLUDE myStrArraySub
#ARRAYINCLUDE myIntArrayFunct
#ARRAYINCLUDE myFloatArrayFunct

'#LIBRARYEND


 
