' Code by Darron Vanaria
' 07/14/2018
' This is a version of BREAKOUT

Option Base 0    ' start arrays at index 0
Mode 4
Cls

''''''''''''''''''''''''''' Game Constants and Variables ''''''''''''''''''''''
background = Red
border = Green
brick_color = Blue
screen_w = MM.HRes-1    ' active playing field
screen_h = MM.VRes-13
font_w = 6              ' character font dimensions
font_h = 12
fps_lock_in_ms = 7

ball_size = 7
ball_boundary_left = 1
ball_boundary_right = screen_w - ball_size
ball_boundary_top = 1
ball_boundary_bottom = screen_h - ball_size
ball_start_x = 0    ' starting location x,y
ball_start_y = 0
ball_x = ball_start_x
ball_y = ball_start_y
ball_dx = 0
ball_dy = 0
ball_move_delta = 1.3

paddle_top = screen_h - 9    ' y corner of paddle
paddle_left = 100            ' x corner of paddle (variable, player moves)
paddle_mid = paddle_left + 16
paddle_right = paddle_left + 32
paddle_dx = 0
paddle_dy = 0
paddle_move_delta = 1.8

brick_w = 22
brick_h = 6
brick_buffer = 4    ' the space between bricks
bricks_across = 9   ' total number of bricks across screen
bricks_down = 7     ' total number of bricks down screen

Dim brick(bricks_across-1, bricks_down-1)   ' array holding brick state

KEY_LEFT = 130
KEY_RIGHT = 131
KEY_UP = 128
KEY_DOWN = 129
KEY_W = 119
KEY_A = 97
KEY_S = 115
KEY_D = 100
KEY_ESCAPE = 27

score = 0
lives = 3
level = 1
brick_count = 0      ' how many bricks left? gets initialized on new game
missing_count = 5    ' mysteriously missing from the wall
brick_value = 13     ' how much is each brick worth?

childs_play = 0      ' special version for young kids (can't miss!)

''''''''''''''''''''''''''' Subroutines and Functions '''''''''''''''''''''''''

' helper function to print text on a grid
Sub PrintAt(x, y, s$)
    Print @( x * font_w, y * font_h, 1 ) s$
End Sub

' Update display with just the numerical part of the score
Sub UpdateScore()
    Line (36,screen_h+1)-(66,screen_h+12),Black,BF
    Print @(36,screen_h+1,1) Str$(level)
    Line (126,screen_h+1)-(188,screen_h+12),Black,BF
    Print @(126,screen_h+1,1) Str$(score)
    Line (234,screen_h+1)-(239,screen_h+12),Black,BF
    Print @(234,screen_h+1,1) Str$(lives)
End Sub

Sub IntroScreen()

    Line (0,0)-(MM.HRes-1,MM.VRes-1),Black,BF  ' solid rectangle
    Line (0,0)-(MM.HRes-1,MM.VRes-1),Cyan,B  ' outline rectangle
    Font #1, 1, 0
    Color Cyan
    PrintAt(2,1,"CMM BREAKOUT")
    Color Blue
    PrintAt(2,3,"Use ARROW KEYS to move paddle.")
    PrintAt(2,4,"Press ESCAPE at any time to end game.")
    Color Yellow
    PrintAt(2,6,"CHOOSE A GAME:")
    PrintAt(2,7,"1. Normal Difficulty")
    PrintAt(2,8,"2. Expert Level")
    PrintAt(2,9,"3. Child's Play")

    k = KeyDown
    Do While k <> 49 And k <> 50 And k <> 51
        k = KeyDown
        If k = KEY_ESCAPE Then k = 49
    Loop

    Line (0,0)-(MM.HRes-1,MM.VRes-1),Black,BF  ' solid rectangle

    If k = 50 Then
        fps_lock_in_ms = 7
        ball_move_delta = 2
        paddle_move_delta = 3
    EndIf

    If k = 51 Then
        childs_play = 1
        missing_count = 45
    EndIf

End Sub


Sub TestForBallHit()

    '''''' Handle collisions with ball-to-boundary ''''''''''''''''''''''''''

    If ball_x <= ball_boundary_left Then ball_dx = -ball_dx : PlaySound(1)
    If ball_x >= ball_boundary_right Then ball_dx = -ball_dx : PlaySound(1)
    If ball_y <= ball_boundary_top Then ball_dy = -ball_dy : PlaySound(1)
    If ball_y >= ball_boundary_bottom Then ball_dy = -ball_dy : PlaySound(1)

    '''''' Handle collisions with ball-to-brick '''''''''''''''''''''''''''''

    ' For each side of the ball, find corresponding brick x,y coordinates
    top_x    = Int((ball_x+3-29) / 26) + 1
    top_y    = Int((ball_y+0-13) / 10) + 1
    bottom_x = top_x
    bottom_y = Int((ball_y+6-14) / 10) + 1
    left_x   = Int((ball_x+0-29) / 26) + 1
    left_y   = Int((ball_y+3-13) / 10) + 1
    right_x  = Int((ball_x+6-30) / 26) + 1
    right_y  = left_y

    If top_x < 0 Then top_x = 0
    If top_y < 0 Then top_y = 0
    If left_x < 0 Then left_x = 0
    If left_y < 0 Then left_y = 0
    If right_x < 0 Then right_x = 0
    If right_y < 0 Then right_y = 0
    If bottom_x < 0 Then bottom_x = 0
    If bottom_y < 0 Then bottom_y = 0

    If right_x > 8 Then right_x = 8

    If top_y <= 6 Then

        If brick(top_x, top_y) = 1 Then
           DestroyBrick(top_x,top_y)
           ball_dy = -ball_dy
        EndIf

        If left_y <= 6 Then

            If brick(left_x,left_y) = 1 Then
                DestroyBrick(left_x,left_y)
                ball_dx = -ball_dx
            EndIf
            If brick(right_x,right_y) = 1 Then
                DestroyBrick(right_x,right_y)
                ball_dx = -ball_dx
            EndIf

            If bottom_y <= 6 Then
                If brick(bottom_x,bottom_y) = 1 Then
                    DestroyBrick(bottom_x,bottom_y)
                    ball_dy = -ball_dy
                EndIf
            EndIf
        EndIf
    EndIf

    ''''' Handle collisions with ball-to-paddle ''''''''''''''''''''''''''''

    r = Collision(3, SPRITE)

    If (r And &B1000) = &B1000 Then

        PlaySound(2)

        ball_y = paddle_top - 7

        If (paddle_mid-8) < (ball_x+3) And (paddle_mid+8) > (ball_x+3)) Then
            PlaySound(2)
            ball_dy = -ball_dy
        Else
            PlaySound(6)
            ball_dy = -ball_dy
            ball_dx = 0
            Do While ball_dx = 0
                ball_dx = Rnd(5) - ball_move_delta
            Loop
            ball_dx = -ball_dx
        EndIf

    EndIf

    If ball_y + 7 = screen_h And childs_play = 0 Then

        PlaySound(3)

        lives = lives - 1

        If lives > 0 Then

            Sprite OFF 3

            ' Start ball moving in random direction
            ball_dx = 0
            Do While ball_dx = 0
                ball_dx = Rnd(5) - ball_move_delta
            Loop
            ball_dy = ball_move_delta

            ball_x = ball_start_x
            ball_y = ball_start_y

            Sprite ON 3, ball_x, ball_y

            UpdateScore()

        Else

            ball_dx = 0
            ball_dy = 0
            PlaySound(7)

            Color BORDER
            PrintAt(6,7, "  G  A  M  E    O  V  E  R")
            PrintAt(6,10," PRESS ANY KEY FOR NEW GAME")
            PrintAt(6,11,"     OR ESCAPE TO QUIT")

            k = 0
            Do While k = 0
                k = KeyDown
                If k = KEY_ESCAPE Then End Sub
            Loop

            Sprite off 1
            Sprite off 2
            Sprite off 3
            StartNewGame()

        EndIf

    EndIf

End Sub


Sub NewBoard()

    PlaySound(4)

    ' Initialize brick 2D array (1 = brick there, 0 = brick gone)
    For rr = 0 To bricks_down-1
        For cc = 0 To bricks_across-1
            brick(cc,rr) = 1
            brick_count = brick_count + 1
        Next cc
    Next rr

    ' Remove some bricks to make it interesting
    For i = 1 To missing_count
        tx = Int(Rnd(1) * bricks_across)
        ty = Int(Rnd(1) * bricks_down)
        If brick(tx,ty) = 1 Then
            brick(tx,ty) = 0
            brick_count = brick_count - 1
        EndIf
    Next i

    ' Remove top row of bricks always
    For cc = 0 To bricks_across-1
        If brick(cc,0) = 1 Then
            brick(cc,0) = 0
            brick_count = brick_count - 1
        EndIf
    Next cc

    ' Draw Bricks on Screen
    For j = 0 To bricks_down-1
        For i = 0 To bricks_across-1
            If brick(i,j) = 1 Then
                x1 = (((brick_w+brick_buffer) * i) + brick_buffer) + 1
                y1 = (((brick_h+brick_buffer) * j) + brick_buffer) + 1
                x2 = x1 + brick_w
                y2 = y1 + brick_h
                Line (x1,y1)-(x2,y2),brick_color,BF
                Line (x1,y1)-(x2,y2),border,B
            EndIf
        Next i
    Next j

    ball_start_x = Int(Rnd(1)*(screen_w-12)) + 7
    ball_start_y = Int(Rnd(1)*50) + 3

End Sub

Sub DrawInitialScreen()
    Line (0,0)-(screen_w,screen_h),BACKGROUND,BF  ' solid rectangle
    Line (0,0)-(screen_w,screen_h),BORDER,B  ' outline rectangle
    Font #1, 1, 0
    Color BORDER
    PrintAt(0,17,"LEVEL")
    PrintAt(15,17,"SCORE")
    PrintAt(33,17,"LIVES")
End Sub

Sub StartNewGame()

    background = Red
    brick_color = Blue
    score = 0
    lives = 3
    level = 1
    brick_count = 0
    brick_value = 13

    DrawInitialScreen()
    NewBoard()
    UpdateScore()

    ball_x = ball_start_x
    ball_y = ball_start_y

    ' Draw Sprites
    Sprite on 3, ball_x, ball_y
    Sprite on 1, paddle_left, paddle_top
    Sprite on 2, paddle_left+12, paddle_top

    ' Start ball moving in random direction
    ball_dx = 0
    Do While ball_dx = 0
        ball_dx = Rnd(5) - ball_move_delta
    Loop
    ball_dy = ball_move_delta

End Sub

Sub NextLevel()

    c = 2
    Do While c = 2 Or c = BACKGROUND
        c = Int(Rnd(1)*8)
    Loop
    BACKGROUND = c

    ' Choose brick color, not Green or Background color
    c = 2
    Do While c = 2 Or c = BACKGROUND
        c = Int(Rnd(1)*8)
    Loop
    brick_color = c

    Sprite off 2
    Sprite off 1
    Sprite off 3
    Pause 20

    Line (0,0)-(screen_w,screen_h),BACKGROUND,BF  ' solid rectangle
    Line (0,0)-(screen_w,screen_h),BORDER,B  ' outline rectangle

    DrawInitialScreen()
    NewBoard()

    Sprite On 3, ball_x, ball_y
    Sprite on 1, paddle_left, paddle_top
    Sprite on 2, paddle_left+12, paddle_top

    level = level + 1
    brick_value = brick_value + 3

    UpdateScore()

End Sub

Sub DestroyBrick(i, j)
    x1 = (((brick_w+brick_buffer) * i) + brick_buffer) + 1
    y1 = (((brick_h+brick_buffer) * j) + brick_buffer) + 1
    x2 = x1 + brick_w
    y2 = y1 + brick_h
    Line (x1,y1)-(x2,y2),background,BF
    brick(i,j) = 0
    PlaySound(5)
    brick_count = brick_count - 1
    score = score + brick_value
    If brick_count = 0 Then
        NextLevel()
    EndIf
    UpdateScore()
End Sub

Sub PlaySound(i)

    If i = 3 Then                            ' lose a life
        For j = 850 To 150 Step -50
            Sound j,20
            Pause 20
        Next j
    ElseIf i = 4 Then                        ' new board
        t1 = Int(Rnd(1) * 70) + 30
        For j = 100 To 1150 Step t1
            For k = 300 To 800 Step 45
                Sound k,20
            Next k
            Sound j,20
            Pause 20
        Next j
    ElseIf i = 5 Then                        ' brick destroyed
        Sound 800,20
    ElseIf i = 6 Then                        ' off-center paddle hit
        Sound 175, 160
    ElseIf i = 7 Then                        ' game over
        t1 = Int(Rnd(1) * 20) + 17
        For j = 977 To 181 Step -t1
            For k = 763 To 77 Step -23
                Sound k,20
            Next k
            Sound j,20
            Pause 20
        Next j
    ElseIf i = 8 Then                        ' earn points!
        Sound 1005,2
    Else
        t1 = i * 100
        t2 = i * 20
        Sound t1, t2 + t1
    EndIf

End Sub


'''''''''''''''''''''''''''''''' Main Program '''''''''''''''''''''''''''''''

Randomize Timer

IntroScreen()

' Load Sprites
Drive "B:"
Sprite Load "Break.spr"

StartNewGame()

k = KeyDown
While k <> KEY_ESCAPE

    Timer = 0

    k = KeyDown

    ' Update ball position

        If k=KEY_A Then ball_dx = -ball_move_delta
        If k=KEY_D Then ball_dx = ball_move_delta
        If k=KEY_S Then ball_dy = ball_move_delta
        If k=KEY_W Then ball_dy = -ball_move_delta

        ball_x = ball_x + ball_dx
        If ball_x >= ball_boundary_right Then
            ball_x = ball_boundary_right
        ElseIf ball_x <= ball_boundary_left Then
            ball_x = ball_boundary_left
        EndIf

        ball_y = ball_y + ball_dy
        If ball_y >= ball_boundary_bottom Then
            ball_y = ball_boundary_bottom
        ElseIf ball_y <= ball_boundary_top Then
            ball_y = ball_boundary_top
        EndIf

        Sprite move 3, ball_x, ball_y, BACKGROUND

    ' Update paddle position

        If k=KEY_LEFT Then paddle_dx = -paddle_move_delta
        If k=KEY_RIGHT Then paddle_dx = paddle_move_delta

        paddle_x = paddle_left + paddle_dx
        If paddle_x >= ball_boundary_right - 25 Then
            paddle_x = ball_boundary_right - 25
        ElseIf paddle_x <= ball_boundary_left Then
            paddle_x = ball_boundary_left
        EndIf

        paddle_left = paddle_x
        paddle_mid = paddle_left+16
        paddle_right = paddle_left+32

        Sprite MOVE 1, paddle_left, paddle_top, BACKGROUND
        Sprite MOVE 2, paddle_mid, paddle_top, BACKGROUND
        Sprite MOVE 2, paddle_mid, paddle_top, BACKGROUND
        Sprite MOVE 1, paddle_left, paddle_top, BACKGROUND

        TestForBallHit()

        paddle_dx = 0

    Do While Timer < fps_lock_in_ms : Loop

Wend

Cls

End
