'screen-layout-constants.inc
' ############################################################################
' #                                                                          #
' # /----------------------------------------------\           /-----------\ #
' # |                                              |           |           | #
' # |                                              |           |  Sprite   | #
' # |                                              |           |  Preview  | #
' # |                                              |           |    (1)    | #
' # |                                              |           |           | #
' # |                                              |           \-----------/ #
' # |                                              |                         #
' # |                                              |   /-------------------\ #
' # |                                              |   |                   | #
' # |                                              |   |                   | #
' # |                                              |   |      Colour       | #
' # |                                              |   |      Palette      | #
' # |                                              |   |        (2)        | #
' # |                 Sprite Grid                  |   |                   | #
' # |                     (0)                      |   |                   | #
' # |                                              |   \-------------------/ #
' # |                                              |                         #
' # |                                              |              /--------\ #
' # |                                              |              |        | #
' # |                                              |              |        | #
' # |                                              |              | Colour | #
' # |                                              |              | Swatch | #
' # |                                              |              |  (3)   | #
' # |                                              |              |        | #
' # |                                              |              |        | #
' # \----------------------------------------------/              \--------/ #
' #                                                                          #
' # /----------------------------------------------------------------------\ #
' # |                                                                      | #
' # |                         Sprite Palette (4)                           | #
' # |                                                                      | #
' # \----------------------------------------------------------------------/ #
' #                                                                          #
' ############################################################################

'Define control regions (for tabbing + shift tabbing)
CONST spriteGrid = 0      'Main editing area
CONST spritePreview = 1   'Sprite preview area
CONST colourPalette = 2   'Full colour palette
CONST colourSwatch =  3   'Subset of colours in use on the current sprite
CONST spritePalette = 4   'Sprites in the current session

'Define the screen border and control gaps
CONST screenBorder = 10
CONST controlBorder = 10

'Pointer Names
CONST largePointer = "crosshair.spt"
CONST smallPointer = "crosshair_sml.spt"

'Set up pointers for each control region
CONST spriteGrid_Pointer     = 60 + spriteGrid
CONST spritePreview_Pointer  = 60 + spritePreview
CONST colourPalette_Pointer  = 60 + colourPalette
CONST colourSwatch_Pointer   = 60 + colourSwatch
CONST spritePalette_Pointer  = 60 + spritePalette


'Define the screen size, grid and "Zoomed Grid" size
CONST screenMaxX = MM.HRES
CONST screenMaxY = MM.VRES

'Starting Position For The Grid
CONST gridX = screenBorder
CONST gridY = screenBorder

CONST spriteX = screenMaxX - spriteMaxCols - screenBorder - 20
CONST spriteY = screenBorder

CONST paletteX = screenMaxX - 204
CONST paletteY = spriteY + 80

CONST swatchX = screenMaxX - 84
CONST swatchY = paletteY + 196

CONST spritePaletteX = screenBorder
CONST spritePaletteY = screenMaxY - screenBorder - 110

'Pixels per "zoomed" sprite
CONST gridSize = 8
