
'############################
'#                          #
'# Show Control Definitions #
'#                          #
'############################

SUB ShowControlDefinitionByName(controlName As String)
  PRINT "Name           : " + Name(controlName)
  PRINT "Type           : " + STR$(Type(controlName))
  PRINT "Label          : " + Label(controlName)
  PRINT "Value          : " + Value(controlName)
  PRINT "Top            : " + STR$(Top(controlName))
  PRINT "Left           : " + STR$(Left(controlName))
  PRINT "Height         : " + STR$(Height(controlName))
  PRINT "Width          : " + STR$(Width(controlName))
  PRINT "Tab Order      : " + STR$(TabOrder(controlName))
  PRINT "Parent Control : " + ParentControl(controlName)
END SUB

'##################################################################################################

SUB ShowControlDefinitionById(controlID As Integer)

  LOCAL controlName As String = ""

  controlName = ctlGetControlNameByID(controlID)
  ShowControlDefinitionByName(controlName)

END SUB

'##################################################################################################

SUB ctlRegister(crName As String, crType As Integer, crLabel As String, crValue As String, crTop As Integer, crLeft As Integer, crHeight As Integer, crWidth As Integer, crTabOrder As Integer, crParentControl As String)

  'Check the new control won't exceed the control array
  IF ctlControlCount<(ctlMaxControls-1) THEN
    ctlArray(ctlControlCount,ctlName)          = crName
    ctlArray(ctlControlCount,ctlType)          = STR$(crType)
    ctlArray(ctlControlCount,ctlLabel)         = crLabel
    ctlArray(ctlControlCount,ctlValue)         = crValue
    ctlArray(ctlControlCount,ctlTop)           = STR$(crTop)
    ctlArray(ctlControlCount,ctlLeft)          = STR$(crLeft)
    ctlArray(ctlControlCount,ctlHeight)        = STR$(crHeight)
    ctlArray(ctlControlCount,ctlWidth)         = STR$(crWidth)
    ctlArray(ctlControlCount,ctlTabOrder)      = STR$(crTabOrder)
    ctlArray(ctlControlCount,ctlParentControl) = crParentControl
    ctlControlCount = ctlControlCount + 1
  ELSE
    'Do some error here
    PRINT "Maximum number ("&STR$(ctlMaxControls)&") already added to Array"
    END
  END IF

END SUB

'##################################################################################################

SUB ctlListControls()
  LOCAL i As Integer = 0
  LOCAL controlName As String = ""
  
  PRINT Column("ID",4),;
  PRINT Column("Name",15),;
  PRINT Column("Type",4),;
  PRINT Column("Label",15),;
  PRINT Column("Value",5),;
  PRINT Column("Top",5),;
  PRINT Column("Left",5),;
  PRINT Column("Height",5),;
  PRINT Column("Width",5),;
  PRINT Column("TabOrder",5),;
  PRINT Column("ParentControl",15)

  FOR i = 0 to ctlControlCount-1
    controlName=ctlGetControlNameByID(i)
    PRINT Column(STR$(i),4),;
    PRINT Column(Name(controlName),15),;
    PRINT Column(STR$(Type(controlName)),4),;
    PRINT Column(Label(controlName),15),;
    PRINT Column(Value(controlName),4),;
    PRINT Column(STR$(Top(controlName)),5),;
    PRINT Column(STR$(Left(controlName)),5),;
    PRINT Column(STR$(Height(controlName)),5),;
    PRINT Column(STR$(Width(controlName)),5),;
    PRINT Column(STR$(TabOrder(controlName)),5),;
    PRINT Column(ParentControl(controlName),15),;
    PRINT ""
  NEXT i

END SUB

'##################################################################################################

FUNCTION ctlExists(controlName as String) As Integer

  ctlExists = (ctlGetControlIDByName(controlName)<>-1)

END FUNCTION

'##################################################################################################

FUNCTION ctlGetControlIDByName(controlName as String) As Integer
LOCAL ctlFound As Integer = ctlDoesNotExist
LOCAL iElement As Integer = 0

DO
  IF UCASE$(ctlArray(iElement,ctlName))=UCASE$(controlName) THEN
    ctlFound = iElement
  END IF
  iElement=iElement+1
LOOP UNTIL (iElement>ctlControlCount-1) OR (ctlFound<>-1)

ctlGetControlIDByName = ctlFound

END FUNCTION


'##################################################################################################

FUNCTION ctlGetControlNameByID(controlID As Integer) As String
  IF (controlID<0) OR (controlID>ctlControlCount) THEN
    ctlGetControlNameByID=""
  ELSE
    ctlGetControlNameByID=ctlArray(controlID,ctlName)
  END IF
END FUNCTION


'##################################################################################################

FUNCTION Column(printValue As String, printWidth As Integer) As String

  Column = LEFT$(printValue + STRING$(printWidth," "),printWidth)

END FUNCTION

'##################################################################################################

