OPTION EXPLICIT ON
OPTION DEFAULT NONE
OPTION BASE 0


' 
' Window (0)
' ############################################################################
' #                                                                          #
' # /----------------------------------------------\           /-----------\ #
' # |                                              |           |           | #
' # |                                              |           |  Sprite   | #
' # |                                              |           |  Preview  | #
' # |                                              |           |    (2)    | #
' # |                                              |           |           | #
' # |                                              |           \-----------/ #
' # |                                              |                         #
' # |                                              |   /-------------------\ #
' # |                                              |   |                   | #
' # |                                              |   |                   | #
' # |                                              |   |      Colour       | #
' # |                                              |   |      Palette      | #
' # |                                              |   |        (3)        | #
' # |                 Sprite Grid                  |   |                   | #
' # |                     (1)                      |   |                   | #
' # |                                              |   \-------------------/ #
' # |                                              |                         #
' # |                                              |              /--------\ #
' # |                                              |              |        | #
' # |                                              |              |        | #
' # |                                              |              | Colour | #
' # |                                              |              | Swatch | #
' # |                                              |              |  (4)   | #
' # |                                              |              |        | #
' # |                                              |              |        | #
' # \----------------------------------------------/              \--------/ #
' #                                                                          #
' # /----------------------------------------------------------------------\ #
' # |                                                                      | #
' # |                         Sprite Palette (5)                           | #
' # |                                                                      | #
' # \----------------------------------------------------------------------/ #
' #                                                                          #
' ############################################################################

'Define the screen border and control gaps
CONST screenBorder = 10
CONST controlBorder = 10

'Define the screen size, grid and "Zoomed Grid" size
CONST screenMaxX = MM.HRES
CONST screenMaxY = MM.VRES

'Starting Position For The Grid
CONST gridX = screenBorder
CONST gridY = screenBorder

CONST spriteMaxCols = 48
CONST spriteX = screenMaxX - spriteMaxCols - screenBorder - 20
CONST spriteY = screenBorder

CONST paletteX = screenMaxX - 204
CONST paletteY = spriteY + 80

CONST swatchX = screenMaxX - 84
CONST swatchY = paletteY + 196

CONST spritePaletteX = screenBorder
CONST spritePaletteY = screenMaxY - screenBorder - 110

'Pixels per "zoomed" sprite
CONST gridSize = 8

MODE 1,16
#INCLUDE "includes/constants_controls.inc"
#INCLUDE "subs/sub_controls.inc"
#INCLUDE "subs/sub_controls_draw.inc"
#INCLUDE "subs/sub_control_props.inc"
#INCLUDE "subs/sub_press_keys.inc"

'wimp.bas
'##################################################################################################

'Register some controls
ctlRegister "MainWindow",ctlContainerWindow,"Main Window","",0,0,screenMaxX,screenMaxY,1,""
ctlRegister "SpriteGrid",ctlTypeImage,"Sprite Grid","",gridX,gridY,spriteMaxCols*(gridSize+1),spriteMaxCols*(gridSize+1),1,"MainWindow"
ctlRegister "SpritePreview",ctlTypeImage,"Preview","",screenBorder,screenMaxX - spriteMaxCols - screenBorder - 20,spriteMaxCols,spriteMaxCols,1,"MainWindow"
ctlRegister "ColourPalette",ctlTypeSelectableImage,"Palette","",70,screenMaxX - 176 - screenBorder - 20,185,176,2,"MainWindow"
ctlRegister "ColourSwatch",ctlTypeSelectableImage,"Swatches","",270,screenMaxX - 56 - screenBorder - 20,180,56,3,"MainWindow"
ctlRegister "SpritePalette",ctlTypeSelectableImage,"Sprites","",screenMaxY-screenBorder-(2*spriteMaxCols),screenBorder,(2*spriteMaxCols),(screenMaxX-2*screenBorder)-20,4,"MainWindow"
ctlRegister "OKButton",ctlTypeDefaultButton,"OK","",200,50,20,80,5,"SpriteGrid"
ctlRegister "CancelButton",ctlTypeButton,"Cancel","",200,150,20,80,6,"SpriteGrid"



ctlListControls
PressAnyKeyPrompt
CLS RGB(127,127,127)
DrawControls
PressAnyKey
ctlMove "SpritePreview",400,400
PressAnyKey
SetVisible "SpritePreview",False
PressAnyKey
SetVisible "SpritePreview",True
PressAnyKey
ctlMove "SpritePreview",10,10
PressAnyKey
ctlMove "SpritePreview",300,100
PressAnyKey
ctlMove "SpritePalette",10,10
PressAnyKey
ctlMove "ColourSwatch",400,400
PressAnyKey
ctlMove "ColourSwatch",600,10
PressAnyKey
SetVisible "ColourSwatch",False
PressAnyKey
SetVisible "SpritePreview",False
PressAnyKey
ctlMove "SpritePalette",screenBorder,screenMaxY-screenBorder-(2*spriteMaxCols)
PressAnyKey
SetVisible "SpritePalette",False
PressAnyKey


