' DEMO
'use: GPS on Rs232
'     RTC ds3231 on i2c
'     1 relay on pin 22
'     1 beep (each minut)
'     1 PIC32mx470
'     1 LCD 5"
'     1 BME180  for temp and pressure
'prog use rtc and gps to have a good clock
'if diff betwenn 2 clocks, write hour's gps clock in rtc
' if no gps, use rtc clock
'
'this prog work in asynch mode
'  it use interrupt to read gps 
'   and tick interupt1 for tasks (like round robin)
'   and tick interrupt2 for i/o in schedul mode
'
'  gps work in 3 steps
'  1 - read strings and put in fifo
'	2 - for each new string receive, calc crc, valisate string and put fields in tables
'	3 - read tables and use infos 
'-----------------------------------
'  Options to decalre before run----
'*** you must change pins num to use with your card
'********************************
'OPTION LCDPANEL SSD1963_5,LANDSCAPE,12
'OPTION SDCARD 52
'OPTION TOUCH 51, 33, 50
'OPTION RTC 10,12
'-----------------------------------
' V 0.1b   20/09/17  goc
' this modul is free but if use, you must put 'copyright goc 2017 for gps Module' in your src
'-----------------------------------
SETPIN 22,DOUT   'output relay 1min
dim vp22 as integer   'value of output (pin22 relay)
Dim tmcde(10) As string LENGTH 6   'liste des commandes gps a traiter
Dim tmgps(10,20) As string LENGTH 255   'texte de chaque case, par type de commande
Dim nbcde As integer    'nombre de cde a traiter
Dim nbgps(10) As integer   'nombre de champs recu par type de cde
Dim ptcde As integer  'poiteur de la commande en cours
Dim ptgps As integer  'pointeur du N du champs dans la cde en cours
Dim flggps(10) As integer   'flag des etats de reception de chaque commande (0= rien, 1=en cours, 2=fini)
Dim flgentete As integer   'flag signale qu'on a reu "$" et pas encore ","
              '0= rien reu, 1= recept entete en cours, 2= entete reu et decod (ptcde=index entete cde)
Dim txbufgps As string   'buffer de recpetion du gps
Dim txchamp As string   'buffer reception champs en cours

Dim i As integer
Dim i1 As integer
Dim i2 As integer
Dim i3 As integer
Dim i5 As integer
Dim j1 As integer
Dim j As integer
Dim j2 As integer
Dim txt As string
Dim tx$ As string
Dim a$ As string
Dim b$ As string
Dim nbcar As integer
Dim validgps As integer  'mot d'etat gps (0= tous les defauts), bit 0=crc (1=pas de faut), bit 1= valide (1=valide)
Dim errgps As integer       'compteur d'erreurs
Dim nbsat As integer    'nombre de satellites
Dim tmvsat(12) As integer  'niveau de recpetion des satellites
Dim txlat As string  'vlaeur latitude
Dim txlatns As string   'Nord Sud
Dim txlong As string  'vlaeur longitude
Dim txlongeo As string   'Est Ouest
Dim txspeed As string
Dim txangl As string
Dim txspeedkm As string
Dim txspeedno As string
Dim txalti As string

Dim icrc As integer     'valeur en cours du crc
Dim txcrc As string     'valeur du crc en hexa
Dim flgcrc As integer   'si =1 alors on calcul le crc, raz apres reception "*"
Dim tmbufcrc(10) As string

Dim tmbuf(10) As string     'pile de recption des trames gps
Dim ptbufecr As integer     'pointeur ecriture des buffers
Dim ptbuflec As integer     'pointeur lecture des buffers

Dim vtimezoneh As integer    'valeur decalge heures % heure GMT  +/- 12h
Dim vtimezonem As integer    'valeur decalge minutes % heure GMT  x minutes
Dim flghete As integer       'signale si gere heures ete/hiver
Dim vhete As integer        '1 si heure ete, 0 si heure hiver
dim flgsec as integer
Dim heure$ As string
Dim vheur As integer
Dim minut$ As string
Dim vminu As integer
Dim second$ As string
Dim vsecon As integer
Dim txjour$ As string
Dim vjour As integer
Dim txmois$ As string
Dim vmois As integer
Dim txan$ As string
Dim van As integer
dim txthgps as string
Dim vmilli As integer
dim vsecont1 as integer
dim vsect0 as integer
dim vsect1 as integer  'nb de secondes depuis derniere lecture capteur temp
dim vsect2 as integer  'nb sec max avant lecture temp (periode lecture)
dim vsect3 as integer  'valeur de "seconde" à t-1
dIM vsec as integer
Dim posx As integer
Dim posy As integer
Dim taillx As integer
Dim tailly As integer
Dim posx2 As integer
Dim posy2 As integer
dim gposx as integer
dim gposy as integer
dim igl as integer
dim jgl as integer
dim nn as integer
dim statfeu as integer  'etat des feux
dim statft1 as integer    'etat feu à t-1
dim clifeu as integer   'flag clignotement
Dim tmcoulf(3) as integer
dim tmbase(3,2) as integer

Dim statmod as integer  'mode de focntionnement
DIM valpert as integer   'periode allumage feu en secondes
DIM valtpv as integer   'nb de seconde vert allume
Dim valtpj as integer   'nb sec jaune allume

dim degr as integer
dim vsinus as float
dim vcosi as float
dim tmptsec(60,4) as integer
dim tmcoulbase(20) as integer  'long
dim tmcoulsec(60,5) as integer  'long
dim lposx as integer
dim lposy as integer
dim rayon1 as float
dim rayon2 as float
dim centx as integer
dim centy as integer
dim vledc as integer
dim flgfond as integer
dim modeled as integer

'----- Var Temerature/pression
Const i2caddr=&b1110111
Const MS7=7 'set default wait period
Const signed=1
Const unsigned=0
'
Dim i2cin$ length 8 'max size for integer conversion
Dim UT%,UP%
Dim ac1%,ac2%,ac3,ac4%,ac5%,ac6%,b1%,b2%,mb%,mc%,md% 'bmp180 parameters
Dim x1%,x2%,b5%,b6%,x3,b3%,b4%,b7%,OSS%
Dim temperature%,pressure%
Dim altitude,QNH,prsHpa
Dim OSSdata%(4)
Dim OSSscale%(4)

'----- Datas RTC -----------------------------

' Special options
Const maxclocks = 19            ' the number of clocks is this plus 1
Const OptionDisplayDate = 1     ' set to zero if you do not want the day/date

dim t1 as integer

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''


DefineFont #7
  0A303220 00000000 00000000 00FEFF00 00FFFF01 80FFFF03 60FFFF01 F0FEFF0C
  F801001E F801003F F801003F F801003F F801003F F801003F F801003F F801003F
  F801003F F801003F F801003F F801003F F801003F F801003F 7800003E 18000038
  08000020 00000000 00000020 18000038 7800003E F801003F F801003F F801003F
  F801003F F801003F F801003F F801003F F801003F F801003F F801003F F801003F
  F801003F F801003F F801003F F000001E 60FEFF0C 00FFFF01 80FFFF03 00FFFF01
  00FEFF00 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  60000000 F0000000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  78000000 18000000 08000000 00000000 00000000 18000000 78000000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F0000000 60000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00FEFF00
  00FFFF01 80FFFF03 60FFFF01 F0FEFF00 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 78000000 18FEFF01 88FFFF03 E0FFFF0F C0FFFF27 00FFFF39
  0000003E 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F
  0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000001E
  00FEFF0C 00FFFF01 80FFFF03 00FFFF01 00FEFF00 00000000 00000000 00000000
  00000000 00FEFF00 00FFFF01 80FFFF03 60FFFF01 F0FEFF00 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 78000000 18FEFF01 88FFFF03 E0FFFF0F
  C0FFFF07 18FFFF01 78000000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F0000000 60FEFF00 00FFFF01 80FFFF03 00FFFF01 00FEFF00 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 60000000 F000000C
  F801001E F801003F F801003F F801003F F801003F F801003F F801003F F801003F
  F801003F F801003F F801003F F801003F F801003F F801003F 7800003E 18FEFF39
  88FFFF23 E0FFFF0F C0FFFF07 18FFFF01 78000000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F0000000 60000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00FEFF00 00FFFF01 80FFFF03
  00FFFF01 00FEFF0C 0000001E 0000003F 0000003F 0000003F 0000003F 0000003F
  0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F
  0000003E 00FEFF39 80FFFF23 E0FFFF0F C0FFFF07 18FFFF01 78000000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F0000000 60FEFF00 00FFFF01
  80FFFF03 00FFFF01 00FEFF00 00000000 00000000 00000000 00000000 00FEFF00
  00FFFF01 80FFFF03 00FFFF01 00FEFF0C 0000001E 0000003F 0000003F 0000003F
  0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F
  0000003F 0000003F 0000003E 00FEFF39 80FFFF23 E0FFFF0F C0FFFF27 18FFFF39
  7800003E F801003F F801003F F801003F F801003F F801003F F801003F F801003F
  F801003F F801003F F801003F F801003F F801003F F801003F F801003F F000001E
  60FEFF0C 00FFFF01 80FFFF03 00FFFF01 00FEFF00 00000000 00000000 00000000
  00000000 00FEFF00 00FFFF01 80FFFF03 60FFFF01 F0FEFF00 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 78000000 18000000 08000000 00000000
  00000000 18000000 78000000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F0000000 60000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00FEFF00 00FFFF01 80FFFF03 60FFFF01 F0FEFF0C
  F801001E F801003F F801003F F801003F F801003F F801003F F801003F F801003F
  F801003F F801003F F801003F F801003F F801003F F801003F 7800003E 18FEFF39
  88FFFF23 E0FFFF0F C0FFFF27 18FFFF39 7800003E F801003F F801003F F801003F
  F801003F F801003F F801003F F801003F F801003F F801003F F801003F F801003F
  F801003F F801003F F801003F F000001E 60FEFF0C 00FFFF01 80FFFF03 00FFFF01
  00FEFF00 00000000 00000000 00000000 00000000 00FEFF00 00FFFF01 80FFFF03
  60FFFF01 F0FEFF0C F801001E F801003F F801003F F801003F F801003F F801003F
  F801003F F801003F F801003F F801003F F801003F F801003F F801003F F801003F
  7800003E 18FEFF39 88FFFF23 E0FFFF0F C0FFFF07 18FFFF01 78000000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000 F8010000
  F8010000 F8010000 F8010000 F8010000 F8010000 F0000000 60FEFF00 00FFFF01
  80FFFF03 00FFFF01 00FEFF00 00000000 00000000
End DefineFont

'***************************************
'** INIT GENERALE
'***************************************

'---------- init graphique et fonts ---
'Load image "image3d", 0, 0
'Load font "calib60.c" As #7
'Load font "sevseg3.c" As #8
'Load font "Ssegp.c" As #9
'Pause 1000
vp22=0
pin(22)=0  'init relay to 0
CLS RGB(32,32,32)
'---- init tables -------------
For i=1 To 10
  nbgps(i)=0    'raz des nb de champs reues
  flggps(i)=0   'raz des flags de traitemetn des cde
  tmbuf(i)=""
  tmbufcrc(i)=""
  For j=1 To 20
    tmgps(i,j)=""   'raz des champs recues
  Next j
Next i
'---- Init Cerlce horloge ---
rayon1=225  '228;
centx=240   '400;
centy=235  '240;
rayon2=10   '11;
degr=0    'ru
flgfond=0
vledc=-1    'init des leds
modeled=0   'mode led 0=x leds, 1= 1 led à la fois
flgsec=-1  '0= beep, -1=pas de beep
vsect2=30   'periode scrut mesure temp
vsect1=60  'force scrutation
vsect3=0  'force valeur a t-1
valtpv=5  'temps allumage feu vert
valtpj=5  'temps allumage jaune

Box 490,0,308,100,3,RGB(255,255,255),RGB(32,32,32)
BOX 490,99,308,379,3,RGB(255,255,255),RGB(32,32,32)

for i=1 to 60
         vsinus=sin((3.14159*degr)/180)
         vcosi=cos((3.14159*degr)/180)
         lposy= int(rayon1*vcosi)   'round(rayon1*vcosi)
         lposx= int(rayon1*vsinus)  'round(rayon1*vsinus)
         lposx=centx+ lposx
         lposy=centy-lposy
         tmptsec(i,1)=lposx
         tmptsec(i,2)=lposy
         tmptsec(i,3)=1
         if (i mod 5)=0 then tmptsec(i,3)=2
         tmptsec(i,4)=0
         degr=degr+6
next i
     '-- definition dess couleurs des leds
      i=1
      tmcoulbase(i)=&h880000   'couleur bordure eteint rouge
      tmbase(1,2)=tmcoulbase(i)
      i=i+1
      tmcoulbase(i)=&h440000   'couleur interne eteint rouge
      i=i+1
      tmcoulbase(i)=&hFFCCCC   'couleur bordure allume rouge
      i=i+1
      tmcoulbase(i)=&hFF0000   'couleur interne allume rouge
      tmbase(1,1)=tmcoulbase(i)
      i=i+1
      tmcoulbase(i)=&hFF4444   'couleur pen allume rouge
      i=i+1
      tmcoulbase(i)=&h008800   'couleur bordure eteint Vert
      tmbase(3,2)=tmcoulbase(i)
      i=i+1
      tmcoulbase(i)=&h004400   'couleur interne eteint Vert
      i=i+1
      tmcoulbase(i)=&h44FF44   'couleur bordure allume Vert
      i=i+1
      tmcoulbase(i)=&h00FF00   'couleur interne allume Vert
      tmbase(3,1)=tmcoulbase(i)
      i=i+1
      tmcoulbase(i)=&h4444FF   'couleur pen allume bleue
      i=i+1
      tmcoulbase(i)=&h888800   'couleur bordure eteint Jaune
      tmbase(2,2)=tmcoulbase(i)
      i=i+1
      tmcoulbase(i)=&h444400   'couleur interne eteint Jaune
      i=i+1
      tmcoulbase(i)=&hffff44   'couleur bordure allume Jaune
      i=i+1
      tmcoulbase(i)=&hffff00   'couleur interne allume Jaune
      tmbase(2,1)=tmcoulbase(i)
      i=i+1
      tmcoulbase(i)=&hffff44   'couleur pen allume Jaune
      i=i+1
      tmcoulbase(i)=&h000088   'couleur bordure eteint Bleu
     
      i=i+1
      tmcoulbase(i)=&h000044   'couleur interne eteint Bleu
      i=i+1
      tmcoulbase(i)=&hAAAAFF   'couleur bordure allume Bleu
      i=i+1
      tmcoulbase(i)=&h0000FF   'couleur interne allume Bleu
      
      for i=1 to 60 
       
         for j=1 to 5 
          
         tmcoulsec(i,j)= tmcoulbase(j+15)
         if ((i-1) mod 5)=0 then tmcoulsec(i,j)= tmcoulbase(j)
        next j
      next i
      

'---- init variables ----
vtimezoneh=2   'paris =gmt+1
vtimezonem=0   'pas de declages en minutes
flghete=1  'on gere ete/hiver
vhete=0  'on est en ete
vsecont1=0
ptbufecr=0
ptbuflec=0
validgps=0
errgps=0
nbsat=0
ptcde=0
ptgps=0
txchamp=""
icrc=0
txcrc=""
vledc=-1
flgentete=0  'flag pour signaler qu'on recoit l'entete du message activ sur rec "$", (disparait apres rec de ",")
i=0
i=i+1:tmcde(i)="$GPGGA"
i=i+1:tmcde(i)="$GPGSA"
i=i+1:tmcde(i)="$GPRMC"
'i=i+1:tmcde(i)="$GPGSV"
'i=i+1:tmcde(i)="$GPVTG"
'i=i+1:tmcde(i)="$GPGLL"
nbcde=i  'nombre de commandes gps traites
txbufgps=""
'----- init rtc ds3231 --------
I2C Open 100, 200, PU
I2C Write &H68, 0, 1, 0
If MM.I2C <> 0 Then I2C Write &H51, 0, 1, 2
If MM.I2C = 0 Then
  TimeSource = 1
  'van=17:vmois=09:vjour=18
 'RTC SetTime van, vmois, vjour, 0, 0, 0
  'pause 200
  'RTC GetTime
  txjour$=left$(date$,2):vjour=val(txjour$)
  txmois$=mid$(date$,4,2):vmois=val(txmois$)
  txan$=right$(date$,2):van=val(txan$)
  If Date$ = "01-01-2016" Then
    MessageBox "ERR: RTC invalide", "date et Heures"
    'RTC SetTime van, vmois, vjour, 0, 0, 0
    'Time$ = "00:00:00" : Date$ = "01/01/16"
    Text 680,15,"HOR",CM,2,1,RGB(144,144,144),RGB(32,32,32)
  ELSE
    Text 680,15,"HOR",CM,2,1,RGB(Black),RGB(Green)
  EndIf
  Text 240,390,DATE$,CM,3,1,RGB(GREEN),RGB(32,32,32)
End If
nn=0
gesled
CIRCLE 190,220,10,1,1.0,0,RGB(WHITE)
CIRCLE 190,260,10,1,1.0,0,RGB(WHITE)
statmod=1
gesmod
'----- init temperatures ------
' global arrays
Dim mdm(12) ', arg$(20)
Data 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334
For i = 1 To 12: Read mdm(i): Next i
I2C OPEN 400,1000
init:
  OSS%=1 'set oversampling ratio
' OSS%=0 ' Uncomment this line to check algorithm against datasheet
  OSSdata%(0)=&H34 'commands to sample pressure% with different levels of oversampling
  OSSdata%(1)=&H74
  OSSdata%(2)=&Hb4
  OSSdata%(3)=&HF4
  OSSscale%(0)=1 'scale factors for calcs when oversampled
  OSSscale%(1)=2
  OSSscale%(2)=4
  OSSscale%(3)=8
'
  I2C WRITE i2caddr,1,1,&HAA 'send read calibration data command
  I2C READ i2caddr,0,22,i2cin$() 'read in calibration data
  ac1%=intconv(Mid$(i2cin$,1,2),signed)
  ac2%=intconv(Mid$(i2cin$,3,2),signed)
  ac3=intconv(Mid$(i2cin$,5,2),signed)
  ac4%=intconv(Mid$(i2cin$,7,2),unsigned)
  ac5%=intconv(Mid$(i2cin$,9,2),unsigned)
  ac6%=intconv(Mid$(i2cin$,11,2),unsigned)
  b1%=intconv(Mid$(i2cin$,13,2),signed)
  b2%=intconv(Mid$(i2cin$,15,2),signed)
  mb%=intconv(Mid$(i2cin$,17,2),signed)
  mc%=intconv(Mid$(i2cin$,19,2),signed)
  md%=intconv(Right$(i2cin$,2),signed)
'--------------------------
vsecon=-1 

Open "COM1:9600,255,spcomrec2" As #5
pause 100
RTC GetTime
pause 100
print "End init"
Print "Date:";Date$;"  Time:"; time$

'--- init tick d base

settick 300,tachefond,1
Settick 100,tachehor,2


'*** BOUCLE PRINCIPALE *********
Do
'-------------------------
  WatchDog 5000                               ' reset apres 5 secondes inactivite
loop

sub boucle
'-------- Lecture GPS -----
If ptbufecr>0 Then
  For i3=1 To ptbufecr
     txt=tmbuf(i3)

'--- calc CRC ---
    icrc=0
    txcrc=""
    nbcar=0
    j2=Instr(txt,"*")  'bute fin de chaine avant crc
    If j2>2 Then
      For i=2 To j2-1
        nbcar=nbcar+1
        icrc=icrc Xor Asc(Mid$(txt,i,1))   'calcul crc
      Next i
    End If
    txcrc=Hex$(icrc)
    If Len(txcrc)=1 Then txcrc="0"+txcrc  'on force 2 car
    '-- test crc
    If txcrc=Right$(txt,2) Then
        validgps=(validgps Or 1)    'bit erreur crc
    Else
        validgps=(validgps And &hfe ) 'on raz bit erreur crc
        If errgps <32000 Then errgps=errgps+1    'on compte le nombre d'erreur si compteur inf  32k (pour eviter les debordements)
    End If
'---------

    If (validgps And 1) = 1 Then  'si chaine crc ok
        rangegps
      'Print i3,txt
    End If
  Next i3
  ptbufecr=0
End If

For i=1 To nbcde
  If flggps(i)=2 Then
    flggps(i)=3
    '--- test validit infos
    If tmgps(i,1)="$GPGGA" Then

        nbsat=Val(tmgps(i,8))  'on recupere le nombre de sat recu
        'Print "Nb Sat:"+Str$(nbsat)
        txalti="Sat="+Str$(nbsat)
        Text 500,20,txalti,LM,3,1,RGB(White),RGB(32,32,32)
        'txalti=tmgps(i,10)+" "+tmgps(i,11)

        If txalti<>"" Then 
            '**Text 500,20,txalti,LM,3,1,RGB(White),RGB(32,32,32)
        end if    

    End If
    If tmgps(i,1)="$GPGSA" Then
        'Print "Niv Sat:";
        posy=84  '44
        taillx=8
        For i5=1 To 12
            posx=(i5*16)+534 
            Box posx,posy-32,taillx,32,2,RGB(32,32,32),RGB(32,32,32)
            tmvsat(i5)=Val(tmgps(i,i5+3))  'on recupere le nombre de sat recu
            If tmvsat(i5)>0 Then
                'posx=(i5*16)+620  '316
                tailly=tmvsat(i5)
                If tailly<20 Then
                     Box posx,posy-tailly,taillx,tailly,1,RGB(Yellow),RGB(Yellow)
                Else
                    Box posx,posy-tailly,taillx,tailly,1,RGB(Green),RGB(Green)
                End If
            End If
            'Print tmgps(i,i5+3),
        Next i5
        'Print
    End If

    If tmgps(i,1)="$GPRMC" Then
    'print tmgps(i,2);"   [";tmgps(i,3);"]"
        If (tmgps(i,3)="V" or tmgps(i,3)="A") Then validgps=(validgps Or 2) Else validgps=(validgps And &hfd)
    '--- gestion heure---
        vheur=Val(Left$(tmgps(i,2),2))
        vminu=Val(Mid$(tmgps(i,2),3,2))
        vsecon=Val(Mid$(tmgps(i,2),5,2))
        'vminu = vminu + vtimezonem    'on ajoute la time zone
        If vminu=>60 Then
            vheur=vheur+1
            vminu=vminu-60
        End If
        vheur = vheur + vtimezoneh
        If flghete=1 Then vheur = vheur + vhete  'si gestion et/hive et periode ete
        If vheur=>24 Then vheur=vheur-24
        'Print vheur,vminu,vsecon
        heure$=Str$(vheur)
        If vheur<10 Then heure$="0"+heure$
        minut$=Str$(vminu)
        If vminu<10 Then minut$="0"+minut$
        second$=Str$(vsecon)
        If vsecon<10 Then second$="0"+second$
        txthgps= heure$ + ":" + minut$ + ":" + second$
        if (validgps AND 3) = 3 then  'on corrige l'horloge interne si necessaire
           if (vsecon=0 and (vminu mod 10)=0) then   'on le fait toutes les 10 minutes
           'if (vsecon=0) then   'on le fait toutes les 10 minutes
              RTC GetTime
              if txthgps<>time$ then
                'Print heure$;":";minut$;":";second$;"   etat:";hex$(validgps)
                if (van>0 and vmois>0 and vjour>0) then
                  RTC SetTime van, vmois, vjour, vheur, vminu, vsec
                end if
                  
                Text 240,390,DATE$,CM,3,1,RGB(YELLOW),RGB(32,32,32)
              end if
           end if
        end if

    End If
    '-------

    'Print i, nbgps(i),txt$
  End If
Next i

'-----------------------------
if ((vsecont1<>vsecon)or vsecon=-1) then
  vsecont1=vsecon
  txt$=heure$ + ":" + minut$ + ":" + second$
  If txt$<>"::" Then
      Text 620,15,"GPS",CM,2,1,RGB(Black),RGB(Green)
      If (validgps And 2) =0 Then

          Text 240,100,txt$,CM,4,2,RGB(Green),RGB(32,32,32)
      Else

          Text 240,100,txt$,CM,4,2,RGB(Yellow),RGB(32,32,32)
      End If
      '**Text 20,260,txt$,LM,7,3,RGB(White),RGB(32,32,32)
      txt$="0"
      Text 70,240,txt$,LM,7,3,RGB(White),RGB(32,32,32)
      txt$="00"
      Text 220,240,txt$,LM,7,3,RGB(White),RGB(32,32,32)
  Else
      Text 620,15,"GPS",CM,2,1,RGB(144,144,144),RGB(32,32,32)
  End If
  if vsecon=0 then  'second$="00" then 
    if flgsec=0 then
      flgsec=1
    end if
  else
      if flgsec>0 then flgsec=0
  end if  
'---------------------------

  I2C WRITE i2caddr,0,2,&HF4,&H2E 'send temp conversion
  Pause MS7 'wait for temperature% conversion
  I2C WRITE i2caddr,1,1,&HF6 'send read data
  I2C READ i2caddr,0,2,i2cin$() 'read 2 bytes
  UT%=intconv(i2cin$,unsigned)
'  UT%=27898 ' Uncomment this line to check algorithm against datasheet
  I2C WRITE i2caddr,0,2,&HF4,ossdata%(oss%) 'send pressure% conversion
  Pause (oss%+1)*ms7 'wait for the p  ressure% conversion
  I2C WRITE i2caddr,1,1,&HF6 'send read data
  I2C READ i2caddr,0,3,i2cin$() 'read 3 bytes
  UP%=intconv(i2cin$,unsigned)
  UP%=UP%>>(8-oss%) 'scale the oUT%pUT% by the numb%er of unused bits in the xlsb byte
'  UP%=23843' Uncomment this line to check algorithm against datasheet
  calc_temp
  'calc_pressure
  'prsHpa=pressure%/100
  'Print "Temperature = ",Str$(temperature%/10,4,1),"Deg C"
  Text 790,20,Str$(temperature%/10,3,1),RM,3,1,RGB(CYAN),RGB(32,32,32)
  'print hex$(validgps)
  if (validgps AND 2) = 0 then  'si gps non valide
    RTC GETTIME
    Text 240,390,DATE$,CM,3,1,RGB(GREEN),RGB(32,32,32)
    Text 240,100,TIME$,CM,3,1,RGB(GREEN),RGB(32,32,32)
    'print time$  
  end if
  
  vsec=vsecon
  if vsec=-1 then vsec=0  'si ni gps ni rtc
  vsect0=vsec-vsect3
  if vsect0<0 then vsect0=vsect0+60
  if vsect0<0 then vsect0=1
  vsect3=vsec
  vsect1=vsect1+vsect0
  if vsect1>vsect2 then
			 
    vsect1=0
			'liremes;
  end if
  
  
  
  nn=vsecon
  if modeled=0 then gesled
  if modeled=1 then gesled1
'print "*";
end if
if vsecon=0 then  'pulse each 1 minute
  if vp22=0 then vp22=1  'vp22+1
else
  vp22=0  
end if

'Pause 100
'Loop
end sub
Close #5
'*****************************
sub tachefond
  't1=timer
  boucle
  'print (timer-t1)
end sub

sub tachehor
'-- gestion relais top 1 minute
if vp22=1 then pin(22)=1  'pulse 100ms
if vp22=>3 then pin(22)=0
if (vp22>0 and vp22<10) then vp22=vp22+1
'--- gestion beep
if flgsec=1 then
  GUI BEEP 100
  flgsec=2
end if
end sub

'*****************************

Sub calc_temp
  x1%=(UT%-ac6%)*ac5%\powerof2(15)
  x2%=mc%*powerof2(11)/(x1%+md%) 'This needs to be a floating divide to match the datasheet
  b5%=x1%+x2%
  temperature%=(b5%+8)\powerof2(4)
End Sub



Sub rangegps
  If Left$(txt,1)="$" Then
    ptgps=0
    ptcde=0
    flgentete=0
    For i1=1 To nbcde
      If Left$(txt,6)=tmcde(i1) Then
        ptcde=i1
        flgentete=1
        Exit For
      End If
    Next i1
    If flgentete=1 Then
      txchamp=""
      For i1=1 To Len(txt)
        b$=Mid$(txt,i1,1)
        If b$="," Then
          ptgps=ptgps+1
          tmgps(ptcde,ptgps)=txchamp
          txchamp=""
        Else
          If Asc(b$)>31 Then txchamp=txchamp+b$
        End If
      Next i1
      ptgps=ptgps+1
      tmgps(ptcde,ptgps)=txchamp
      flggps(ptcde)=2
      nbgps(ptcde)=ptgps
    End If
  End If

End Sub

'*****************************
Sub spcomrec2
  nbcar=Loc(#5)
  If nbcar>0 Then
    tx$=Input$(nbcar,#5)
    'Print tx$;
    For i2=1 To nbcar
        a$=Mid$(tx$,i2,1)

        If a$="$" Then
          txbufgps=""   'on force init du buffer de rangement
          flgentete=1     'on informe qu'on est en cours de recpetion d'une trame
        End If
        If flgentete=1  Then
          If Asc(a$)>31 Then txbufgps=txbufgps+a$  'on range le car recu
          If Asc(a$)=10 Then  'fin de chaine envoy
            'Print "..."+txbufgps
            If ptbufecr<10 Then ptbufecr=ptbufecr+1  'on pointe sur buffer suivant de la pile
            tmbuf(ptbufecr)=txbufgps        'range le buffer recu
            txbufgps=""         'et on prepare pour recpetion suivante
            flgentete=0
          End If
        End If
    Next i2
  End If
End Sub

'*************************************
sub gesled
  if nn>61 then jgl=1

  if nn>60 then nn=0
  jgl=nn+1


  
  if (vledc=-1) and (nn>1) then
     for igl=1 to jgl-1  
       gposx=tmptsec(igl,1)
       gposy=tmptsec(igl,2)
       CIRCLE gposx,gposy,rayon2,1,1.0,0,tmcoulsec(igl,4)
       CIRCLE gposx-4,gposy-4,rayon2-6,1,1.0,tmcoulsec(igl,3),tmcoulsec(igl,3)
       tmptsec(igl,3)=1
     next igl   'end
     vledc=jgl-1
     for igl=jgl to 60  
     'begin
      gposx=tmptsec(igl,1)
      gposy=tmptsec(igl,2)
       CIRCLE gposx,gposy,rayon2,1,1.0,0,tmcoulsec(igl,1)
       CIRCLE gposx,gposy,rayon2-2,1,1.0,0,tmcoulsec(igl,2)
       tmptsec(igl,3)=0

     next igl  'end
  end if

  igl=nn+1
  gposx=tmptsec(igl,1)
  gposy=tmptsec(igl,2)
    'canvas.Pen.Color=0
  if tmptsec(igl,3)=0 then
       CIRCLE gposx,gposy,rayon2,1,1.0,0,tmcoulsec(igl,4)
       CIRCLE gposx-4,gposy-4,rayon2-6,1,1.0,tmcoulsec(igl,3),tmcoulsec(igl,3)
        tmptsec(igl,3)=1
  else
       CIRCLE gposx,gposy,rayon2,1,1.0,0,tmcoulsec(igl,1)
		tmptsec(igl,3)=0
    end if

end sub
'****************************************
sub gesled1    '(nn: integer)
  if nn>60 then nn=0
  if (vledc=-1) and (nn>1) then
    for i=1 to 60  
      gposx=tmptsec(i,1)
      gposy=tmptsec(i,2)
      if ((i-1) mod 5)=0 then 
      end if    
      tmptsec(i,3)=0
      vledc=60
     next i   'end
  end if

    i=nn+1
    lposx=tmptsec(i,1)
    lposy=tmptsec(i,2)
     if ((i-1) mod 5)=0 then 
     end if
     tmptsec(i,3)=1
     i=i-1
    lposx=tmptsec(i,1)
    lposy=tmptsec(i,2)

    if i=0 then
          lposx=tmptsec(60,1)
          lposy=tmptsec(60,2)
     end if
     if ((i-1) mod 5)=0 then 
     end if
     tmptsec(i,3)=0
end sub
'*************************************
CFunction intconv
     00000000
     27bdfff8 00001021 00001821 afa20000 afa30004 90880000 1900000b 01003821
     2503ffff 03a31821 24020001 00823021 90c60000 a0660000 24420001 00e2302a
     10c0fffa 2463ffff 8ca20000 1040000d 03a81021 9042ffff 30420080 10400009
     29020008 10400007 03a81021 27a40008 2403ffff a0430000 24420001 5444fffe
     a0430000 8fa20000 8fa30004 03e00008 27bd0008
End CFunction

CFunction powerof2
     00000000
     27bdfff8 00001021 00001821 afa20000 afa30004 8c820000 000218c2 03a32021
     000318c0 00431023 24030001 00431004 a0820000 8fa20000 8fa30004 03e00008
     27bd0008
End CFunction
