Option explicit
option default NONE
memory
dim integer testrun=1
load image "image4c"
sprite INTERRUPT collision ' specify the  interrupt routine to handle collisions
sprite load #4, "logom4"
sprite load #2, "logom4"
sprite load #17, "logom4"
'
' test 1 - sprites on different layers don't collide except with layer 0
sprite show 4,10,10,1
sprite show 2,50,50,2
pause 200
sprite show 17,35,30,0
pause 1000
'
' test 2 - single sprite overlaps the corner
sprite hide 17
sprite hide 2
sprite show 4,-10,-10,7
pause 1000
'
' test 3 - one sprite moves and hits another
sprite show 4,10,10,7
sprite show 2,100,100,7
pause 200
sprite show 2,50,50,7
pause 1000
' 
' test 4 - collision in contact with edge
sprite hide 2
sprite hide 4
sprite show 2,-10,10,7
pause 1000
'
' test 5 - all layers collide with layer 0
sprite hide 2
sprite show 17, 55,25, 0
sprite show 2, 100, 10,7
pause 1000
'
' test 6 - scroll causes collision with edge of screen for layer-0 sprite
sprite hide 2
BLIT scrollv 30
pause 1000
'
' test 7 - scroll causes collision between sprites
BLIT scrollv -60
BLIT scrollv -60
sprite show 4,10,10,7
sprite show 2,110,10,7
blit scrollv 30
pause 1000
'
' Close everything and check for memory leakage
sprite close 0
sprite close 4
sprite close 2
sprite close 17
clear
memory
end
'
' This routine demonstrates a complete interrogation of collisions
'
sub collision
  local integer i
  print "Test : ",testrun
  testrun = testrun +1
  if sprite(S) <> 0 then 'collision of individual sprite
    print "Collision on sprite ",sprite(S) 'sprite(S) returns the sprite that moved to cause the collision
    process_collision(sprite(S))
    print ""
  else 'collision of one or more sprites caused by background move
    print "Scroll caused a total of ",sprite(C,0)," sprites to have collisions" 
    for i=1 to sprite(C,0)
      print "Sprite ",sprite(C,0,i)
      process_collision(sprite(C,0,i))
    next i
    print ""
  endif
end sub

sub process_collision(S as integer)
  local integer i ,j
  print "Total of ",sprite(C,S)," collisions" 'sprite(C, #n) returns the number of current collisions
  for i=1 to sprite(C,S)
    j=sprite(C,S,i)
    if j=100 then
      print "collision with left of screen"
    else if j=101 then
      print "collision with top of screen"
    else if j=102 then
      print "collision with right of screen"
    else if j=103 then
      print "collision with bottom of screen"
    else
      print "Collision with sprite ",sprite(C,S,i) 'sprite(C, #n, #m) returns details of the mth collision
    endif  
  next i
end sub