MODE 2 ' 640 x 400 
page write 1 : cls
CONST SCREEN_LEFT = 0
CONST SCREEN_RIGHT = 639
CONST SCREEN_TOP = 0
CONST SCREEN_BOTTOM = 399
CONST ACCEL = 1
CONST MOMENTUM = 0.99
x = SCREEN_RIGHT/2
y = SCREEN_BOTTOM/2
x_vel = 0
y_vel = 0
vel = 0
turn_speed = 0.1
angle = rnd*PI*2


DO
  cls
  KEYCHECK
  UPDATE_SPRITE
  WRAP_SPRITE
  DRAW_SPRITE
  DEBUG
  page copy 1,0,B
  PAUSE 1000/30
LOOP

SUB DRAW_SPRITE
  HALF_NOSE_ANGLE = PI/16
  SHIP_LENGTH = 10
  x2 = x + cos(angle-HALF_NOSE_ANGLE)*SHIP_LENGTH
  y2 = y + SIN(angle-HALF_NOSE_ANGLE)*SHIP_LENGTH
  x3 = x + cos(angle+HALF_NOSE_ANGLE)*SHIP_LENGTH
  y3 = y + SIN(angle+HALF_NOSE_ANGLE)*SHIP_LENGTH
  triangle x, y, x2, y2, x3, y3
END SUB

SUB KEYCHECK
  for keycode = 128 to 131
    pressed = 0
    for key = 1 to 6
      if keydown(key) = keycode then pressed = 1
    next
    if keycode = 128 then u_pressed = pressed
    if keycode = 129 then d_pressed = pressed
    if keycode = 130 then l_pressed = pressed
    if keycode = 131 then r_pressed = pressed
  next
END SUB

SUB UPDATE_SPRITE
  if u_pressed then 
    x_vel = x_vel + cos(angle)*ACCEL
    y_vel = y_vel + SIN(angle)*ACCEL
  endif
  if l_pressed then angle = angle - turn_speed
  if r_pressed then angle = angle + turn_speed
  x = x - x_vel
  y = y - y_vel
  x_vel = x_vel * MOMENTUM
  y_vel = y_vel * MOMENTUM
END SUB

sub WRAP_SPRITE
  if x < SCREEN_LEFT then x = SCREEN_RIGHT-2
  if x > SCREEN_RIGHT then x = SCREEN_LEFT
  if y < SCREEN_TOP then y = SCREEN_BOTTOM-2
  if y > SCREEN_BOTTOM then y = SCREEN_TOP
END SUB

SUB DEBUG
  print @(10,10) "  LOC:"  STR$(x,2 ,2)  "," STR$(y,2,2)
  print @(10,30) "X_VEL:"  STR$(x_vel,2, 2) " Y_VEL:"  STR$(y_vel,2, 2) 
  print @(10,50) "ANGLE:" STR$(angle,2, 2)  
END SUB