'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Micromite Controlled AD9833 Signal Generator
' SignalGeneratorAD9833_v1.0.bas
' Gerry Allardice Apr 16
' V1.00 21/4/2016
'''''''''''' Acknowledgements'''''''''''''''''''''''''''''''''
' SPI control code by Peter Mather (@MatherP of TBS)
' Touch interface routines based on those found in
' Geoff Graham's programs:
'   Garage Parking Assistant Dec 15
'   Boat Computer            Feb 16
' Font containing graphic symbols created using
' FontTweak program by @TassieJim
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Requires MMBasic 5.1 or later and an ILI9341 based LCD panel with touch
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'''''''' Command Line setup of LCD and Touch and Calibration ''''''''''''''''
'OPTION LCDPANEL ILI9341,L,4,5,6
'OPTION TOUCH 7,2
'GUI CALIBRATE
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''


Option Autorun On
Option Explicit
Option Default Integer

CLS

' Micromite pin allocation and AD9833 wiring for modules 0 and 1
'AD9833 pin        Micromite
'  CS0 ----> 10
'  CS1 ----> 16
'  DAT ----> 3   SPI-OUT
'  CLK ----> 25  SPI-CLK
'  FSY0 ----> 9
'  FSY1 ----> 15
'  GND ----> 8  or any GND
'  VCC ----> 13 or any 3.3V

'Rotary Encoder
' RA ---> 22
' RB ---> 21
' SW ---> 23


Dim selectedmodule=0
'Module 0
Const CS0%=10 '  pin for MCP41010 chip select (CS) pin on digital potentiometer
Const FSY0%=9 ' pin for AD9833 chip select(FSY) pin on module
'Module 1
Const CS1%=16 ' pin for MCP41010 chip select (CS) pin on digital potentiometer
Const FSY1%=15 ' pin for AD9833 chip select(FSY) pin on module

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' colours used
Const cBGnd = RGB(0,0,0) '(96, 96, 150)      ' background colour
Const cBorder = RGB(blue)           ' border colour
      '


Const cTitle = RGB(green)           ' title colour
Const cEntry = RGB(yellow)          ' colour used for the entry
Const cButton =RGB(cyan)            ' the key colour
Const cSave = RGB(white)            ' the save button

' other colours used in keypad entry screens
Const cDel = RGB(magenta)           ' the delete button
Const cSpecial = RGB(248, 184, 184) ' special buttons

'Define the fonts used
Const fSmall=1
Const fStandard=2
Const fGraphics=4   'font used to store graphic symbols
Const True=1
Const False=0
Const LongPress=25      ' Set Switch Delay

Dim Integer key_coord(20, 5)
Dim Integer key_font(20)
Dim String key_caption(20)
Dim Integer selected(20),selected0(20),selected1(20)
Dim INTEGER nbr,x,c, Ra, RB, RSW, RTACT, Multiply, ButtonPress
Dim Integer  fChanged=0,gChanged=0,wavetype,gain,slidervalue, frequency,wavetype0,gain0,slidervalue0, frequency0,wavetype1,gain1,slidervalue1, frequency1
Dim Rotatedright, Rotatedleft, Resetenc=true, RTCount, PinRA, PinRB, PinRSW
RA=21:RB=22   ' Set Encoder Pins
RSW=23        ' Encoder Switch Pin
RTCount=0
RTAct=0
Multiply=1

SetPin(RB), INTH, RTint
SetPin(RA), DIN 'INTB, RTint
SetPin(RSW), INTL, SWint, PULLUP

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'
' AD9833 Control Bits
'
Const B28%=&H2000
Const RESET%=&H100
Const SLEEP12%=&H40
Const OPBITEN%=&H20
Const DEV2%=8
Const MODE%=2
'
' Output modes
Const triangle=1
Const sine=0
Const square=-1
'
'Module 0
Pin(CS0%)=1
Pin(FSY0%)=1
SetPin CS0%,dout
SetPin FSY0%,dout
'Module 1
Pin(CS1%)=1
Pin(FSY1%)=1
SetPin CS1%,dout
SetPin FSY1%,dout

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Pause 2000 'wait for signal genrator to initialise
' restore the settings.
VAR Restore
'Check if values have been saved. If not set them to default

If frequency0=0 Then
 frequency0=10000
 gain0=150
 wavetype0=sine
 slidervalue0=5
End If

If frequency1=0 Then
 frequency1=10000
 gain1=150
 wavetype1=sine
 slidervalue1=5
End If

selected(8)=1:selected(9)=0  'channel 0 selected
selected0(2)=0:selected0(3)=0:selected0(4)=0

If wavetype0=square Then
  selected0(3)=1   'Square
Else If wavetype0=triangle Then
  selected0(4)=1   'Triangle
Else
  selected0(2)=1  'Sine
End If

selected1(2)=0:selected1(3)=0:selected1(4)=0

If wavetype1=square Then
  selected1(3)=1   'Square
Else If wavetype1=triangle Then
  selected1(4)=1   'Triangle
Else
  selected1(2)=1  'Sine
End If

CLS
fChanged=1   'Get it to update at startup
GetOptions

End
'
Sub updateamplitude(i%,module%) ' Sets the output of the MCP41010 digital potentiometer (0-255)
  Local j%=&H1100 Or (i% And 255)
  If module%=0 Then Pin(CS0%)=0 Else Pin(CS1%)=0
  SPI write 1,j%
  If module%=0 Then Pin(CS0%)=1 Else Pin(CS1%)=1
End Sub


'
Sub updatefrequency(fin%, wave%,module%) 'Sets the frequency (Hz) and waveform of the AD9833 (Sine:wave%=0, Triangle:wave%=1, Square:wave%=-1)
  Local oscillator%=25000000 'Crystal frequency
  Local twoby28%=268435456 '2^28
  Local f%=(fin%*twoby28%)\oscillator%
  Local c%=0
  Local f1%=(f% And &H3FFF) Or &H4000
  Local f2%=(f%>>14) Or &H4000
  Local p%=&B1100000000000000
  If wave% =triangle Then c%=c% Or MODE%
  If wave%=square Then c%=c% Or SLEEP12% Or OPBITEN% Or DEV2%
  If module%=0 Then Pin(FSY0%)=0 Else Pin(FSY1%)=0
  SPI write 5,c% Or RESET% Or B28%,f1%,f2%,p%,c%
  If module%=0 Then Pin(FSY0%)=1 Else Pin(FSY1%)=1
End Sub

Sub showbar(j%,xc%,yt%)
  Local bar$
  Select Case j%
   Case 0
     bar$=Chr$(6)+Chr$(12)
   Case 1
     bar$= Chr$(7)+Chr$(12)
   Case 2
     bar$= Chr$(8)+Chr$(12)
   Case 3
     bar$= Chr$(9)+Chr$(12)
   Case 4
    bar$= Chr$(10)+Chr$(12)
   Case 5
     bar$= Chr$(11)+Chr$(12)
   Case 6
     bar$= Chr$(11)+Chr$(13)
   Case 7
     bar$= Chr$(11)+Chr$(14)
   Case 8
     bar$= Chr$(11)+Chr$(15)
   Case 9
     bar$= Chr$(11)+Chr$(16)
   Case 10
    bar$= Chr$(11)+Chr$(17)
  End Select
   Text xc%,yt%, bar$,CM , 4, 1,RGB(cyan), 0
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' this is the touch interrupt used when the main screen is touched
' all it does is set a flag
Sub TouchDown
  GotTouch = Touch(y)
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Int routine for Rotary Encoder
Sub RTInt
If Pin(RA) = 1 Then
   RTCount = RTCount + Multiply
  Else
   RTCount = RTCount - Multiply
 EndIf

 frequency=frequency+rtcount
 If Frequency < 0 Then Frequency = 0
 If Frequency > 9999999 Then Frequency = 9999999
Text (MM.HRes/2) + 15, 170+(MM.FontHeight * 2)+4, "       ", RT, 1 ,2, 15790320, 0 '6316182
Text (MM.HRes/2) + 15, 170+(MM.FontHeight * 2)+4, Str$(Frequency), RT, 1, 2, 15790320, 0 '6316182

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Int routine to check Rotary switch
Sub SWint
  ' Constant LONGPRESS determines LongPress Time
  ' ButtonPress=0 - No Press
  ' ButtonPress=1 - Short Press
  ' ButtonPress=2 - Long Press
SetPin(RSW), DIN, PULLUP

  ButtonPress=0
 Do While Pin(RSW)=0
    If ButtonPress <255 Then ButtonPress=ButtonPress+1
    Pause 25 ' This is also our Debounce value
 Loop
  If ButtonPress >0 Then
    If ButtonPress => LongPress Then

 Pause 500
      SPI open 1000000,3,16  'MCP41010 seem to need mode 3
      updateamplitude(gain,selectedmodule) 'scale output 100%
      SPI CLOSE
      SPI open 1000000,2,16 'has to be mode 2 for AD9833
      updatefrequency(frequency,wavetype,selectedmodule)
      SPI CLOSE
      UpdatedXDisplay
      ButtonPress=2
     Else
      Multiply = Multiply * 10
      If Multiply > 10000 Then Multiply = 1
      UpdateXDisPlay
      ButtonPress=1
     EndIf
    EndIf

 SetPin(RSW), INTL, SWint, PULLUP

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' routines to draw the option pages and get any changes
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub UpdateXDisplay
  Text 80, 180, "Multiplier", RT, 1 ,1, 15790320, 0 '6316182
  Text 60, 200, "X      ", RT, 1 ,1, 15790320, 0 '6316182
  Text 60, 200, Str$(Multiply), RT, 1 ,1, 15790320, 0 '6316182
End Sub

Sub UpdatedXDisplay
   Text 60, 220, "Updated", RT, 1 ,1, 15790320 , 0 '6316182
   Pause 750
   Text 60, 220, "       ", RT, 1 ,1, 15790320 , 0 '6316182
End Sub

' get the first page of options (frequency, offset and call GetThresholds)
Sub GetOptions
  Local refresh%
  Local integer b
  refresh%=&HFFFFFFFFFFFFFFFF
  'CLS
  'Watchdog 600000      ' restart program after 10 minutes if no key pressed
      SPI open 1000000,3,16 'MCP41010 seem to need mode 3

      gain0=getGain(frequency0,slidervalue0,wavetype0)
      updateamplitude(gain0,0)
      gain1=getGain(frequency1,slidervalue1,wavetype1)
      updateamplitude(gain1,1)
      SPI CLOSE
      SPI open 1000000,2,16 'has to be mode 2 for AD9833
      updatefrequency(frequency0,wavetype0,0)
      updatefrequency(frequency1,wavetype1,1)
      SPI CLOSE
      'select module 0 at startup
      selectedmodule=0
       If selectedmodule=0 Then
       selected(2)=selected0(2)
       selected(3)=selected0(3)
       selected(4)=selected0(4)
       'selected(8)=selected0(8)
       'selected(9)=selected0(9)
       slidervalue=slidervalue0
       frequency=frequency0
       wavetype=wavetype0
     Else
       selected(2)=selected1(2)
       selected(3)=selected1(3)
       selected(4)=selected1(4)
       'selected(8)=selected1(8)
       'selected(9)=selected1(9)
       slidervalue=slidervalue1
       frequency=frequency1
       wavetype=wavetype1

     End If

  Do
     If (refresh%=&HFFFFFFFFFFFFFFFF) Then
       CLS
       'DrawButton 5, 0,5,0,70,34,RGB(yellow),CHR$(20),4
       'DrawButton 5, 0,120,0,70,34,RGB(yellow),CHR$(23),4
       'DrawButton 5, 0,235,0,70,34,RGB(red),CHR$(21),4
     End If
    'Text 225, 100, " "+str$(gain)+" ", LT, fStandard, 1

       ' draw/refresh the options and the change button
If (refresh% And &H1)   Then DrawOption 0, RGB(240, 240, 240),"Frequency",225,170, frequency, "Hz"
       If (refresh% And &H1)   Then UpdateXDisplay
       'ClearButton 1
       If (refresh% And &H2)   Then DrawOptionButton 1, RGB(yellow), "",225, 0,RGB(yellow), Chr$(23),0

       If (refresh% And &H4)   Then DrawOptionButton 2, RGB(250, 192, 250), "Wave Form", 5, 38,cButton, Chr$(1),selected(2)
       If (refresh% And &H8)   Then DrawOptionButton 3, RGB(250, 192, 250), "Wave Form", 115, 38,cButton, Chr$(2),selected(3)
       If (refresh% And &H10)  Then DrawOptionButton 4, RGB(250, 192, 250), "Wave Form", 225, 38,cButton, Chr$(3),selected(4)
       ClearButton 5
       'if (refresh% AND &H2)   THEN DrawOption 1, RGB(250, 192, 250), "Amplitude", 100, gain, "%"
       If (refresh% And &H20)  Then DrawSliderButton 6, RGB(250, 192, 250), "Amplitude", 5, 106, Chr$(18),slidervalue
       If (refresh% And &H40)  Then DrawSliderButton 7, RGB(250, 192, 250), "Amplitude", 225, 106, Chr$(19),slidervalue

       If (refresh% And &H80)   Then DrawOptionButton 8, RGB(250, 192, 250), "", 5, 0,cButton, Chr$(24),selected(8)
       If (refresh% And &H100)  Then DrawOptionButton 9, RGB(250, 192, 250), "", 115, 0, cButton,Chr$(25),selected(9)


    WatchDog OFF    'Stop any WATCHDOG timer
    Do While Touch(x) = -1
Pause 50

 RTCount=0
  Loop  'Wait till touch
    refresh%=&H0
    ' get the selected button and take action based on the button
    b = CheckButtonPress(0, 9)'Check buttons 0-7
    Select Case b
      Case 0   'FREQUENCY
        CheckButtonRelease b
        nbr = frequency
        GetInteger "Freq.(Hz)", nbr
        frequency = nbr
        fChanged=1
        If selectedmodule=0 Then
          frequency0=frequency

        Else
          frequency1=frequency

        EndIf

        refresh%=&HFFFFFFFFFFFFFFFF

      Case 1 'save
        CheckButtonRelease b
          VAR Save frequency0,wavetype0,slidervalue0,gain0,frequency1,wavetype1,slidervalue1,gain1,Multiply
          refresh%=&HFFFFFFFFFFFFFFFF
          MessageBox "Current Settings", "Saved!"
      Case 2       'Select SINE Option
          CheckButtonRelease b
          selected(2)=1
          selected(3)=0
          selected(4)=0
          wavetype=0
          fChanged=1

          'Var Save wavetype
          refresh%=&H1C
          If selectedmodule=0 Then
            wavetype0=wavetype
          Else
            wavetype1=wavetype
          EndIf
          gain=getGain(frequency,slidervalue,wavetype)


      Case 3       'select SQUARE Option
          CheckButtonRelease b
          selected(2)=0
          selected(3)=1
          selected(4)=0
          wavetype=-1
          fChanged=1
          'Var Save wavetype
          refresh%=&H1C
          If selectedmodule=0 Then
            wavetype0=wavetype
          Else
            wavetype1=wavetype
          EndIf
          gain=getGain(frequency,slidervalue,wavetype)

      Case 4      'select TRIANGLE Option
          CheckButtonRelease b
          selected(2)=0
          selected(3)=0
          selected(4)=1
          wavetype=1
          fChanged=1
          'Var Save wavetype
          refresh%=&H1C
          If selectedmodule=0 Then
            wavetype0=wavetype
          Else
            wavetype1=wavetype
          EndIf
          gain=getGain(frequency,slidervalue,wavetype)

      Case 5   ' FINISH BUTTON
        CheckButtonRelease b
        'Var Save gain, frequency,wavetype
        fChanged=1
        CLS
        Exit Sub

      Case 6 'amplitude down
        CheckButtonRelease b
         If slidervalue>1 Then
           slidervalue=slidervalue-1
           gain=getGain(frequency,slidervalue,wavetype)
           gChanged=1
           'Var Save gain
           refresh%=&H20
           If selectedmodule=0 Then
            slidervalue0=slidervalue
            gain0=gain
           Else
            slidervalue1=slidervalue
            gain1=gain
           EndIf
         EndIf


       Case 7 'amplitude up
        CheckButtonRelease b
        If slidervalue<10 Then
           slidervalue=slidervalue+1
           gain=getGain(frequency,slidervalue,wavetype)
          'GetInteger "Amplitude (%)", nbr
          ' gain = nbr
           gChanged=1
           'Var Save gain
           refresh%=&H40
           If selectedmodule=0 Then
             slidervalue0=slidervalue
             gain0=gain
           Else
             slidervalue1=slidervalue
             gain1=gain
           EndIf

        End If

       Case 8 'Channel 0 selected
         CheckButtonRelease b
         If selectedmodule=1 Then

          frequency1=frequency
          gain1=gain
          wavetype1=wavetype
          selected1(2)=selected(2)
          selected1(3)=selected(3)
          selected1(4)=selected(4)
          slidervalue1=slidervalue

          frequency=frequency0
          gain=gain0
          wavetype=wavetype0
          selected(2)=selected0(2)
          selected(3)=selected0(3)
          selected(4)=selected0(4)
          slidervalue=slidervalue0
         End If

         selectedmodule=0
         selected(8)=1:selected(9)=0
         refresh%=&HFFFFFFFFFFFFFFFF


       Case 9 'Channel 1 selected
         CheckButtonRelease b
         If selectedmodule=0 Then
          frequency0=frequency
          gain0=gain
          wavetype0=wavetype
          selected0(2)=selected(2)
          selected0(3)=selected(3)
          selected0(4)=selected(4)
          slidervalue0=slidervalue

          frequency=frequency1
          gain=gain1
          wavetype=wavetype1
          selected(2)=selected1(2)
          selected(3)=selected1(3)
          selected(4)=selected1(4)
          slidervalue=slidervalue1
         End If
         selectedmodule=1
         selected(8)=0:selected(9)=1
         refresh%=&HFFFFFFFFFFFFFFFF

       Case -1
          ' no SET buttons have been touched, now check the main entries

    End Select
    If gchanged=1 Then
      gChanged=0
      SPI open 1000000,3,16   'MCP41010 seem to need mode 3
      updateamplitude(gain,selectedmodule) 'scale output 100%
      SPI CLOSE
    End If
    If fChanged=1 Then
      fChanged=0
      SPI open 1000000,3,16  'MCP41010 seem to need mode 3
      updateamplitude(gain,selectedmodule) 'scale output 100%
      SPI CLOSE
      SPI open 1000000,2,16 'has to be mode 2 for AD9833
      updatefrequency(frequency,wavetype,selectedmodule)
      SPI CLOSE

    End If

  Loop
End Sub

 Function getGain(freq As integer,slider As Integer,wave As integer) As integer

   Select Case wave
    Case sine,triangle

     Select Case freq
      Case < 400000
        getGain=slider*18
      Case < 500000
        getGain=Int(slider*18.5)
      Case < 1000000
        getGain=Int(slider*19.5)
      Case < 2000000
        getGain=Int(slider*22)
      Case < 4000000
        getGain=Int(slider*25.5)
      Case Else
        getGain=Int(slider*25.5)
     End Select
    Case square
       getGain=Int(7+slider*2)
   End Select

 End Function



'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Draw options and get button presses
' These two subs draw the option title, value and a button labeled "CHANGE"
' The function CheckButtonPress() will check if a button has been touched.
'
' These routines use the arrays key_coord() and key_caption() to track the
' coordinates and size of each button and save its caption.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' draw a single option
Sub DrawSliderButton n As Integer, foreground As Integer, title As String, xpos As integer, ypos As Integer,label As String, value As Integer
  Const btn_width = 80 '120
  Const fonth = MM.FontHeight * 2
  Const pad_width = 4
  'Text MM.HRes/2, vert, chr$(1), CT, 4, 1, colour
  Text MM.HRes/2, ypos, title, CT, fStandard, 1, foreground,cBGnd
  showbar(value,MM.HRes/2,ypos+fonth+12+pad_width+1)
  DrawButton n, 0,xpos,ypos + fonth + pad_width/2,btn_width,fonth + pad_width,cButton,label,fGraphics
End Sub


' draw a single option
Sub DrawOptionButton n As Integer, foreground As Integer, title As String, xpos As integer, ypos As Integer,btn_colour As Integer,label As String, selected As Integer
  Const btn_width = 80 '120
  Const fonth = MM.FontHeight * 2
  Const pad_width = 4
  'Text MM.HRes/2, vert, chr$(1), CT, 4, 1, colour
  If title<>"" Then
    Text MM.HRes/2, ypos, title, CT, fStandard, 1, foreground,cBGnd
    DrawButton n, 0,xpos,ypos + fonth + pad_width/2,btn_width,fonth + pad_width,btn_colour,label,fGraphics
  Else
    DrawButton n, 0,xpos,ypos ,btn_width,fonth + pad_width,btn_colour,label,fGraphics
  End If
  If selected=1 Then DrawButton n,2
End Sub

' draw a single option
Sub DrawOption n As Integer, foreground  As Integer, title As String,xpos As integer, ypos As Integer, value As integer, units As String
  Const btn_width = 80 '120
  Const fonth = MM.FontHeight * 2
  Const pad_width = 4
  Text MM.HRes/2, ypos, title, CT, fStandard, 1, foreground,cBGnd

If value <> -1 Then
Text (MM.HRes/2) + 15, 170+(MM.FontHeight * 2)+4, Str$(Frequency), RT, 1, 2, 15790320, 0
Text (MM.HRes/2) + 55, 170+(MM.FontHeight * 2)+4, units, RT, 1, 2, 15790320, 0
EndIf

 DrawButton n, 0,xpos,ypos + fonth + pad_width/2,btn_width,fonth + pad_width,cButton,"SET",fStandard

End Sub





'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Get an integer number
' when the user touches ENT (enter) the value is saved into the variable result
' which is parsed as reference as the second argument
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub GetInteger title As String, result As integer




  Local String s=""
  Local i, b
  ' these are the captions on each key
  Local String Scap(15) = ("7","8","9","","4","5","6","","1","2","3","Can","000","0","Del","ENT")
  'Local string strOriginal = str
  Const bw = MM.HRes\4, bh = MM.VRes\5

  CLS 0
  ' draw the title
  Text 0, 8, title + ": ", , 2, 1, cTitle, cBGnd

  For i = 0 To 15
    Select Case i
    Case 3,7 'Not used
      ClearButton i
    Case 11  'CAN
      DrawButton i, 0, bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, cSpecial, SCap(i),2
    Case 14  'DEL
      DrawButton i, 0, bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, cDel, SCap(i),2
    Case 15 'ENT
      DrawButton i, 0, bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, cSave, SCap(i),2
    Case Else
      DrawButton i, 0, bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, cButton, SCap(i),2
    End Select
  Next i


  Do
    'If Timer > 700 Then Text bw, 10, str + "_", , 2, 1, cEntry, 0 : Timer = 0
    'If Timer > 500 Then Text bw, 10, str + " ", , 2, 1, cEntry, 0
      b = CheckButtonPress(0, 15)
      Select Case b

        Case 0,1,2,4,5,6,8,9,10,12,13
          CheckButtonRelease b
          s = s + SCap(b)
          'Text bw, 10, s, , 2, 1, cEntry, 0
          Text Len(title + ": ") * 16, 8, s + " ", , 2, 1, cEntry, 0
        Case 11  'Cancel
          CheckButtonRelease b
          Exit Do
        Case 14  'DEL
          CheckButtonRelease b
          If s <> "" Then s = Left$(s, Len(s) - 1)
          Text Len(title + ": ") * 16, 8, s + " ", , 2, 1, cEntry, 0
        Case 15  'Enter
          CheckButtonRelease b
           If  s <> "" Then result = Val(s)
          Exit Do

      End Select
    EndIf
  Loop

End Sub



'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Draw buttons and get button presses
'
' The subrouting DrawButton will draw a button (normally used when drawing
' the screen for input).
'
' The function CheckButtonPress() will check if a button has been touched.
' If it has it will set it to selected (reverse video) and return with the
' button's number.
'
' The subroutine CheckButtonRelease will wait for the touch to be released
' and will then draw the button as normal.
'
' These routines use the global arrays key_coord() and key_caption() to
' track the coordinates and size of each button and save its caption.
'
' IMPORTANT: These routines set the watchdog to 10 minutes.  If a button
'            has not been pressed within this time the Micromite will
'            restart.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Clear button coordinates if not currently used
Sub ClearButton n As integer

    key_coord(n,0) = 0 : key_coord(n,1) = 0 : key_coord(n,2) = 0 : key_coord(n,3) = 0
    key_coord(n,4) = 0 : key_caption(n) = "" :key_font(n) = 1


End Sub
' draw a button
Sub DrawButton n As Integer, mode As Integer, x As integer, y As integer, w As integer, h As integer, c As integer, s As string,f As Integer
  Local integer backcolour, forecolour


  If mode = 0 Then
    key_coord(n,0) = x : key_coord(n,1) = y : key_coord(n,2) = w : key_coord(n,3) = h
    key_coord(n,4) = c : key_caption(n) = s :key_font(n) = f
  EndIf

  If mode > 1 Then
    backcolour = key_coord(n,4) : forecolour = 0    ' draw in reverse video if it is being touched
  Else
    backcolour = 0 : forecolour = key_coord(n,4)    ' a normal (untouched) button
  EndIf

  RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), backcolour
  Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n),CM , key_font(n), 1, forecolour, backcolour

End Sub


' check if a button has been touch and animate the button's image
' returns the button's number
Function CheckButtonPress(startn As Integer, endn As Integer) As Integer
  Local Integer xt, yt, n

  CheckButtonPress = -1
  If Touch(x) <> -1 Then
    ' we have a touch
    'WatchDog 600000                        ' reset after 10 minutes
    xt = Touch(x)
    yt = Touch(y)
    ' scan the array key_coord() to see if the touch was within the
    ' boundaries of a button
    For n = startn To endn
      If xt > key_coord(n,0) And xt < key_coord(n,0) + key_coord(n,2) And yt > key_coord(n,1) And yt < key_coord(n,1) + key_coord(n,3) Then
        ' we have a button press
        ' draw the button as pressed
        DrawButton n, 2
        CheckButtonPress = n
        Exit For
      EndIf
    Next n
  EndIf
End Function


' wait for the touch to be released and then draw the button as normal
Sub CheckButtonRelease n As integer
  ' if a button is currently down check if it has been released
  Do While Touch(x) <> -1 : Loop   ' wait for the button to be released
  DrawButton n, 1                  ' draw the button as normal (ie, not pressed)
End Sub



'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' this handy routine draws a message box with an OK button
' then waits for the button to be touched
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MessageBox s1 As String, s2 As String
  Local integer w
  If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
  w = w * 8     ' get the width of the text (used for the box width)

  ' draw the box and the message in it
  RBox MM.HRes/2 - w - 20, 60, w * 2 + 40, 130, , RGB(yellow), 0
  Text MM.HRes/2, 70, s1, CT, 1, 2, RGB(white)
  Text MM.HRes/2, 100, s2, CT, 1, 2, RGB(white)

  ' draw the OK button
  RBox 110, 140, 100, 34, , cButton
  Text MM.HRes/2, 157, "OK", CM, 1, 2, cButton

  ' wait for the button to be touched
  Do While Not (Touch(x) > 110 And Touch(x) < 210 And Touch(y) > 140 And Touch(y) < 180) : Loop

  ' draw the OK button as depressed
  RBox 110, 140, 100, 34, , cButton, cButton
  Text MM.HRes/2, 157, "OK", CM, 1, 2, 0, cButton

  ' wait for the touch to be removed
  Do While Touch(x) <> -1 : Loop
End Sub                                                                                                                            