option explicit

mode 1,16

'INITIALISE VARIABLES
'deck$ array holds all the tiles in the deck (0-71) + temp tile for swapping
dim deck$(72,2)
'grid (x,y) array is the tile grid, each cell holds the tile type no (99 for empty)
dim grid(17,17)
'type$ array holds the edges/connection matrices for each different tile type
dim type$(23,4)
'claim array holds the x,y co-ords of each claim position on each tile type
dim claim(23,12,1)
'player array holds the no. of counters / score of each player
dim player(4,2)
'numPlayers is the total number of players 1-5
dim numPlayers,humanPlayers as integer
'offset is for positioning the play grid on screen
dim offset=20
'gridSize is the size of the play grid on screen (actually 1 bigger than this, counting 0)
dim gridSize=16
'a grey colour for the background
dim grey=rgb(64,64,64)
'temp var for propagating feature ownerships
dim edgeNodes$
'temp var for storing tile feature claim (x,y) pairs
dim claimPos(12,1)
'temp loop vars
dim f as integer

initArrays

'set top of the deck to be the start tile (currently tile 7 in the deck)
deck$(72,0)=deck$(0,0) 'first move tile 0 to temporary slot
deck$(0,0)=deck$(7,0)  'copy tile 7 to top of the deck (deck(0,..)
deck$(7,0)=deck$(72,0) 'put tile 0 (old top of the deck) into tile 7's slot

'shuffle the deck from position 1-71 (leave top of the deck as start tile
dim tileFrom,tileTo as integer
for f=0 to 1000
  tileFrom=(rnd*70)+1
pickNew:
  tileTo=(rnd*70)+1
  if tileTo=tileFrom goto pickNew:
  deck$(72,0)=deck$(tileFrom,0)
  deck$(tileFrom,0)=deck$(tileTo,0)
  deck$(tileTo,0)=deck$(72,0)
next f

dim currentPlayer
dim currentTile
dim currentTileX=8
dim currentTileY=8
dim currentTileType=eval(deck$(currentTile,0))
dim tileRotation=0
dim tileEdge$=type$(currentTileType,tileRotation)
dim tileMatrix$=type$(currentTileType,4)


'load up the tileset onto the background page
page write 1
load png "tileset.png"
page write 0

'welcome message
print "Welcome to Carcassone, the classic Medieval tiling board game.":print
print "There can be up to 5 players, and you can play against other humans or AI.":print
getPlayers:
input "How many players would you like?";numPlayers
if numPlayers<2 or numPlayers>5 then print "Invalid number of players.":goto getPlayers
gethumanPlayers:
'input "How many human players?";humanPlayers
'if humanPlayers<1 or humanPlayers>numPlayers then print "Invalid number of human players.": goto getHumanPlayers
'print
'print "There are";numPlayers;" players in this game.";
'dim aiPlayers=numPlayers-humanPlayers
'print "There are";aiPlayers;" AI players."

'player 1 is always human
player(0,0)=0
if humanPlayers=2 then player(1,0)=0
if humanPlayers=3 then player(2,0)=0
if humanPlayers=4 then player(3,0)=0
if humanPlayers=5 then player(4,0)=0

'print
'print "Press a key to start."

'waitKey

do while keydown(0)<>0
loop

'BEGIN GAME
'set current player to first player
currentPlayer=0
'set current tile to the top of the deck (0)
currentTile=0  'start drawing tiles from the top of the deck

'draw main board grid
drawGrid

'put first tile (deck tile 0) on the board
grid(8,8)=currentTile
copyTileGraphic(currentTile)
placeTileGraphic(8,8)
'set feature type nodes on first tile in default rotation, 0
setNodes(currentTile,0)
'copy connection matrix into the current tile in default rotation
deck$(currentTile,2)=type$(currentTileType,4)

'deck$(1,0)="3"

dim i

'MAIN GAME LOOP - ALL PLAYERS
do
  'put up all player's stats,
  'highlight the current player
  updateStats
  'blank info area
  box 580,320,219,279,0,0,grey
  'get the next tile from the deck
  currentTile=currentTile+1
  'initialise current tile data  
  currentTileX=0
  currentTileY=0
  currentTileType=eval(deck$(currentTile,0))
  tileRotation=0
  tileEdge$=type$(currentTileType,tileRotation)
  'put next tile onto the screen below players
  copyTileGraphic(currentTile)
  'put next tile onto the play grid in top left corner
  placeTileGraphic(currentTileX,currentTileY)
  'set the node codes in default rotation
  setNodes(currentTile,tileRotation)
  'copy connection matrix into the current tile in default rotation
  deck$(currentTile,2)=type$(currentTileType,4)

  text 580,320,"Tile to place:",,,,,-1
  text 580,400,str$(72-currentTile)+" tiles to place"
  text 580,415,"Cursor keys to move tile"
  text 580,430,"> and < to rotate tile"
  text 580,445,"ENTER key to place tile"
  
tile_placement:
  'PLAYER PLACE TILE LOOP
  do

    'get a keypress from the player
    i=keydown(1)
   
    if i=128 then 'cursor up
      if currentTileY>1 then if grid(currentTileX,currentTileY-1)<>99 then goto skip_move:
      blankGrid(currentTileX,currentTileY)
      currentTileY=currentTileY-1
      if currentTileY<0 then currentTileY=0
      placeTileGraphic(currentTileX,currentTileY)      
    end if

    if i=129 then 'cursor down
      if currentTileY<gridSize then if grid(currentTileX,currentTileY+1)<>99 then goto skip_move:
      blankGrid(currentTileX,currentTileY)
      currentTileY=currentTileY+1
      if currentTileY>gridSize then currentTileY=gridSize
      placeTileGraphic(currentTileX,currentTileY)
    end if

    if i=130 then 'cursor left
      if currentTileX>1 then if grid(currentTileX-1,currentTileY)<>99 then goto skip_move:
      blankGrid(currentTileX,currentTileY)
      currentTileX=currentTileX-1
      if currentTileX<0 then currentTileX=0
      placeTileGraphic(currentTileX,currentTileY)
    end if

    if i=131 then 'cursor right
      if currentTileX<gridSize then if grid(currentTileX+1,currentTileY)<>99 then goto skip_move:
      blankGrid(currentTileX,currentTileY)
      currentTileX=currentTileX+1
      if currentTileX>gridSize then currentTileX=gridSize
      placeTileGraphic(currentTileX,currentTileY)
    end if

    if i=asc(".") then 'rotate clockwise
      tileRotation=tileRotation+1
      if tileRotation>3 then tileRotation=0
      'update the edge ownership nodes in new rotation
      setNodes(currentTile,tileRotation)
      'rotate the connection matrix clockwise by 90 degrees
'      text 10,570,"pre-rotate matrix:"+deck$(currentTile,2)+" "
      rotateMatrix
 '     text 10,570,"post-rotation matrix:"+deck$(currentTile,2)+" "
      'redraw the tile graphic
      rotateClockwise
      placeTileGraphic(currentTileX,currentTileY)
    end if

    if i=asc(",") then  'rotate anticlockwise
      tileRotation=tileRotation-1
      if tileRotation<0 then tileRotation=3
      'update the edge ownership nodes in new rotation
      setNodes(currentTile,tileRotation)
      'rotate the connection matrix anticlockwise 90 degrees (3 x clockwise rotations)
      rotateMatrix
      rotateMatrix
      rotateMatrix
'      text 10,570,"connection matrix now:"+deck$(currentTile,2)+" "
      'redraw the tile graphic
      rotateAnticlockwise
      placeTileGraphic(currentTileX,currentTileY)
    end if

    if i=10 then 'ENTER key
      goto check_placement:
    endif

skip_move:

    pause 100

  loop
  'END OF PLAYER SELECT TILE LOOP - INFITITE LOOP!

  print "shouldn't get here!!!": waitKey : end

check_placement:

  'check to see if tile is connected to the other tiles
  if currentTileY>0 then if grid(currentTileX,currentTileY-1)<>99 goto tileConnected:
  if grid(currentTileX+1,currentTileY)<>99 goto tileConnected:
  if grid(currentTileX,currentTileY+1)<>99 goto tileConnected:
  if currentTileX>0 then if grid(currentTileX-1,currentTileY)<>99 goto tileConnected:
  'placed tile is not connected to anything - go back and try again.
  text 10,575,"Tile must be connected to another tile. Try again!",,,,rgb(255,255,255),rgb(255,0,0)
  goto tile_placement:

tileConnected:
  'blank footer notification area
  blankFooter

  'check to see if the edges of the tile correctly align
  'with edges of tiles already placed
  if not edgeMatch("N") then
    text 10,570,"North edge of tile doesn't match tile on board. Try again."
    goto tile_placement: 
  endif

  if not edgeMatch("E") then
    text 10,570,"East edge of tile doesn't match tile on board. Try again."
    goto tile_placement:
  endif

  if not edgeMatch("S") then
    text 10,570,"South edge of tile doesn't match tile on board. Try again."
    goto tile_placement:
  endif

  if not edgeMatch("W") then
    text 10,570,"West edge of tile doesn't match tile on board. Try again."
    goto tile_placement:
  endif

  'assign the tile to the grid position
  grid(currentTileX,currentTileY)=currentTile

  'propagate surrounding edge ownerships to edges of currentTile
  'north edge of current tile - (getOwnedNodes("N") checks south edge of tile above)
  edgeNodes$=getOwnedNodes$("N")
    mid$(deck$(currentTile,1),1,1)=mid$(edgeNodes$,1)
    mid$(deck$(currentTile,1),3,1)=mid$(edgeNodes$,2)
    mid$(deck$(currentTile,1),5,1)=mid$(edgeNodes$,3)
  edgeNodes$=getOwnedNodes$("E")
    mid$(deck$(currentTile,1),7,1)=mid$(edgeNodes$,1)
    mid$(deck$(currentTile,1),9,1)=mid$(edgeNodes$,2)
    mid$(deck$(currentTile,1),11,1)=mid$(edgeNodes$,3)
  edgeNodes$=getOwnedNodes$("S")
    mid$(deck$(currentTile,1),17,1)=mid$(edgeNodes$,1)
    mid$(deck$(currentTile,1),15,1)=mid$(edgeNodes$,2)
    mid$(deck$(currentTile,1),13,1)=mid$(edgeNodes$,3)
  edgeNodes$=getOwnedNodes$("W")
    mid$(deck$(currentTile,1),23,1)=mid$(edgeNodes$,1)
    mid$(deck$(currentTile,1),21,1)=mid$(edgeNodes$,2)
    mid$(deck$(currentTile,1),19,1)=mid$(edgeNodes$,3)

  'propagate ownerships from edges through currentTile using connection matrix
  'look out for conflicting ownerships on other edges that mean shared ownership
  'must be propagated through to already-placed tiles
  
  
  'blank the info area
  blankInfoArea

  'PLAYER SELECTS FEATURE TO CLAIM (OR NONE)

  'player can place a counter on a feature if they have at least one left
  if player(currentPlayer,1)>0 then
    text 580,400,"Enter key cycles which"
    text 580,415,"claim position you want."
    text 580,430,"Space bar to confirm."
    text 580,445,"Choose NONE if you don't"
    text 580,460,"want to place a counter."

    'transfer the non-rotated claim positions to the temp var claimPos(12,1) for rotating
    getClaimPos(currentTileType)
    'rotate the claim(x,y) positions on this tile according to its rotation
    if tileRotation=1 then rotateClaims
    if tileRotation=2 then rotateClaims:rotateClaims
    if tileRotation=3 then rotateClaims:rotateClaims:rotateClaims

    do
      'loop through available claim spots on the current tile, plus NONE
      for f=0 to 12
        'if there is a claim pos on this node, and it's not been claimed already
        if claimPos(f,0)<>99 and mid$(deck$(currentTile,1),(f*2)+1,1)="Z" then
          placeTileGraphic(currentTileX,currentTileY)
          drawCounter(claimPos(f,0),claimPos(f,1))
          i=getKey()
          if i=asc(" ") then goto counter_placed:
        endif
      next f
      placeTileGraphic(currentTileX,currentTileY)
      text offset+currentTileX*32,offset+currentTileY*32,"NONE",,,,,grey
      i=getKey()
      if i=asc(" ") then placeTileGraphic(currentTileX,currentTileY):goto no_counter_placed:
    loop  
counter_placed:
  player(currentPlayer,1)=(player(currentPlayer,1))-1
'  text 10,580,"deducted 1 from player "+str$(currentPlayer)+"'s counters. "+str$(player(currentPlayer,1)+" left."
 ' waitkey
  if player(currentPlayer,1)<0 then print "ERROR! placed too many counters.":waitkey
    
  endif 'player has finished placing a counter (or none)

no_counter_placed:

  inc currentPlayer
  if currentPlayer>numPlayers-1 then currentPlayer=0

  'wait for player to let go of enter key
  do while keydown(0)<>0
  loop

loop while currentTile<72
'END OF MAIN GAME LOOP - ALL TILES USED UP! 
'do final score calculations

end

function getKey()
  'wait for the player to let go of all keys
  do while keydown(0)<>0
  loop
  'wait for a keypress
  do
    i=keydown(1)
    if i<>0 then goto breakout:
  loop
breakout:
  getKey=i
end function

sub drawCounter(x,y)
  blit currentPlayer*6,128,x+offset+(currentTileX*32),y+offset+(currentTileY*32),6,7,1
end sub


function getOwnedNodes$(d$)
  local t$=""
  local checkTile,checkPos as integer
  if d$="N" then 'get ownerships of south edge of tile above currentTile
    checkTile=grid(currentTileX,currentTileY-1)
    if checkTile=99 then t$="ZZZ":goto skipOwnership:
    t$=t$+mid$(deck$(checkTile,1),17,1)
    t$=t$+mid$(deck$(checkTile,1),15,1)
    t$=t$+mid$(deck$(checkTile,1),13,1)
  endif
  if d$="E" then  'get ownerships of west edge of tile to the right of currentTile
    checkTile=grid(currentTileX+1,currentTileY)
    if checkTile=99 then t$="ZZZ":goto skipOwnership:
    t$=t$+mid$(deck$(checkTile,1),23,1)
    t$=t$+mid$(deck$(checkTile,1),21,1)
    t$=t$+mid$(deck$(checkTile,1),19,1)
  endif
  if d$="S" then 'get ownerships of north edge of tile below currentTile
    checkTile=grid(currentTileX,currentTileY+1)
    if checkTile=99 then t$="ZZZ":goto skipOwnership:
    t$=t$+mid$(deck$(checkTile,1),1,1)
    t$=t$+mid$(deck$(checkTile,1),3,1)
    t$=t$+mid$(deck$(checkTile,1),5,1)
  endif
  if d$="W" then 'get ownerships of east edge of tile to the left of currentTile
    checkTile=grid(currentTileX-1,currentTileY)
    if checkTile=99 then t$="ZZZ":goto skipOwnership:
    t$=t$+mid$(deck$(checkTile,1),7,1)
    t$=t$+mid$(deck$(checkTile,1),9,1)
    t$=t$+mid$(deck$(checkTile,1),11,1)
  endif
skipOwnership:
  getOwnedNodes$=t$
end function

sub rotateClaims
  local t,f as integer
  for f=0 to 12
    if claimPos(f,0)<>99 then 
      t=claimPos(f,0)
      claimPos(f,0)=26-claimPos(f,1)
      claimPos(f,1)=t
    endif
  next f
end sub

sub getClaimPos(type)
  'transfer the claim positions into the temp var claimPos(12,1)
  'from the appropriate type in claim(n,12,1)
  local f
  for f=0 to 12
    claimPos(f,0)=claim(type,f,0)
    claimPos(f,1)=claim(type,f,1)
  next f
end sub

sub blankFooter
  box 10,570,800,29,0,0,grey
end sub

sub blankInfoArea
  box 580,400,219,199,0,0,grey
end sub  

sub rotateMatrix
  local f,g as integer
  local t$,s$
  s$=deck$(currentTile,2)
  for f=1 to 24
    mid$(s$,f,1)=shiftThree$(mid$(s$,f,1))
  next f
  for f=0 to 5
    t$=mid$(s$,24,1)  'store the last char in a temp var
    for g=23 to 1 step -1
      mid$(s$,g+1,1)=mid$(s$,g,1)
    next g
    mid$(s$,1,1)=t$
  next f
  deck$(currentTile,2)=s$
end sub

function shiftThree$(c$)
  if c$="0" then shiftThree$="3"
  if c$="1" then shiftthree$="4"
  if c$="2" then shiftThree$="5"
  if c$="3" then shiftThree$="6"
  if c$="4" then shiftThree$="7"
  if c$="5" then shiftThree$="8"
  if c$="6" then shiftThree$="9"
  if c$="7" then shiftThree$="A"
  if c$="8" then shiftThree$="B"
  if c$="9" then shiftThree$="0"
  if c$="A" then shiftThree$="1"
  if c$="B" then shiftThree$="2"
  if c$="C" then shiftThree$="3"
  if c$="X" then shiftThree$="X"
end function

function edgeMatch(edge$)
  local edgeCurrent$,edgePlaced$
  local matchTile as integer
  edgeMatch=0
  if edge$="N" then 'checking north edge of currentTile against grid
    if currentTileY=0 then edgeMatch=1 : goto endEdgeMatch:
    edgeCurrent$=mid$(deck$(currentTile,1),1,6)
    matchTile=grid(currentTileX,currentTileY-1)
    if matchTile=99 then edgeMatch=1 : goto endEdgeMatch:
    edgePlaced$=mid$(deck$(matchTile,1),13,6)
    if getEdge$(edgeCurrent$)=getEdge$(edgePlaced$) then edgeMatch=1 : goto endEdgeMatch:
  endif
  if edge$="E" then 'checking east edge of currentTile against grid
    if currentTileX=gridSize then edgeMatch=1 : goto endEdgeMatch:
    edgeCurrent$=mid$(deck$(currentTile,1),7,6)
    matchTile=grid(currentTileX+1,currentTileY)
    if matchTile=99 then edgeMatch=1 : goto endEdgeMatch:
    edgePlaced$=mid$(deck$(matchTile,1),19,6)
    if getEdge$(edgeCurrent$)=getEdge$(edgePlaced$) then edgeMatch=1 : goto endEdgeMatch:
  endif
  if edge$="S" then 'checking south edge of currentTile against grid
    if currentTileY=gridSize then edgeMatch=1 : goto endEdgeMatch:
    edgeCurrent$=mid$(deck$(currentTile,1),13,6)
    matchTile=grid(currentTileX,currentTileY+1)
    if matchTile=99 then edgeMatch=1 : goto endEdgeMatch
    edgePlaced$=mid$(deck$(matchTile,1),1,6)
    if getEdge$(edgeCurrent$)=getEdge$(edgePlaced$) then edgeMatch=1 : goto endEdgeMatch:
  endif
  if edge$="W" then 'checking west edge of currentTile against grid
    if currentTileX=0 then edgeMatch=1 : goto endEdgeMatch:
    edgeCurrent$=mid$(deck$(currentTile,1),19,6)
    matchTile=grid(currentTileX-1,currentTileY)
    if matchTile=99 then edgeMatch=1 : goto endEdgeMatch
    edgePlaced$=mid$(deck$(matchTile,1),7,6)
    if getEdge$(edgeCurrent$)=getEdge$(edgePlaced$) then edgeMatch=1 : goto endEdgeMatch:
  endif
 
endEdgeMatch:
'  text 10,570,"current edge="+edgeCurrent$+";edge placed="+edgePlaced$

end function


function getEdge$(edge$)
  getEdge$=mid$(edge$,2,1)
  getEdge$=getEdge$+mid$(edge$,4,1)
  getEdge$=getEdge$+mid$(edge$,6,1)
end function


sub rotateClockwise
  local x=offset+(19*32)
  local y=offset+(10*32)
  image rotate_fast x-1,y-1,34,34,x-2,y-1,90
end sub

sub rotateAnticlockwise
  local x=offset+(19*32)
  local y=offset+(10*32)
  image rotate_fast x-1,y-1,34,34,x-1,y-2,270
end sub

sub blankGrid(gridX,gridY)
  local sx=offset+(gridX*32)
  local sy=offset+(gridY*32)
  box sx,sy,32,32,0,0,grey
  line sx,sy,31+sx,sy,,0
  line sx,sy,sx,sy+31,,0
end sub

'copyTile copies the graphic for the specified tile in the deck
'from tileset in bank 1 (default rotation 0) onto screen, below the player stats
sub copyTileGraphic(deckNo)
  local graphicX,graphicY as integer
  local tileType=eval(deck$(deckNo,0))
  graphicX=getX(tileType)
  graphicY=getY(tileType)
'  graphicX=96
'  graphicY=0
  blit graphicX,graphicY,offset+19*32,offset+10*32,32,32,1
end sub

'placeTile copies the current tile graphic below the player stats
'into a paticular place on screen
sub placeTileGraphic(gridX,gridY)
  blit offset+19*32,offset+10*32,offset+(gridX*32),offset+(gridY*32),32,32
end sub

function getX(type)
  getX=(type mod 6) * 32
end function

function getY(type)
  getY=int(type/6) * 32
end function

sub setNodes(deckNo,rotationNo)
  local nodeString$,temp$
  local f
  temp$=type$(eval(deck$(deckNo,0)),rotationNo)
  'parse temp$ tile edges (FRTR etc) to nodeString$
  for f=1 to 4
    if mid$(temp$,f,1)="F" then nodeString$=nodeString$+"ZFZFZF"
    if mid$(temp$,f,1)="R" then nodeString$=nodeString$+"ZFZRZF"
    if mid$(temp$,f,1)="T" then nodeString$=nodeString$+"ZTZTZT"
  next f
  'add the monastery on the end (node 13)
  if deck$(deckNo,0)="0" or deck$(deckNo,0)="1" then
    nodeString$=nodeString$+"ZM"
  else
    nodeString$=nodeString$+"ZZ"
  endif
  deck$(deckNo,1)=nodeString$


'  text 580,460,"tile code:"
'  text 580,475,deck$(deckNo,1)
end sub


sub drawGrid
  cls grey
  local x,y
  for y=0 to gridSize
    for x=0 to gridSize
      box offset+x*32,offset+y*32,33,33,1,0,grey
'      text 5+offset+x*32,5+offset+y*32,str$(grid(x,y)),,,,,-1
    next x
  next y
end sub

sub updateStats
  local p,c,counters as integer
  'draw highlight box for current player
  box 580,20,170,300,0,0,grey
  box 580,20+currentPlayer*60,170,60,0,0,rgb(RED)
  for p=0 to numPlayers-1
    text 600,30+p*60,"Player "+str$(p+1),,,,,-1
    counters=player(p,1)
    for c=0 to counters-1
      image resize_fast p*6,128,6,7,600+c*18,50+p*60,12,14,1
    next c
  next p

end sub

sub initArrays
  'zero the grid tiles to 99
  local x,y
  for y=0 to gridSize
    for x=0 to gridSize
      grid(x,y)=99
    next x
  next y
  local f
  'zero out all the player stats
  for f=0 to 4
   'all players AI  'all have 7 counters  'all have zero score
    player(f,0)=1 : player(f,1)=7 : player(f,2)=0
  next f
  'set up tile type array
  local a$,b$,c$,d$,e$
  for f=0 to 23
    read a$,b$,c$,d$,e$
    type$(f,0)=a$:type$(f,1)=b$:type$(f,2)=c$:type$(f,3)=d$:type$(f,4)=e$
  next f
  '0
  data "FFRF","FFFR","RFFF","FRFF"
  data "1B021324354658XX698A9B0A"
  '1
  data "FFFF","FFFF","FFFF","FFFF"
  data "1B02132435465768798A9B0A"
  '2
  data "TTTT","TTTT","TTTT","TTTT"
  data "1B02132435465768798A9B0A"
  '3
  data "RTRF","FRTR","RFRT","TRFR"
  data "8B7X6X4X354X2X1X098A9B0A"
  '4
  data "TFFF","FTFF","FFTF","FFFT"
  data "1X021XB435465768798A9B3A"
  '5
  data "FTFT","TFTF","FTFT","TFTF"
  data "1X021XB435947X687X5A9B3A"
  '6
  data "TFTF","FTFT","TFTF","FTFT"
  data "8102614X354X276807AX9BAX"
  '7
  data "FTFT","TFTF","FTFT","TFTF"
  data "8102614X354X276807AX9BAX"
  '8
  data "FTTF","FFTT","TFFT","TTFF"
  data "1B02914X354X7X687X2A9B0A"
  '9
  data "TRRF","FTRR","RFTR","RRFT"
  data "1X021X8B7X6X5X4X398A9B3A"
  '10
  data "RTFR","RRTF","FRRT","TFRR"
  data "BXAX694X354X276879281X0X"
  '11
  data "RTRR","RRTR","RRRT","TRRR"
  data "BXXX6X4X354X2XXX9X8XXX0X"
  '12
  data "TFFT","TTFF","FTTF","FFTT"
  data "1B02918435466868372A9B0A"
  '13
  data "TFFT","TTFF","FTTF","FFTT"
  data "1B02918435466868372A9B0A"
  '14
  data "TRRT","TTRR","RTTR","RRTT"
  data "1B02918X7X6X5X4X3X2A9B0A"
  '15
  data "TRRT","TTRR","RTTR","RRTT"
  data "1B02918X7X6X5X4X3X2A9B0A"
  '16
  data "TTFT","TTTF","FTTT","TFTT"
  data "1B02132435947X687X5A9B0A"
  '17
  data "TTFT","TTTF","FTTT","TFTT"
  data "1B02132435947X687X5A9B0A"
  '18
  data "TTRT","TTTR","RTTT","TRTT"
  data "1B0213243594XXXXXX5A9B0A"
  '19
  data "TTRT","TTTR","RTTT","TRTT"
  data "1B0213243594XXXXXX5A9B0A"
  '20
  data "RFRF","FRFR","RFRF","FRFR"
  data "8B7X63243546251X098A9B0A"
  '21
  data "FFRR","RFFR","RRFF","FRRF"
  data "1B0213243546B5AX9X8X7X60"
  '22
  data "FRRR","RFRR","RRFR","RRRF"
  data "1B02132BXX6X5XXX9X8XXX30"
  '23
  data "RRRR","RRRR","RRRR","RRRR"
  data "BXXX3X2XXX6X5XXX9X8XXX0X"

  'set up deck$ with tile types and blank ownership nodes
  local n
  for f=0 to 71
    read n
    deck$(f,0)=str$(n) : deck$(f,1)="ZZZZZZZZZZZZZZZZZZZZZZZZZZ"
  next f
  data 0,0
  data 1,1,1,1
  data 2
  data 3,3,3,3
  data 4,4,4,4,4
  data 5,5
  data 6
  data 7,7,7
  data 8,8
  data 9,9,9
  data 10,10,10
  data 11,11,11
  data 12,12
  data 13,13,13
  data 14,14
  data 15,15,15
  data 16
  data 17,17,17
  data 18,18
  data 19
  data 20,20,20,20,20,20,20,20
  data 21,21,21,21,21,21,21,21,21
  data 22,22,22,22
  data 23
  
  'set up claim array (x,y) values  
  for f=0 to 23
    for n=0 to 12
      claim(f,n,0)=99 : claim(f,n,1)=99
    next n
  next f
  claim(0,6,0)=23:claim(0,6,1)=23
  claim(0,7,0)=12:claim(0,7,1)=23
  claim(0,12,0)=13:claim(0,12,1)=13
  claim(1,6,0)=23:claim(1,6,1)=23
  claim(1,12,0)=13:claim(1,12,1)=13
  claim(2,1,0)=13:claim(2,1,1)=13
  claim(3,4,0)=26:claim(3,4,1)=13
  claim(3,6,0)=19:claim(3,6,1)=25
  claim(3,7,0)=13:claim(3,7,1)=13
  claim(3,10,0)=4:claim(3,10,1)=13
  claim(4,1,0)=13:claim(4,1,1)=0
  claim(4,7,0)=13:claim(4,7,1)=19
  claim(5,1,0)=13:claim(5,1,1)=0
  claim(5,4,0)=13:claim(5,4,1)=10
  claim(5,7,0)=13:claim(5,7,1)=25
  claim(6,1,0)=13:claim(6,1,1)=0
  claim(6,4,0)=13:claim(6,4,1)=10
  claim(6,7,0)=13:claim(6,7,1)=25
  claim(7,4,0)=26:claim(7,4,1)=13
  claim(7,7,0)=13:claim(7,7,1)=13
  claim(7,10,0)=0:claim(7,10,1)=13
  claim(8,4,0)=26:claim(8,4,1)=13
  claim(8,7,0)=13:claim(8,7,1)=25
  claim(8,10,0)=10:claim(8,10,1)=10
  claim(9,1,0)=13:claim(9,1,1)=0
  claim(9,6,0)=23:claim(9,6,1)=23
  claim(9,7,0)=16:claim(9,7,1)=17
  claim(9,8,0)=5:claim(9,8,1)=18
  claim(10,0,0)=2:claim(10,0,1)=2
  claim(10,1,0)=10:claim(10,1,1)=9
  claim(10,4,0)=26:claim(10,4,1)=13
  claim(10,7,0)=13:claim(10,7,1)=20
  claim(11,0,0)=2:claim(11,0,1)=2
  claim(11,1,0)=12:claim(11,1,1)=3
  claim(11,4,0)=26:claim(11,4,1)=13
  claim(11,6,0)=14:claim(11,6,1)=13
  claim(11,7,0)=10:claim(11,7,1)=23
  claim(11,8,0)=2:claim(11,8,1)=23
  claim(11,10,0)=0:claim(11,10,1)=13
  claim(12,0,0)=5:claim(12,0,1)=6
  claim(12,6,0)=22:claim(12,6,1)=20
  claim(13,0,0)=5:claim(13,0,1)=6
  claim(13,6,0)=22:claim(13,6,1)=20
  claim(14,0,0)=5:claim(14,0,1)=6
  claim(14,6,0)=24:claim(14,6,1)=23
  claim(14,7,0)=18:claim(14,7,1)=21
  claim(14,8,0)=14:claim(14,8,1)=15
  claim(15,0,0)=5:claim(15,0,1)=6
  claim(15,6,0)=24:claim(15,6,1)=23
  claim(15,7,0)=18:claim(15,7,1)=21
  claim(15,8,0)=14:claim(15,8,1)=15
  claim(16,1,0)=13:claim(16,1,1)=7
  claim(16,7,0)=15:claim(16,7,1)=24
  claim(17,1,0)=13:claim(17,1,1)=7
  claim(17,7,0)=15:claim(17,7,1)=24
  claim(18,1,0)=13:claim(18,1,1)=7
  claim(18,6,0)=19:claim(18,6,1)=25
  claim(18,7,0)=13:claim(18,7,1)=25
  claim(18,8,0)=7:claim(18,8,1)=25
  claim(19,1,0)=13:claim(19,1,1)=7
  claim(19,6,0)=19:claim(19,6,1)=25
  claim(19,7,0)=13:claim(19,7,1)=25
  claim(19,8,0)=7:claim(19,8,1)=25
  claim(20,1,0)=13:claim(20,1,1)=13
  claim(20,4,0)=22:claim(20,4,1)=13
  claim(20,10,0)=4:claim(20,10,1)=13
  claim(21,2,0)=21:claim(21,2,1)=8
  claim(21,7,0)=12:claim(21,7,1)=15
  claim(21,8,0)=4:claim(21,8,1)=21
  claim(22,1,0)=13:claim(22,1,1)=2
  claim(22,4,0)=25:claim(22,4,1)=13
  claim(22,6,0)=23:claim(22,6,1)=22
  claim(22,7,0)=13:claim(22,7,1)=23
  claim(22,8,0)=5:claim(22,8,1)=21
  claim(22,10,0)=2:claim(22,10,1)=13
  claim(23,0,0)=5:claim(23,0,1)=3
  claim(23,1,0)=14:claim(23,1,1)=1
  claim(23,2,0)=23:claim(23,2,1)=4
  claim(23,4,0)=24:claim(23,4,1)=14
  claim(23,6,0)=22:claim(23,6,1)=23
  claim(23,7,0)=13:claim(23,7,1)=24
  claim(23,8,0)=4:claim(23,8,1)=23
  claim(23,10,0)=2:claim(23,10,1)=12

end sub

sub waitKey
  do while inkey$<>""
  loop
  do while inkey$=""
  loop
end sub




