option explicit

font 7

mode 1,16

const tileSize=80
const RNGseed=15
'239 is the width of the text window for scrolling info
const lineLen=239/mm.info(fontwidth)
const fontHeight=mm.info(fontheight)

dim debug as integer =0

dim gridX,gridY,tileNo as integer
dim originX,originY as integer
dim sx,sy,x,y,i,f,t as integer
dim roomOffset as integer

'32 different "room" types (0-31)
'each entry is a string of 25 chars, see separate encoding chart
dim room$(31)

'32 different item types (0-31)
'text descriptions of items and monsters 
'0-15 is an item, 16-31 is a monster 
dim item$(31,2)

const maxStack=200

'updateItem is an array of items that have been previously interacted with.
'every time a monster is killed, or an item is collected, the room tile on 
'which it occurred is added to this list. If a room tile is included in this
'list, and there is a monster on the tile, it means the monster is dead.
'if a room tile is included in this list, and there is an item on the tile,
'it means the item has already been collected.
dim updateItem(maxStack)
'itemPointer is the current position in the updateItem list
dim itemPointer as integer =0

'similar stack for doors that have been unlocked. If a tile number is showing
'on this list, it means that the doors of that room have been unlocked.
dim unlockedDoors(maxStack)
'doorsPointer is the current stack position in the unlockedDoors list
dim doorsPointer as integer =0

'PLAYER STATS
dim health as integer =5
dim maxHealth as integer =5
dim attack as integer =1
dim defence as integer =1
dim numKeys as integer =0
dim foodBandages as integer =0
dim magicMaps as integer =0
dim playerTile as integer
dim playerRoomX,playerRoomY as integer
dim carrying as integer

'tileVals() holds one in every 300 (skip) calculated tileVal RNG
'to speed up tile calcs in game
const storedVals=200
const skip=300
dim tileVals(storedVals) as integer
tileVals(0)=getTileVal(0)
for f=1 to storedVals
  tileVals(f)=getRelTile(skip,tileVals(f-1))
next f

dim prevTile as integer =999999
dim prevTileVal as integer
dim tileVal,reltile as integer
dim offsetX,offsetY as integer =0
dim playerX,playerY as integer =0
dim playerScreenX,playerScreenY
dim useLights=1
'max light dist is in pixels
dim maxLightDist=72
dim noDoors1,noDoors2,noDoors3 as integer
dim alreadyUnlocked1 as integer
dim alreadyUnlocked2 as integer
dim alreadyUnlocked3 as integer
dim unlockDoors as integer
dim processEncounter as integer =99


dim tileBin$
dim roomString$,roomStringE$,roomStringS$,roomStringN$,roomStringW$

'room code is 0-31 and is the top 5 bits of the 20-bit Lehmer tile code
dim roomCode
'item code is 0-31 and is the next 5 bits of the 20-bit Lehmer tile code
dim itemCode

'pre calc powers of 2 to speed up bin2dec routine in game
dim powerTwo(20)
for f=0 to 20
  powerTwo(f)=2^f
next f

'some colours
const solid=rgb(80,20,20)
const floor=rgb(128,128,128)
const wall=rgb(white)
const door=rgb(128,50,50)
const monster=rgb(255,0,0)
const itemCol=rgb(0,0,255)

'arrays to hold 11 different shades for lighting
dim solidColour(10) as integer
dim floorColour(10) as integer
dim wallColour(10) as integer
dim doorColour(10) as integer
dim monstColour(10) as integer
dim itemColour(10) as integer

'pre-calc inverse square lighting values to speed up lighting in game
for f=0 to 10
  solidColour(f)=getLitColour(solid,1-f/10)
  floorColour(f)=getLitColour(floor,1-f/10)
  wallColour(f)=getLitColour(wall,1-f/10)
  doorColour(f)=getLitColour(door,1-f/10)
  monstColour(f)=getLitColour(monster,1-f/10)
  itemColour(f)=getLitColour(itemCol,1-f/10)
next f

'labyrinth grid is drawn in the top left of the screen
originX=mm.hres/2-160
originY=mm.vres/2-50

'init room types
initRooms

'init item descriptions
initItems

drawWholeScreen

box 560,60,239,540,0,0,rgb(80,80,80)
scroll("You are in the deepdark - a creepy catacomb of chambers and winding passageways","")
scroll("How you came here, you know not. You carry a flickering torch that lights up the immediate area.","")
scroll("You are relieved to see that you have been armed with a sword and shield - let us hope you need not use it!","")
scroll("Explore the labyrinth, see what treasures you can find... and what perils await.","")
scroll("And maybe.. if you are very fortunate, you may even find the exit to this accursed place.","")
scroll("Cursor keys to move around. Unlock doors with 'U'. Use magic maps with 'M'.","")

'for f=0 to 15
'  scroll(str$(f),"")
'  scroll(item$(f,0),"")
'  scroll(item$(f,1),"")
'  scroll(item$(f,2),"")
'  scroll("--","")
'  waitkey
'next f

do

  'clamp x and y to not exceed 62,500 tile limit
  if offsetX<-125 then offsetX=-125
  if offsetX>125 then offsetX=125
  if offsetY<-125 then offsetY=-125
  if offsetY>125 then offsetY=125

  'get a keypress from the player

  i=getKey()

  'parse the keypress

  'player presses cursor left
  if i=130 then
    'is the way blocked to the west?
    if checkBlocked("W") then goto skip_moves:
    blankPlayer
    inc playerX,-1
    if playerX<-2 then 
      playerX=2
      inc offsetX,-1
      if not uselights then drawLeft
    endif
    if uselights then drawWholeScreen
  endif

  'player presses cursor right
  if i=131 then 
    'is the way blocked to the east?
    if checkBlocked("E") then goto skip_moves:
    blankPlayer
    inc playerX
    if playerX>2 then
      playerX=-2
      inc offsetX
      if not uselights then drawRight
    endif
    if uselights then drawWholeScreen
  endif

  if i=128 then
    if checkBlocked("N") then goto skip_moves:
    blankPlayer
    inc playerY,-1
    if playerY<-2 then 
      playerY=2
      inc offsetY,-1
      if not uselights then drawTop
    endif
    if uselights then drawWholeScreen
  endif

  if i=129 then
    if checkBlocked("S") then goto skip_moves:
    blankPlayer
    inc playerY
    if playerY>2 then
      playerY=-2
      inc offsetY
      if not uselights then drawBottom
    endif
    if uselights then drawWholeScreen
  endif

skip_moves:

  if i=asc("i") then
    carrying=0
    scroll("You are currently carrying:","")
    if numKeys=1 then scroll("a strange, small key.","") : carrying=1
    if numKeys>1 then scroll("% strange, small keys.",str$(numKeys)) : carrying=1
    if foodBandages=1 then scroll("A pack of food and bandages.",""): carrying=1
    if foodBandages>1 then scroll("% packs of food and bandages.",str$(foodBandages)) : carrying=1
    if magicMaps=1 then scroll("a magic map.","") : carrying=1
    if magicMaps>1 then scroll("% magic maps.",str$(magicMaps)) : carrying=1
    if carrying=0 then
      scroll("just your torch, sword and shield.")
    else 
      scroll("as well as your torch, sword and shield.")
    endif
  endif

  if i=asc("d") then debug = not debug

  if i=asc("u") then
    noDoors1=0
    noDoors2=0
    noDoors3=0
    alreadyUnlocked1=0
    alreadyUnlocked2=0
    alreadyUnlocked3=0
    unlockDoors=0
    if numKeys>0 then
      'check first to see if there are any doors in this room
      if doorsInRoom(roomString$) then
        'check first to see if the doors have been unlocked already
        if doorsAreUnlocked(playerTile) then
          alreadyUnlocked1=1
        else
          'doors are not unlocked - unlock them
          unlockedDoors(doorsPointer)=playerTile
          inc doorsPointer
          unlockDoors=1
        endif
      else
        'there are no doors in this room
        noDoors1=1
      endif
      'check to see if room to the E has a door to unlock
      if doorsInRoom(roomStringE$) and playerX=2 and playerY=0 then
        if doorsAreUnlocked(getTileNo(playerRoomX+1,playerRoomY)) then
          alreadyUnlocked2=1
        else
          unlockedDoors(doorsPointer)=getTileNo(playerRoomX+1,playerRoomY)
          inc doorsPointer
          unlockDoors=1
        endif
      else
        'there are no doors in room to the E
        noDoors2=1
      endif

      'check to see if room to the S has a door to unlock
      if doorsInRoom(roomStringS$) and playerY=2 and playerX=0 then
        if doorsAreUnlocked(getTileNo(playerRoomX,playerRoomY+1)) then
          alreadyUnlocked3=1
        else
          unlockedDoors(doorsPointer)=getTileNo(playerRoomX,playerRoomY+1)
          inc doorsPointer
          unlockDoors=1
        endif
      else 
        'there are no doors in room to the S
        noDoors3=1
      endif

    if noDoors1=1 and noDoors2=1 and noDoors3=1 then scroll("There are no doors to unlock. Perhaps best not to waste a key here.","")
    if alreadyUnlocked1=1 and alreadyUnlocked2=1 and alreadyUnlocked3=1 then
      scroll("The doors in this area are already unlocked.","")
    endif
    if unlockDoors=1 then 
      scroll("You unlock all the doors in this area. After unlocking them, the key crumbles into dust in your hand.","")
      inc numKeys,-1
    endif
    else
      'numkeys is not>0
      scroll("You don't have a key.")
    endif
skip_unlock_doors:
    drawWholeScreen
  endif 

'  if i=asc("=") then
'    inc maxLightDist,8
'    if maxLightDist>200 then maxLightDist=200
'    drawWholeScreen
'  endif

'  if i=asc("-") then
'    inc maxLightDist,-8
'    if maxLightDist<1 then maxLightDist=1
'    drawWholeScreen
'  endif

  'use magic map
  if i=asc("m") then
    if magicMaps<1 then scroll("You aren't carrying a map.","") : goto skip_map:
    uselights=0
    drawWholeScreen
    pause 2000
    uselights=1
    drawWholeScreen
  endif
skip_map:

  if rnd>.99 then 
    'flicker the torch
    inc maxLightDist,-4
    drawWholeScreen
    inc maxLightDist,4
    drawWholeScreen
  endif



  'if player has landed on an item/monster, process it:
  if processEncounter<>99 then
    'check if it's a monster
    if processEncounter>15 then
      'this is a monster - process battle!
      scroll(item$(processEncounter,1),"")
      scroll(item$(processEncounter,2),"")   
      processMonster(processEncounter)
    else
      'processEncounter<=15 - this is an item:
      scroll("You have found %",item$(processEncounter,1))
      scroll(item$(processEncounter,2),"")
      'mark this item as collected so it doesn't appear on the map
      updateItem(itemPointer)=playerTile : inc itemPointer
      processItemEffect(processEncounter)
    endif
  endif
  'encounter finished, reset procesEncounter back to dummy value
  processEncounter=99

  text 560,10,"Health: "+str$(health)+"/"+str$(maxHealth)+" | Atk:"+str$(attack)+" | Def:"+str$(defence)
  text 560,25,"Keys: "+str$(numKeys)+" | Food&Bandages: "+str$(foodBandages)
  text 560,40,"Magic maps: "+str$(magicMaps)
  page copy 0 to 1

loop

end

sub processItemEffect(itemNo)
  if item$(itemNo,0) ="small key" then inc numKeys : goto end_processItem:
  if item$(itemNo,0) ="torch fuel" then inc maxLightDist,8 : goto end_processItem:
  if item$(itemNo,0) ="health potion" then inc maxHealth : goto end_processItem:
  if item$(itemNo,0) ="food and bandages" then inc foodBandages : goto end_processItem:
  if item$(itemNo,0) ="shield reinforcement" then inc defence : goto end_processItem:
  if item$(itemNo,0) ="carborundum block" then inc attack : goto end_processItem:
  if item$(itemNo,0) ="magic map" then inc magicMaps : goto end_processItem:

end_processItem:
end sub

sub processMonster(monster)
  local itemDrop
  scroll("(battle goes here. Assume player wins for now.)","")
  scroll("You defeat the %! It mysteriously disintigrates into a pile of dust.",item$(monster,0))

  'add this monster to the list of the dead so it no longer appears on the map
  updateItem(itemPointer)=playerTile : inc itemPointer

  itemdrop=fix(rnd*16)
  scroll("Where it once was, you now see %.",item$(itemDrop,1))
  processItemEffect(itemDrop)
  

end_processMonster:
end sub

function doorsAreUnlocked(tile)
  doorsAreUnlocked=0
  for f=0 to doorsPointer
    if unlockedDoors(f)=tile then
      doorsAreUnlocked=1
      goto skip_are_doors_unlocked:
    endif
  next f
skip_are_doors_unlocked:
end function

function doorsInRoom(r$)
  'check to see if there are any doors in this roomstring
  local f,c$
  doorsinRoom=0
  for f=1 to 25
    c$=mid$(r$,f,1)
    if c$="5" or c$="6" or c$="7" or c$="8" or c$="J" or c$="K" or c$="L" or c$="M" then
      'door found
      doorsinRoom=1
      goto skip_door_check:  
    endif
  next f
skip_door_check:
end function

'send either "N", "E", "S" or "W" to this routine
'to see if the way is blocked in that direction
'accesses global vars roomstring$, roomStringS$ & roomStringE$
function checkBlocked(dir$)
  local checkString$,checkRow,checkCol,charPos,checkChar$,checkTile
  'start by assuming the way is not blocked
  checkBlocked=0
  'start by assuming the square to check is on this room tile
  checkString$=roomString$
  'start by assuming checkRow/checkCol are in line with player
  checkRow=playerY
  checkCol=playerX  
  checkTile=playerTile

  if dir$="S" then
    checkRow=playerY+1
    if playerY=2 then 
      checkString$=roomStringS$
      checkRow=-2
      checkTile=getTileNo(playerRoomX,playerRoomY+1)
    endif
  endif
  if dir$="E" then
    checkCol=playerX+1
    if playerX=2 then 
      checkString$=roomStringE$
      checkCol=-2
      checkTile=getTileNo(playerRoomX+1,playerRoomY)
    endif
  endif
  
  'work out which char in the roomstring to check (1-25)
  charPos=13+checkCol+checkRow*5
  checkchar$=mid$(checkString$,charPos,1)

  'ignore the monster tile specifiers
  if asc(checkChar$)>asc("D") then
    checkChar$=chr$(asc(checkChar$)-21)
  endif
  
  if dir$="N" or dir$="S" then
    if checkChar$="2" or checkChar$="4" or checkChar$="8" or checkChar$="9" or checkChar$="B" then 
      checkBlocked=1
    endif
    'door
    if checkChar$="5" or checkChar$="7" then
      'check for locked door on this room - set checkBlocked to 1 if locked
      checkBlocked=doorsLocked(checkTile)
      if checkBlocked=1 then scroll("You rattle the ancient door handle, but it remains closed fast. There is a strange key hole - if only you could find a key that fits...","")
    endif
  endif
  
  if (dir$="E" or dir$="W") then
    if checkChar$="3" or checkChar$="4" or checkChar$="7" or checkChar$="A" or checkChar$="B" then
      checkBlocked=1
    endif
    'door
    if checkChar$="6" or checkChar$="8" then
      'check for locked door on this room - set checkBlocked to 1 if locked
      checkBlocked=doorsLocked(checkTile)
      if checkBlocked=1 then scroll("You rattle the ancient door handle, but it remains closed fast. There is a strange key hole - if only you could find a key that fits...","")
    endif
  endif
end function

function doorsLocked(tile)
  local f
  doorsLocked=1
  for f=0 to doorsPointer
    if unlockedDoors(f)=tile then
    doorsLocked=0
    goto end_doors_locked:
  endif
  next f
end_doors_locked:
end function

'find a char position in the 25 char roomstring
'-2<=px<=+2  -  -2<=py<=+2
function getCharPos(px,py)
  getCharPos=13+px+py*5
end function

sub blankPlayer
  if uselights=0 then circle playerScreenX,playerScreenY,4,0,,0,floor
end sub

'NON-LIGHTING DRAWING ROUTINES

'blit the left 7 tiles one to the right
'and draw in the new left hand column
sub drawLeft
  local x,y
  blit 0,10,80,10,560,560
  box 0,10,80,560,0,0,solid
  x=-4+offsetX
  for y=-3+offsetY to 3+offsetY
    drawTile(x,y)
  next y
    
end sub

'blit the right 7 tiles one to the left
'and draw in the new right hand column
sub drawRight
  local x,y
  blit 80,10,0,10,560,560
  box 560,10,80,560,0,0,solid
  x=3+offsetX
  for y=-3+offsetY to 3+offsetY
    drawTile(x,y)
  next y
end sub

'blit the top 6 tiles one down
'and draw in the new top row
sub drawTop
  local x,y
  blit 0,10,0,90,640,480
  box 0,10,640,80,0,0,solid
  y=-3+offsetY
  for x=-4+offsetX to 3+offsetX
    drawTile(x,y)
  next x
end sub

'blit the bottom 6 tiles one row up
'and draw in the new bottom row
sub drawBottom
  local x,y
  blit 0,90,0,10,640,480
  box 0,490,640,80,0,0,solid
  y=3+offsetY
  for x=-4+offsetX to 3+offsetX
    drawtile(x,y)
  next x
end sub

sub drawWholeScreen

  timer=0
  'draw dungeon "solid" background
  if uselights then 
    page write 1
    box 0,10,560,560,0,0,0
  else
    box 0,10,560,560,0,0,solid 
  endif    

  'draw whole dungeon map
  '7 rooms visible top to bottom, 8 rooms visible left to right
  for y=-3+offsetY to 3+offsetY
    for x=-3+offsetX to 3+offsetX
      drawTile(x,y)
    next x
  next y

  'if using the lighting routine, scroll the screen
  'so the player is always dead centre of the labyrinth draw area
  if useLights then
    blit 0,0,playerX*-16,playerY*-16,450,450
    page copy 1 to 0
    page write 0
  endif

  'if the lighting routine is on, player is always dead centre of the map
  playerScreenX=originX+40+(playerX*16*not uselights)
  playerScreenY=originY+40+(playerY*16*not uselights)
  circle playerScreenX,playerScreenY,4,0,,0,rgb(yellow)



'  text 650,0,"redraw time="+str$(int(timer))+"ms",,,,rgb(green)
'  text 650,10,"Room tile X="+str$(offsetX)+" Y="+str$(offsetY)
'  text 650,30,"Torch Dist="+str$(maxLightDist)
'  text 650,40,"- / + to change"

  'debugging - print up the first 5 rooms in room stack
'  for f=0 to 5 : text 650,200+15*f,"room("+str$(f)+")="+str$(unlockedDoors(f)):next f
'  text 650,300,"pointer:"+str$(doorsPointer)
'  text 650,315,"in room:"+str$(playerTile)

end sub

'drawTile draws the room tile a given x,y values (centred on room grid origin 0,0)
'playerX and playerY are global vars (-2<=n<=+2) for player's position within the tile
'uses global vars offsetX and offsetY (to reposition area drawn onto screen)
sub drawTile(x,y)
  local lightDist, present,tileOffset,itemX,itemY

  'update the player's screen position
  playerScreenX=originX+40+playerX*16
  playerScreenY=originY+40+playerY*16

  'get the screen origin (top left) of this 5x5 tile
  sX=screenX(x) : sY=screenY(y)

  'if this tile is out of reach of the light, skip it
  if useLights then
    lightDist=getDist2Player(sX,sY)
    if lightDist>maxLightDist+70 then goto unlit_tile:
  endif

  'get the tile number of the room to be drawn from the (x,y) value
  tileNo=getTileNo(x,y)
  'calcRelTile takes tileNo and finds the quickest way to calc the
  'Lehmer RNG value and assigns values to global vars relTile and prevTileVal
  calcRelTile
  'calculate tile value using values calc'd in sub calcRelTile
  tileVal=getRelTile(relTile,prevTileVal)  

  'get 20-bit binary code of current Lehmer tile value
  tileBin$=bin$(tileVal,20)

  'get 5-bit room code (val 0-31) to determine which room to draw
  roomCode=getRoomCode(tileBin$)

  '99 is the dummy value to denote there is no item/monster in this tile
  itemCode=99
  'see if there is an item/monster in this room tile
  if getItemAppears(tileBin$) then 
    itemCode=getItemCode(tileBin$)
'   check to see if this item/monster has been looted/killed already 
    present=itemIsPresent(tileNo)
  endif

  'if we're drawing the tile the player is currently on, store roomstring in global va
  if x-offsetX=0 and y-offsetY=0 then
    roomString$=room$(roomCode)
    playerTile=tileNo
    playerRoomX=x
    playerRoomY=y

    'see if there's an item/monster on this roomtile:
    if present then
      itemX=getItemX(getItemPos(roomString$))
      itemY=getItemY(getItemPos(roomString$))
        'see if the player has landed on the item/monster square:
        if itemX=playerX and itemY=playerY then
          processEncounter=itemCode
        endif
        'end of if itemX,Y=playerX,Y
    endif
  endif

  'store the roomString of the tile to the east of the player in a global var
  'to speed up checking for blocking walls in movement routine
  if x-offSetX=1 and y-offSetY=0 then
    roomStringE$=room$(roomCode)
  endif

  'store the roomString of the tile to the south of the player in a global var
  'to speed up checking for blocking walls in movement routine
  if x-offsetX=0 and y-offsetY=1 then
    roomStringS$=room$(roomCode)
  endif

  'draw this room/tile to the screen
  drawRoom(sX,sY,roomCode,itemCode,present)

'  text sX,sY,str$(tileNo)

  'store this tile no and tile val in global vars to speed up Lehmer RNG calcs
  prevTile=tileNo
  prevTileVal=tileVal

unlit_tile:
end sub

function getItemPos(r$)
  'return a charPos 1-25 for the item/monster in the roomString supplied
  local f
  for f=1 to 25
    if asc(mid$(r$,f,1))>asc("D") then
      getItemPos=f
      goto skip_getItem:
    endif
  next f
  'no monster found - debug!
  text 650,180,"no item found!":waitkey:end
skip_getItem:  
end function

function getItemX(charPos)
  'return an X value (-2 <= x <= +2) from charPos 1-25
  getItemX=(charPos mod 5)-3
end function

function getItemY(charPos)
  'return a Y value (-2 <= y <= +2) from charPos 1-25
  getItemY=(int(charPos/5))-2
end function

'this sub uses global vars: relTile, prevTileVal, tileNo, skip, tileVals()
'assigns values to global vars: relTile,prevTileVal
sub calcRelTile
  local tileOffset
  'if previously drawn tile is nearer than nearest pre-calc'd value
  'in the tileVals() array:
  tileOffset=tileNo-prevTile
  if tileOffset>0 and tileOffset<(tileNo mod skip) then
    relTile=tileNo-prevTile
    goto calc_tileVal:
  endif

  'pre-calculated tile value from the tileVals() array  
  if tileNo>skip then 
    t=int(tileNo/skip)
    prevtile=t*skip
    prevTileVal=tileVals(t)
    relTile=tileNo-prevTile
    goto calc_tileVal:
  endif

  'if both above fail, calculate tile value from origin
  relTile=tileNo
  prevTileVal=tileVals(0)

calc_tileVal:
end sub

'scan through the updateItem array to see if this room number
'is included in the list, if it is - set itemIsPresent to 0
'updateItem() is a global stack array holding a list of room numbers
'itemPointer is a global var holding the current length of the updateItem stack array
function itemIsPresent(tile)
  local f
  itemIsPresent=1
  for f=0 to itemPointer
    if updateItem(f)=tile then 
      itemIsPresent=0
      goto end_item_present:
    endif
  next f
end_item_present:
end function

'draw a room tile
'supply the x position and y position in the room grid
'supply the room code of the room to be drawn
'supply the item code for this room's item(/monster)
'supply if the item is present (and therefore to be drawn) in this room
sub drawRoom(posX,posY,code,item,present)
  local char$,temp$
  local monsterPres
  local x,y,subtile,wallThick,doorSize,doorWall
  local localX,localY,lightDist,light
  local litWallColour,litFloorColour,litDoorColour,litSolidcolour
  subTile=16
  wallThick=2
  doorSize=6
  doorWall=6

  for y=0 to 4
    localY=posY+y*subTile
    for x=0 to 4
      localX=posX+x*subTile
      char$=mid$(room$(code),y*5+x+1,1)

      'assign unlit colours by default
      litFloorColour=floor
      litWallColour=wall
      litDoorColour=door

      if useLights then
        'get distance of this square to the player (light source)
        lightDist=getDist2Player(localX,localY)

        if lightDist>maxLightDist then goto dont_draw:

        light=lightDist/maxLightDist*10

        'assign falloff colours from pre-calc'd arrays
        litWallColour=wallColour(light)
        litFloorColour=floorColour(light)
        litDoorColour=doorColour(light)
        litSolidColour=solidColour(light)
        'solid
        box localX,localY,subTile,subTile,0,0,litSolidColour
      endif

      monsterPres=0
      'check to see if we're drawing the square with the item/monster in it
      if asc(char$)>asc("D") then
        char$=chr$(asc(char$)-21)
        monsterPres=1
      endif

      'floor
      if char$<>"9" and char$<>"A" and char$<>"B" and char$<>"C" and char$<>"D" then
        box localX,localY,subtile,subTile,0,0,litFloorColour      
      endif
      
      'corner wall piece
      if char$="1" or char$="D" then
        box localX,localY,wallThick,wallThick,0,0,litWallColour
      endif

      'top wall
      if char$="2" or char$="9" or char$="4" or char$="8" or char$="B" then
        box localX,localY,subTile,wallThick,0,0,litWallColour
      endif

      'left wall
      'TO DO: if this square is on the left hand column, and the square immediately to the left
      'is a "9" or "A" or "B" or "C" or "D" then DONT DRAW IT
      if char$="3" or char$="4" or char$="7" or char$="A" or char$="B" then
        box localX,localY,wallThick,subTile,0,0,litWallColour
      endif

      'top door
      if char$="5" or char$="7" then
        box localX,localY,doorWall,wallThick,0,0,litWallColour
        box localX+doorWall,localY,doorSize,1,0,0,litDoorColour
        box localX+doorWall+doorSize,localY,doorWall,wallThick,0,0,litWallColour
      endif

      'left door
      if char$="6" or char$="8" then
        box localX,localY,wallThick,doorWall,0,0,litWallColour
        box localX,localY+doorWall,1,doorSize,0,0,litDoorColour
        box localX,localY+doorWall+doorSize,wallThick,doorWall,0,0,litWallColour
      endif

      if monsterPres and present then 
        'draw the item/monster
        if item<16 then 
          'item is an item - draw blue blob
          circle localX+8,localY+8,4,0,,0,itemColour(light)
        else
          'item is a monster - draw red blob
          circle localX+8,localY+8,4,0,,0,monstColour(light)
        endif
      endif

dont_draw:

 
    next x
  next y

end sub

'used to pre-calculate lit colours
'supply scaling value 'amount' as a value between 0 and 1
'0=completely dark ; 1=maximum brightness
function getLitColour(inputColour,amount)
  local red,green,blue, binary$

  'get a binary string of the 24-bit input colour
  binary$=bin$(inputColour,24)

  'bin$() adds an extra 4 0s on the front of the bit string - strip them off:
  binary$=mid$(binary$,5,24)

  'split the input colour into RGB (8 bits, 8 bits, 8 bits)
  red=bin2dec(mid$(binary$,1,8))
  green=bin2dec(mid$(binary$,9,8))
  blue=bin2dec(mid$(binary$,17,8))

  red=red*amount'*amount    'linear light falloff means a smaller view radius = faster redraw
  blue=blue*amount'*amount
  green=green*amount'*amount

  getLitColour=rgb(red,green,blue)  
end function

'how far away from the player (light source) is the currently drawn square?
'supply the required x,y location as screen pixel values
function getDist2Player(x,y)
  local relX,relY
  relX=x-playerScreenX+8
  relY=y-playerScreenY+4
  getDist2Player=sqr(relX*relX+relY*relY)
end function

function getRoomCode(b$)
  'b$ is the tile val, 20-bit binary number
  'room code is first 5 bits of the tile val
  getRoomCode=bin2dec(mid$(b$,1,5))
end function

function getItemAppears(b$)
  'b$ is the tile val, 20-bit number
  'if the last 6 bits of the tile val (0-63)
  'is less than appears (set locally), that room's item appears.
  local appears = 15
  getItemAppears=0
  if bin2dec(mid$(b$,15,6))<appears then getItemAppears=1
end function  

function getItemCode(b$)
  getItemCode=bin2dec(mid$(b$,6,5))
end function  

function bin2dec(b$)
'get the decimal number from a binary number in string format
  local f,tot
  local strlen
  strlen=len(b$)
  for f=0 to strlen-1
    'powerTwo(l) is an array of pre-calculated values of powers of 2: powerTwo(2)=4 etc
    if mid$(b$,strlen-f,1)="1" then tot=tot+powerTwo(f)
  next f
  bin2dec=tot
end function

'these functions convert a grid x, y into a screen pixel position
function screenX(x)
  screenX=originX+tileSize*(x-offsetX)
end function

function screenY(y)
  screenY=originY+tileSize*(y-offsetY)
end function

function getLayerStart(n)
'this fn returns the start tile number of the layer number supplied
  if n=0 then getLayerStart=0 : goto skip_layer:
  local rootLayerStart
  rootLayerStart=2*(n-1)+1
  getLayerStart=rootLayerStart*rootLayerStart
skip_layer:
end function

function getTileNo(x,y)
'this fn returns the tile (room) no for given x and y values
  'n is the layer number
  local n=abs(x)
  local layerStart
  if abs(y)>abs(x) then n=abs(y)
  layerStart=getLayerStart(n)
  if y=-n then getTileNo=layerStart+x+n : goto skip_tile:
  if x=n then getTileNo=layerStart+n*2+y+n : goto skip_tile:
  if y=n then getTileNo=layerStart+n*4-x+n : goto skip_tile:
  getTileNo=layerStart+n*6-y+n  
skip_tile:
end function

function getTileVal(tileNo)
'this sub returns a Lehmer generated RNG for an absolute tile no.
  local f, rand
  rand=RNGseed
  for f=0 to tileNo
    rand=nextRand(rand)
  next f
  getTileVal=rand
end function

function getRelTile(incTile,currentTileVal)
'this function returns a Lehmer generated RNG for a relative tile increment
  local f
  for f=1 to incTile
    currentTileVal=nextRand(currentTileVal)
  next f
  getRelTile=currentTileVal
end function

function nextRand(value)
'this function returns a procedural RND in the range 1-1048261 (largest prime under 20 bits)
  nextRand=value*9901 mod 1048261
end function

sub getXY(tileNo)
'this sub assigns values to the global vars gridX and gridY depending on supplied tile no.
  'n is the layer number
  local n
  local layerStart,layerOffset as integer
  n=fix((1+sqr(tileNo))/2)
  layerStart=getLayerstart(layer)
  layerOffset=tileNo-layerStart

  if layerOffset<n*2 then
    gridX=originX+(layerOffset-n)*tileSize
    gridY=originY-n*tileSize
    goto skip_xy:
  endif
  if layerOffset<n*4 then
    layerOffset=layerOffset-n*2
    gridX=originX+n*tileSize
    gridY=originY+(layerOffset-n)*tileSize
    goto skip_xy:
  endif
  if layerOffset<n*6 then
    layerOffset=layerOffset-n*4
    gridX=originX+(n-layerOffset)*tileSize
    gridY=originY+n*tileSize
    goto skip_xy:
  layerOffset=layerOffset-n*6
  gridX=originX-n*tileSize
  gridY=originY-(n-layerOffset)*tileSize
skip_xy:
end sub

function getKey()
'see if the user is pressing a key
  getKey=keydown(1)
end function

sub waitkey
'pause the execution until user presses 
'and lets go of a key (mainly for debugging!)
  do 
  loop while inkey$<>""
'  text 650,580,"PRESS ENTER",,,,rgb(white),rgb(red)
  do 
  loop while inkey$=""
end sub

sub initRooms
  local i$
  for f=0 to 31
    read i$
    room$(f)=i$
  next f
  
  'room layout datastrings - must be 32 in total (codes 0-31)

  'one single large 5x5 room
  data "I212230000100003000030000"
  '3 rooms
  data "421423003052G603003030030"
  'crossroads with door
  data "B93B9AC3AC2G122B97B9AC3AC"
  data "B93B9AC3AC2G122B97B9AC3AC"
  'corner to corner corridors
  data "I21B93B9DC1A422BD3B9AC3AC"
  data "I21B93B9DC1A422BD3B9AC3AC"
  'boss room
  data "421223452316E063300332521"
  'jail cells
  data "44344333335515577377333H3"
  'vertical passage
  data "B93B9AC3ACACHA4AC3A9AC3AC"
  data "B93B9AC3ACACHA4AC3A9AC3AC"
  data "B93B9AC3ACACHA4AC3A9AC3AC"
  'vertical passage with joining passages
  data "426B9HB3AC1A382BD3B9AC3AC"
  'horizontal passage
  data "B9999ACCCC22G22B9999AC4AC"
  data "B9999ACCCC22G22B9999AC4AC"
  data "B9999ACCCC22G22B9999AC4AC"
  'horizontal passage with joining passages
  data "B9322AC99322225B9LB9AC3AC"
  'mazey passages with 2x2 in centre
  data "421423426316E334221232240"
  'corner to corner corridors with 1x1 room in middle
  data "B93B9AC32A22M62B32B9A93AC"
  '4X3 room with antechambers
  data "4254B3003A6003830E7B7221A"
  't-junction going down
  data "B9999ACCCC22222B9LB9AC3AC"
  'columns room
  data "421223111111F113111131111"
  't-junction to right
  data "B93B9AC3ACAC3G2AC3B9AC3AC"
  'circle room
  data "B412B41B321BD933GA41B321B"
'----23 TO HERE
  'small square room with solid corners
  data "B93B9A412A21E02B300BA93BD"
  'snake labyrinth 1
  data "42142343331333333H3230220"
  'snake labyrinth 2
  data "421423221322223I221332221"
  'snake labyrinth 3
  data "423423331313I214132232220"
  'two square rooms off vertical corridor
  data "B97B9AC342826603E3B9B93AC"
  'two square rooms off crossroads
  data "I23423033052152B93B9AC3AC"
'---29 TO HERE

  'snake labyrinth 4
  data "42142H2233221334221B322BD"
  'snake labyrinth 5
  data "B9322A42212H2243423331331"
  'circle room
  data "B412B41B321BD933GA41B321B"

end sub

sub scroll(t$,insert$)
  if t$="" goto skip_scrollprint:
  local f
  local ch$,word$,st1$,st2$
  local cursorX=0
  local position
  'put the inserted word in, if there is one
  if insert$<>"" then
    position=instr(t$,"%")
    st1$=left$(t$,position-1)
    st2$=right$(t$,len(t$)-position)
    t$=st1$+insert$+st2$ 
  endif

  scrollLine
  
  f=1

scanString:

  if debug=1 then 
    text 560,60,"len t$="+str$(len(t$))+";f="+str$(f) : waitkey
  endif

  ch$=mid$(t$,f,1)
  'read in a full word from t$
  do while ch$<>" "
    word$=word$+ch$
    if f=len(t$) then goto break_readword:
    f=f+1
    ch$=mid$(t$,f,1)
  loop

break_readword:
  if cursorX+len(word$)>lineLen then scrollLine : cursorX=0
  text 561+cursorX*mm.info(fontwidth),597-fontheight-fontheight,word$,,,,rgb(50,0,0),-1
  cursorX=cursorX+len(word$)+1
  word$=""
  f=f+1
  if f<len(t$) then goto scanString:

  scrollLine

  page copy 0 to 1

skip_scrollprint:
end sub

sub scrollLine
  'scroll all the text up, blanking the top line
  blit 561,61+fontheight,561,61,237,559+fontheight
end sub

sub initItems
  local f,t$,l$,l2$
  for f=0 to 31 : read t$,l$,l2$ : item$(f,0)=t$ : item$(f,1)=l$ :item$(f,2)=l2$: next f
end sub
  'item/monster descriptions
  'items 0-15 are items
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
  data ""
'
  data "torch fuel"
  data "some torch fuel! You pour it onto your torch, making it shine a little brighter - now you can see a little further into the gloom!"
  data ""
' 
  data "health potion"
  data "a potion of fortification! You gulp it down gladly, and it permanently increases your maximum health!"
  data ""
'
  data "food and bandages"
  data "some food and bandages. You store them safely in your backpack. If you are injured, you can use them to restore 5 health points."
  data ""
'
  data "shield reinforcement"
  data "some reinforcement bands for your shield. You fix them in place, increasing your defence value permanently!"
  data ""
'
  data "carborundum block"
  data "a carborundum sharpening block. You give your sword a good polish with it, making the edge keener. Your attack value is increased permanently!"
  data ""
' 
  data "magic map"
  data "a magic map. You store it safely in your backpack. When you use it, it temporarily shows all the chambers, monsters and items nearby. When used, it lasts only seconds before disappearing forever."
  data ""
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
  data ""
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
  data ""
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
  data ""
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
  data ""
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
  data ""
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
  data ""
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
  data ""
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
  data ""
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
  data ""

  'items 16-31 are monsters
  data "sand snake"
  data "A large, sandy coloured snake is curled up in the passageway here, its head raised and scanning the area."
  data "As you approach, it bares two long, curved fangs and lunges at you hissing angrily!"
'
  data "rock goblin"
  data "At first glance, this creature appears to be a pile of rocks piled up against the wall. But as you approach, it looks up at you, and its gnarled and cratered face screws up into an angry grimace."
  data "Baring teeth of pure black obsidian, it clambers to its feet and charges at you with a gutteral, scraping cry."
'
  data "green slime"
  data "A patch of shiny green slime is hanging over the walls here. It seems almost alive as it oozes slowly around."
  data "As you warily move closer, it flings a glob of toxic ichor straight at you!"
'
  data "giant cockroach"
  data "You hear a scuttling, hammering sound, like iron rods being being banged against the ground. As you approach, a cockroach comes into view."
  data "But this is no ordinary cockroach - it has grown huge in the deep dark, and is now the size of a large dog. From under its thick, shiny carapace, it claws at you with mandibles the size of kitchen knives."
'
  data "gelatinous glob"
  data "Looking ahead, you don't see anything out of the ordinary - except maybe a vague misty haze."
  data "Only when you are almost upon it do you see that there is a giant, gelatinous glob filling the entire passageway. It oozes towards you, trying to envelop you in its suffocating jelly, where it will digest you."
' 
  data "dust zombie"
  data "You hear a faint, scuffing, shuffling sound, accompanied by a gasping moan that chills your blood."
  data "A creature, seemingly made entirely of dust, lurches and stumbles towards you out of the dark. Once human, its now hollow carcass sheds disease ridden flakes as grasping fingers flail towards you."
'
  data "mummified torso"
  data "You hear a strange scraping, dragging sound in the distance. As you approach, you see a horrific headless, legless torso dragging itself along the ground by its fingers, flesh rotting and grey."
  data "Scraps of decaying linen hang from its shoulders and chest. Despite having no eyes, it seems to sense your presence, and scrambles itself alarmingly towards you, reaching for you with claw-like, bony fingers."
'
  data "floating skull"
  data "You see a mysterious, fleshless human skull floating in the dark in the passageway ahead. Its grinning, empty face turns round slowly and regards you curiously for a moment as it begins to drift towards you."
  data "Then, it suddenly flies at you, its jaw champing and biting furiously with a sharp clacking sound!"
'
  data "giant worm"
  data "You hear a disgusting squelching, oozing sound coming from the darkness in the passageway ahead. As you approach, you see a huge, bloated worm-like creature slithering towards you."
  data "Its veins and organs pulsate through its semi-translucent skin as it launches itself towards you, lashing with its fat, writhing body."
'
  data "beetle swarm"
  data "You hear a low, rumbling, buzzing sound coming from the darkness in the passageway ahead. As you approach, you see a cloud of iridescent black scarab beetles, each as big as your hand, filling the entire passageway."
  data "The buzzing gets louder as the swarm starts to drift towards you, their glossy carapaces glinting in the torchlight. Countless snapping mandibles close in on your face."
'
  data "flesh monstrosity"
  data "A monstrous, greyish-tan coloured creature stands naked in the passageway on two bloated stumps for legs. Four sinewy arms hang at its sides, terminated by vile, rotting flaps of skin where its hands should be."
  data "It seems to be breathing, as folds of flesh roll and slide over each other, its head and body merged into one shapeless, fleshy blob. Suddenly, it lunges at you, flailing its horrific limbs wildly!"
'
  data "","",""
'
  data "","",""
'
  data "","",""
'
  data "","",""
'
  data "","",""
'
  data "","",""
