option explicit

const textWindowBG=rgb(80,80,80)

mode 8,12,textWindowBG

font 7

const tileSize=80
const RNGseed=15
'239 is the width of the text window for scrolling info
const lineLen=239/mm.info(fontwidth)
const fontHeight=mm.info(fontheight)

dim debug as integer =0

dim gridX,gridY,tileNo as integer
dim originX,originY as integer
dim sx,sy,x,y,i,f,t as integer
dim roomOffset as integer

'32 different "room" types (0-31)
'each entry is a string of 25 chars, see separate encoding chart
dim room$(31)

'32 different item types (0-31)
'text descriptions of items and monsters 
'0-15 is an item, 16-31 is a monster 
dim item$(15,1)

initItems

'need to know the total number of different monsters of any given level to choose one
'monstTot(0) is the number of different level 0 monsters
'monstTot(1) is the number of different level 1 monsters
'...etc etc...
dim monstTot(9)

'monstName$(0,0,0) is the monster name for the first level 0 monster
'monstName$(0,0,1) is monster description 1, monstName(0,0,2) is monst descript 2
'monstName$(0,1,0) is the monster name for the second level 0 monster
'monstName$(1,0,0) is the monster name for the first level 1 monster...etc etc...
'maximum of 10 different monsters (0-9) on each of 10 different levels (0-9)
dim monstName$(9,9,2)

initMonsters

'levelStepUp is how far from the origin the player must move before encountering
'monsters of the next level up
const levelStepUp = 10

'maxStack is used on updateItem() and unlockedDoors()
const maxStack=200

'updateItem is an array of items that have been previously interacted with.
'every time a monster is killed, or an item is collected, the room tile on 
'which it occurred is added to this list. If a room tile is included in this
'list, and there is a monster on the tile, it means the monster is dead.
'if a room tile is included in this list, and there is an item on the tile,
'it means the item has already been collected.
dim updateItem(maxStack)
'itemPointer is the current position in the updateItem list
dim itemPointer as integer =0

'similar stack for doors that have been unlocked. If a tile number is showing
'on this list, it means that the doors of that room have been unlocked.
dim unlockedDoors(maxStack)
'doorsPointer is the current stack position in the unlockedDoors list
dim doorsPointer as integer =0

'PLAYER STATS
dim health as integer =5
dim maxHealth as integer =5
dim attack as integer =1
dim defence as integer =1
dim numKeys as integer =0
dim foodBandages as integer =0
dim magicMaps as integer =0
dim playerTile as integer
dim playerRoomX,playerRoomY as integer
dim carrying as integer
dim playerOnInterlevel as integer =0
dim interlevelTimer as integer =0

'tileVals() holds one in every 300 (skip) calculated tileVal RNG
'to speed up tile calcs in game
const storedVals=200
const skip=300
dim tileVals(storedVals) as integer
tileVals(0)=getTileVal(0)
for f=1 to storedVals
  tileVals(f)=getRelTile(skip,tileVals(f-1))
next f

dim prevTile as integer =999999
dim prevTileVal as integer
dim tileVal,reltile as integer
dim offsetX,offsetY as integer =0
dim prevOffsetX,prevOffsetY as integer =0
dim playerX,playerY as integer =0

'ppx and ppy are past player x and past player y for backtracking
dim ppx(5),ppy(5)
dim playerScreenX,playerScreenY

dim useLights=1

'max light dist is in pixels
dim maxLightDist=72

dim noDoors1,noDoors2,noDoors3 as integer
dim alreadyUnlocked1 as integer
dim alreadyUnlocked2 as integer
dim alreadyUnlocked3 as integer
dim unlockDoors as integer
dim processEncounter as integer =99


dim tileBin$
dim roomString$,roomStringE$,roomStringS$,roomStringN$,roomStringW$

'room code is 0-31 and is the top 5 bits of the 20-bit Lehmer tile code
dim roomCode
'item code is 0-31 and is the next 5 bits of the 20-bit Lehmer tile code
dim itemCode

'pre calc powers of 2 to speed up bin2dec routine in game
dim powerTwo(20)
for f=0 to 20
  powerTwo(f)=2^f
next f

'some colours
const solid=rgb(80,20,20)
const floor=rgb(128,128,128)
const wall=rgb(white)
const door=rgb(128,50,50)
const monster=rgb(255,0,0)
const itemCol=rgb(0,0,255)

'arrays to hold 11 different shades for lighting
'dim solidColour(10) as integer
'dim floorColour(10) as integer
'dim wallColour(10) as integer
'dim doorColour(10) as integer
'dim monstColour(10) as integer
'dim itemColour(10) as integer

'pre-calc inverse square lighting values to speed up lighting in game
'for f=0 to 10
'  solidColour(f)=getLitColour(solid,1-f/10)
'  floorColour(f)=getLitColour(floor,1-f/10)
'  wallColour(f)=getLitColour(wall,1-f/10)
'  doorColour(f)=getLitColour(door,1-f/10)
'  monstColour(f)=getLitColour(monster,1-f/10)
'  itemColour(f)=getLitColour(itemCol,1-f/10)
'next f

'labyrinth grid is drawn in the top left of the screen
originX=mm.hres/2-160
originY=mm.vres/2-30

'init room types
initRooms

'load the tilesheet onto hidden page 3
'need to re-do tilesheet at 640x480
'page write 3
'load png "tilesheet.png"
'page write 0

redrawShadow(15)
drawWholeScreen

scroll("You are in the deepdark - a creepy catacomb of chambers and winding passageways")
scroll("How you came here, you know not. You hold aloft a flickering torch, illuminating a strange columned chamber with exits leading out all round.")
scroll("You are relieved to see that you have been armed with a sword and shield - let us hope you need not use it!")
scroll("Explore the labyrinth, learn where its secrets lie hidden and see what treasures you can find... and what perils await.")
scroll("And maybe, if you are very fortunate, you could even find the way out of this accursed place.")
scroll("Cursor keys to move around, and 'U' to unlock doors.")

do

  'clamp x and y to not exceed 62,500 tile limit
  if offsetX<-125 then offsetX=-125
  if offsetX>125 then offsetX=125
  if offsetY<-125 then offsetY=-125
  if offsetY>125 then offsetY=125

  'get a keypress from the player

  i=getKey()

  'parse the keypress

  'player presses cursor left
  if i=130 then
    'is the way blocked to the west?
    if checkBlocked("W") then goto skip_moves:
    'backtracking
    ppx(5)=ppx(4):ppx(4)=ppx(3):ppx(3)=ppx(2):ppx(2)=ppx(1):ppx(1)=ppx(0)
    ppx(0)=playerX
    ppy(5)=ppy(4):ppy(4)=ppy(3):ppy(3)=ppy(2):ppy(2)=ppy(1):ppy(1)=ppy(0)
    ppy(0)=playerY

    footstep

    inc playerX,-1
    if playerX<-2 then
      playerX=2
      'backtracking
'      prevOffsetX=offsetX      
'      prevOffsetY=offsetY

      inc offsetX,-1
    endif
    drawWholeScreen
  endif

  'player presses cursor right
  if i=131 then 
    'is the way blocked to the east?
    if checkBlocked("E") then goto skip_moves:
    'backtracking
    ppx(5)=ppx(4):ppx(4)=ppx(3):ppx(3)=ppx(2):ppx(2)=ppx(1):ppx(1)=ppx(0)
    ppx(0)=playerX
    ppy(5)=ppy(4):ppy(4)=ppy(3):ppy(3)=ppy(2):ppy(2)=ppy(1):ppy(1)=ppy(0)
    ppy(0)=playerY

    footstep

    inc playerX
    if playerX>2 then
      playerX=-2
      'backtracking
 '     prevOffsetX=offsetX      
'      prevOffsetY=offsetY

      inc offsetX
    endif
    drawWholeScreen
  endif

  if i=128 then
    if checkBlocked("N") then goto skip_moves:
    'backtracking
    ppy(5)=ppy(4):ppy(4)=ppy(3):ppy(3)=ppy(2):ppy(2)=ppy(1):ppy(1)=ppy(0)
    ppy(0)=playerY
    ppx(5)=ppx(4):ppx(4)=ppx(3):ppx(3)=ppx(2):ppx(2)=ppx(1):ppx(1)=ppx(0)
    ppx(0)=playerX

    footstep

    inc playerY,-1
    if playerY<-2 then 
      playerY=2
      'backtracking
'      prevOffsetX=offsetX      
 '     prevOffsetY=offsetY

      inc offsetY,-1
    endif
    drawWholeScreen
  endif

  if i=129 then
    if checkBlocked("S") then goto skip_moves:
    'backtracking
    ppy(5)=ppy(4):ppy(4)=ppy(3):ppy(3)=ppy(2):ppy(2)=ppy(1):ppy(1)=ppy(0)
    ppy(0)=playerY
    ppx(5)=ppx(4):ppx(4)=ppx(3):ppx(3)=ppx(2):ppx(2)=ppx(1):ppx(1)=ppx(0)
    ppx(0)=playerX

    footstep

    inc playerY
    if playerY>2 then
      playerY=-2
      'backtracking
'      prevOffsetX=offsetX      
 '     prevOffsetY=offsetY

      inc offsetY
    endif
    drawWholeScreen
  endif

skip_moves:


  if isInterlevel(playerRoomX,playerRoomY) and timer>interlevelTimer+20000 and (playerRoomx<>0 and playerRoomy<>0) then 
    scroll("You are in a passage of strange columned chambers that reaches out of sight in both directions. This marks out the end of the previous level and the start of the next.")
    scroll("Beware for if you pass beyond this chambered passage, you will meet more powerful and sinister monsters!")
    interlevelTimer=timer
  endif

  'display player inventory
  if i=asc("i") then
    carrying=0
    scroll("You are currently carrying:","")
    if numKeys=1 then scroll("a strange, small key.","") : carrying=1
    if numKeys>1 then scroll("% strange, small keys.",str$(numKeys)) : carrying=1
    if foodBandages=1 then scroll("A pack of food and bandages.",""): carrying=1
    if foodBandages>1 then scroll("% packs of food and bandages.",str$(foodBandages)) : carrying=1
    if magicMaps=1 then scroll("a magic map.","") : carrying=1
    if magicMaps>1 then scroll("% magic maps.",str$(magicMaps)) : carrying=1
    if carrying=0 then
      scroll("just your torch, sword and shield.")
    else 
      scroll("as well as your torch, sword and shield.")
    endif
  endif

  'debugging tools
  if i=asc("d") then debug = not debug
  if i=asc(",") then useLights=0 : drawWholeScreen: removeShadow 
  if i=asc(".") then useLights=1 : drawWholeScreen: redrawShadow(15)
  if i=asc("x") then inc numKeys
  if i=asc("s") then removeShadow
  if i=asc("n") then inc magicMaps

  'unlock doors
  if i=asc("u") then
    noDoors1=0
    noDoors2=0
    noDoors3=0
    alreadyUnlocked1=0
    alreadyUnlocked2=0
    alreadyUnlocked3=0
    unlockDoors=0
    if numKeys>0 then
      'check first to see if there are any doors in this room
      if doorsInRoom(roomString$) then
        'check first to see if the doors have been unlocked already
        if doorsAreUnlocked(playerTile) then
          alreadyUnlocked1=1
        else
          'doors are not unlocked - unlock them
          unlockedDoors(doorsPointer)=playerTile
          inc doorsPointer
          unlockDoors=1
        endif
      else
        'there are no doors in this room
        noDoors1=1
      endif
      'check to see if room to the E has a door to unlock
      if doorsInRoom(roomStringE$) and playerX=2 and playerY=0 then
        if doorsAreUnlocked(getTileNo(playerRoomX+1,playerRoomY)) then
          alreadyUnlocked2=1
        else
          unlockedDoors(doorsPointer)=getTileNo(playerRoomX+1,playerRoomY)
          inc doorsPointer
          unlockDoors=1
        endif
      else
        'there are no doors in room to the E
        noDoors2=1
      endif

      'check to see if room to the S has a door to unlock
      if doorsInRoom(roomStringS$) and playerY=2 and playerX=0 then
        if doorsAreUnlocked(getTileNo(playerRoomX,playerRoomY+1)) then
          alreadyUnlocked3=1
        else
          unlockedDoors(doorsPointer)=getTileNo(playerRoomX,playerRoomY+1)
          inc doorsPointer
          unlockDoors=1
        endif
      else 
        'there are no doors in room to the S
        noDoors3=1
      endif

      if noDoors1=1 and noDoors2=1 and noDoors3=1 then scroll("There are no doors to unlock. Perhaps best not to waste a key here.","")
      if alreadyUnlocked1=1 and alreadyUnlocked2=1 and alreadyUnlocked3=1 then
        scroll("The doors in this area are already unlocked.","")
      endif
      if unlockDoors=1 then 
        play stop
        play mp3 "unlock.mp3"
        scroll("You unlock all the doors in this area. After unlocking them, the key crumbles into dust in your hand.","")
        inc numKeys,-1
      endif

    else
      'numkeys is not>0
      scroll("You don't have a key.")
    endif

skip_unlock_doors:

    drawWholeScreen
  endif 

'  if i=asc("=") then
'    inc maxLightDist,8
'    if maxLightDist>200 then maxLightDist=200
'    drawWholeScreen
'  endif

'  if i=asc("-") then
'    inc maxLightDist,-8
'    if maxLightDist<1 then maxLightDist=1
'    drawWholeScreen
'  endif

  'use magic map
  if i=asc("m") then
    if magicMaps<1 then 
      scroll("You aren't carrying a map.","")
    else
      uselights=0
      drawWholeScreen
      removeShadow
      timer=0
      do
        if inkey$<>"" then timer=5000 
      loop while timer<5000
      uselights=1
      for f=0 to 15 : redrawShadow(f) : pause 80 : next f
      drawWholeScreen
      inc magicMaps,-1
      scroll("The map shone briefly for but a fleeting moment. It soon fades and crumbles to dust in your fingers.")
    endif
  endif

  'use food&bandages
  if i=asc("f") then
    if foodBandages<1 then 
      scroll("You don't have any food and bandages.")
    else
      scroll("You sit down and take some food and bandages out of your backpack. After eating the food and applying the bandages, you feel a lot better.")
      inc foodBandages,-1
      inc health,5
      if health>maxHealth then health=maxHealth
    endif
  endif
    

  if rnd>.995 and uselights=1 then 
    'flicker the torch
    inc maxLightDist,-4
    redrawShadow(15)
    inc maxLightDist,4
    redrawShadow(15)
  endif


  'if player has landed on an item/monster, process it:
  'processEncounter is set in drawRoom()
  if processEncounter<>99 then
    'check if it's a monster
    if processEncounter>15 then
      'this is a monster - process battle!
      processBattle(processEncounter)
    else
      'processEncounter<=15 - this is an item:
      play stop
      play mp3 "item.mp3"
      scroll("You have found %",item$(processEncounter,1))
      'mark this item as collected so it doesn't appear on the map
      updateItem(itemPointer)=playerTile : inc itemPointer
      processItemEffect(processEncounter)
    endif
  endif
  'encounter finished, reset procesEncounter back to dummy value
  processEncounter=99

  updateStats

loop

end

sub updateStats
  text 10,10,"Health: "+str$(health)+"/"+str$(maxHealth)+"  |  Atk:"+str$(attack)+"  |  Def:"+str$(defence)+"  |  Keys: "+str$(numKeys)+"  |  Food&Bandages: "+str$(foodBandages)+"  |  Magic maps: "+str$(magicMaps)
  text 10,20,"You are on labyrinth difficultly level "+str$(getLevel(playerRoomX,playerRoomY))
'  text 10,20,"X="+str$(offsetX)+" Y="+str$(offsetY)
end sub

sub processItemEffect(itemNo)
  if item$(itemNo,0) ="small key" then inc numKeys
  if item$(itemNo,0) ="torch fuel" then inc maxLightDist,8 : redrawShadow(15)
  if item$(itemNo,0) ="health potion" then inc maxHealth
  if item$(itemNo,0) ="food and bandages" then inc foodBandages
  if item$(itemNo,0) ="shield reinforcement" then inc defence
  if item$(itemNo,0) ="carborundum block" then inc attack
  if item$(itemNo,0) ="magic map" then inc magicMaps
end sub

sub removeShadow
  page write 1 : box 0,30,400,480,0,0,rgb(0,0,0,0) : page write 0
end sub

sub redrawShadow(bgTrans)
  local trans,f
  'build the shadow image on hidden page 2
  page write 2
  box 0,30,400,480,0,0,rgb(0,0,0,bgTrans)
  f=maxLightDist
  for trans=bgTrans to 0 step -1
    circle 201,220,f,3,,rgb(0,0,0,trans),rgb(0,0,0,trans)
    inc f,-3
  next trans

  'blit the shadow onto the screen overlay page 1
  page write 1
  blit 0,30,0,30,400,450,2
  'reset back to writing on the main screen
  page write 0
end sub

sub processBattle(monsterCode)
  local itemDrop, monsterLevel,monsterHealth,monsterMaxHealth,monsterAttack,monsterDefence,i
  local playerHitChance,monsterHitChance
  local mSelect
  local m$

  'the monster's level is based on how far away from the origin it is.

  monsterLevel=getLevel(playerRoomX,playerRoomY)


  monsterMaxHealth=5+(monsterLevel*5)
  monsterHealth=monsterMaxHealth
  monsterAttack=monsterLevel+1
  monsterDefence=monsterLevel

  'need to determine which monster of this monsterLevel has appeared
  'monsterCode is a value between 16-31 determined by the Lehmer RNG room value
  'need to translate that to a value between 0-monstTot(monsterLevel)
  monsterCode=monsterCode-16
  mSelect=fix((monsterCode/15)*monstTot(monsterLevel))

  'monstName$(0,0,0) is the monster name for the first level 0 monster
  'monstName$(0,0,1) is monster description 1, monstName(0,0,2) is monst descript 2

  'monstName$(0,1,0) is the monster name for the second level 0 monster

  'monstName$(1,0,0) is the monster name for the first level 1 monster...etc etc...

  'get the monster's name
  m$=monstName$(monsterLevel,mSelect,0)

  'calculate hit chances as a value of 0-1
  '0 = never hits, 1 = always hits
  playerHitChance= (16+ 8*(attack-monsterDefence)) / 32
  monsterHitChance=(16+ 8*(monsterAttack-defence)) / 32


  'describe the monster encounter
  scroll(monstName$(monsterLevel,mSelect,1),"")
  scroll(monstName$(monsterLevel,mSelect,2),"")   
  scroll("What will you do?!")
  scroll("Press A to attack, or R to run away. Quickly now!")

'  scroll("your hit chance =%",str$(playerHitChance))
'  scroll("monst hit chance =%",str$(monsterHitChance))
'  scroll("your damage =%",str$(attack))
'  scroll("monst damage =%",str$(monsterAttack))

  do
  'COMBAT LOOP
    timer=0

    i=getKey()
    if i=asc("a") then 
      'player attacks   
      if playerHitChance>rnd then
        inc monsterHealth,-attack
        if monsterHealth<1 then 
          scroll("You land a deadly blow against the % and the creature slumps to the ground, dead.",m$)
          goto monster_dead:
        else
          if monsterHealth<=attack then
            scroll("You land a hit with your sword! The % recoils, visibly exhausted. One more hit like that and that'll be the end of it! It gathers what's left of its strength and launches another desperate attack!",m$)
          else
            scroll("You land a hit with your sword! The % recoils in anger, then lunges forward to retaliate!",m$)
          endif          
        endif
      else
        scroll("You swing at it, but the % dodges your attack. It lunges forward to retaliate!",m$)
      endif

      monsterAttacks(m$,monsterHitChance,monsterAttack)
      timer=0

    endif

    if i=asc("r") then
      'player runs away
      scroll("You turn around to run, but seizing the moment, the % attacks you from behind!",m$)
      inc health,-monsterAttack
      if health<1 then goto player_dead:
      scroll("You flee for your life, but after a few moments, you turn and see that you are not being pursued.")
      'move player 6 squares back from the encounter
      runAwayPlayer
      drawWholeScreen
      goto end_processMonster:      
    endif

'    if i=asc("z") then
'      'cheat code!
'      monsterHealth=0
'    endif

    if timer>=10000-monsterLevel*100 then
      'monster attacks
      scroll("Sensing your hesitancy, the % attacks!",m$)
      monsterAttacks(m$,monsterHitChance,monsterAttack)
      timer=0
    endif  

  loop while monsterHealth>0
  'END OF COMBAT LOOP
 monster_dead:

  scroll("You have defeated the %! Before your very eyes, it mysteriously disintigrates into a pile of dust.",m$)

  'add this monster's room to the list of the dead so it no longer appears on the map
  updateItem(itemPointer)=playerTile : inc itemPointer

  itemdrop=fix(rnd*16)
  scroll("Admist the dust, you see %.",item$(itemDrop,1))
  processItemEffect(itemDrop)
  
end_processMonster:
end sub

function getLevel(x,y)
  getLevel=abs(x)
  if abs(y)>abs(x) then getLevel=abs(y)
  getLevel=int(getLevel/levelStepUp)
end function

sub monsterAttacks(m$,mhc,ma)
'  scroll("monst atk=%",str$(mhc))
  if mhc>rnd then
    scroll("It lands a successful attack on you! You stumble backwards, gasping heavily.")
    inc health,-ma
    if health<1 then goto player_dead:
  else
    scroll("Fortunately you lift your shield just in time, blocking its attack!")
  endif      
  updateStats
end sub

sub runAwayPlayer
  'backtrack 5 positions
  offsetX=prevOffsetX
  offsetY=prevOffsetY
  playerX=ppx(5)
  playerY=ppy(5)
end sub

function doorsAreUnlocked(tile)
  doorsAreUnlocked=0
  for f=0 to doorsPointer
    if unlockedDoors(f)=tile then
      doorsAreUnlocked=1
      goto skip_are_doors_unlocked:
    endif
  next f
skip_are_doors_unlocked:
end function

function doorsInRoom(r$)
  'check to see if there are any doors in this roomstring
  local f,c$
  doorsinRoom=0
  for f=1 to 25
    c$=mid$(r$,f,1)
    if c$="5" or c$="6" or c$="7" or c$="8" or c$="J" or c$="K" or c$="L" or c$="M" then
      'door found
      doorsinRoom=1
      goto skip_door_check:  
    endif
  next f
skip_door_check:
end function

'send either "N", "E", "S" or "W" to this routine
'to see if the way is blocked in that direction
'accesses global vars roomstring$, roomStringS$ & roomStringE$
function checkBlocked(dir$)
  local checkString$,checkRow,checkCol,charPos,checkChar$,checkTile
  'start by assuming the way is not blocked
  checkBlocked=0
  'start by assuming the square to check is on this room tile
  checkString$=roomString$
  'start by assuming checkRow/checkCol are in line with player
  checkRow=playerY
  checkCol=playerX  
  checkTile=playerTile

  if dir$="S" then
    checkRow=playerY+1
    if playerY=2 then 
      checkString$=roomStringS$
      checkRow=-2
      checkTile=getTileNo(playerRoomX,playerRoomY+1)
    endif
  endif
  if dir$="E" then
    checkCol=playerX+1
    if playerX=2 then 
      checkString$=roomStringE$
      checkCol=-2
      checkTile=getTileNo(playerRoomX+1,playerRoomY)
    endif
  endif
  
  'work out which char in the roomstring to check (1-25)
  charPos=13+checkCol+checkRow*5
  checkchar$=mid$(checkString$,charPos,1)

  'ignore the monster tile specifiers
  if asc(checkChar$)>asc("D") then
    checkChar$=chr$(asc(checkChar$)-21)
  endif
  
  if dir$="N" or dir$="S" then
    if checkChar$="2" or checkChar$="4" or checkChar$="8" or checkChar$="9" or checkChar$="B" then 
      checkBlocked=1
    endif
    'door
    if checkChar$="5" or checkChar$="7" then
      'check for locked door on this room - set checkBlocked to 1 if locked
      checkBlocked=doorsLocked(checkTile)
      if checkBlocked=1 then 
        play stop
        play mp3 "rattle.mp3"
        scroll("You rattle the ancient door handle, but it remains closed fast. There is a strange key hole - if only you could find a key that fits...","")
      endif
    endif
  endif
  
  if (dir$="E" or dir$="W") then
    if checkChar$="3" or checkChar$="4" or checkChar$="7" or checkChar$="A" or checkChar$="B" then
      checkBlocked=1
    endif
    'door
    if checkChar$="6" or checkChar$="8" then
      'check for locked door on this room - set checkBlocked to 1 if locked
      checkBlocked=doorsLocked(checkTile)
      if checkBlocked=1 then 
        play stop
        play mp3 "rattle.mp3"
        scroll("You rattle the ancient door handle, but it remains closed fast. There is a strange key hole - if only you could find a key that fits...","")
      endif
    endif
  endif
end function

function doorsLocked(tile)
  local f
  doorsLocked=1
  for f=0 to doorsPointer
    if unlockedDoors(f)=tile then
    doorsLocked=0
    goto end_doors_locked:
  endif
  next f
end_doors_locked:
end function

'find a char position in the 25 char roomstring
'-2<=px<=+2  -  -2<=py<=+2
function getCharPos(px,py)
  getCharPos=13+px+py*5
end function

sub drawWholeScreen

  'build the actual map on the hidden page 2 to blit onto the screen when finished drawing
  page write 2

  'draw dungeon "solid" background
  box 0,30,400,450,0,0,solid 

  'draw whole dungeon map
  '5 rooms visible top to bottom, 5 rooms visible left to right
  for y=-3+offsetY to 3+offsetY
    for x=-2+offsetX to 2+offsetX
      drawTile(x,y)
    next x
  next y
  
  'scroll the screen so the player is always in the middle
  blit 0,30,playerX*-16,playerY*-16,400,450

  'copy the view window only onto the main screen
  page write 0
  blit 0,30,0,30,400,400,2

  'position the player in the middle of the dungeon map area
  playerScreenX=originX+40
  playerScreenY=originY+10

  'draw the player
  circle playerScreenX,playerScreenY,4,0,,0,rgb(yellow)

end sub

'drawTile draws the room tile a given x,y values (centred on room grid origin 0,0)
'playerX and playerY are global vars (-2<=n<=+2) for player's position within the tile
'uses global vars offsetX and offsetY (to reposition area drawn onto screen)
sub drawTile(x,y)
  local lightDist, present,tileOffset,itemX,itemY

  'update the player's screen position
  playerScreenX=originX+40+playerX*16
  playerScreenY=originY+40+playerY*16

  'get the screen origin (top left) of this 5x5 tile
  sX=screenX(x) : sY=screenY(y)

  'if this tile is out of reach of the light, skip it
  if useLights then
    if x<playerRoomX-1 or x>playerRoomX+1 then goto unlit_tile
    if y<playerRoomY-1 or y>playerRoomY+1 then goto unlit_tile
'    lightDist=getDist2Player(sX,sY)
'    if lightDist>maxLightDist+80 then goto unlit_tile:
  endif

  if isInterlevel(x,y) then
    'we are drawing the interLevel stage
    roomCode=20
    goto skip_roomCodeCalc:
  endif

  'get the tile number of the room to be drawn from the (x,y) value
  tileNo=getTileNo(x,y)
  'calcRelTile takes tileNo and finds the quickest way to calc the
  'Lehmer RNG value and assigns values to global vars relTile and prevTileVal
  calcRelTile
  'calculate tile value using values calc'd in sub calcRelTile
  tileVal=getRelTile(relTile,prevTileVal)  

  'get 20-bit binary code of current Lehmer tile value
  tileBin$=bin$(tileVal,20)

  'get 5-bit room code (val 0-31) to determine which room to draw
  roomCode=getRoomCode(tileBin$)

  'store this tile no and tile val in global vars to speed up Lehmer RNG calcs
  prevTile=tileNo
  prevTileVal=tileVal

skip_RoomCodeCalc:


  '99 is the dummy value to denote there is no item/monster in this tile
  itemCode=99
  'see if there is an item/monster in this room tile
  if getItemAppears(tileBin$) then 
    itemCode=getItemCode(tileBin$)
'   check to see if this item/monster has been looted/killed already 
    present=itemIsPresent(tileNo)
  endif

  'draw this room/tile to the screen
  drawRoom(sX,sY,roomCode,itemCode,present,getLevel(x,y))

unlit_tile:

  'if we're drawing the tile the player is currently on, 
  'store roomstring and tile number in global vars
  if x-offsetX=0 and y-offsetY=0 then
    roomString$=room$(roomCode)
    playerTile=tileNo
    playerRoomX=x
    playerRoomY=y

    'see if there's an item/monster on this roomtile:
    'note there is never an item or tile in the columns room (interlevel/start tile)
    if present and tileNo<>20 then
      itemX=getItemX(getItemPos(roomString$))
      itemY=getItemY(getItemPos(roomString$))
        'see if the player has landed on the item/monster square:
        if itemX=playerX and itemY=playerY then
          'set the process encounter global var to handled in MAIN GAME LOOP
          processEncounter=itemCode
        endif
    endif
  endif

  'store the roomString of the tile to the east of the player in a global var
  'to speed up checking for blocking walls in movement routine
  if x-offSetX=1 and y-offSetY=0 then
    roomStringE$=room$(roomCode)
  endif

  'store the roomString of the tile to the south of the player in a global var
  'to speed up checking for blocking walls in movement routine
  if x-offsetX=0 and y-offsetY=1 then
    roomStringS$=room$(roomCode)
  endif

end sub

function isInterlevel(x,y)
  isInterlevel=0
  if (abs(x) mod levelStepUp = 0) then
    'on a vertical line at the levelStepUp position
    if (abs(y) mod levelStepup=0) then
      'on an intersection between x and y
      isInterlevel=1
      goto end_interlevel:
    endif
    if x=0 then goto end_interlevel:
    isInterlevel=1
  endif
  if (abs(y) mod levelStepUp = 0) then
    'on a horizontal line a the levelstepup position
    if y=0 then goto end_interlevel:
    isInterlevel=1
  endif
end_interlevel:
end function
    

function getItemPos(r$)
  'return a charPos 1-25 for the item/monster in the roomString supplied
  local f
  for f=1 to 25
    if asc(mid$(r$,f,1))>asc("D") then
      getItemPos=f
      goto skip_getItem:
    endif
  next f
  'no monster/item found on this tile
  getItemPos=0
skip_getItem:  
end function

function getItemX(charPos)
  'return a room X value (-2 <= x <= +2) from charPos 1-25
  getItemX=(charPos mod 5)-3
  'if there is no item in the room, charPos is 0
  if charPos=0 then getItemX=99
end function

function getItemY(charPos)
  'return a room Y value (-2 <= y <= +2) from charPos 1-25
  getItemY=(int(charPos/5))-2
  if charPos=0 then getItemY=99
end function

'this sub uses global vars: relTile, prevTileVal, tileNo, skip, tileVals()
'assigns values to global vars: relTile,prevTileVal
sub calcRelTile
  local tileOffset
  'if previously drawn tile is nearer than nearest pre-calc'd value
  'in the tileVals() array:
  tileOffset=tileNo-prevTile
  if tileOffset>0 and tileOffset<(tileNo mod skip) then
    relTile=tileNo-prevTile
    goto calc_tileVal:
  endif

  'pre-calculated tile value from the tileVals() array  
  if tileNo>skip then 
    t=int(tileNo/skip)
    prevtile=t*skip
    prevTileVal=tileVals(t)
    relTile=tileNo-prevTile
    goto calc_tileVal:
  endif

  'if both above fail, calculate tile value from origin
  relTile=tileNo
  prevTileVal=tileVals(0)

calc_tileVal:
end sub

'scan through the updateItem array to see if this room number
'is included in the list, if it is - set itemIsPresent to 0
'updateItem() is a global stack array holding a list of room numbers
'itemPointer is a global var holding the current length of the updateItem stack array
function itemIsPresent(tile)
  local f
  itemIsPresent=1
  for f=0 to itemPointer
    if updateItem(f)=tile then 
      itemIsPresent=0
      goto end_item_present:
    endif
  next f
end_item_present:
end function

'draw a room tile
'supply the x position and y position in the room grid
'supply the room code of the room to be drawn
'supply the item code for this room's item(/monster)
'supply if the item is present (and therefore to be drawn) in this room
sub drawRoom(posX,posY,code,item,present,level)
  local char$,temp$
  local monsterPres
  local x,y,subtile,wallThick,doorSize,doorWall
  local localX,localY,lightDist,light
  local litWallColour,litFloorColour,litDoorColour,litSolidcolour
  local litItemColour,litMonsterColour
  subTile=16
  wallThick=2
  doorSize=6
  doorWall=6

  for y=0 to 4
    localY=posY+y*subTile
    for x=0 to 4
      localX=posX+x*subTile
      char$=mid$(room$(code),y*5+x+1,1)

      'assign unlit colours by default
      litFloorColour=floor
      litWallColour=wall
      litFloorColour=rgb(128+level*20,128,128)
      litDoorColour=door
      litItemColour=itemCol
      litMonsterColour=monster

'      if useLights then
'        'get distance of this square to the player (light source)
'        lightDist=getDist2Player(localX,localY)
'
'        if lightDist>maxLightDist then goto dont_draw:
'
'        light=lightDist/maxLightDist*10
'
'        'assign falloff colours from pre-calc'd arrays
'        litWallColour=wallColour(light)
'        litFloorColour=floorColour(light)
'        litDoorColour=doorColour(light)
'        litSolidColour=solidColour(light)
'        litItemColour=itemColour(light)
'        litMonsterColour=monstColour(light)
'        'solid
'        box localX,localY,subTile,subTile,0,0,litSolidColour
'      endif

      monsterPres=0
      'check to see if we're drawing the square with the item/monster in it
      if asc(char$)>asc("D") then
        char$=chr$(asc(char$)-21)
        monsterPres=1
      endif

      'draw floor
      if char$<>"9" and char$<>"A" and char$<>"B" and char$<>"C" and char$<>"D" then
        box localX,localY,subtile,subTile,0,0,litFloorColour      
      endif
      
      'draw corner wall piece
      if char$="1" or char$="D" then
        box localX,localY,wallThick,wallThick,0,0,litWallColour
      endif

      'draw top wall
      if char$="2" or char$="9" or char$="4" or char$="8" or char$="B" then
        box localX,localY,subTile,wallThick,0,0,litWallColour
      endif

      'draw left wall
      'TO DO: if this square is on the left hand column, and the square immediately to the left
      'is a "9" or "A" or "B" or "C" or "D" then DONT DRAW IT
      if char$="3" or char$="4" or char$="7" or char$="A" or char$="B" then
        box localX,localY,wallThick,subTile,0,0,litWallColour
      endif

      'draw top door
      if char$="5" or char$="7" then
        box localX,localY,doorWall,wallThick,0,0,litWallColour
        box localX+doorWall,localY,doorSize,1,0,0,litDoorColour
        box localX+doorWall+doorSize,localY,doorWall,wallThick,0,0,litWallColour
      endif

      'draw left door
      if char$="6" or char$="8" then
        box localX,localY,wallThick,doorWall,0,0,litWallColour
        box localX,localY+doorWall,1,doorSize,0,0,litDoorColour
        box localX,localY+doorWall+doorSize,wallThick,doorWall,0,0,litWallColour
      endif

      if monsterPres and present then 
        'draw the item/monster
        if item<16 then 
          'item is an item - draw blue blob
          circle localX+8,localY+8,4,0,,0,litItemColour
        else
          'item is a monster - draw red question mark
'          circle localX+8,localY+8,4,0,,0,monstColour(light)
          text localX+6,localY+5,"?",,,,litMonsterColour,-1
        endif
      endif

dont_draw:

    next x
  next y

end sub

'used to pre-calculate lit colours
'supply scaling value 'amount' as a value between 0 and 1
'0=completely dark ; 1=maximum brightness
function getLitColour(inputColour,amount)
  local red,green,blue, binary$

  'get a binary string of the 24-bit input colour
  binary$=bin$(inputColour,24)

  'bin$() adds an extra 4 0s on the front of the bit string - strip them off:
  binary$=mid$(binary$,5,24)

  'split the input colour into RGB (8 bits, 8 bits, 8 bits)
  red=bin2dec(mid$(binary$,1,8))
  green=bin2dec(mid$(binary$,9,8))
  blue=bin2dec(mid$(binary$,17,8))

  red=red*amount'*amount    'linear light falloff means a smaller view radius = faster redraw
  blue=blue*amount'*amount
  green=green*amount'*amount

  getLitColour=rgb(red,green,blue)  
end function

'how far away from the player (light source) is the currently drawn square?
'supply the required x,y location as screen pixel values
function getDist2Player(x,y)
  local relX,relY
  relX=x-playerScreenX+30
  relY=y-playerScreenY+30
  getDist2Player=sqr(relX*relX+relY*relY)
end function

function getRoomCode(b$)
  'b$ is the tile val, 20-bit binary number
  'room code is first 5 bits of the tile val
  getRoomCode=bin2dec(mid$(b$,1,5))
end function

function getItemAppears(b$)
  'b$ is the tile val, 20-bit number
  'if the last 6 bits of the tile val (0-63)
  'is less than appears (set locally), that room's item appears.
  local appears = 15
  getItemAppears=0
  if bin2dec(mid$(b$,15,6))<appears then getItemAppears=1
end function  

function getItemCode(b$)
  getItemCode=bin2dec(mid$(b$,6,5))
end function  

function bin2dec(b$)
'get the decimal number from a binary number in string format
  local f,tot
  local strlen
  strlen=len(b$)
  for f=0 to strlen-1
    'powerTwo(l) is an array of pre-calculated values of powers of 2: powerTwo(2)=4 etc
    if mid$(b$,strlen-f,1)="1" then tot=tot+powerTwo(f)
  next f
  bin2dec=tot
end function

'these functions convert a room grid x, y into a screen pixel origin position (top left)
function screenX(x)
  screenX=originX+tileSize*(x-offsetX)
end function

function screenY(y)
  screenY=originY+tileSize*(y-offsetY)
end function

function getLayerStart(n)
'this fn returns the start tile number of the layer number supplied
  if n=0 then getLayerStart=0 : goto skip_layer:
  local rootLayerStart
  rootLayerStart=2*(n-1)+1
  getLayerStart=rootLayerStart*rootLayerStart
skip_layer:
end function

function getTileNo(x,y)
'this fn returns the tile (room) no for given x and y values
  'n is the layer number
  local n=abs(x)
  local layerStart
  if abs(y)>abs(x) then n=abs(y)
  layerStart=getLayerStart(n)
  if y=-n then getTileNo=layerStart+x+n : goto skip_tile:
  if x=n then getTileNo=layerStart+n*2+y+n : goto skip_tile:
  if y=n then getTileNo=layerStart+n*4-x+n : goto skip_tile:
  getTileNo=layerStart+n*6-y+n  
skip_tile:
end function

function getTileVal(tileNo)
'this sub returns a Lehmer generated RNG for an absolute tile no.
  local f, rand
  rand=RNGseed
  for f=0 to tileNo
    rand=nextRand(rand)
  next f
  getTileVal=rand
end function

function getRelTile(incTile,currentTileVal)
'this function returns a Lehmer generated RNG for a relative tile increment
  local f
  for f=1 to incTile
    currentTileVal=nextRand(currentTileVal)
  next f
  getRelTile=currentTileVal
end function

function nextRand(value)
'this function returns a procedural RND in the range 1-1048261 (largest prime under 20 bits)
  nextRand=value*9901 mod 1048261
end function

sub getXY(tileNo)
'this sub assigns values to the global vars gridX and gridY depending on supplied tile no.
  'n is the layer number
  local n
  local layerStart,layerOffset as integer
  n=fix((1+sqr(tileNo))/2)
  layerStart=getLayerstart(layer)
  layerOffset=tileNo-layerStart

  if layerOffset<n*2 then
    gridX=originX+(layerOffset-n)*tileSize
    gridY=originY-n*tileSize
    goto skip_xy:
  endif
  if layerOffset<n*4 then
    layerOffset=layerOffset-n*2
    gridX=originX+n*tileSize
    gridY=originY+(layerOffset-n)*tileSize
    goto skip_xy:
  endif
  if layerOffset<n*6 then
    layerOffset=layerOffset-n*4
    gridX=originX+(n-layerOffset)*tileSize
    gridY=originY+n*tileSize
    goto skip_xy:
  layerOffset=layerOffset-n*6
  gridX=originX-n*tileSize
  gridY=originY-(n-layerOffset)*tileSize
skip_xy:
end sub

function getKey()
'see if the user is pressing a key
  getKey=keydown(1)
end function

sub waitkey
'pause the execution until user presses 
'and lets go of a key (mainly for debugging!)
  do 
  loop while inkey$<>""
'  text 650,580,"PRESS ENTER",,,,rgb(white),rgb(red)
  do 
  loop while inkey$=""
end sub

sub initRooms
  local i$
  restore room_data:
  for f=0 to 31
    read i$
    room$(f)=i$
  next f
  
room_data:
  'room layout datastrings - must be 32 in total (codes 0-31)

  'one single large 5x5 room
  data "I212230000100003000030000"
  '3 rooms
  data "421423003052G603003030030"
  'crossroads with door
  data "B93B9AC3AC2G122B97B9AC3AC"
  data "B93B9AC3AC2G122B97B9AC3AC"
  'corner to corner corridors
  data "I21B93B9DC1A422BD3B9AC3AC"
  data "I21B93B9DC1A422BD3B9AC3AC"
  'boss room
  data "421223452316E063300332521"
  'jail cells
  data "44344333335515577377333H3"
  'vertical passage
  data "B93B9AC3ACACHA4AC3A9AC3AC"
  data "B93B9AC3ACACHA4AC3A9AC3AC"
  data "B93B9AC3ACACHA4AC3A9AC3AC"
  'vertical passage with joining passages
  data "426B9HB3AC1A382BD3B9AC3AC"
  'horizontal passage
  data "B9999ACCCC22G22B9999AC4AC"
  data "B9999ACCCC22G22B9999AC4AC"
  data "B9999ACCCC22G22B9999AC4AC"
  'horizontal passage with joining passages
  data "B9322AC99322225B9LB9AC3AC"
  'mazey passages with 2x2 in centre
  data "421423426316E334221232240"
  'corner to corner corridors with 1x1 room in middle
  data "B93B9AC32A22M62B32B9A93AC"
  '4X3 room with antechambers
  data "4254B3003A6003830E7B7221A"
  't-junction going down
  data "B9999ACCCC22222B9LB9AC3AC"
  'columns room
  data "4212231111111113111131111"
  't-junction to right
  data "B93B9AC3ACAC3G2AC3B9AC3AC"
  'circle room
  data "B412B41B321BD933GA41B321B"
'----23 TO HERE
  'small square room with solid corners
  data "B93B9A412A21E02B300BA93BD"
  'snake labyrinth 1
  data "42142343331333333H3230220"
  'snake labyrinth 2
  data "421423221322223I221332221"
  'snake labyrinth 3
  data "423423331313I214132232220"
  'two square rooms off vertical corridor
  data "B97B9AC342826603E3B9B93AC"
  'two square rooms off crossroads
  data "I23423033052152B93B9AC3AC"
'---29 TO HERE

  'snake labyrinth 4
  data "42142H2233221334221B322BD"
  'snake labyrinth 5
  data "B9322A42212H2243423331331"
  'circle room
  data "B412B41B321BD933GA41B321B"

end sub

sub scroll(t$,insert$)
  if t$="" goto skip_scrollprint:
  local f
  local ch$,word$,st1$,st2$
  local cursorX=0
  local position
  'put the inserted word in, if there is one
  if insert$<>"" then
    position=instr(t$,"%")
    if position=0 then scroll("DEBUG: no % in string",""):waitkey
    st1$=left$(t$,position-1)
    st2$=right$(t$,len(t$)-position)
    t$=st1$+insert$+st2$ 
  endif

  scrollLine

  'start reading in the string at char position 1  
  f=1

scanString:

  ch$=mid$(t$,f,1)
  'read in a full word from t$
  do while ch$<>" "
    word$=word$+ch$
    if f=len(t$) then goto break_readword:
    f=f+1
    ch$=mid$(t$,f,1)
  loop

break_readword:
  'word wrap onto next line if necessary
  if cursorX+len(word$)>lineLen then scrollLine : cursorX=0
  'put this word on screen at the bottom of the scroll window
  text 402+cursorX*mm.info(fontwidth),478-fontheight-fontheight,word$,,,,rgb(50,0,0),-1
  cursorX=cursorX+len(word$)+1
  word$=""
  f=f+1
  if f<len(t$) then goto scanString:

  scrollLine

'  page copy 0 to 2

skip_scrollprint:
end sub

sub scrollLine
  'scroll all the text up, blanking the top line
  blit 402,31+fontheight,402,31,237,478+fontheight
end sub

sub initItems
  'init items - 16 different items to init
  local f,lev$,t$,l$
  restore item_data:
  for f=0 to 15 : read t$,l$ : item$(f,0)=t$ : item$(f,1)=l$ : next f
end sub

item_data:
  'items 0-15
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
'
  data "torch fuel"
  data "some torch fuel! You pour it onto your torch, making it shine a little brighter - now you can see a little further into the gloom!"
' 
  data "health potion"
  data "a potion of fortification! You gulp it down gladly, and it permanently increases your maximum health!"
'
  data "food and bandages"
  data "some food and bandages. You store them safely in your backpack. If you are injured, press 'F' to use them to restore 5 health points."
'
  data "shield reinforcement"
  data "some reinforcement bands for your shield. You fix them in place, increasing your defence value permanently!"
'
  data "carborundum block"
  data "a carborundum sharpening block. You give your sword a good polish with it, making the edge keener. Your attack value is increased permanently!"
' 
  data "magic map"
  data "a magic map. You store it safely in your backpack. Press 'M' to use it, and it will briefly show all the chambers, monsters and items nearby."
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
'
  data "emerald gems"
  data "glinting and twinkling green in your torchlight, a pile of emerald gems! You stash them safely in your backpack."
' 
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."
'
  data "small key"
  data "a small key, which you store safely in your backpack. It fits all the door locks in this labyrinth, but it is ancient and fragile, and will only work a few times on doors close at hand before crumbling to dust."



sub initMonsters
  local f,g,lev$,t$,l$,l2$,mlev
  'zero the monster totals for all monster levels
  for f=0 to 9 : monstTot(f)=0 : next f
  'init monsters - unknown number of monsters - data list termination denoted with "X"
  restore monster_data:
  read t$,l$,l2$
  f=0
  do while t$<>"X"
    lev$=left$(t$,1)
    mlev=asc(lev$)
    if mlev<asc("0") or mlev>asc("9") then print"DEBUG-no level on monster ";f:waitkey:end
    mlev=eval(chr$(mlev))
    t$=mid$(t$,2,len(t$)-1)

    'monstName$(0,0,0) is the monster name for the first level 0 monster
    'monstName$(0,0,1) is monster description 1, monstName(0,0,2) is monst descript 2
    'monstName$(0,1,0) is the monster name for the second level 0 monster
    'monstName$(1,0,0) is the monster name for the first level 1 monster...etc etc...
    monstName$(mlev,monstTot(mlev),0) = t$
    monstName$(mlev,monstTot(mlev),1) = l$
    monstName$(mlev,monstTot(mlev),2) = l2$
    inc monstTot(mlev)
    
    read t$,l$,l2$: inc f
  loop

'  for f=0 to 9
'    print "level";f;" monsters:" : print:
'    for g=0 to 9
'      print g;" - ";monstName$(f,g,0)
'    next g
'  waitkey
'  next f
  
end sub

monster_data:
  'the first char of the monster name is the level number of that monster
  data "0sand snake"
  data "A large, sandy coloured snake is curled up in the passageway here, its head raised and scanning the area."
  data "As you approach, it bares two long, curved fangs and lunges at you hissing angrily!"
'
  data "1rock goblin"
  data "At first glance, this creature appears to be a pile of rocks piled up against the wall. But as you approach, it looks up at you, and its gnarled and cratered face screws up into an angry grimace."
  data "Baring teeth of pure black obsidian, it clambers to its feet and charges at you with a gutteral, scraping cry."
'
  data "1green slime"
  data "A patch of shiny green slime is hanging over the walls here. It seems almost alive as it oozes slowly around."
  data "As you warily move closer, it flings a glob of toxic ichor straight at you!"
'
  data "0giant cockroach"
  data "You hear a scuttling, hammering sound, like iron rods being banged against the ground. As you approach, a cockroach comes into view."
  data "But this is no ordinary cockroach - it has grown huge in the deep dark, and is now the size of a large dog. From under its thick, shiny carapace, it claws at you with mandibles the size of kitchen knives."
'
  data "1gelatinous glob"
  data "Looking ahead, you don't see anything out of the ordinary - except maybe a vague misty haze."
  data "Only when you are almost upon it do you see that there is a giant, gelatinous glob filling the entire passageway. It oozes towards you, trying to envelop you in its suffocating jelly, where it will digest you."
' 
  data "2dust zombie"
  data "You hear a faint, scuffing, shuffling sound, accompanied by a gasping moan that chills your blood."
  data "A creature, seemingly made entirely of dust, lurches and stumbles towards you out of the dark. Once human, its now hollow carcass sheds disease ridden flakes as grasping fingers flail towards you."
'
  data "3mummified torso"
  data "You hear a strange scraping, dragging sound in the darkness. As you approach, you see a horrific headless, legless torso dragging itself along the ground by its fingers, flesh rotting and grey."
  data "Scraps of decaying linen hang from its shoulders and chest. Despite having no eyes, it seems to sense your presence, and scrambles itself alarmingly towards you, reaching for you with claw-like, bony fingers."
'
  data "2floating skull"
  data "You see a mysterious, fleshless human skull floating in the dark in the passageway ahead. Its grinning, empty face turns round slowly and regards you curiously for a moment as it begins to drift towards you."
  data "Then, it suddenly flies at you, its jaw champing and biting furiously with a sharp clacking sound!"
'
  data "0giant worm"
  data "You hear a disgusting squelching, oozing sound coming from the darkness in the passageway ahead. As you approach, you see a huge, bloated worm-like creature slithering towards you."
  data "Its veins and organs pulsate through its semi-translucent skin as it launches itself towards you, lashing with its fat, writhing body."
'
  data "1beetle swarm"
  data "You hear a low, rumbling, humming sound coming from the darkness in the passageway ahead. As you approach, you see a cloud of iridescent black scarab beetles, each as big as your hand, filling the entire passageway."
  data "The buzzing gets louder as the swarm starts to drift towards you, their glossy carapaces glinting in the torchlight. Countless snapping mandibles close in on your face."
'
  data "3flesh monstrosity"
  data "A monstrous, greyish-tan coloured creature stands naked in the passageway on two bloated stumps for legs. Four sinewy arms hang at its sides, terminated by vile, rotting flaps of skin where its hands should be."
  data "It seems to be breathing, as folds of flesh roll and slide over each other, its head and body merged into one shapeless, fleshy blob. Suddenly, it lunges at you, flailing its horrific limbs wildly!"
'
  data "4ghostly apparition"
  data "You hear a deathly moan coming from the darkness ahead of you. As you approach, you see the transparent, ghostly figure of a man drifting towards you, his tortured face drawn into a horrific glare."
  data "Both fearing and hating the living, this undead apparition flies towards you as it raises its arms ready to attack."
'
  data "0giant centipede"
  data "A rapid scuttling sound reaches your ears moments before a giant centipede comes scurrying towards you along the wall. It is at least 6 feet long, with a head the size of a watermelon."
  data "It rushes at you, its mandibles biting and clacking furiously."
'
  data "4mummified bear"
  data "A gutteral, gurgling growl emanates from the darkness ahead. Slowly, something that looks like it was once a grizzly bear stumbles towards you on its back legs. It is draped in rotting linen rags."
  data "The unearthly creature stretches out its mummified limbs towards you, slashing at you with 6 inch claws at the end of each necrotic paw."
'
  data "1stranglevine"
  data "On the wall ahead, you see a large overgrowth of a strange vine. The leaves seem to swirl by themselves even though there is no wind."
  data "As you approach, the tendrils reach out, trying to curl themselves around your neck!"
'
  data "3minotaur"
  data "You hear a huffing, grunting sound coming from the passageway ahead. A large, muscular man with a bull's head looms from the darkness, blood-red eyes staring straight into yours."
  data "He lowers his horns towards you and begins to run at you full pace!"
'
  data "X","X","X"



sub footstep
  local s=rnd*3
  play stop
  select case s
  case is >2
    play mp3 "footstep 1.mp3"
  case is >1
    play mp3 "footstep 2.mp3"
  case else
    play mp3 "footstep 3.mp3"
  end select
end sub


player_dead:
updateStats
scroll("You have died. Oh dear how sad never mind.","")
scroll("Better luck next time.","")
waitkey

end


