' ELLO Chess
' (C) KnivD
' platform: ELLO 2M (Micromite+ V5.2 or higher)

option explicit
option default none

const MAXLOG = 150  ' maximum number of recorded moves in a game

const BLACK = rgb(black)
const WHITE = rgb(white)
const YELLOW = rgb(yellow)
const BROWN = &H886600
const LTBLUE = &H0060ff
const DKGREY = &H606060
const LTGREY = &H909090

const VOID = -1
const WPAWN = 0
const BPAWN = 1
const WKNIGHT = 2
const BKNIGHT = 3
const WBISHOP = 4
const BBISHOP = 5
const WROOK = 6
const BROOK = 7
const WQUEEN = 8
const BQUEEN = 9
const WKING = 10
const BKING = 11

dim integer player = 0  ' current player's colour: 0:white, 1:black
dim integer board(8,8)  ' pieces on the board
                        ' horizontal axis (first index) 1..8 = 'A'..'H'
                        ' -1 is void
                        ' 0:white pawn, 1:black pawn, 2:white knight, 3:black knight, 4:white bishop, 5:black bishop
                        ' 6:white rook, 7:black rook, 8:white queen, 9:black queen, 10:white king, 11:black king
dim integer bbuf(8,8)   ' temporary buffer
dim string gamelog(2,MAXLOG) length 10
dim integer move        ' current move in the game
dim integer selx, sely  ' x,y of the currently selected piece on the board
dim integer markx, marky ' piece marked for moving
dim integer v,x,y       ' variables for temporary values
dim integer enpx        ' "en passant" flag; stores the x of the en passant eligible pawn
dim integer cstlfW, cstlfB  ' "castling already done" flag for the two players

cpu 100
do
entry:
  cls
  font #5
  text (780-10*MM.fontwidth)/2, 20, "ELLO CHESS", LT, 5, 1, YELLOW, BLACK
  font #2
  text (780-17*MM.fontwidth)/2, 60, "r1607.1 (C) KnivD", LT, 2, 1, LTBLUE, BLACK
  text 20, 10, chr$(33+BKNIGHT), LT, 8, 1, BLACK, WHITE
  text 80, 10, chr$(33+WKING), LT, 8, 1, BLACK, WHITE
  text 140, 10, chr$(33+BROOK), LT, 8, 1, BLACK, WHITE
  text 610, 10, chr$(33+WQUEEN), LT, 8, 1, BLACK, WHITE
  text 670, 10, chr$(33+BPAWN), LT, 8, 1, BLACK, WHITE
  text 730, 10, chr$(33+WBISHOP), LT, 8, 1, BLACK, WHITE
  font #3
  gui button #1, "Start New Game", 200, 250, 400, 50, YELLOW, BROWN
  gui button #2, "Load Saved Game", 200, 350, 400, 50, YELLOW, BROWN
  do : loop until ctrlval(1) or ctrlval(2)
  if ctrlval(1) then v=1 else v=2
  do while touch(REF)>0 : loop
  gui delete all
  randomize timer
  NewGame
  if v=2 then
  

    ' ### LOAD GAME dialog

  
  end if
  cls BLACK
  DrawBoard
  font #3
  colour WHITE
  text 560, 0, "White"
  colour DKGREY
  text 680, 0, "Black"
  font #2
  gui button #100, "ELLO", 720, 430, 80, 50, YELLOW, BROWN
  gui button #99, "Resign", 620, 430, 80, 50, YELLOW, BROWN
  gui button #98, "Save", 520, 430, 80, 50, YELLOW, BROWN
  pause 1000
  do
    if move<1 then exit do  ' the game has ended
    if ctrlval(98) then
      gui disable 100
      gui disable 99
      gui disable 98
      
      
      ' ### SAVE GAME dialog
      
      
      gui enable 100
      gui enable 99
      gui enable 98
    end if
    if ctrlval(99) then
      gui disable 100
      gui disable 99
      gui disable 98
      colour YELLOW, BLACK
      v=msgbox("Resign game|Are you sure?", "Yes", "No")
      gui enable 100
      gui enable 99
      gui enable 98
      if v=1 then goto entry
      DrawBoard
      ShowLog
    end if
    if ctrlval(100) then
      do while touch(REF)>0 : loop
      gui disable 100
      gui disable 99
      gui disable 98
      MakeMove (player)
      gui enable 100
      gui enable 99
      gui enable 98
    else 
      selx=touch(X) : sely=touch(Y)
      if selx>=32 and selx<480 then selx=1+int((selx-32)/56) else selx=0
      if sely>=5 and sely<453 then sely=8-int((sely-5)/56) else sely=0
    end if
    if selx>0 and sely>0 then
      if markx=0 and marky=0 then
        if board(selx,sely)<>VOID and (board(selx,sely) mod 2)=player then 
          markx=selx : marky=sely
          DrawSquare (markx, marky)
        end if
      else
        v=IsValid(markx, marky, selx, sely)
        if v>0 then
          StoreBoard (bbuf())
          Executemove (v) ' speculative execution of the move
          if IsCheckmate(player) then v=0 ' invalidate a move which leaves the king under attack
          RestoreBoard (bbuf())
        end if
        if v>0 then
          if (v=1 and board(selx,sely)<>VOID) or v=2 then y=asc("X") else y=asc("-")
          enpx=0
          ExecuteMove (v)
          x=0
          if v=3 Then
            PromotionMenu (selx, sely, player)
            if board(selx,sely)=WQUEEN or board(selx,sely)=BQUEEN then x=ASC("Q")
            if board(selx,sely)=WROOK or board(selx,sely)=BROOK then x=ASC("R")
            if board(selx,sely)=WBISHOP or board(selx,sely)=BBISHOP then x=ASC("B")
            if board(selx,sely)=WKNIGHT or board(selx,sely)=BKNIGHT then x=ASC("K")
          end if
          if v=4 or v=6 then
            gamelog(player,move)="O-O-O"
          elseif v=5 or v=7 then
            gamelog(player,move)="O-O"
          else
            gamelog(player,move)=chr$(ASC("a")-1+markx)+chr$(asc("0")+marky)+chr$(y)+chr$(ASC("a")-1+selx)+chr$(asc("0")+sely)
            if x>0 then gamelog(player,move)=gamelog(player,move)+">"+chr$(x)
            x=IsCheckmate(0)+10*IsCheckmate(1)
            if x\10=1 or (x mod 10)=1 then gamelog(player,move)=gamelog(player,move)+"!"  ' mark "Check"
            if x\10=2 or (x mod 10)=2 or x\10=3 or (x mod 10)=3 then  ' mark "Checkmate" or "Stallmate" - end of game
              if x\10=2 or (x mod 10)=2 then 
                gamelog(player,move)=gamelog(player,move)+"!!"
                x=2
              else
                gamelog(player,move)=gamelog(player,move)+"=="
                x=3
              end if
              ShowLog
              GameOver (x, player)
              move=0
              continue do
            end if
            do while len(gamelog(player,move))<9
              gamelog(player,move)=gamelog(player,move)+" "
            loop
          end if
          if player=1 then move=move+1
          player=1-player
          font #3
          colour WHITE
          if player=0 then text 560, 0, "White" else text 680, 0, "Black"
          colour DKGREY
          if player=1 then text 560, 0, "White" else text 680, 0, "Black"
          if move>MAXLOG then
            for y=1 to MAXLOG-1
              gamelog(0,y)=gamelog(0,y+1)
              gamelog(1,y)=gamelog(1,y+1)
            next
            gamelog(0,MAXLOG)=""
            gamelog(1,MAXLOG)=""
            move=MAXLOG
          end if
          ShowLog
        end if
        x=markx : y=marky
        markx=0 : marky=0
        DrawSquare (x, y)
        x=selx : y=sely
        selx=0 : sely=0
        DrawSquare (x, y)
      end if
      do while touch(DOWN) : loop
    end if
  loop
  do while touch(REF)>0 : loop
  gui delete all
loop
end


' evaluate the current board situation and return a score; as greater the score is, as better for the player
' (c) color of own figures: 0:white; 1:black
function EvalBoard(c as integer) as integer
  local integer score=0
  local integer x,y,s,cy
  for y=1 to 8
    for x=1 to 8
      if (board(x,y) mod 2)=player then s=1 else s=-1
      if player=0 then cy=9-y else cy=y
      s=s*cy*10*(board(x,y)+1)*RND()
      score=score+s
    next
  next
  score=score+250*IsCheckmate(1-player)*RND()
  score=score-500*IsCheckmate(player)*RND()
  EvalBoard=score
end function


' ELLO is playing chess!
' (c) color of own figures: 0:white; 1:black
' modifies (markx,marky) initial position, and (selx,sely) new position, to mark the move
' markx, marky, selx, sely are chess table coordinates 1..8 (a..h)
sub MakeMove (c as integer)
  local integer bbuf(8,8)
  local integer v, s, maxs=-1000000000
  local integer zo, zn, ox, oy, nx, ny
  for zo=0 to 63
    ox=(zo and 7)+1
    oy=((zo>>3) and 7)+1
    if board(ox,oy)<>VOID and (board(ox,oy) mod 2)=c then
      for zn=0 to 63
        nx=(zn and 7)+1
        ny=((zn>>3) and 7)+1
        v=IsValid(ox, oy, nx, ny)
        if v>0 then
          StoreBoard (bbuf())
          ExecuteMove (v)
          s=EvalBoard(player)
          if s>=maxs then
            maxs=s
            markx=ox : marky=oy
            selx=nx : sely=ny
          end if
          RestoreBoard (bbuf())
        end if
      next
    end if
  next
end sub


' execute a move move based on (markx,marky), (selx,sely), and the result returned by IsValid()
' (v) is the IsValid() result
sub ExecuteMove (v as integer)
  if v=4 then       ' long castling (WHITE)
    board(1,1)=VOID : DrawSquare (1,1)
    board(4,1)=WROOK : DrawSquare (4,1)
    cstlfW=1
  elseif v=5 then   ' short castling (WHITE)
    board(8,1)=VOID : DrawSquare (8,1)
    board(6,1)=WROOK : DrawSquare (6,1)
    cstlfW=1
  elseif v=6 then   ' long castling (BLACK)
    board(1,8)=VOID : DrawSquare (1,8)
    board(4,8)=BROOK : DrawSquare (4,8)
    cstlfB=1
  elseif v=7 then   ' short castling (BLACK)
    board(8,8)=VOID : DrawSquare (8,8)
    board(6,8)=BROOK : DrawSquare (6,8)
    cstlfB=1
  elseif v=8 then   ' white king moved
    cstlfW=1
  elseif v=9 then   ' black king moved
    cstlfB=1
  end if
  board(selx,sely)=board(markx,marky) ' speculative move
  board(markx,marky)=VOID
end sub


' test whether selected move is valid and return a value indicating the result
'          0:invalid move; 1:valid move; 2:'en passant' move; 3:pawn promotion
'          4:long castling (WHITE); 5:short castling (WHITE)
'          6:long castling (BLACK); 7:short castling (BLACK)
'          8:white king valid move; 9: black king valid move
'          11..18:valid move to set enpx
' (oldx,oldy) initial coordinates of the piece
' (newx,newy) desired new coordinates
function IsValid(oldx as integer, oldy as integer, newx as integer, newy as integer) as integer
  IsValid=0
  local integer ex=enpx
  local integer dx,dy,t,f1,f2,f3,p
  p=board(oldx,oldy)
  if p=VOID or (oldx=newx and oldy=newy) then exit function
  local integer np=board(newx,newy)
  if np<>VOID and (p mod 2)=(np mod 2) then exit function ' can't take over own pieces
  if p=WPAWN then
    if newx=oldx and oldy=2 and newy=4 and np=VOID and board(newx,3)=VOID then IsValid=10+newx
    if newx=oldx and newy=(oldy+1) and np=VOID then IsValid=1
    if newy=(oldy+1) and (newx=(oldx-1) or newx=(oldx+1)) then
      if np<>VOID then IsValid=1
      if ex=newx and np=VOID and board(newx,oldy)=BPAWN then IsValid=2
    end if
    if newy=8 and IsValid=1 then IsValid=3  ' promotion
  elseif p=BPAWN then
    if newx=oldx and oldy=7 and newy=5 and np=VOID and board(newx,6)=VOID then IsValid=10+newx
    if newx=oldx and newy=(oldy-1) and np=VOID then IsValid=1
    if newy=(oldy-1) and (newx=(oldx-1) or newx=(oldx+1)) then
      if np<>VOID then IsValid=1
      if ex=newx and np=VOID and board(newx,oldy)=WPAWN then IsValid=2
    end if
    if newy=1 and IsValid=1 then IsValid=3  ' promotion
  elseif p=WKNIGHT or p=BKNIGHT then
    if newx=(oldx-2) and (newy=(oldy-1) or newy=(oldy+1)) then IsValid=1
    if newx=(oldx-1) and (newy=(oldy-2) or newy=(oldy+2)) then IsValid=1
    if newx=(oldx+1) and (newy=(oldy-2) or newy=(oldy+2)) then IsValid=1
    if newx=(oldx+2) and (newy=(oldy-1) or newy=(oldy+1)) then IsValid=1
  elseif p=WBISHOP or p=BBISHOP then
    if newx=oldx or newy=oldy then exit function
    if abs(newx-oldx)<>abs(newy-oldy) then exit function
    if newx=oldx then dx=0 else if newx<oldx then dx=-1 else dx=1
    if newy=oldy then dy=0 else if newy<oldy then dy=-1 else dy=1
    IsValid=TraceFree(oldx,oldy,dx,dy,abs(newx-oldx))
  elseif p=WROOK or p=BROOK then
    if newx<>oldx and newy<>oldy then exit function
    if newx=oldx then dx=0 else if newx<oldx then dx=-1 else dx=1
    if newy=oldy then dy=0 else if newy<oldy then dy=-1 else dy=1
    if abs(newx-oldx)>abs(newy-newy) then t=abs(newx-oldx) else t=abs(newy-oldy)
    IsValid=TraceFree(oldx,oldy,dx,dy,t)
  elseif p=WQUEEN or p=BQUEEN then
    if newx<>oldx and newy<>oldy and abs(newx-oldx)<>abs(newy-oldy) then exit function
    if newx=oldx then dx=0 else if newx<oldx then dx=-1 else dx=1
    if newy=oldy then dy=0 else if newy<oldy then dy=-1 else dy=1
    if abs(newx-oldx)>abs(newy-newy) then t=abs(newx-oldx) else t=abs(newy-oldy)
    IsValid=TraceFree(oldx,oldy,dx,dy,t)
  elseif p=WKING then
    if cstlfW=0 and oldx=5 and newx=3 and oldy=1 and newy=1 then  ' long castling  
      if board(4,1)=VOID and board(3,1)=VOID and board(2,1)=VOID and board(1,1)=WROOK then
        f1=IsAttacked(3,1,0)
        f2=IsAttacked(4,1,0)
        f3=IsAttacked(5,1,0)
        if f1=0 and f2=0 and f3=0 then
          IsValid=4
          exit function
        end if
      end if
    end if
    if cstlfW=0 and oldx=5 and newx=7 and oldy=1 and newy=1 then  ' short castling
      if board(6,1)=VOID and board(7,1)=VOID and board(8,1)=WROOK then
        f1=IsAttacked(5,1,0)
        f2=IsAttacked(6,1,0)
        f3=IsAttacked(7,1,0)
        if f1=0 and f2=0 and f3=0 then
          IsValid=5
          exit function
        end if
      end if
    end if
    if abs(newx-oldx)>1 or abs(newy-oldy)>1 or IsAttacked(newx,newy,0)>0 then exit function
    IsValid=8
  elseif p=BKING then
    if cstlfB=0 and oldx=5 and newx=3 and oldy=8 and newy=8 then  ' long castling
      if board(4,8)=VOID and board(3,8)=VOID and board(2,8)=VOID and board(1,8)=BROOK then
        f1=IsAttacked(3,8,1)
        f2=IsAttacked(4,8,1)
        f3=IsAttacked(5,8,1)
        if f1=0 and f2=0 and f3=0 then
          IsValid=6
          exit function
        end if
      end if
    end if
    if cstlfB=0 and oldx=5 and newx=7 and oldy=8 and newy=8 then  ' short castling
      if board(6,8)=VOID and board(7,8)=VOID and board(8,8)=BROOK then
        f1=IsAttacked(5,8,1)
        f2=IsAttacked(6,8,1)
        f3=IsAttacked(7,8,1)
        if f1=0 and f2=0 and f3=0 then
          IsValid=7
          exit function
        end if
      end if
    end if
    if abs(newx-oldx)>1 or abs(newy-oldy)>1 or IsAttacked(newx,newy,1)>0 then exit function
    IsValid=9
  end if
end function


' test for check or checkmate
' (c) is the king colour to be tested: 0:white; 1:black
' return 0:nothing; 1:check; 2:checkmate; 3:stallmate
function IsCheckmate(c as integer) as integer
  IsCheckmate=0
  local integer x,y,xk,yk,f,j
  xk=0 : yk=0
  for x=1 to 8  ' find for the own king
    for y=1 to 8
      if board(x,y)=(WKING+c) then
        xk=x : yk=y
      end if
    next
  next
  if xk=0 or yk=0 then  ' where is the king??
    IsCheckmate=2
    exit function
  end if
  local integer bbuf(8,8) ' buffer for temporary storage
  IsCheckmate=IsAttacked(xk, yk, c) ' check?
  f=0
  for x=1 to 8
    for y=1 to 8
      if (board(x,y) mod 2)=c then
        for xk=1 to 8
          for yk=1 to 8
            if IsValid(x, y, xk, yk)>0 then
              f=1   ' indicate that there is a valid move
              StoreBoard (bbuf())
              board(xk,yk)=board(x,y)   ' execute the move
              board(x,y)=VOID
              j=IsAttacked(xk, yk, c)
              RestoreBoard (bbuf())
              if j=0 then exit function ' valid move
            end if
          next
        next
      end if
    next
  next
  if f=0 then ' no valid move for any own piece - checkmate or stallmate
    if IsCheckmate=1 then IsCheckmate=2 else IsCheckmate=3
  end if
end function


' test whether a given square on the board is under attack from an enemy's figure
' (x,y) coordinates of the square to be checked
' (c) color of own figures: 0:white; 1:black
' return 1 if the piece is under attack; 0 otherwise
function IsAttacked(x as integer, y as integer, c as integer) as integer
  IsAttacked=0
  local integer t,r,v
  for t=1 to 8
    for r=1 to 8
      v=board(t,r)
      if v>=0 and v<>WKING and v<>BKING and c<>(v mod 2) then
        if IsValid(t, r, x, y)>0 then
          IsAttacked=1
          exit function
        end if
      end if
    next
  next
end function


' trace a given trajectory to see if it is available for a piece move
' (x, y) initial coordinates
' (dx,dy) pair of values -1 or +1 to specify any of the eight possible trajectories
' (tl) trajectory length in number of pieces
' return 1 if a move is possible; 0 otherwise
function TraceFree(x as integer, y as integer, dx as integer, dy as integer, tl as integer) as integer
  TraceFree=0
  local integer lx=x, ly=y, t
  for t=1 to (tl-1)
    lx=lx+dx
    ly=ly+dy
    if lx<1 or lx>8 or ly<1 or ly>8 then exit function
    if board(lx,ly)<>VOID then exit function
  next
  TraceFree=1
end function


' pawn promotion menu
' (x,y) coordinates of the pawn for promotion
' (c) color of own figures: 0:white; 1:black
sub PromotionMenu (x as integer, y as integer, c as integer)
  local string cp$ length 10
  if c=0 then cp$="white" else cp$="black"
  box 100, 50, 280, 300, 2, YELLOW, BLACK
  font #2
  colour YELLOW
  text 110, 60, "Promote "+cp$+" pawn to"
  font #3
  gui button #1, "Queen", 120, 110, 240, 50, YELLOW, BROWN
  gui button #2, "Rook", 120, 190, 240, 50, YELLOW, BROWN
  gui button #3, "Bishop", 120, 270, 240, 50, YELLOW, BROWN
  do
    if ctrlval(1) then board(x,y)=(WQUEEN+c)
    if ctrlval(2) then board(x,y)=(WROOK+c)
    if ctrlval(3) then board(x,y)=(WBISHOP+c)
  loop until ctrlval(1) or ctrlval(2) or ctrlval(3)
  do while touch(REF)>0 : loop
  gui delete 1, 2, 3
  local integer t,r
  for t=1 to 8
    for r=1 to 8
      DrawSquare (t,r)
    next
  next
  ShowLog
end sub


' draw end of game message
' (tw) type of win: 2:checkmate; 3:stallmate
' (c) color of own figures: 0:white; 1:black
sub GameOver (tw as integer, c as integer)
  selx=0 : sely=0
  markx=0 : marky=0
  local integer t,r
  for t=1 to 8
    for r=1 to 8
      DrawSquare (t,r)
    next
  next
  ShowLog
  box 180, 160, 350, 150, 2, YELLOW, BLACK
  local string cp$ length 30
  if tw=2 then
    if c=0 then cp$="White" else cp$="Black"
    cp$="  "+cp$+" win by checkmate  "
  else
    cp$="Stallmate. The game is tie"
  end if
  colour WHITE
  font #2
  text 200, 270, cp$
  font #4
  gui button #1, "GAME OVER", 200, 180, 310, 80, YELLOW, BROWN
  do : loop until ctrlval(1)
  do while touch(REF)>0 : loop
  gui delete 1
end sub


' draw a specified chess figure
' (x,y) chess board coordinates (1..8,1..8) starting from the lower left corner
sub DrawSquare (x as integer, y as integer)
  local integer c
  if ((x mod 2)>0 and (y mod 2)>0) or ((x mod 2)=0 and (y mod 2)=0) then c=DKGREY else c=LTGREY
  if (selx>0 and sely>0 and x=selx and y=sely) or (markx>0 and marky>0 and x=markx and y=marky) then c=YELLOW
  box 32+(x-1)*56, 5+(8-y)*56, 56, 56, 1, c, c
  text 36+(x-1)*56, 9+(8-y)*56, chr$(33+board(x,y)), LT, 8, 1, c
end sub


' display most recent moves from the game log
sub ShowLog
  font #2
  colour YELLOW
  local integer t,r
  if move>17 then r=move-17 else r=1
  for t=0 to (move-r)
    text 520, 40+t*20, str$(r+t)+"."
    text 580, 40+t*20, gamelog(0,r+t)
    text 700, 40+t*20, gamelog(1,r+t)
  next
end sub


' draw the chess board and the indexes
sub DrawBoard
  local integer x,y,c
  for x=1 to 8
    for y=1 to 8
      DrawSquare (x,y)
    next
  next
  box 30, 3, 452, 452, 3, YELLOW
  font #3
  colour YELLOW
  for x=0 to 7
    text 5, (56-MM.FONTHEIGHT)/2+x*56, str$(8-x)
    text 30+(56-MM.FONTWIDTH)/2+x*56, 460, chr$(asc("a")+x)
  next
  text 560, 0, "White"
  text 680, 0, "Black"
  line 520, 30, 799, 30, 2
end sub


' store the board into the designater array buf()
sub StoreBoard (buf() as integer)
  local integer x,y
  for x=1 to 8
    for y=1 to 8
      buf(x,y)=board(x,y)
    next
  next
end sub


' restore the board from buf()
sub RestoreBoard (buf() as integer)
  local integer x,y
  for x=1 to 8
    for y=1 to 8
      board(x,y)=buf(x,y)
    next
  next
end sub


' initialise a new game
sub NewGame
  move=1
  selx=0 : sely=0
  markx=0 : marky=0
  cstlfW=0 : cstlfB=0
  local integer x,y
  for x=1 to MAXLOG
    gamelog(0,x)=""
    gamelog(1,x)=""
  next
  for x=1 to 8
    for y=1 to 8
      board(x,y)=VOID
    next
  next
  for x=1 to 8
    board(x,2)=WPAWN
    board(x,7)=BPAWN
  next
  board(1,1)=WROOK
  board(2,1)=WKNIGHT
  board(3,1)=WBISHOP
  board(4,1)=WQUEEN
  board(5,1)=WKING
  board(6,1)=WBISHOP
  board(7,1)=WKNIGHT
  board(8,1)=WROOK
  board(1,8)=BROOK
  board(2,8)=BKNIGHT
  board(3,8)=BBISHOP
  board(4,8)=BQUEEN
  board(5,8)=BKING
  board(6,8)=BBISHOP
  board(7,8)=BKNIGHT
  board(8,8)=BROOK
end sub


' chess pieces (12 characters starting from ASCII code 33)
' size 48x48 pixels
' memory 3748 bytes
DefineFont #8
  0D203030 FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF 1FFCFFFF FFFFFFFF FFFF0FF0 03E0FFFF FFFFFFFF FFFFE3C7 F1CFFFFF
  FFFFFFFF FFFFF98F F98FFFFF FFFFFFFF FFFFF98F F1CFFFFF FFFFFFFF FFFFE3C7
  C3C1FFFF FFFFFFFF FFFF8081 E003FEFF FEFFFF7F FF3FFC1F FE7FFCFF F8FFFF1F
  FF1FFFFF FFFFF8FF F8FFFF8F FF8FFFFF FFFFF1FF F1FFFF8F FF8FFFFF FFFFF1FF
  F8FFFF8F FF8FFFFF FFFFF8FF FCFFFF1F FF1FFF7F FE3FFCFF FEFFFF3F FF7FF80F
  F00FFFFF FCFFFF7F FF3FF00F FC3FF8FF E0FFFF0F FF87FFFF FFFFC3FF C7FFFFC3
  FFE1FFFF FFFF8FFF 1FFFFFF0 FFF8FFFF FFFF1FFF 3FFE7FFC 3FFCFFFF FFFF3FFE
  7FFC3FFE 3FFEFFFF FFFF7FFC 7FFC1FFF 1FFFFFFF FFFFFFF8 FFF81FFF 1FFFFFFF
  FFFFFFF8 FFF81FFF 1FFFFFFF FFFFFFF8 FFF81FFF 1FFFFFFF 000000F8 00F81F00
  1F000000 FFFFFFFF FFFFFFFF FFFF7FFF 0FF8FFFF FFFFFFFF FFFF07F0 03E0FFFF
  FFFFFFFF FFFF03E0 03E0FFFF FFFFFFFF FFFF03E0 07E0FFFF FFFFFFFF FFFF07F0
  0FF8FFFF FFFFFFFF FFFF0FF8 01C0FFFF FFFFFFFF FFFF0000 0000FEFF FEFFFF7F
  FF3F0000 0000FCFF FCFFFF3F FF1F0000 0000FCFF FCFFFF1F FF1F0000 0000FCFF
  FCFFFF1F FF3F0000 0000FEFF FEFFFF3F FF7F0000 0000FFFF FFFFFFFF FFFF01C0
  03E0FFFF FFFFFFFF FFFF01C0 0000FEFF FCFFFF7F FF1F0000 0000F0FF E0FFFF0F
  FF070000 0000E0FF C0FFFF03 FF010000 000080FF 80FFFF00 FF000000 000000FF
  00FF7F00 7F000000 000000FE 00FE7F00 3F000000 000000FE 00FE3F00 3F000000
  000000FE 00FE3F00 3F000000 000000FE 00FE3F00 3F000000 000000FE FFFF3F00
  FFFFFFFF FFFBFFFF C7FFFFFF FFFFFFF9 FFE1C3FF C0FFFFFF FFFFFFC0 FF04C4FF
  C6FFFFFF FFFF7F0C 001EC4FF E0FFFFFF FF3F007E FCFFC1FF 87FFFF0F FF87FFFF
  FFFF8FFF 1FFFFFE3 FFF1FFFF FFFF3FFE 73FCFFF8 7FFCFFFF FFFF63FC 63FC7FFE
  3FFEFFFF DFFF47FC 4FFC3FFF 1FFF8FFF 8FFF7FFC FFF89FFF 8FFF8FFF 8FFFFFF8
  FFF1CFFF CFFF1FFF 1FFEFFF3 FFE3C7FF E7FF3FFC 7FF0FFC7 FFC7E7FF E3FF7FE0
  7F82FFCF FE9FE3FF F3FF7F0E 7F3EFC93 F803F3FF F3FF7FFC 7FFCF107 E38FF1FF
  F1FFFFFC FFF8238E 47C4F9FF F9FFFFF9 FFF14FC0 0FF0F9FF F9FFFFE3 FFC71FFC
  3FFEF8FF F8FFFF8F FF1FFFFF FEFFF8FF F8FFFF3F FF3FFCFF FCFFFCFF FCFFFF7F
  FFFFF8FF F8FFFCFF FCFFFFFF FFFFF8FF F8FFFCFF 04000000 0000F8FF FCFF0000
  00000000 FFFFFFFF FFFFFFFF FFFFFFFF FFFBF7FF F3FFFFFF FFFFFFF1 FFE1F0FF
  F0FFFFFF FFFFFF60 0700F0FF F0FFFFFF FFFF7800 FF00F0FF E0FFFF3F FFCF8700
  0000C0FF C0FFFF67 FF1B0000 000080FF 06FFFF0D FF060000 00000EFF 1CFFFF02
  7F030000 000038FF 30FFBF01 BF010000 000000FF 00FEBF00 DF000000 000000FE
  00FC5F00 6F000000 000000F8 00F86F00 2F000000 800300F0 00F02F00 37008007
  801F00E0 00E03700 1700807F 00FF00CC 01CC1700 1B0000FF 00FF03C8 07C01B00
  1B0000FF 00FE07E0 0FE00B00 0B0000FC 00FC1FF8 1FFE0D00 0D0000F8 00F03FFF
  FFFF0D00 0D0000E0 00C0FFFF FFFF0500 05000080 0000FFFF FEFF0500 05000000
  0000FEFF FCFF0500 05000000 0000FCFF FCFF0600 00000000 0000FEFF FFFF0100
  FFFFFFFF 3FFEFFFF FFFFFFFF FFFF1FFC 0FF8FFFF FFFFFFFF FFFFCFF9 CFF9FFFF
  FFFFFFFF FFFF8FF8 1FFCFFFF FFFFFFFF FFFF1FFC 07F8FFFF FFFFFFFF FFFFC3E1
  E1C3FFFF FFFFFFFF FF7FF80F FC1FFEFF FCFFFF3F FF1F7E3F 3F7EF8FF F0FFFF8F
  FFC73FFE 3FFEF1FF E3FFFFC7 FFE307F0 07F0E3FF E7FFFFE3 FFF13FFE 3FFEE7FF
  C7FFFFF1 FFF13FFE 7FFFE7FF E3FFFFF1 FFE3FFFF FFFFE3FF F1FFFFE3 FFC7FFFF
  01E0F0FF F8FFFF87 FF0F0000 F80FFEFF FEFFFF1F FF3FFF7F FF7FFEFF FCFFFF1F
  FF1F0F78 0040FCFF FCFFFF1F FF1FE003 FE3FFCFF FCFFFF1F FF1FFE3F 0000FFFF
  FFFFFF3F FFFF01C0 07F0FFFF 00FFFFFF 7F00C001 F00700F8 03F00F00 03E03FFE
  07F8FFC1 E087C1FF F0018000 E003008F 01C47800 11C0FFFF FFFF7FE0 FFF103FF
  C7FFFFFF FFFFFFFF FFFFFFFF FFFF7FFE 1FFCFFFF FFFFFFFF FFFF1FF8 1FF8FFFF
  FFFFFFFF FFFF1FFC 7FFEFFFF FFFFFFFF FFFF7FFE 3FFCFFFF FFFFFFFF FFFF0FF8
  07E0FFFF FFFFFFFF FFFF01C0 0080FFFF FEFFFFFF FF7F0000 8000FCFF F8FFFF3F
  FF1F8001 8001F8FF F0FFFF0F FF0FF007 F007F0FF F0FFFF07 FF07C001 8001F0FF
  F0FFFF07 FF078001 0000F0FF F0FFFF07 FF070000 0000F0FF F8FFFF0F FF0F0000
  F80FFCFF FEFFFF1F FF3FFE3F 0630FFFF FFFFFF7F FF7F0000 0000FFFF FEFFFF7F
  FF3FE007 FC1FFEFF FEFFFF3F FF3F1F7C 03C0FCFF FFFFFF9F FF7F0000 01C0FFFF
  FFFFFFFF FFFF3FFC 3FFCFFFF FFFFFFFF FFFF0FF0 000000FF 00F87F00 1F000000
  800000F0 00C00700 0300E003 FFFF01C0 7FE001C0 03FFFFFF FFFFFFF1 FFFFC7FF
  FFFFFFFF 07E003F8 03F81FC0 1FC007E0 03C003F8 F3F91FC0 9FCFE3C7 E007F0F8
  F0F81F0F 1F0FE007 FFFFFFF8 FFF91FFF 9FFFFFFF FFFFFFF8 00F81FFF 1F000000
  000000F8 1FFE1F00 3FF8FFFF FFFF0FFF 80FFFFF0 FF010000 0000C0FF E0FFFF03
  FF070000 FFFFE3FF E3FFFFC7 FFC7FFFF FFFFE3FF E3FFFFC7 FFC7FFFF FFFFE3FF
  E3FFFFC7 FFC7FFFF FFFFE3FF E3FFFFC7 FFC7FFFF FFFFE3FF E3FFFFC7 FFC7FFFF
  FFFFE3FF E3FFFFC7 FFC7FFFF FFFFE3FF E3FFFFC7 FFC7FFFF FFFFE3FF E3FFFFC7
  FFC7FFFF 0000E0FF C0FFFF07 FF030000 FFFF8FFF 1FFFFFF1 FFF8FFFF FFFF3FFE
  00FC7FFC 3F000000 000000FC 00FC3F00 3F000000 FFFFFFFC FFFC3FFF 3FFFFFFF
  000000E0 00E00700 07000000 000000E0 FFE70700 E7FFFFFF FFFFFFE7 00E0E7FF
  07000000 FFFFFFFF 0FFEFFFF 3FF0FFFF 07F003FE 03FE3FE0 3FE007F0 07F003FE
  00FE3FE0 3F000000 000000FE 00FE3F00 3F000000 000000FC FFFC1F00 9FFFFFFF
  FFFF1FFF 80FF7FFC FF000000 0000C0FF F3FFFF01 FFE7FFFF FFFFF3FF F8FFFFE7
  FF0FFC3F 0000F8FF F8FFFF0F FF0F0000 0000F8FF F8FFFF0F FF0F0000 0000F8FF
  F8FFFF0F FF0F0000 0000F8FF F8FFFF0F FF0F0000 0000F8FF F8FFFF0F FF0F0000
  0000F8FF F8FFFF0F FF0F0000 0000F8FF F8FFFF0F FF0F0000 0000F8FF F8FFFF0F
  FF0F0000 FFFFFBFF F3FFFFEF FFE7FFFF 0000E0FF C0FFFF03 FF010000 000080FF
  9FFFFF00 FFFCFFFF FFFF7FFE 00FE3FFF 3F000000 000000FE 00FE3F00 3F000000
  000000FE 7FF83F00 0FFFFFFF 000000F0 00F00700 07000000 000000F0 00F00700
  07000000 FFFFFFFF FFFFFFFF FFFF3FFE 1FFCFFFF F1FFFFFF FFC78FF8 CFF9E0FF
  C4FFFF83 FF118F79 1F7CCEFF C4C7FF39 E1113F7E 3FFEE083 F019C083 CC873FFE
  1FFCF039 F011CE87 C4871FFC 9FFCF001 F0C3C007 C0279F7C 9F7CF2E1 F2E1C327
  C3679E7C 9E39F3E0 F3F08367 8767CE39 CC39F3F0 73F207E7 27E7CC99 CC9973F2
  33F327E6 67E6C999 C1C333F3 97F367E6 C7E4E1C3 63E387F3 C7F9C7E0 CFF123E2
  0000C6F9 00F9CF21 4F00C001 FFFF01F8 0FF80FC0 0FF8FFFF FFFFFFF8 FFFC8FFF
  1FFF03E0 00007CFE 00FE3F1F 3F00FC1F FFFF03FF 8FFF7FC0 FFF8FFFF 07F09FFF
  CEFFFFFC FF390000 F80FC0FF E1FFFF01 FF83FFFF FFFFC7FF CEFFFFF1 FF390000
  000080FF 80FFFF00 FF80FFFF FFFF87FF C0FFFFF0 FF010000 0000F0FF FFFFFF07
  FFFF0F80 FFFFFFFF FFFFFFFF FFFFFFFF 3FFEFFFF FFFFFFFF FFFF1FFC 1FFCF1FF
  E0FFFFC7 FF831FFC 3FFEE0FF E0FFFF83 F3837FFF 7FFFF1C7 F983E1C7 C0CF3FFE
  3FFEF983 F983C0CF C0CF3FFE 3FFEF8C3 F8E7E18F E38F3FFE 3FFEF8F3 F8F3E78F
  E78F3FFE 1F7CF8F1 F8F9C70F C70F1F7C 1F7CF8F8 F8F8870F 8F0F1E3C 1E3CF8F8
  78F80F0F 0F0F1E3C 1C1C78F8 38F80F0F 0F0E0C18 0C1838F8 18FC0F0E 0F0C0808
  080818FC 00FC1F0C 1F000000 000000FC 00FC1F00 1F000000 000000FC 00FE1F00
  3F00FC1F FFFF01FF 8FFF7FC0 FFF83FFE 00009EFF C0FFFF3C FF01F007 F80FC0FF
  E0FFFF01 FF03FFFF 07F0E3FF E7FFFFE3 FF730000 0000E0FF E0FFFF03 FF03FE3F
  0FF8C3FF CEFFFFE1 FF390000 0000F0FF F0FFFF07 FF070000 0000FFFF FFFFFF7F
  FFFFFFFF FFFFFFFF FFFFFFFF FFFF7FFE 7FFEFFFF FFFFFFFF FFFF0FF0 0FF0FFFF
  FFFFFFFF FFFF0FF0 7FFEFFFF FFFFFFFF FFFF7FFE 7FFEFFFF FFFFFFFF FFFF1FFC
  0FF8FFFF FFFFFFFF FFFFC7F1 E7E3FFFF 1FFCFFFF 1FF8E7E7 E7E703F0 01E007E0
  0380E7E7 E667F0C3 FC8FE30F F13FC423 C003FF9F FF1FF87F F8FFC183 C3C3FF1F
  FF1FF8FF F8FF87E1 8FF1FF1F FF9FF8FF F8FF8FF9 9FF9FF8F FFC7F1FF F1FF1FFC
  1FFCFFC7 FFE3E3FF C7FF1FFC 3FFEFFF1 FFF9C7FF 8FFF3FFE 1FFCFFF8 78FC1FFF
  1F0F0000 000000FE 01FE3F00 7FC0FFFF FFFF3FFE 3FFF7FFC 7FFCFFFF 00003FFF
  20FF7FFC 7F040000 FFFF00FF 0FFF7F00 7FF01FF8 00003CFF 20FF7F3C 7F040000
  FFFF01FF 0FFF7F80 7FF0FFFF FFFF03FF C0FF7FC0 FF030000 0000F8FF FFFFFF1F
  FFFF0FF0 FFFFFFFF FFFFFFFF FFFFFFFF 3FFEFFFF FFFFFFFF FFFF3FFE 07F0FFFF
  FFFFFFFF FFFF07F0 3FFEFFFF FFFFFFFF FFFF3FFE 3FFEFFFF FFFFFFFF FFFF3FFE
  1FFCFFFF FFFFFFFF FFFFCFF9 2FF2FFFF FFFFFFFF FFFF17F4 17F41FFC E3FB1FF8
  EFE717F4 17F41DE4 06E81798 0B701774 16B401D0 00D005C0 058035D6 336600A0
  00A00500 05002432 6C1A00A0 00D00500 0500580D 500500D0 00D80500 0B007007
  600300EC 00F41B00 17006003 400300FA 00FB2F00 4F004001 400100FD 81FEDF00
  BF80FFFF FFFFCFFE 7FFF3FF9 7FFF01C0 0000B0FF 80FFFF06 FF000000 F80F80FF
  81FFFF00 FFC0FFFF 07F08FFF 9CFFFFF8 FF1C0000 FC1F80FF 81FFFF00 FFC0FFFF
  00808FFF 98FFFFF8 FF0C0000 0000C0FF C0FFFF01 FF010000 0000FFFF FFFFFF7F
  FFFFFFFF 
End DefineFont
