/*
 * ascii ICSP implementation for the PIC16F1455
 * additions to m-stack source (c) Peter Mather  2016
 * based on USB CDC-ACM Demo
 * licenced as per the original licensing of m-stack, see below.
 *
 * ICSP extensions adapted from:
 * ascii ICSP implementation for the Arduino NANO
 * arduino code (c) Robert Rozee  2015
 *
 * ascii ICSP extension developed for use with PIC32PROG by Serge Vakulenko
 * see:
 * https://github.com/sergev/pic32prog
 * 
 * Version 1.0, 27/7/2016
 * Version 1.1, 28/7/2016
 *   add break handling to reset uP
 *   Performance tuning
 *   increased clock wait states
 *  Version 1.2, 29/7/2016
 *   Change PID/VID
 * 
 * Hardware Initialization
 *
 * This file may be used by anyone for any purpose and may be used as a
 * starting point making your own application using M-Stack.
 *
 * It is worth noting that M-Stack itself is not under the same license as
 * this file.
 *
 * M-Stack is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  For details, see sections 7, 8, and 9
 * of the Apache License, version 2.0 which apply to this file.  If you have
 * purchased a commercial license for this software from Signal 11 Software,
 * your commerical license superceeds the information in this header.
 *
 * Alan Ott
 * Signal 11 Software
 * 2016-05-02
 */

#ifndef HARDWARE_H__
#define HARDWARE_H__

//set up LED pin
#define LED_LAT LATCbits.LATC2
#define LED_TRIS TRISCbits.TRISC2
#define VPP_LAT  LATCbits.LATC1      
#define VPP_TRIS TRISCbits.TRISC1
#define VCC_LAT  LATCbits.LATC0      
#define VCC_TRIS TRISCbits.TRISC0
//set up reset pin - must be on port A otherwise external pullup resistor is required
#define ICSP_RESET_LAT LATCbits.LATC3
#define ICSP_RESET_TRIS TRISCbits.TRISC3
#define ICSP_RESET_WPUA WPUCbits.WPUC3

// set up PGD pin - must be output capable
#define ICSP_PGD_LAT LATAbits.LATA5
#define ICSP_PGD_PORT PORTAbits.RA5
#define ICSP_PGD_TRIS TRISAbits.TRISA5
#define ICSP_PGD_WPUA WPUAbits.WPUA5
#define ICSP_PGD_MASK = 0b00100000

// set up PGC pin - must be output capable
#define ICSP_PGC_LAT LATAbits.LATA4
#define ICSP_PGC_TRIS TRISAbits.TRISA4
#define ICSP_PGC_WPUA WPUAbits.WPUA4
//set up mode switching pin - must be on port A otherwise external pullup resistor is required
#define MUP_SWITCG_PORT PORTAbits.RA3
#define MUP_SWITCG_WPUA  WPUAbits.WPUA3

#define LED_ON  1
#define LED_OFF 0
#define PIN_ON  1
#define PIN_OFF 0
#define PIN_INPUT  1
#define PIN_OUTPUT 0
#define BUTTON_PRESSED      0
#define BUTTON_NOT_PRESSED  1

#define UART_ENABLE   RCSTAbits.SPEN
#define UART_TRISTx   TRISCbits.TRISC4
#define UART_TRISRx   TRISCbits.TRISC5
#define UART_Tx       PORTCbits.RC4
#define UART_Rx       PORTCbits.RC5


#define mDataRdyUSART() PIR1bits.RCIF
#define mTxRdyUSART()   TXSTAbits.TRMT

void hardware_init(void);
void USART_Initialize(unsigned char, unsigned char);
void USART_putcUSART(char);
void timer_init(void);
unsigned char USART_getcUSART(void);
extern volatile unsigned char ledpoke;
#endif /* HARDWARE_H__ */
