# Raspberry Pi Pico – Joystick to Keyboard (WASZ + Space)
# Joystick to key mapping:
# Up     -> W  ->GP2
# Left   -> A  ->GP3
# Down   -> S  ->GP4
# Right  -> Z  ->GP5
# Button -> Space  ->GP6
# Keys are held while the joystick is held.
# Joystick switches must be active-low (pressed = GND).
# Internal pull-ups are enabled in software.

import time
import board
import digitalio
import usb_hid
from adafruit_hid.keyboard import Keyboard
from adafruit_hid.keycode import Keycode

kbd = Keyboard(usb_hid.devices)

def make_input(pin):
    d = digitalio.DigitalInOut(pin)
    d.direction = digitalio.Direction.INPUT
    d.pull = digitalio.Pull.UP
    return d

joy_up     = make_input(board.GP2)
joy_down   = make_input(board.GP3)
joy_left   = make_input(board.GP4)
joy_right  = make_input(board.GP5)
joy_button = make_input(board.GP6)

state = {
    "up": False,
    "down": False,
    "left": False,
    "right": False,
    "button": False
}

while True:
    if not joy_up.value:
        if not state["up"]:
            kbd.press(Keycode.W)
            state["up"] = True
    else:
        if state["up"]:
            kbd.release(Keycode.W)
            state["up"] = False

    if not joy_down.value:
        if not state["down"]:
            kbd.press(Keycode.S)
            state["down"] = True
    else:
        if state["down"]:
            kbd.release(Keycode.S)
            state["down"] = False

    if not joy_left.value:
        if not state["left"]:
            kbd.press(Keycode.A)
            state["left"] = True
    else:
        if state["left"]:
            kbd.release(Keycode.A)
            state["left"] = False

    if not joy_right.value:
        if not state["right"]:
            kbd.press(Keycode.Z)
            state["right"] = True
    else:
        if state["right"]:
            kbd.release(Keycode.Z)
            state["right"] = False

    if not joy_button.value:
        if not state["button"]:
            kbd.press(Keycode.SPACE)
            state["button"] = True
    else:
        if state["button"]:
            kbd.release(Keycode.SPACE)
            state["button"] = False

    time.sleep(0.01)
