'-----------------------------------------------------------
'Varanus Camper Web Interface
' for ESP8266 Annex Basic 1.39b3
' Example of checkbox styling using CSS
' sw_22rc2.bas
' - stable, refresh updates battery values and switch values
' info from https://paulund.co.uk/style-checkboxes-with-css
'-----------------------------------------------------------
' define the variables that are used for the output pins
fridge = 0 
pump = 0
lights = 0
sockets = 0
batVolts$="12.75V"
chargeAmps$="2.5A"
loadAmps$="4.25A"
batAmps$="-1.75A"
i=1  'loop counter
A$ = "" ' initial clean out of A$ and sw$
sw$ = ""
MM_sw$=""
MM_sw_stat=0
col_neg$ = "background-color:red;color:white;"
col_pos$ = "background-color:green;color:white;"
col_warn$ = "background-color:yellow;color:red;"
'---------------
'begin main code
onHtmlChange pinChange ' detect the check on the switch
onSerial MM_Serial  ' handle serial input from MM
onHtmlReload main ' just back here on a reload
gosub main ' draw the page
Autorefresh 1000
print "?" ' send status update request to MM for initial data
wait ' loop on input click

main: ' this is the html code for the page
cls
A$ = |<html>|
A$ = A$ + |<head> |
A$ = A$ + |</head> |
A$ = A$ + |<body>|
'--- all styling of elements in here
A$ = A$ + |<style>|
A$ = A$ +   |header {|
A$ = A$ +    | background-color: #a0a0a0;|
A$ = A$ +    | color: white; |
A$ = A$ +    | text-align: center; |
A$ = A$ +    | font-family: Times, serif; |
A$ = A$ +    |}|
'-------------
A$ = A$ + |.flex-container1 {| ' for switches
A$ = A$ + |  display: flex;|
A$ = A$ + |  flex-flow: row;|
A$ = A$ + |  background-color: #a0a0a0;|
A$ = A$ + |  justify-content: center;|
A$ = A$ + |  justify-content: space-around;|
A$ = A$ + |  align-items: center;|
A$ = A$ + |}|
A$ = A$ + |.flex-container1 > div {|
A$ = A$ + |  background-color: #f1f1f1;|
A$ = A$ + |  width: 84px;|
A$ = A$ + |  margin: 2px;|
A$ = A$ + |  text-align: center;|
A$ = A$ + |  line-height: 30px;|
A$ = A$ + |  font-size: 18px;|
A$ = A$ + |  font-family: Arial,Helvetica, sans-serif; |
A$ = A$ + |}|
A$ = A$ + |.flex-container2 {| ' for battery values
A$ = A$ + |  display: flex;|
A$ = A$ + |  flex-flow: row;|
A$ = A$ + |  background-color: #b0b0a0;|
A$ = A$ + |  justify-content: center;|
A$ = A$ + |  justify-content: space-around;|
A$ = A$ + |  align-items: center;|
A$ = A$ + |}|
A$ = A$ + |.flex-container2 > div {|
A$ = A$ + |  background-color: #e1e1f1;|
A$ = A$ + |  width: 75px;|
A$ = A$ + |  margin: 2px;|
A$ = A$ + |  text-align: center;|
A$ = A$ + |  line-height: 20px;|
A$ = A$ + |  font-size: 16px;|
A$ = A$ + |  font-family: Arial,Helvetica, sans-serif; |
A$ = A$ + |}|
A$ = A$ + ||
'------------
A$ = A$ + |input[type=checkbox] {| ' hide behind switch label
A$ = A$ + |  visibility: hidden;|
A$ = A$ + |}|
'-----------
A$ = A$ + |input { |
A$ = A$ +   | background-color: #d0d0d0;|
A$ = A$ +   | font-size: 14px;|
A$ = A$ +   | width: 75px;|
A$ = A$ +   | text-align: center; |
A$ = A$ +   | font-family: Arial,Helvetica, sans-serif; |
A$ = A$ +  |}|
'-----------
A$ = A$ +  |.bat_vars {| ' block that switch is in
A$ = A$ + |  background-color: #e1e1f1;|
A$ = A$ +   | text-align: center; |
A$ = A$ +   | font-size: 16px;|
A$ = A$ +  |}|
'-----------
A$ = A$ +  |.sw_vars {| ' block that switch is in
A$ = A$ +   | background-color: #d0d0d0;|
A$ = A$ +   | text-align: center; |
A$ = A$ +   | font-size: 18px;|
A$ = A$ +  |}|
'----------
' central block for switches
A$ = A$ + |.switchesBox {|
A$ = A$ +   | background-color: #a0a0a0;|
A$ = A$ +   | border: 2px solid black; |
A$ = A$ + |}|
'----------
' background switch housing
A$ = A$ + |.sliderSW {|
A$ = A$ +   | width: 80px;|
A$ = A$ +   | height: 40px;|
A$ = A$ +   | background: #555;|
A$ = A$ +   | margin: 2px 2px;|
A$ = A$ +   | border-radius: 40px;|
A$ = A$ +   | position: relative;|
A$ = A$ +   |}|
'----------
A$ = A$ + |.sliderSW:before {|
A$ = A$ +   |  content: 'On';|
A$ = A$ +   |  position: absolute;|
A$ = A$ +   |  top: 5px;|
A$ = A$ +   |  left: 10px;|
A$ = A$ +   |  height: 2px;|
A$ = A$ +   |  color: #00f000;|
A$ = A$ +   |  font-size: 16px;|
A$ = A$ +   |}|
'---------
A$ = A$ + |.sliderSW:after {|
A$ = A$ +   | content: 'Off';|
A$ = A$ +   | position: absolute;|
A$ = A$ +   | top: 5px;|
A$ = A$ +   | left: 48px;|
A$ = A$ +   | height: 2px;|
A$ = A$ +   | color: #f00000;|
A$ = A$ +   | font-size: 16px;|
A$ = A$ +   |}|
'---------
' details of the slider
A$ = A$ + |.sliderSW label {|
A$ = A$ +   | display: block;|
A$ = A$ +   | width: 40px;|
A$ = A$ +   | height: 32px;|
A$ = A$ +   | border-radius: 30px;|
A$ = A$ +   | -webkit-transition: all .5s ease;|
A$ = A$ +   | -moz-transition: all .5s ease;|
A$ = A$ +   | transition: all .5s ease;|
A$ = A$ +   | cursor: pointer;|
A$ = A$ +   | position: absolute;|
A$ = A$ +   | top: 4px;|
A$ = A$ +   | z-index: 1;|
A$ = A$ +   | left: 5px;|
' set off colour
A$ = A$ +   | background: #e00000;|
A$ = A$ +   |}|
'--------------
' slider when set on
A$ = A$ + |.sliderSW input[type=checkbox]:checked + label {|
A$ = A$ +   | left: 35px;|
' set on colour of switch
A$ = A$ +   | background: #00f000;|
A$ = A$ +   |}|
A$ = A$ + |</style>|
'-----------
' now we set up the page
A$ = A$ + |<header> |
A$ = A$ + |  <p><h3>VARANUS Camper Interface</h3></p>|
A$ = A$ + |  <p><h5>Ver: sw_22rc2.bas</h5></p>|
A$ = A$ + |</header>|
A$ = A$ + |<p></p>|
A$ = A$ + |<div class="flex-container1">|
A$ = A$ + |  <div>|
A$ = A$ + |    <section class="sw_pos">|
A$ = A$ + |      Sockets|
A$ = A$ + |      <div class="sliderSW">|
A$ = A$ +          checkbox$(sockets, "check4")
A$ = A$ + |        <label for="check4"></label>|
A$ = A$ + |      </div>|
A$ = A$ + |    </section>|
A$ = A$ + |  </div>|
A$ = A$ + |  <div>|
A$ = A$ + |    <section class="sw_pos">|
A$ = A$ + |      Fridge|
A$ = A$ + |      <div class="sliderSW">|
A$ = A$ +          checkbox$(fridge, "check1")
A$ = A$ + |        <label for="check1"></label>|
A$ = A$ + |      </div>|
A$ = A$ + |    </section>|
A$ = A$ + |  </div>|
A$ = A$ + |  <div>|
A$ = A$ + |    <section class="sw_pos">|
A$ = A$ + |      Lights|
A$ = A$ + |      <div class="sliderSW">|
A$ = A$ +          checkbox$(lights, "check3")
A$ = A$ + |        <label for="check3"></label>|
A$ = A$ + |      </div>|
A$ = A$ + |    </section>|
A$ = A$ + |  </div>|
A$ = A$ + |  <div>|
A$ = A$ + |    <section class="sw_pos">|
A$ = A$ + |      Pump|
A$ = A$ + |      <div class="sliderSW">|
A$ = A$ +          checkbox$(pump, "check2")
A$ = A$ + |        <label for="check2"></label>|
A$ = A$ + |      </div>|
A$ = A$ + |    </section>|
A$ = A$ + |  </div>|
A$ = A$ + |</div>|
A$ = A$ + |<p></p>|
A$ = A$ + |<div><p></p></div>|
A$ = A$ + |<div class="flex-container2">|
A$ = A$ + |  <div>|
A$ = A$ + |    Battery<br>Volts|
A$ = A$ + |    <section class="bat_vars" id="bv">|
A$ = A$ +        textbox$(batVolts$,"bv")
A$ = A$ +        cssid$("bv",col_pos$)
A$ = A$ + |    </section>|
A$ = A$ + |  </div>|
A$ = A$ + |  <div>|
A$ = A$ + |    Charge<br>Amps|
A$ = A$ + |    <section class="bat_vars" id="ca">|
A$ = A$ +        textbox$(chargeAmps$,"ca")
A$ = A$ +        cssid$("ca",col_pos$)
A$ = A$ + |    </section> |
A$ = A$ + |  </div>|
A$ = A$ + |  <div>|
A$ = A$ + |    Load<br>Amps|
A$ = A$ + |    <section class="bat_vars" id="da">|
A$ = A$ +        textbox$(loadAmps$,"da")
A$ = A$ +        cssid$("da",col_pos$)
A$ = A$ + |    </section> |
A$ = A$ + |  </div>|
A$ = A$ + |  <div>|
A$ = A$ + |    Battery<br>Amps|
A$ = A$ + |    <section class="bat_vars" id="ba">|
A$ = A$ +        textbox$(batAmps$,"ba")
A$ = A$ +        cssid$("ba",col_pos$)
A$ = A$ + |    </section> |
A$ = A$ + |  </div>|
A$ = A$ + |</div>|
A$ = A$ + |</body>|
A$ = A$ + |</html>|
html A$
A$ = ""   ' this cleans memory 
return ' end of main subroutine

pinChange:
  refresh
  ' for remote MM
  sw_stat$=""
  sw$ = HtmlEventVar$
  select case sw$
    case "fridge":
      sw_stat$ = "F" + str$(fridge,"%1u",1)
    case "pump":
      sw_stat$ = "P"+str$(pump,"%1u",1)
    case "lights":
      sw_stat$ = "L"+str$(lights,"%1u",1)
    case "sockets":
      sw_stat$ = "S"+str$(sockets,"%1u",1)
    case "web_client":
      sw_stat$ = "W"+str$(web_client,"%1u",1)
  end select
  wlog "Switch status : ",sw_stat$
  print sw_stat$ ' out serial port to MM
return

MM_Serial:
  Rcvd$ = ""
  do while Serial.Len <> 0
    Rcvd$ = Rcvd$ + Serial.CHR$
  loop
  wlog "Update from MM",Rcvd$
  ' process all variables from MM
  for i = 1 to word.count(Rcvd$,",")
    MM_sw_field$ = word$(Rcvd$,i,",")
    MM_sw$ = left$(MM_sw_field$,1) ' event
    MM_val$ = right$(MM_sw_field$,len(MM_sw_field$)-1)
    MM_sw_stat = val(right$(MM_sw_field$,len(MM_sw_field$)-1)) ' value
    select case MM_sw$
      case "S":
        sockets = MM_sw_stat
      case "L":
        lights = MM_sw_stat
      case "F":
        fridge = MM_sw_stat
      case "P":
        pump = MM_sw_stat
      case "V":
        batVolts$ = str$(MM_sw_stat,"%2.2f")+"V"
        if MM_sw_stat < 12 then
          css cssid$("bv",col_neg$)
        endif
        if (MM_sw_stat >= 12) AND (MM_sw_stat < 12.4) then
          css cssid$("bv",col_warn$)
        endif
        if MM_sw_stat >= 12.4 then
          css cssid$("bv",col_pos$)
        endif          
      case "C":
        chargeAmps$ = str$(MM_sw_stat,"%2.2f")+"A"
        css cssid$("ca",col_pos$)
      case "D":
        loadAmps$ = str$(MM_sw_stat,"%2.2f")+"A"
        css cssid$("da",col_neg$)
      case "B":
        batAmps$ = str$(MM_sw_stat,"%2.2f")+"A"
        if left$(batAmps$,1) = "-" then
          css cssid$("ba",col_neg$)
        else
          css cssid$("ba",col_pos$)
        endif
    end select
  next i
  Rcvd$ = Serial.INPUT$ ' clear out any junk
  refresh
return
'end
