
float[] volts,amps;
int np, pwm;
float vknee, vmax, imax,gr, pmax;

float pwr, old_pwr;
int pwm_dir, nsamples, sample_count, old_pwm,error_count;

float sx,sy,ox,oy,sy2;

float mppt_error[];

void setup()
  {
  np = 800;      // the number of pwm steps    
  volts = new float[np];
  amps = new float[np];
  mppt_error = new float[100];
  
  pwm = 75;      // just start somewhere
  
  vmax = 50.0;
  vknee = 40.0;
  imax = 10.0;
  
  gr = 0.3;    // random (+/- this) is added to amps
  nsamples = 5;
  sample_count=0;
  error_count = 0;
  
  pwr = 0.0;
  old_pwm = 0;

  
  size(800,800);
  ox = 0.1 * width;
  oy = 0.7 * height;
  sx = 0.8 * width;
  sy = -0.6 * height;
  sy2 = 0.25 * height;
  init();
  draw_it();
  
  old_pwr = 0.0;
  
  }
  
void init()
  {
  int i,k;
  float v,kv,t;
  pmax = 0.0;
  for (i=0; i < np; i++)
    {

      v = 50.0 * (float)(i)/(float)(np-1);
      if (v < vknee)
        amps[i] = imax ;
      else
        {
          t = (vmax - v)/(vmax - vknee);
          kv = cos((1.0 - t)*3.14159*0.5);         
          amps[i] = kv * imax ;
        }
      volts[i] = v;  
      if (pmax < (volts[i]*amps[i])) pmax = volts[i]*amps[i];
    }
  }
  
void draw_it()
  {
    int i,k;
    background(0);
    
    float x,y,x2,y2;
    stroke(255,0,0);
    line(ox,oy,ox,oy+sy);
    line(ox,oy+sy,ox+sx,oy+sy);
    line(ox+sx,oy+sy,ox+sx,oy);
    line(ox+sx,oy,ox,oy);   
    
    stroke(255,0,255);
    line(ox,oy,ox,oy+sy2);
    line(ox,oy+sy2,ox+sx,oy+sy2);
    line(ox+sx,oy+sy2,ox+sx,oy);
    line(ox+sx,oy,ox,oy);   
    line(ox,oy + sy2/2.0,ox+sx,oy+sy2/2.0);
    text("+5%",ox-25,oy+5);
    text("-5%",ox-25,oy+5+sy2);
    text("0",ox-25,oy+5+sy2/2.0);
    stroke(0,255,0);
    x2=0;
    y2=0;
    for(i=0,k=0; i < np; i++)
      {
        x = ox + sx * 0.9 * (float)(i)/(float)np;
        y = oy + sy * 0.9 * (random(-gr,gr) + amps[i])/imax; 
        if(k == 0)
          {
            k=1;
            line(x,y,x,y);
          }
        else
            line(x2,y2,x,y);
        x2=x;
        y2=y;
      }
    stroke(0,255,255);  
    x2=0;
    y2=0;
    for(i=0,k=0; i < np; i++)
      {
        x = ox + sx * 0.9 * (float)(i)/(float)np;
        y = oy + sy * 0.9 * ((random(-gr,gr) + amps[i])/imax)*(volts[i]/vmax); 
        if(k == 0)
          {
            k=1;
            line(x,y,x,y);
          }
        else
            line(x2,y2,x,y);
        x2=x;
        y2=y;
      }  
    stroke(0,160,200);
    for (i=0,k=0,x2=0.0,y2=0.0; i < 100; i++)
      {
        x = ox + sx * (float)(i)/100.0;
        y = oy + sy2 * mppt_error[i];
        if(k == 0)
          {
            k=1;
            line(x,y,x,y);
          }
        else
            line(x2,y2,x,y);
        x2=x;
        y2=y;
      }
    x = 0.0;
    for (i=0; i < 100; i++)
      x += (mppt_error[i]-0.5) * (mppt_error[i] - 0.5);
    x = sqrt(x);
    text("RMS error " + x + " %",ox + 100, oy + 30);
}

void draw()
  {
   float x,y; 
    int i = 5;    
   // perturb and observe
   // A naive approach - works with noise free data
   // but NFG when there is noise. So multiply sample it and average.
   //
   //
   pwr += volts[pwm] * (amps[pwm] + random(-gr,gr));
   
   sample_count ++;
   if (sample_count >= nsamples)
     {
     pwr  = pwr / (float) sample_count;
     
     // has it increased since last time? if so, keep increasing voltage (or pwm, same thing)
     if (pwr > old_pwr)
       {
           if ( pwm > old_pwm)
             pwm_dir = +i;
           else
             pwm_dir = -i;
     }
     else
       {
       if ( pwm > old_pwm)
             pwm_dir = -i;
           else
             pwm_dir = +i;
         
       }
     // alter the voltage as required 
     old_pwm = pwm;
     pwm += pwm_dir;
     // print(pwr); print("  "); print(old_pwr);print("  ");print(pwm); print ("  "); println(old_pwm);  
     // and record the current operating power for next time through the loop
     old_pwr = pwr; 

     mppt_error[error_count] = 0.5 + 10.0 * (pwr - pmax)/pmax;
     //mppt_error[error_count] = 0.5 + 10.0 * 0.049;
     if (mppt_error[error_count] > 1.0) mppt_error[error_count] = 1.0;
     if (mppt_error[error_count] < 0.0) mppt_error[error_count] = 0.0;
          
     error_count++;
     if (error_count >= 100)
       error_count = 0;
       
     if (pwm < 1) pwm = 1;
     if (pwm >= np) pwm = np-1;
     pwr = 0.0;
     sample_count = 0;
     }
     
   // draw a cross where pwm is (i.e. operating voltage)  
   draw_it();
   stroke(255,255,0);
   x = ox + sx * 0.9 * (float)(pwm)/(float)np;
   y = oy + sy * 0.9 * (amps[pwm]/imax)*(volts[pwm]/vmax); 
   line(ox,y,x+8,y);
   line(x,oy,x,y-8);
 
  }
    
    
  void keyReleased() 
  {
  if (key == 'n')
    gr *= 0.7;
  if (key == 'N')
    gr *= 1.5;
  if (key == 'k')
    vknee -= 5.0;
  if (key == 'K')
    vknee += 5.0;
  if (key == 'z')
    pwm = 10;
  init();
  }  
