10 ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
20 ' LCD driver for standard 16 x 2 LCDs
30 ' Originally by Geoff Graham, March 2011,  
40 ' Modified for Arduino by Mick Gulovsen July 2011
43 '
45 ' For example:  futurlec.com       LCD16X2
50 '               altronics.com.au   Z7001
60 '               jaycar.com.au      QP5512
70 '
80 ' To use:
90 '  - execute GOSUB 5000 to initialise display and Maximite
100 '  - then load the text strings into the
110 '    variables LCD_line1$ and LCD_line2$
120 '  - execute GOSUB 12000 to display the text
125 '  - To send an LCD Command load Variable LCD with the Command byte
130 '  - Execute GOSUB 6000
135 '  - To send a character to the LCD load Variable LCD with the Character byte
137 '  - Execute GOSUB 7000
138 '
140 ' See the file lcd.pdf for the schematic.
150 ' Maximite pin 19 is RS, pin 20 is EN
160 ' pins 15 to 18 are D4 to D7.  R/W is grounded
200 ' Define Variables and pin Numbers 
210 RS=19 : EN=20 : D4=15 : D5=16 : D6=17 : D7=18
220 GOSUB 5000 ' Initialise Display and Maximite
225 LCD_line1$ = "  *Dontronics*  "
230 LCD_line2$ = " DonDuino Cross "
300 GOSUB 12000
400 PAUSE 5000
410 LCD = &B00000001 : GOSUB 6000     ' clear display
413 GOSUB 4000:                       ' Get Keypress Status
415 PRINT pin(1):GOSUB 12000: PAUSE 500    ' display on Console the voltage read for Keypress .. delay 0.5 sec
420 goto 413
500 END
4000 IF PIN(1) < .2 THEN LCD_line1$=" Right           ": RETURN
4010 IF PIN(1) < 1 THEN LCD_line1$=" Up               ": RETURN
4020 IF PIN(1) < 1.6 THEN LCD_line1$=" Down           ": RETURN
4030 IF PIN(1) < 2.2 THEN LCD_line1$=" Left           ": RETURN
4040 IF PIN(1) < 2.91 THEN LCD_line1$=" Select         ": RETURN
4050 LCD_line1$=" None           ": RETURN
5000 ' -----------------------------------------------------------------
5010 'Initialise the LCD
5020 SETPIN 1,1: SETPIN D4,8:SETPIN D5,8:SETPIN D6,8:SETPIN D7,8:SETPIN EN,8:SETPIN RS,8
5030 LCD = &B0011 : GOSUB 6000        ' reset
5040 LCD = &B0011 : GOSUB 6000        ' reset
5050 LCD = &B0011 : GOSUB 6000        ' reset
5060 LCD = &B0010 : GOSUB 6000        ' 4 bit mode
5070 LCD = &B00101100 : GOSUB 6000      ' 4 bit, 2 lines
5080 LCD = &B00001100 : GOSUB 6000     ' display on, no cursor
5090 LCD = &B00000110 : GOSUB 6000     ' increment on write
5100 LCD = &B00000001 : GOSUB 6000     ' clear display
5110 RETURN
6000 ' ------------------------------------------------------------------
6005 ' Send Command Byte
6010 PIN(RS)=0 : PIN(EN)=0 : delay=5          
6020 GOSUB 13000                     ' send byte
6030 RETURN
7000 '-------------------------------------------------------------------
7005 ' Send Data Byte
7010 PIN(RS)=1 : delay=1              
7020 GOSUB 13000                     ' send byte
7030 RETURN
12000 '------------------------------------------------------------------
12010 ' send the two lines to the LCD
12020 ' the text is in LCD_line1$ and LCD_line2$
12030 '
12040 LCD = &H80 : GOSUB 6000          ' select the 1st line
12050 FOR X= 1 TO 16
12060     LCD = ASC(MID$(LCD_line1$, X, 1))
12070     GOSUB 7000           ' send the character
12080 NEXT X
12090 LCD = &B11000000 : GOSUB 6000    ' select the 2nd line
12100 FOR X = 1 TO 16
12110     LCD = ASC(MID$(LCD_line2$, X, 1))
12120     GOSUB 7000           ' send the character
12130 NEXT X
12140 RETURN
12150 '
12160 '
13000 '-----------------------------------------------------------------
13010 ' Send a byte to the LCD
13020 ' the data to be sent is in LCD
13030 '
13040 PIN(D4) = LCD AND &B00010000      ' output the 1st 4 bits
13050 PIN(D5) = LCD AND &B00100000
13060 PIN(D6) = LCD AND &B01000000
13070 PIN(D7) = LCD AND &B10000000
13080 PIN(EN) = 1 : PAUSE 1:PIN(EN) = 0 : PAUSE DELAY      ' tell lcd to accept data
13090 ' Entry point to send just 4 bits to the LCD
13100 PIN(D4) = LCD AND &B00000001      ' output the 2nd 4 bits
13110 PIN(D5) = LCD AND &B00000010
13120 PIN(D6) = LCD AND &B00000100
13130 PIN(D7) = LCD AND &B00001000
13140 PIN(EN) = 1 : PAUSE 1: PIN(EN) = 0 : PAUSE DELAY:  ' tell lcd to accept data
13150 RETURN

