' PicoPong for PicoMite 2350 HDMI/VGA  v0.09
' by twofingers/6-2025
' ----------------------------------------------------
'Option AUDIO GP10, GP11
Option default float
Option explicit
Option KEYBOARD repeat 300,50 'default for USB-KB: 600,150

MODE 3

Const TRUE=1, FALSE= TRUE=0
Const DEBUG        = FALSE
Const FW=MM.Info(FONTWIDTH), FH=MM.Info(FONTHEIGHT)
Const HRES         = MM.HRES '480
Const VRES         = MM.VRES '640

Const PD_SPEED = 12
Const PD_WIDTH = 10
Dim   PD_HEIGHT As integer = 60

Const BALL_SIZE    = 10
Const BALL_SPEED   = 8

Const C_BG         = RGB(black)
Const BC           = RGB(black)
Const C_PD_L       = RGB(red)
Const C_PD_R       = RGB(cyan)
Const C_BALL       = RGB(magenta)
Const C_TEXT       = RGB(yellow)
Const C_LINE       = RGB(white)
Const FC           = RGB(white)

Dim String k$,cUp$=Chr$(128),cDn$=Chr$(129),Esc$=Chr$(27),F1$=Chr$(145)

Dim float leftY    = VRES /2 -PD_HEIGHT/2
Dim float rightY   = VRES /2 -PD_HEIGHT/2
Dim float ballX    = HRES /2 -BALL_SIZE/2
Dim float ballY    = VRES *Rnd
Dim float ballDX   = BALL_SPEED
Dim float ballDY   = BALL_SPEED
Dim integer i,soundOn%=FALSE

Dim scoreL% = 0
Dim scoreR% = 0
Dim pdDataL%(PD_WIDTH * PD_HEIGHT - 1)
Dim pdDataR%(PD_WIDTH * PD_HEIGHT - 1)
Dim ballData%(BALL_SIZE * BALL_SIZE - 1)

Dim hMask%(PD_WIDTH - 1)

loadSprites()
drawField()

Sprite SHOW #1, 0,leftY,2
Sprite SHOW #2, HRES -PD_WIDTH, rightY,2,1
Sprite SHOW #3, ballX, ballY, 1

SetTick 40, BallMove
SetTick 90, Opponent,2
k$ = "p"

Do
  If k$ = "p" Then
    SetTick pause, BallMove
    SetTick pause, Opponent,2
    Text HRES /2, 35*FH, "Press any key", "CT",3 ,1, RGB(cerulean)
    Do :Loop While Inkey$=""
    SetTick resume, BallMove
    SetTick resume, Opponent,2
    drawField(): k$ = cUp$
  EndIf
  If k$ = cUp$ Then
    leftY = Max(0,leftY -PD_SPEED)
    Box 0, 0,20, VRES, 0,, C_BG
    Sprite SHOW #1, 0, leftY, 2
  ElseIf k$ = cDn$ Then
    leftY = Min(VRES -PD_HEIGHT,leftY +PD_SPEED)
    Box 0, 0,20, VRES, 0,, C_BG
    Sprite SHOW #1, 0, leftY, 2
  EndIf
  If k$ = F1$ Then showHelp()
  If k$ = "t" Then soundOn%=(soundOn%=FALSE)
  If k$ = "s" Then Save image "b:PrScr"
  If k$ = Esc$ Then gameOver()
  k$ = Inkey$
Loop '*********** Main loop (s. Settick) ************

Sub showHelp()
  Text HRES/2,10*FH, "  Cursor up = Paddle up  ", "CT", 3, 1, C_LINE
  Text HRES/2,13*FH, "Cursor down = Paddle down", "CT", 3, 1, C_LINE
  Text HRES/2,16*FH, "'t' = Sound on/off", "CT", 3, 1, C_LINE
  Text HRES/2,19*FH, " 's' = Screenshot   ", "CT", 3, 1, C_LINE
  Text HRES/2,22*FH, "    'p' = pause  ", "CT", 3, 1, C_LINE
  Text HRES/2,25*FH, " Esc = Exit", "CT", 3, 1, C_LINE
  Do :Loop While Inkey$=""
  CLS
  drawField()
  Sprite SHOW #1, 0, leftY, 2
End Sub

Sub loadSprites
Local integer x,y,idx,col,bit
 hMask%( 0)=&H0
 hMask%( 1)=&H0
 hMask%( 2)=&H0
 hMask%( 3)=&H0
 hMask%( 4)=&H800000000000001
 hMask%( 5)=&HC00000000000003
 hMask%( 6)=&HF8000000000001F
 hMask%( 7)=&HFFC0000000003FF
 hMask%( 8)=&HFFFFC000003FFFF
 hMask%( 9)=&HFFFFFF801FFFFFF

 For x = 0 To PD_WIDTH -1'paddles
   For y = 0 To PD_HEIGHT -1
     idx = y * PD_WIDTH +x
     bit = (hMask%(x) >> (PD_HEIGHT -1-y)) And 1
     pdDataL%(idx) = Choice(bit,RGB(GOLD),C_PD_L)
     pdDataR%(idx) = Choice(bit,RGB(BLUE),RGB(BLUE))
   Next y
 Next x
 For y = 0 To BALL_SIZE-1'ball
   For x = 0 To BALL_SIZE-1
     ballData%(y * BALL_SIZE +x)=Choice(Sqr((x -(BALL_SIZE -1)/2)^2 +(y -(BALL_SIZE -1)/2)^2) <=BALL_SIZE/2,C_BALL, C_BG)
   Next
 Next

 Sprite LOADARRAY #1, PD_WIDTH, PD_HEIGHT, pdDataL%()
 Sprite LOADARRAY #2, PD_WIDTH, PD_HEIGHT, pdDataR%()
 Sprite LOADARRAY #3, BALL_SIZE, BALL_SIZE, ballData%()
End Sub

Sub drawField()
  CLS
  Line HRES/2,0, HRES /2, VRES, , C_LINE
  Text HRES/2,40, "PicoPongo", "CT", 3, 1, C_TEXT
  updateScore()
End Sub

Sub updateScore()
  Box 200, 0, 440, 30, 0, C_BG, C_BG
  Text 210, FH, "Player:" +Str$(scoreL%), "LT", , 1, C_PD_L
  Text 370, FH, "Pico:"   +Str$(scoreR%), "LT", , 1, C_PD_R
End Sub

Sub BallMove
  Local nextX, nextY,angleY,radians
  Sprite HIDE #3
  nextX = ballX +ballDX
  nextY = ballY +ballDY
  If nextY < 0 Or nextY >VRES -BALL_SIZE Then
    ballDY = -ballDY
    nextY  = ballY +ballDY
    If soundOn% Then Play TONE 400,400,50'sound hit wall
  EndIf
  If nextX<= PD_WIDTH And nextY +BALL_SIZE >=leftY And nextY <= leftY +PD_HEIGHT Then
    ballDY = AdjustAngle(nextY, leftY)
    radians= Atn(ballDY / BALL_SPEED)
    ballDX = Cos(radians) * BALL_SPEED
    nextX  = ballX+ballDX
    If soundOn% Then Play TONE 600,600,50 'sound paddle left
  End If
  If nextX + BALL_SIZE >= HRES -PD_WIDTH And nextY + BALL_SIZE >= rightY And nextY <= rightY + PD_HEIGHT Then
    ballDY = AdjustAngle(nextY, leftY)
    radians= Atn(ballDY / BALL_SPEED)
    ballDX =-((Cos(radians) * BALL_SPEED))
    nextX  = ballX+ballDX
    If soundOn% Then Play TONE 800,800,50'sound paddle right
  EndIf
  If nextX <0 +BALL_SIZE Then'
    Inc scoreR%
    updateScore()
    resetBall(-1)
    Exit Sub
  EndIf
  If nextX >HRES -BALL_SIZE Then
    Inc scoreL%%
    updateScore()
    resetBall(1)
    Exit Sub
  EndIf
  ballX = nextX
  If ballX>=HRES Then ballX =HRES-1
  ballY = nextY
  Sprite SHOW #3, ballX, ballY, 1
  If DEBUG Then Line ballX, ballY,ballX +BALL_SIZE,ballY +BALL_SIZE,,RGB(red)
End Sub

Sub Opponent
  Local targetY
  targetY =ballY +BALL_SIZE /2 -PD_HEIGHT /2
  If rightY + PD_HEIGHT / 2 < targetY Then
    rightY =Min(VRES - PD_HEIGHT,rightY +PD_SPEED -1)
  ElseIf rightY + PD_HEIGHT / 2 > targetY Then
    rightY =Max(0, rightY - (PD_SPEED -1))
  EndIf
  Box HRES -PD_WIDTH, 0, HRES-1, VRES, 0,, C_BG
  Sprite SHOW #2,HRES -PD_WIDTH, rightY, 2,1
End Sub

Sub resetBall(dir)
Local p,angle,radians
  Pause 200
  ballX = HRES /2
  p     = (VRES-PD_HEIGHT*2)/2*Rnd
  ballY = VRES/2+p*Sgn(Rnd - 0.5)
  angle = (Rnd * 60 - 30)
  If Abs(angle) <5 Then angle =Sgn(angle)*5
  radians = angle * Pi/180
  ballDX = dir * Cos(radians) * BALL_SPEED
  ballDY = Sin(radians) * BALL_SPEED
  Sprite SHOW #3, ballX, ballY, 1
  If soundOn% Then Play TONE 200,200,50    'sound new ball
/*
  Inc PD_HEIGHT,-2
  If PD_HEIGHT<=0 Then gameOver()
  For x = 0 To PD_WIDTH - 1
    For y = 0 To PD_HEIGHT - 1
      idx = y * PD_WIDTH + x
      bit = (hMask%(x) >> (PD_HEIGHT - 1 - y)) And 1
      pdDataL%(idx) = Choice(bit,BC,C_PD_L)
      pdDataR%(idx) = Choice(bit,BC,RGB(BLUE))
    Next y
  Next x
  Sprite close #1
  Sprite close #2
  loadSprites
  Sprite SHOW #1, 0, leftY, 2
  Sprite SHOW #2,HRES -PD_WIDTH, rightY, 2,1
*/
End Sub

Function AdjustAngle(ballYpos, paddleYpos)
Const maxANGLE=75
Local impact, angle, radians
 ' impact: relative hit position from center of paddle (-1.0 to +1.0)
 impact =(ballYpos +BALL_SIZE/2-(paddleYpos+PD_HEIGHT/2))/(PD_HEIGHT/2)
 angle   = impact* maxANGLE
 radians = angle * Pi/180
 AdjustAngle = Sin(radians) * BALL_SPEED
End Function

Sub gameOver()
  SetTick 0,0
  SetTick 0,0,2
  Option KEYBOARD repeat 600,150 'default for USB-KB: 600,150
  Text HRES /2, 20*FH, "Game over!", "CT",3 ,2, RGB(Orange)
  Do :Loop While Inkey$=""
  CLS
  End
End Sub
                             