Option EXPLICIT
Option DEFAULT NONE
Option BASE 0

Const MAX_CHUNK_SIZE% = 128
Const VERSION$ = "0.3"

'DOS specific constants and variables'
If MM.DEVICE$ = "DOS" Then
  Const MAX_NUM_DIRS%=100
  Const MAX_NUM_FILES%=400

  Dim refFile$ = Cwd$ + "\ntsh.temp"
  Dim refFileQuoted$ = Chr$(34) + refFile$ + Chr$(34)

  Dim dirList$(MAX_NUM_DIRS%)
  Dim fileList$(MAX_NUM_FILES%)
  Dim dirListIdx%, fileListIdx%
EndIf

Dim dirToArchive$
Dim recursionLevel% = 0
Dim errno% = 0
Dim cmdLine$

Print "Create Maximite Archive " VERSION$ " by Epsilon"

If MM.DEVICE$ = "DOS" Then
  'If no arguments are passed in, the INSTR below will return 0.
  If Instr(MM.CMDLINE$, " ") = 0 Then
    cmdLine$ =""
  Else
    cmdLine$ = Right$(MM.CMDLINE$, Len(MM.CMDLINE$) - Instr(MM.CMDLINE$, " "))
  EndIf
Else
  cmdLine$ = MM.CMDLINE$
EndIf

'Allow to pass in directory to archive as command line argument
If (cmdLine$ = "") Then
  Input "Directory to archive"; dirToArchive$
Else
  dirToArchive$ = cmdLine$
EndIf

If dirExists%(dirToArchive$) = 0 Then
  Print "Directory not found. Aborting..."
  GoTo EndOfProg
EndIf

Dim outFile$ = dirToArchive$+".mar"

Open outFile$ For OUTPUT As #2

'This is the actual entry point into the archiving logic.
processDir dirToArchive$

Print #2, "ENDARCHIVE:"
Close #2
Print "Done."

EndOfProg:
If errno% <> 0 Then
  Print "errno=" errno%
EndIf

On ERROR SKIP 1
Close #1

On ERROR SKIP 1
Close #2

On ERROR SKIP 1
Close #3

'DOS requires a QUIT or we get stuck on the BASIC prompt.
If MM.DEVICE$ = "DOS" Then
  SYSTEM "DEL " + refFileQuoted$
  QUIT
EndIf

'This function checks if given directory name already exists or not
Function dirExists%(dirName$)
  If MM.DEVICE$ = "DOS" Then
    'DOS MMBasic does not have a DIR$ function :-(
    On ERROR SKIP 1
    SYSTEM "IF exist " + Chr$(34) + dirName$ + Chr$(34) +  " (echo 1 > " + refFileQuoted$ + ") ELSE (echo 0 > " + refFileQuoted$ + ")"
    Open refFile$ For INPUT As #3
    Local res$
    res$ = Input$(1, #3)
    Close #3
    dirExists% = (res$ = "1")
  Else
    dirExists% = (Dir$(dirName$, DIR) <> "")
  EndIf
End Function

'This function checks if given file name already exists or not
Function fileExists%(fileName$)
  If MM.DEVICE$ = "DOS" Then
    'DOS MMBasic does not have a DIR$ function :-(
    On ERROR SKIP 1
    SYSTEM "DIR /a:-d /b " + Chr$(34) + fileName$ + Chr$(34) + "> " + refFileQuoted$
    Open refFile$ For INPUT As #3
    Local line$
    Line Input #3, line$
    Close #3
    fileExists% = (line$ <> "")
  Else
    fileExists% = (Dir$(fileName$, FILE) <> "")
  EndIf
End Function

'This function starts an iteration over all sub directories in the current directory.
Function listDirs$()
  If MM.DEVICE$ = "DOS" Then
    'DOS MMBasic does not have a DIR$ function :-(
    On ERROR SKIP 1
    SYSTEM "DIR /a:d /b > " + refFileQuoted$
    Open refFile$ For INPUT As #3
    dirListIdx%=0
    Local line$
    Do While Not Eof(#3)
      Line Input #3, line$
      dirList$(dirListIdx%) = line$
      dirListIdx% = dirListIdx% + 1
    Loop
    'Fill remainder of dirList with empty.
    Do While dirListIdx% <= MAX_NUM_DIRS%
      dirList$(dirListIdx%) = ""
      dirListIdx% = dirListIdx% + 1
    Loop
    Close #3

    'Reset index into array
    dirListIdx% = 0
    'Return first item
    listDirs$ = nextDir$()
  Else
    'It can be so easy...
    listDirs$ = Dir$("*", DIR)
  EndIf
End Function

'This function starts an iteration over all files in the current directory.
Function listFiles$()
  If MM.DEVICE$ = "DOS" Then
    'DOS MMBasic does not have a DIR$ function :-(
    On ERROR SKIP 1
    SYSTEM "DIR /a:-d /b > " + refFileQuoted$
    Open refFile$ For INPUT As #3
    fileListIdx%=0
    Local line$
    Do While Not Eof(#3)
      Line Input #3, line$
      fileList$(fileListIdx%) = line$
      fileListIdx% = fileListIdx% + 1
    Loop
    'Fill remainder of fileList with empty.
    Do While fileListIdx% <= MAX_NUM_FILES%
      fileList$(fileListIdx%) = ""
      fileListIdx% = fileListIdx% + 1
    Loop
    Close #3

    'Reset index into array
    fileListIdx% = 0
    'Return first item
    listFiles$ = nextFile$()
  Else
    'It can be so easy...
    listFiles$ = Dir$("*", FILE)
  EndIf
End Function

'Returns next directory in the iteration.
Function nextDir$()
  If MM.DEVICE$ = "DOS" Then
    Local exitLoop% = 0
    Local line$
    Do While exitLoop% = 0
      Line $ = dirList$(dirListIdx%)
      Select Case line$
        Case "."
          dirListIdx% = dirListIdx% + 1
        Case ".."
          dirListIdx% = dirListIdx% + 1
        Case ""
          exitLoop% = 1
        Case Else
          exitLoop% = 1
          dirListIdx% = dirListIdx% + 1
      End Select
    Loop

    If dirListIdx% >= MAX_NUM_DIRS% Then
      Print "Max. num. dirs exceeded. Aborting..."
      errno% = 1
      Exit Function
    EndIf

    nextDir$ = line$
  Else
    nextDir$ = Dir$()
  EndIf
End Function

'Returns next file in the iteration.
Function nextFile$()
  If MM.DEVICE$ = "DOS" Then
    Local exitLoop% = 0
    Local line$
    Do While exitLoop% = 0
      Line $ = fileList$(fileListIdx%)
      Select Case line$
        Case "."
          fileListIdx% = fileListIdx% + 1
        Case ".."
          fileListIdx% = fileListIdx% + 1
        Case ""
          exitLoop% = 1
        Case Else
          exitLoop% = 1
          fileListIdx% = fileListIdx% + 1
      End Select
    Loop

    If fileListIdx% >= MAX_NUM_FILES% Then
      Print "Max. num. files exceeded. Aborting..."
      errno% = 1
      Exit Function
    EndIf

    nextFile$ = line$
  Else
    nextFile$ = Dir$()
  EndIf
End Function

'This subroutine processes the contents of given file to add to the archive.
Sub processFile(fileToProcess$)
  Local filetoProcess_l$ = fileToProcess$

  Print Space$(recursionLevel%*2) "Processing file " fileToProcess_l$

  'Header
  Print #2, "FILE: " fileToProcess_l$
  Open fileToProcess_l$ For INPUT As #1

  Print #2, Lof(#1)

  Local chunkLen% = 0, inFileLoc% = 0
  Local chunk$

  'Contents
  Do While Not Eof(#1)
    chunkLen% = Min(Lof(#1)-inFileLoc%, MAX_CHUNK_SIZE%)
    If chunkLen%>0 Then 'file with len = 0
      inFileLoc% = inFileLoc% + chunkLen%
      chunk$ = Input$(chunkLen%, #1)
    Else
      chunk$=""
    EndIf
    Print #2, chunk$;
  Loop

  Close #1
End Sub

'This subroutine processes the contents of given directory to add to the archive.
Sub processDir(dirToProcess$)
  recursionLevel% = recursionLevel% + 1

  Local dirToProcess_l$ = dirToProcess$

  Print Space$(recursionLevel%*2) "Processing dir " dirToProcess_l$

  Print #2, "DIR: " dirToProcess_l$

  Chdir dirToProcess_l$

  'Process the files
  Local fileToProcess$ = listFiles$()

  Do While fileToProcess$ <> ""
    processFile fileToProcess$
    fileToProcess$ = nextFile$()
    If errno% <> 0 Then
      GoTo EndOfProg
    EndIf
  Loop

  'Process the subdirs
  Local subDir$ = listDirs$()

  'DIR$/nextDir$ can't handle recursion in this while loop so we have to build a subDir list
  Local numSubDirs% = 0

  'First calculate how many subdirs there are in this directory
  Do While subDir$ <> ""
    numSubDirs% = numSubDirs% + 1
    subDir$ = nextDir$()
    If errno% <> 0 Then
      GoTo EndOfProg
    EndIf
  Loop

  If numSubDirs% >= 1 Then
    'Note: The size of this array is too big by 1 entry
    Local subDirList$(numSubDirs%)

    subDir$ = listDirs$()
    Local listIdx% = 0

    Do While subDir$ <> ""
      subDirList$(listIdx%) = subDir$
      subDir$ = nextDir$()
      If errno% <> 0 Then
        GoTo EndOfProg
      EndIf
      listIdx% = listIdx% + 1
    Loop

    'Now we recurse. For some reason this doesn't work with a while loop,
    'but with a for loop it works just fine.
    For listIdx%=0 To numSubDirs%-1
      processDir subDirList$(listIdx%)
    Next listIdx%
  EndIf

  Print #2, "ENDDIR: " dirToProcess_l$
  Chdir ".."
  recursionLevel% = recursionLevel% - 1
End Sub
                                                                                