  
  OPTION EXPLICIT
  OPTION DEFAULT NONE
  
  
  'VL53LOX laser distance measurement.
  Const I2Caddr1=&H29   'VL53LOX device address, default address
  Const I2Caddr2=&H2A   'VL53LOX device address, 2nd sensor
  const min_d = 100     'threshold distance in mm for green/red change
  const ToF_s1 = mm.info(pinno "GP14") 'Sensor 1 enable pin
  const ToF_s2 = mm.info(pinno "GP15") 'Sensor 2 enable pin
  const IO_Timeout = 100
  
  const tof_range_default = 0, tof_long_range = 1, tof_high_speed = 2, tof_high_accuracy = 3
  dim integer tof_mode
  
  tof_mode = tof_range_default
  
  'event definitions
  const r1_f_n = 1      'r1 far ro near
  const r1_n_f = 2      'r1 near to far
  const r2_f_n = 3      'r2 far ro near
  const r2_n_f = 4      'r2 near to far
  
  'state definitions
  const idle = 0
  const meas = 1
  
  Dim integer idx, stop_variable, state, r1, r2, r1_l, r2_l, evt,stat
  dim integer start_time, time_diff, s1_bg, s2_bg
  dim float f_scale, f_len_mm, f_speed
  dim integer menue_mode
  
  
  'const scale_type = "1"
  'const scale_type = "0"
  'const scale_type = "H0"
  'const scale_type = "TT"
  const scale_type = "N"
  'const scale_type = "Z"
  
  'testdata
  f_len_mm = 100
  
  
  select case scale_type
    case "1"
      f_scale=32
    case "0"
      f_scale=48
    case "H0"
      f_scale=87
    case "N"
      f_scale=160
    case "Z"
      f_scale=220
  end select
  
  cls
  ' startup sequence begin
  ' - disable senors
  
  'Disable sensor 1
  setpin ToF_s1, dout
  pin(ToF_s1) = 0
  
  'Disable sensor 2
  setpin ToF_s2, dout
  pin(ToF_s2) = 0
  
  'setup sensor 1 with changed I2C address
  ' enable sensor 1
  setpin ToF_s1,din
  pause 5   'wait needed to reselect sensor
  
  setI2Caddr(I2Caddr1, I2Caddr2)                'set new I2C address for sensor 1
  stat = init_sensor (1, I2Caddr2, IO_Timeout)  'I2Caddr2 is assogned to sensor index 1
  select_tof_mode (1, tof_mode)                 'set measurement mode to selected mode
  
  ' enable sensor 1
  setpin ToF_s2,din
  pause 5   'wait needed to reselect sensor
  
  stat = init_sensor (2, I2Caddr1, IO_Timeout)  'I2Caddr1 is assogned to sensor index 2
  select_tof_mode (2, tof_mode)                 'set measurement mode to selected mode
  
  
  Font 2
  CLS
  
  text 0,0, "Sensor 1" + "  Sensor 2"       'header line
  
  ' get first measurements to init r1/r2 last values
  r1 = readRangeSingleMM(1)     'read sensor 1, wait until finished
  r2 = readRangeSingleMM(2)     'read sensor 2, wait until finished
  
  r1_l = r1              'save prev distance r1
  r2_l = r2              'save prev distance r2
  
  '+++++++++++++ main program loop +++++++++++++++
  Do

    startRangeSingleMM_bg(1)    'sensor 1, start measurement without wait
    startRangeSingleMM_bg(2)    'sensor 2, ------"----------
    'now the measurements are done in background in the sensors
    
  'display stuff
    text 0, mm.info(fontheight), str$(r1,8),,,,rgb(blue),s1_bg   'display data sensor 1
    text 120, mm.info(fontheight), str$(r2,8),,,,rgb(blue),s2_bg 'display data sensor 2
    text 0, 2*mm.info(fontheight), str$(time_diff,6) + " mSec" 'display time diff
  
  'state handler and display stuff
    select case state
      case idle
        text 11*mm.info(fontwidth), 2*mm.info(fontheight), " Waiting...    "
      case meas
        text 11*mm.info(fontwidth), 2*mm.info(fontheight), " Measuring...  "
    end select
    
    text 0, 3*mm.info(fontheight), str$(f_speed,4,1)+" kmh, Spur " + scale_type 'display speed
    
    if r1 < min_d and r1_l > min_d then   's1 transition to near
      evt = r1_f_n
      s1_bg = rgb(red)
    end if
    
    if r1 > min_d and r1_l < min_d then   's1 transition to far
      s1_bg = rgb(green)
      evt = r1_n_f
    end if
    
    if r2 < min_d and r2_l > min_d then   's2 transition to near
      evt = r2_f_n
      s2_bg = rgb(red)
    end if
    
    if r2 > min_d and r2_l < min_d then   's2 transition to far
      evt = r2_n_f
      s2_bg = rgb(green)
    end if
    
    'event handler and display stuff
    select case evt
      case r1_f_n                   'if s1 interr and
        if state = idle then        'LS 2 is released
          start_time = timer        'start timer
          state = meas              'ready for LS 2 to be interr
        end if
        
      case r1_n_f                  'LS 1 was released
        
      case r2_f_n                  'LS 2 was interrupted
        if state = meas then        'LS 1 was interr before
          time_diff = timer - start_time  'get timer value
          f_speed = f_len_mm/time_diff * 3.6 * f_scale
          state = idle             'idle state
        end if
        
      case r2_n_f                 'LS 2 released
        
    end select
    
    'all display handling is done now with the previouosly measured values
    r1_l = r1              'save prev distance r1
    r2_l = r2              'save prev distance r2
    
    'while updating the display (code above) the new measurement was running on the sensors
    'now get the new readings
    r1 = readRangeSingleMM_wt(1)
    r2 = readRangeSingleMM_wt(2)
    
  Loop
  
  
  