  '
  OPTION EXPLICIT
  OPTION DEFAULT NONE
  
  dim integer test_i, test_j
  dim float test_f, test_g, runtime
  dim string test_s, test_t
  
  dim integer stat
  
  '++++++++++++++ setup eeprom params (24C32) ++++++++++++++++++++++++++++++++++
  const eep_i2c_addr = &H57         'I2C address
  const eeprom_addr_size = 2        'number of bytes used for eeprom address (see datasheet)
  const eeprom_page_size = 32       'size of eeprom write page (see datasheet)
  const eeprom_read_size = 255      'size of eeprom sequential read (see datasheet for possible maximum)
  const err_max = 10                'error retry counter
  const eep_timeout = 0             'timeout value for I2C errors im mSec (can be set to 0)
  '+++++++++++++++ end setup +++++++++++++++++++++++++++++++++++++++++++++++++++

  test_i = 1025
  test_f = pi
  test_s = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz0123456789"
  
' define locations in eeprom
' INTEGER and FLOAT each take 8 bytes
' STRING takes length of string + 1 byte for length

  const string_addr = 0                   'address for string
  const integer_addr = len(test_s)+1      'NOTE: offset = len() + 1 for length byte
  const float_addr = integer_addr + 8     'offset 8
  
  '++++++++++++++++++++++++++ Main +++++++++++++++++++++++++++++++++++++++++++++
  
  '--------------------- write test -------------------------
  
  print "writing float ";test_f;" at address ";float_addr
  timer = 0
  if put_f_eep(test_f, float_addr, eep_i2c_addr) then print "error writing float"
  runtime = timer
  print "write FLOAT runtime "; runtime
  print
    
  print "writing INTEGER ";test_i;" at address ";integer_addr
  timer = 0
  if put_i_eep(test_i, integer_addr, eep_i2c_addr) then print "error writing integer"
  runtime = timer
  print "write INTEGER runtime "; runtime
  print

  print "writing string ";test_s;" at address ";string_addr;" size ";len(test_s)
  timer = 0
  if put_s_eep(test_s, string_addr, eep_i2c_addr) then print "error writing string"
  runtime = timer
  print "write STRING runtime "; runtime
  print
  
  '--------------------- read test -------------------------
  
  timer = 0
  if get_f_eep(test_g, float_addr, eep_i2c_addr) then print "error reading float"
  runtime = timer
  print "read FLOAT runtime "; runtime
  print "read float ";test_g
  print
    
  timer = 0
  if get_i_eep(test_j, integer_addr, eep_i2c_addr) then print "error reading integer"
  runtime = timer
  print "read INTEGER runtime "; runtime
  print "read INTEGER ";test_j
  print

  timer = 0
  if get_s_eep(test_t, string_addr, eep_i2c_addr) then print "error reading string"
  runtime = timer
  print "read STRING runtime "; runtime
  print "String >";test_t;"<"
  print
end
'-------------------- end main -------------------------------------------------

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'++++  ++++++++ Functions to store / retrieve variables in eeprom ++++++++++++++
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  '++++++++++ string functions +++++++++++++++++++++++++++++++++++++++++++++++++
  '
  ' store string into eeprom
  '
function put_s_eep(str_val as string, location as integer, eep_i2c_addr as integer) as integer
  local integer idx, s_size(1)
  
  s_size(0) = peek(var str_val, 0)      'get string length
  local integer t_str(s_size(0))        'create temp array to pass string
  put_s_eep = write_i2c_eeprom(location, 1, s_size(0))   'store string size
  
  for idx = 1 to s_size(0)
    t_str(idx-1) = peek(var str_val, idx)   'get string content from ram
  next idx
  put_s_eep = write_i2c_eeprom(location+1, s_size(0), t_str())  'store sting content
  
end function
  ' -----------------------------
  '
  ' read string from eeprom
  '
function get_s_eep(str_val as string, location as integer, eep_i2c_addr as integer) as integer
  local integer idx, s_size(1)
  
  'get string length
  get_s_eep = read_i2c_eeprom(location, 1, s_size(0))
  poke var str_val, 0, s_size(0)
  
  local integer t_str(s_size(0))        'create temp array to receive string
  
  get_s_eep = read_i2c_eeprom(location+1, s_size(0), t_str())
  for idx = 0 to s_size(0)-1
    poke var str_val, idx+1, t_str(idx)   'restore string to ram
  next idx
  
end function
  ' -----------------------------
  
  '++++++++++ integer functions ++++++++++++++++++++++++++++++++++++++++++++++++++
  '
function put_i_eep(int_val as integer, location as integer, eep_i2c_addr as integer) as integer
  local integer var_parts(8), idx, varadr
  
  for idx = 0 to 7
    var_parts(idx) = peek(var int_val, idx)     'restore value in ram
  next idx
  
  put_i_eep = write_i2c_eeprom(location, 8, var_parts())
  
end function
  ' -----------------------------
  
function get_i_eep(int_val as integer, location as integer, eep_i2c_addr as integer) as integer
  local integer var_parts(8), idx
  
  get_i_eep = read_i2c_eeprom(location, 8, var_parts()) 'read value from eeprom
  
  for idx = 0 to 7
    poke var int_val, idx, var_parts(idx)     'restore value in ram
  next idx
  
end function
  ' -----------------------------
  
  '++++++++++ float functions ++++++++++++++++++++++++++++++++++++++++++++++++++++
  '
function put_f_eep(flt_val as float, location as integer, eep_i2c_addr as integer) as integer
  local integer var_parts(8), idx
  
  for idx = 0 to 7
    var_parts(idx) = peek(var flt_val, idx)
  next idx
  
  put_f_eep = write_i2c_eeprom(location, 8, var_parts())
  
end function
  ' -----------------------------
  
function get_f_eep(flt_val as float, location as integer, eep_i2c_addr as integer) as integer
  local integer var_parts(8), idx
  
  get_f_eep = read_i2c_eeprom(location, 8, var_parts()) 'read value from eeprom
  
  for idx = 0 to 7
    poke var flt_val, idx, var_parts(idx)     'restore value in ram
  next idx
  
end function
  '--------------------------------
  
  '
  '++++++++++++ eeprom functions +++++++++++++++++++++++++++++++++++++++++++++++++
  '
  ' write data to eeprom
  '
function read_i2c_eeprom (eeprom_addr as integer, num_bytes as integer, eeprom_data() as integer) as integer
  
  'eeprom_addr (i) = storage address of data in eeprom
  'num_bytes (I) = number of bytes to be read from eeprom
  'eeprom_data() (I) = array containing data to be read
  
  'function return
  'read_i2c_eeprom (O)
  '   0 = success
  '   <> 0 = MM.I2C failure status from I2C operation
  
  local integer e_addr, addr_lh(eeprom_addr_size)              'address array
  local integer byte_cnt, byte_ptr, read_bytes, err_cnt
  
  local integer idx
  
  byte_cnt = num_bytes        'byte count to transfer
  e_addr = eeprom_addr        'write-address within eeprom
  byte_ptr = 0                'first data byte
  
  do while byte_cnt > 0       'read all bytes requested
    
    addr_lh(0) = e_addr>>8 and &h0F           'eeprom address high byte
    addr_lh(1) = e_addr and &hFF              'eeprom address low byte
    
    if byte_cnt > eeprom_read_size then       'if chunk bigger than max read size
      read_bytes = eeprom_read_size           'set length
      inc byte_cnt, -eeprom_read_size         'and count down remaining zize
    else
      read_bytes = byte_cnt                   'get length of rest
      byte_cnt = 0                            'mark done
    end if
    
    'write the read-addreess into eeprom
    do                                            'device not ready wait loop
      i2c write eep_i2c_addr, 1, 2, addr_lh()     'setup read address
      if mm.i2c = 2 then
        read_i2c_eeprom = mm.i2c
        exit function                          'timeout
      end if
    loop until not mm.i2c                   'loop if device is not ready
    
    'read in the data from the eeprom
    do                                        'device not ready wait loop
      i2c read eep_i2c_addr, 0, read_bytes, eeprom_data(byte_ptr)
      if mm.i2c = 0 then                                'no error
        exit do                                         'leave retry loop
      else                                              'timeout or NACK
        pause eep_timeout                               'wait before retry
        inc err_cnt                                     'count errors
        if err_cnt > err_max then                       'assume not recoverable
          read_i2c_eeprom = mm.i2c                             'set status to I2C status
          exit function                                 'leave
        end if
      end if
    loop
    
    inc byte_ptr, eeprom_read_size        'adjust out-pointer
    inc e_addr, eeprom_read_size          'get next read address
  loop
  read_i2c_eeprom = mm.i2c
end function
  
  '----------------------------------------------------------
  
  ' write data to eeprom
  
function write_i2c_eeprom (start_addr as integer, num_bytes as integer, eeprom_data() as integer) as integer
  
  'start_addr (i) = storage address of data in eeprom
  'num_bytes (I) = number of bytes to be stored in eeprom
  'eeprom_data() (I) = array containing data to be stored
  
  'function return
  'read_i2c_eeprom (O)
  '   0 = success
  '   <> 0 = MM.I2C failure status from I2C operation
 
  local integer e_addr, byte_cnt, byte_ptr, write_bytes, l_idx, err_cnt
  local integer l_ee_data(eeprom_page_size+eeprom_addr_size)
  
  byte_cnt = num_bytes                                  'byte count to transfer
  e_addr = start_addr                                   'write-address within eeprom
  byte_ptr = 0                                          'first data byte
  
  do while byte_cnt > 0
    l_ee_data(0) = e_addr>>8 and &h0F                   'put eeprom address high byte into write-buffer
    l_ee_data(1) = e_addr and &hFF                      'eeprom address low byte
    
    write_bytes = eeprom_page_size - (e_addr mod eeprom_page_size)
    if byte_cnt < eeprom_page_size then
      write_bytes = byte_cnt
    end if
    inc byte_cnt, -write_bytes
    
    for l_idx = 0 to write_bytes-1                        'for all data bytes
      l_ee_data(eeprom_addr_size+l_idx) = eeprom_data(byte_ptr+l_idx)  'copy into temp array
    next l_idx
    
    'write buffer to eeprom
    do                                                  'error retry loop
      i2c write eep_i2c_addr, 0, write_bytes+eeprom_addr_size, l_ee_data()   'write data
      if mm.i2c = 0 then                                'no error
        exit do                                         'leave retry loop
      else                                              'timeout or NACK
        pause eep_timeout                               'wait before retry
        inc err_cnt                                     'count errors
        if err_cnt > err_max then                       'assume not recoverable
          write_i2c_eeprom = mm.i2c                             'set status to I2C status
          exit function                                 'leave
        end if
      end if
    loop                                                'if device is busy, retry write until done
    
    inc byte_ptr, write_bytes                           'bump byte-pointer
    inc e_addr, write_bytes                             'bump write address
  loop
  
  write_i2c_eeprom = 0                                          'signal success
end function
